/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SessionEntityTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/sessions/{session}/entityTypes/{entity_type}");
    private static final PathTemplate PROJECT_LOCATION_AGENT_ENVIRONMENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/sessions/{session}/entityTypes/{entity_type}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String location;
    private String agent;
    private String session;
    private String entityType;
    private String environment;

    @Deprecated
    protected SessionEntityTypeName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getSession() {
        return this.session;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEnvironment() {
        return this.environment;
    }

    private SessionEntityTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
        this.pathTemplate = PROJECT_LOCATION_AGENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE;
    }

    private SessionEntityTypeName(ProjectLocationAgentEnvironmentSessionEntityTypeBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
        this.pathTemplate = PROJECT_LOCATION_AGENT_ENVIRONMENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationAgentSessionEntityTypeBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationAgentEnvironmentSessionEntityTypeBuilder newProjectLocationAgentEnvironmentSessionEntityTypeBuilder() {
        return new ProjectLocationAgentEnvironmentSessionEntityTypeBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SessionEntityTypeName of(String project, String location, String agent, String session, String entityType) {
        return SessionEntityTypeName.newProjectLocationAgentSessionEntityTypeBuilder().setProject(project).setLocation(location).setAgent(agent).setSession(session).setEntityType(entityType).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SessionEntityTypeName ofProjectLocationAgentSessionEntityTypeName(String project, String location, String agent, String session, String entityType) {
        return SessionEntityTypeName.newProjectLocationAgentSessionEntityTypeBuilder().setProject(project).setLocation(location).setAgent(agent).setSession(session).setEntityType(entityType).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SessionEntityTypeName ofProjectLocationAgentEnvironmentSessionEntityTypeName(String project, String location, String agent, String environment, String session, String entityType) {
        return SessionEntityTypeName.newProjectLocationAgentEnvironmentSessionEntityTypeBuilder().setProject(project).setLocation(location).setAgent(agent).setEnvironment(environment).setSession(session).setEntityType(entityType).build();
    }

    public static String format(String project, String location, String agent, String session, String entityType) {
        return SessionEntityTypeName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setSession(session).setEntityType(entityType).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationAgentSessionEntityTypeName(String project, String location, String agent, String session, String entityType) {
        return SessionEntityTypeName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setSession(session).setEntityType(entityType).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationAgentEnvironmentSessionEntityTypeName(String project, String location, String agent, String environment, String session, String entityType) {
        return SessionEntityTypeName.newProjectLocationAgentEnvironmentSessionEntityTypeBuilder().setProject(project).setLocation(location).setAgent(agent).setEnvironment(environment).setSession(session).setEntityType(entityType).build().toString();
    }

    public static SessionEntityTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_AGENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_AGENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE.match(formattedString);
            return SessionEntityTypeName.ofProjectLocationAgentSessionEntityTypeName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("session"), (String)matchMap.get("entity_type"));
        }
        if (PROJECT_LOCATION_AGENT_ENVIRONMENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_AGENT_ENVIRONMENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE.match(formattedString);
            return SessionEntityTypeName.ofProjectLocationAgentEnvironmentSessionEntityTypeName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("environment"), (String)matchMap.get("session"), (String)matchMap.get("entity_type"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SessionEntityTypeName> parseList(List<String> formattedStrings) {
        ArrayList<SessionEntityTypeName> list = new ArrayList<SessionEntityTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SessionEntityTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SessionEntityTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SessionEntityTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE.matches(formattedString) || PROJECT_LOCATION_AGENT_ENVIRONMENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SessionEntityTypeName sessionEntityTypeName = this;
            synchronized (sessionEntityTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put((Object)"session", (Object)this.session);
                    }
                    if (this.entityType != null) {
                        fieldMapBuilder.put((Object)"entity_type", (Object)this.entityType);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SessionEntityTypeName that = (SessionEntityTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.session, that.session) && Objects.equals(this.entityType, that.entityType) && Objects.equals(this.environment, that.environment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        h ^= Objects.hashCode(this.session);
        h *= 1000003;
        h ^= Objects.hashCode(this.entityType);
        h *= 1000003;
        return h ^= Objects.hashCode(this.environment);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationAgentEnvironmentSessionEntityTypeBuilder {
        private String project;
        private String location;
        private String agent;
        private String environment;
        private String session;
        private String entityType;

        private ProjectLocationAgentEnvironmentSessionEntityTypeBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getSession() {
            return this.session;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public ProjectLocationAgentEnvironmentSessionEntityTypeBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationAgentEnvironmentSessionEntityTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationAgentEnvironmentSessionEntityTypeBuilder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public ProjectLocationAgentEnvironmentSessionEntityTypeBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public ProjectLocationAgentEnvironmentSessionEntityTypeBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public ProjectLocationAgentEnvironmentSessionEntityTypeBuilder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public SessionEntityTypeName build() {
            return new SessionEntityTypeName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String session;
        private String entityType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getSession() {
            return this.session;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        public Builder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        private Builder(SessionEntityTypeName sessionEntityTypeName) {
            Preconditions.checkArgument((sessionEntityTypeName.pathTemplate == PROJECT_LOCATION_AGENT_SESSION_ENTITY_TYPE_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when SessionEntityTypeName has the pattern of projects/{project}/locations/{location}/agents/{agent}/sessions/{session}/entityTypes/{entity_type}.");
            this.project = sessionEntityTypeName.project;
            this.location = sessionEntityTypeName.location;
            this.agent = sessionEntityTypeName.agent;
            this.session = sessionEntityTypeName.session;
            this.entityType = sessionEntityTypeName.entityType;
        }

        public SessionEntityTypeName build() {
            return new SessionEntityTypeName(this);
        }
    }
}

