/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IntentName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/intents/{intent}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String intent;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getIntent() {
        return this.intent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private IntentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.intent = (String)Preconditions.checkNotNull((Object)builder.getIntent());
    }

    public static IntentName of(String project, String location, String agent, String intent) {
        return IntentName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setIntent(intent).build();
    }

    public static String format(String project, String location, String agent, String intent) {
        return IntentName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setIntent(intent).build().toString();
    }

    public static IntentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "IntentName.parse: formattedString not in valid format");
        return IntentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("intent"));
    }

    public static List<IntentName> parseList(List<String> formattedStrings) {
        ArrayList<IntentName> list = new ArrayList<IntentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IntentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IntentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IntentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IntentName intentName = this;
            synchronized (intentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    fieldMapBuilder.put((Object)"intent", (Object)this.intent);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "intent", this.intent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IntentName) {
            IntentName that = (IntentName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.agent.equals(that.agent) && this.intent.equals(that.intent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.agent.hashCode();
        h *= 1000003;
        return h ^= this.intent.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String intent;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getIntent() {
            return this.intent;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setIntent(String intent) {
            this.intent = intent;
            return this;
        }

        private Builder() {
        }

        private Builder(IntentName intentName) {
            this.project = intentName.project;
            this.location = intentName.location;
            this.agent = intentName.agent;
            this.intent = intentName.intent;
        }

        public IntentName build() {
            return new IntentName(this);
        }
    }
}

