/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EntityTypeName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/entityTypes/{entity_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String entityType;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private EntityTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
    }

    public static EntityTypeName of(String project, String location, String agent, String entityType) {
        return EntityTypeName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setEntityType(entityType).build();
    }

    public static String format(String project, String location, String agent, String entityType) {
        return EntityTypeName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setEntityType(entityType).build().toString();
    }

    public static EntityTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "EntityTypeName.parse: formattedString not in valid format");
        return EntityTypeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("entity_type"));
    }

    public static List<EntityTypeName> parseList(List<String> formattedStrings) {
        ArrayList<EntityTypeName> list = new ArrayList<EntityTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntityTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntityTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntityTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntityTypeName entityTypeName = this;
            synchronized (entityTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    fieldMapBuilder.put((Object)"entityType", (Object)this.entityType);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "entity_type", this.entityType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EntityTypeName) {
            EntityTypeName that = (EntityTypeName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.agent.equals(that.agent) && this.entityType.equals(that.entityType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.agent.hashCode();
        h *= 1000003;
        return h ^= this.entityType.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String entityType;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        private Builder() {
        }

        private Builder(EntityTypeName entityTypeName) {
            this.project = entityTypeName.project;
            this.location = entityTypeName.location;
            this.agent = entityTypeName.agent;
            this.entityType = entityTypeName.entityType;
        }

        public EntityTypeName build() {
            return new EntityTypeName(this);
        }
    }
}

