/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AgentName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AgentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
    }

    public static AgentName of(String project, String location, String agent) {
        return AgentName.newBuilder().setProject(project).setLocation(location).setAgent(agent).build();
    }

    public static String format(String project, String location, String agent) {
        return AgentName.newBuilder().setProject(project).setLocation(location).setAgent(agent).build().toString();
    }

    public static AgentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AgentName.parse: formattedString not in valid format");
        return AgentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"));
    }

    public static List<AgentName> parseList(List<String> formattedStrings) {
        ArrayList<AgentName> list = new ArrayList<AgentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AgentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AgentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AgentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AgentName agentName = this;
            synchronized (agentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AgentName) {
            AgentName that = (AgentName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.agent.equals(that.agent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.agent.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        private Builder() {
        }

        private Builder(AgentName agentName) {
            this.project = agentName.project;
            this.location = agentName.location;
            this.agent = agentName.agent;
        }

        public AgentName build() {
            return new AgentName(this);
        }
    }
}

