/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChangelogName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_CHANGELOG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/changelogs/{changelog}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String changelog;

    @Deprecated
    protected ChangelogName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.changelog = null;
    }

    private ChangelogName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.changelog = (String)Preconditions.checkNotNull((Object)builder.getChangelog());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChangelogName of(String project, String location, String agent, String changelog) {
        return ChangelogName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setChangelog(changelog).build();
    }

    public static String format(String project, String location, String agent, String changelog) {
        return ChangelogName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setChangelog(changelog).build().toString();
    }

    public static ChangelogName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT_CHANGELOG.validatedMatch(formattedString, "ChangelogName.parse: formattedString not in valid format");
        return ChangelogName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("changelog"));
    }

    public static List<ChangelogName> parseList(List<String> formattedStrings) {
        ArrayList<ChangelogName> list = new ArrayList<ChangelogName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChangelogName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChangelogName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChangelogName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_CHANGELOG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChangelogName changelogName = this;
            synchronized (changelogName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.changelog != null) {
                        fieldMapBuilder.put((Object)"changelog", (Object)this.changelog);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT_CHANGELOG.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "changelog", this.changelog});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ChangelogName that = (ChangelogName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.changelog, that.changelog);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        return h ^= Objects.hashCode(this.changelog);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String changelog;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getChangelog() {
            return this.changelog;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setChangelog(String changelog) {
            this.changelog = changelog;
            return this;
        }

        private Builder(ChangelogName changelogName) {
            this.project = changelogName.project;
            this.location = changelogName.location;
            this.agent = changelogName.agent;
            this.changelog = changelogName.changelog;
        }

        public ChangelogName build() {
            return new ChangelogName(this);
        }
    }
}

