/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WebhookName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_WEBHOOK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/webhooks/{webhook}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String webhook;

    @Deprecated
    protected WebhookName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.webhook = null;
    }

    private WebhookName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.webhook = (String)Preconditions.checkNotNull((Object)builder.getWebhook());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getWebhook() {
        return this.webhook;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WebhookName of(String project, String location, String agent, String webhook) {
        return WebhookName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setWebhook(webhook).build();
    }

    public static String format(String project, String location, String agent, String webhook) {
        return WebhookName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setWebhook(webhook).build().toString();
    }

    public static WebhookName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT_WEBHOOK.validatedMatch(formattedString, "WebhookName.parse: formattedString not in valid format");
        return WebhookName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("webhook"));
    }

    public static List<WebhookName> parseList(List<String> formattedStrings) {
        ArrayList<WebhookName> list = new ArrayList<WebhookName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WebhookName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WebhookName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WebhookName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_WEBHOOK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WebhookName webhookName = this;
            synchronized (webhookName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.webhook != null) {
                        fieldMapBuilder.put((Object)"webhook", (Object)this.webhook);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT_WEBHOOK.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "webhook", this.webhook});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            WebhookName that = (WebhookName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.webhook, that.webhook);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        return h ^= Objects.hashCode(this.webhook);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String webhook;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getWebhook() {
            return this.webhook;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setWebhook(String webhook) {
            this.webhook = webhook;
            return this;
        }

        private Builder(WebhookName webhookName) {
            this.project = webhookName.project;
            this.location = webhookName.location;
            this.agent = webhookName.agent;
            this.webhook = webhookName.webhook;
        }

        public WebhookName build() {
            return new WebhookName(this);
        }
    }
}

