/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TargetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TARGET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/targets/{target}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String target;

    @Deprecated
    protected TargetName() {
        this.project = null;
        this.location = null;
        this.target = null;
    }

    private TargetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.target = (String)Preconditions.checkNotNull((Object)builder.getTarget());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTarget() {
        return this.target;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TargetName of(String project, String location, String target) {
        return TargetName.newBuilder().setProject(project).setLocation(location).setTarget(target).build();
    }

    public static String format(String project, String location, String target) {
        return TargetName.newBuilder().setProject(project).setLocation(location).setTarget(target).build().toString();
    }

    public static TargetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TARGET.validatedMatch(formattedString, "TargetName.parse: formattedString not in valid format");
        return TargetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("target"));
    }

    public static List<TargetName> parseList(List<String> formattedStrings) {
        ArrayList<TargetName> list = new ArrayList<TargetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TargetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TargetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TargetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TARGET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TargetName targetName = this;
            synchronized (targetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.target != null) {
                        fieldMapBuilder.put((Object)"target", (Object)this.target);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TARGET.instantiate(new String[]{"project", this.project, "location", this.location, "target", this.target});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TargetName that = (TargetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.target, that.target);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.target);
    }

    public static class Builder {
        private String project;
        private String location;
        private String target;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTarget() {
            return this.target;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        private Builder(TargetName targetName) {
            this.project = targetName.project;
            this.location = targetName.location;
            this.target = targetName.target;
        }

        public TargetName build() {
            return new TargetName(this);
        }
    }
}

