/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomTargetTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CUSTOM_TARGET_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/customTargetTypes/{custom_target_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String customTargetType;

    @Deprecated
    protected CustomTargetTypeName() {
        this.project = null;
        this.location = null;
        this.customTargetType = null;
    }

    private CustomTargetTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.customTargetType = (String)Preconditions.checkNotNull((Object)builder.getCustomTargetType());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCustomTargetType() {
        return this.customTargetType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomTargetTypeName of(String project, String location, String customTargetType) {
        return CustomTargetTypeName.newBuilder().setProject(project).setLocation(location).setCustomTargetType(customTargetType).build();
    }

    public static String format(String project, String location, String customTargetType) {
        return CustomTargetTypeName.newBuilder().setProject(project).setLocation(location).setCustomTargetType(customTargetType).build().toString();
    }

    public static CustomTargetTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CUSTOM_TARGET_TYPE.validatedMatch(formattedString, "CustomTargetTypeName.parse: formattedString not in valid format");
        return CustomTargetTypeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("custom_target_type"));
    }

    public static List<CustomTargetTypeName> parseList(List<String> formattedStrings) {
        ArrayList<CustomTargetTypeName> list = new ArrayList<CustomTargetTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomTargetTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomTargetTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomTargetTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CUSTOM_TARGET_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomTargetTypeName customTargetTypeName = this;
            synchronized (customTargetTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.customTargetType != null) {
                        fieldMapBuilder.put((Object)"custom_target_type", (Object)this.customTargetType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CUSTOM_TARGET_TYPE.instantiate(new String[]{"project", this.project, "location", this.location, "custom_target_type", this.customTargetType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomTargetTypeName that = (CustomTargetTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.customTargetType, that.customTargetType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customTargetType);
    }

    public static class Builder {
        private String project;
        private String location;
        private String customTargetType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCustomTargetType() {
            return this.customTargetType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCustomTargetType(String customTargetType) {
            this.customTargetType = customTargetType;
            return this;
        }

        private Builder(CustomTargetTypeName customTargetTypeName) {
            this.project = customTargetTypeName.project;
            this.location = customTargetTypeName.location;
            this.customTargetType = customTargetTypeName.customTargetType;
        }

        public CustomTargetTypeName build() {
            return new CustomTargetTypeName(this);
        }
    }
}

