/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastream.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConnectionProfileName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONNECTION_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/connectionProfiles/{connection_profile}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String connectionProfile;

    @Deprecated
    protected ConnectionProfileName() {
        this.project = null;
        this.location = null;
        this.connectionProfile = null;
    }

    private ConnectionProfileName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.connectionProfile = (String)Preconditions.checkNotNull((Object)builder.getConnectionProfile());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConnectionProfile() {
        return this.connectionProfile;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConnectionProfileName of(String project, String location, String connectionProfile) {
        return ConnectionProfileName.newBuilder().setProject(project).setLocation(location).setConnectionProfile(connectionProfile).build();
    }

    public static String format(String project, String location, String connectionProfile) {
        return ConnectionProfileName.newBuilder().setProject(project).setLocation(location).setConnectionProfile(connectionProfile).build().toString();
    }

    public static ConnectionProfileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONNECTION_PROFILE.validatedMatch(formattedString, "ConnectionProfileName.parse: formattedString not in valid format");
        return ConnectionProfileName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("connection_profile"));
    }

    public static List<ConnectionProfileName> parseList(List<String> formattedStrings) {
        ArrayList<ConnectionProfileName> list = new ArrayList<ConnectionProfileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConnectionProfileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConnectionProfileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConnectionProfileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONNECTION_PROFILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConnectionProfileName connectionProfileName = this;
            synchronized (connectionProfileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.connectionProfile != null) {
                        fieldMapBuilder.put((Object)"connection_profile", (Object)this.connectionProfile);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONNECTION_PROFILE.instantiate(new String[]{"project", this.project, "location", this.location, "connection_profile", this.connectionProfile});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConnectionProfileName that = (ConnectionProfileName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.connectionProfile, that.connectionProfile);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.connectionProfile);
    }

    public static class Builder {
        private String project;
        private String location;
        private String connectionProfile;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConnectionProfile() {
            return this.connectionProfile;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConnectionProfile(String connectionProfile) {
            this.connectionProfile = connectionProfile;
            return this;
        }

        private Builder(ConnectionProfileName connectionProfileName) {
            this.project = connectionProfileName.project;
            this.location = connectionProfileName.location;
            this.connectionProfile = connectionProfileName.connectionProfile;
        }

        public ConnectionProfileName build() {
            return new ConnectionProfileName(this);
        }
    }
}

