/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastream.v1;

import com.google.cloud.datastream.v1.DatastreamResourcesProto;
import com.google.cloud.datastream.v1.Error;
import com.google.cloud.datastream.v1.ErrorOrBuilder;
import com.google.cloud.datastream.v1.PrivateConnectionOrBuilder;
import com.google.cloud.datastream.v1.VpcPeeringConfig;
import com.google.cloud.datastream.v1.VpcPeeringConfigOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public final class PrivateConnection
extends GeneratedMessageV3
implements PrivateConnectionOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int CREATE_TIME_FIELD_NUMBER = 2;
    private Timestamp createTime_;
    public static final int UPDATE_TIME_FIELD_NUMBER = 3;
    private Timestamp updateTime_;
    public static final int LABELS_FIELD_NUMBER = 4;
    private MapField<String, String> labels_;
    public static final int DISPLAY_NAME_FIELD_NUMBER = 5;
    private volatile Object displayName_ = "";
    public static final int STATE_FIELD_NUMBER = 6;
    private int state_ = 0;
    public static final int ERROR_FIELD_NUMBER = 7;
    private Error error_;
    public static final int SATISFIES_PZS_FIELD_NUMBER = 8;
    private boolean satisfiesPzs_ = false;
    public static final int SATISFIES_PZI_FIELD_NUMBER = 9;
    private boolean satisfiesPzi_ = false;
    public static final int VPC_PEERING_CONFIG_FIELD_NUMBER = 100;
    private VpcPeeringConfig vpcPeeringConfig_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final PrivateConnection DEFAULT_INSTANCE = new PrivateConnection();
    private static final Parser<PrivateConnection> PARSER = new AbstractParser<PrivateConnection>(){

        public PrivateConnection parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = PrivateConnection.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private PrivateConnection(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private PrivateConnection() {
        this.name_ = "";
        this.displayName_ = "";
        this.state_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new PrivateConnection();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return DatastreamResourcesProto.internal_static_google_cloud_datastream_v1_PrivateConnection_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 4: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return DatastreamResourcesProto.internal_static_google_cloud_datastream_v1_PrivateConnection_fieldAccessorTable.ensureFieldAccessorsInitialized(PrivateConnection.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCreateTime() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getCreateTime() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public TimestampOrBuilder getCreateTimeOrBuilder() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public boolean hasUpdateTime() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getUpdateTime() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public TimestampOrBuilder getUpdateTimeOrBuilder() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public String getDisplayName() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.displayName_ = s;
        return s;
    }

    @Override
    public ByteString getDisplayNameBytes() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.displayName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStateValue() {
        return this.state_;
    }

    @Override
    public State getState() {
        State result = State.forNumber(this.state_);
        return result == null ? State.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasError() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Error getError() {
        return this.error_ == null ? Error.getDefaultInstance() : this.error_;
    }

    @Override
    public ErrorOrBuilder getErrorOrBuilder() {
        return this.error_ == null ? Error.getDefaultInstance() : this.error_;
    }

    @Override
    public boolean hasSatisfiesPzs() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public boolean getSatisfiesPzs() {
        return this.satisfiesPzs_;
    }

    @Override
    public boolean hasSatisfiesPzi() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public boolean getSatisfiesPzi() {
        return this.satisfiesPzi_;
    }

    @Override
    public boolean hasVpcPeeringConfig() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public VpcPeeringConfig getVpcPeeringConfig() {
        return this.vpcPeeringConfig_ == null ? VpcPeeringConfig.getDefaultInstance() : this.vpcPeeringConfig_;
    }

    @Override
    public VpcPeeringConfigOrBuilder getVpcPeeringConfigOrBuilder() {
        return this.vpcPeeringConfig_ == null ? VpcPeeringConfig.getDefaultInstance() : this.vpcPeeringConfig_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(2, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(3, (MessageLite)this.getUpdateTime());
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)4);
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.displayName_);
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.state_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(7, (MessageLite)this.getError());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeBool(8, this.satisfiesPzs_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeBool(9, this.satisfiesPzi_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(100, (MessageLite)this.getVpcPeeringConfig());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getUpdateTime());
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)labels__);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.displayName_);
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.state_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getError());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeBoolSize((int)8, (boolean)this.satisfiesPzs_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeBoolSize((int)9, (boolean)this.satisfiesPzi_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)100, (MessageLite)this.getVpcPeeringConfig());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PrivateConnection)) {
            return super.equals(obj);
        }
        PrivateConnection other = (PrivateConnection)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.hasCreateTime() != other.hasCreateTime()) {
            return false;
        }
        if (this.hasCreateTime() && !this.getCreateTime().equals((Object)other.getCreateTime())) {
            return false;
        }
        if (this.hasUpdateTime() != other.hasUpdateTime()) {
            return false;
        }
        if (this.hasUpdateTime() && !this.getUpdateTime().equals((Object)other.getUpdateTime())) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (!this.getDisplayName().equals(other.getDisplayName())) {
            return false;
        }
        if (this.state_ != other.state_) {
            return false;
        }
        if (this.hasError() != other.hasError()) {
            return false;
        }
        if (this.hasError() && !this.getError().equals(other.getError())) {
            return false;
        }
        if (this.hasSatisfiesPzs() != other.hasSatisfiesPzs()) {
            return false;
        }
        if (this.hasSatisfiesPzs() && this.getSatisfiesPzs() != other.getSatisfiesPzs()) {
            return false;
        }
        if (this.hasSatisfiesPzi() != other.hasSatisfiesPzi()) {
            return false;
        }
        if (this.hasSatisfiesPzi() && this.getSatisfiesPzi() != other.getSatisfiesPzi()) {
            return false;
        }
        if (this.hasVpcPeeringConfig() != other.hasVpcPeeringConfig()) {
            return false;
        }
        if (this.hasVpcPeeringConfig() && !this.getVpcPeeringConfig().equals(other.getVpcPeeringConfig())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + PrivateConnection.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        if (this.hasCreateTime()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getCreateTime().hashCode();
        }
        if (this.hasUpdateTime()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getUpdateTime().hashCode();
        }
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getDisplayName().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.state_;
        if (this.hasError()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getError().hashCode();
        }
        if (this.hasSatisfiesPzs()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getSatisfiesPzs());
        }
        if (this.hasSatisfiesPzi()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getSatisfiesPzi());
        }
        if (this.hasVpcPeeringConfig()) {
            hash = 37 * hash + 100;
            hash = 53 * hash + this.getVpcPeeringConfig().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static PrivateConnection parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (PrivateConnection)PARSER.parseFrom(data);
    }

    public static PrivateConnection parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (PrivateConnection)PARSER.parseFrom(data, extensionRegistry);
    }

    public static PrivateConnection parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (PrivateConnection)PARSER.parseFrom(data);
    }

    public static PrivateConnection parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (PrivateConnection)PARSER.parseFrom(data, extensionRegistry);
    }

    public static PrivateConnection parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (PrivateConnection)PARSER.parseFrom(data);
    }

    public static PrivateConnection parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (PrivateConnection)PARSER.parseFrom(data, extensionRegistry);
    }

    public static PrivateConnection parseFrom(InputStream input) throws IOException {
        return (PrivateConnection)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static PrivateConnection parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (PrivateConnection)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static PrivateConnection parseDelimitedFrom(InputStream input) throws IOException {
        return (PrivateConnection)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static PrivateConnection parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (PrivateConnection)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static PrivateConnection parseFrom(CodedInputStream input) throws IOException {
        return (PrivateConnection)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static PrivateConnection parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (PrivateConnection)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return PrivateConnection.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PrivateConnection prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static PrivateConnection getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<PrivateConnection> parser() {
        return PARSER;
    }

    public Parser<PrivateConnection> getParserForType() {
        return PARSER;
    }

    public PrivateConnection getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements PrivateConnectionOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Timestamp createTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createTimeBuilder_;
        private Timestamp updateTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> updateTimeBuilder_;
        private MapField<String, String> labels_;
        private Object displayName_ = "";
        private int state_ = 0;
        private Error error_;
        private SingleFieldBuilderV3<Error, Error.Builder, ErrorOrBuilder> errorBuilder_;
        private boolean satisfiesPzs_;
        private boolean satisfiesPzi_;
        private VpcPeeringConfig vpcPeeringConfig_;
        private SingleFieldBuilderV3<VpcPeeringConfig, VpcPeeringConfig.Builder, VpcPeeringConfigOrBuilder> vpcPeeringConfigBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return DatastreamResourcesProto.internal_static_google_cloud_datastream_v1_PrivateConnection_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return DatastreamResourcesProto.internal_static_google_cloud_datastream_v1_PrivateConnection_fieldAccessorTable.ensureFieldAccessorsInitialized(PrivateConnection.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getCreateTimeFieldBuilder();
                this.getUpdateTimeFieldBuilder();
                this.getErrorFieldBuilder();
                this.getVpcPeeringConfigFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.internalGetMutableLabels().clear();
            this.displayName_ = "";
            this.state_ = 0;
            this.error_ = null;
            if (this.errorBuilder_ != null) {
                this.errorBuilder_.dispose();
                this.errorBuilder_ = null;
            }
            this.satisfiesPzs_ = false;
            this.satisfiesPzi_ = false;
            this.vpcPeeringConfig_ = null;
            if (this.vpcPeeringConfigBuilder_ != null) {
                this.vpcPeeringConfigBuilder_.dispose();
                this.vpcPeeringConfigBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return DatastreamResourcesProto.internal_static_google_cloud_datastream_v1_PrivateConnection_descriptor;
        }

        public PrivateConnection getDefaultInstanceForType() {
            return PrivateConnection.getDefaultInstance();
        }

        public PrivateConnection build() {
            PrivateConnection result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public PrivateConnection buildPartial() {
            PrivateConnection result = new PrivateConnection(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(PrivateConnection result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.createTime_ = this.createTimeBuilder_ == null ? this.createTime_ : (Timestamp)this.createTimeBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.updateTime_ = this.updateTimeBuilder_ == null ? this.updateTime_ : (Timestamp)this.updateTimeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.labels_ = this.internalGetLabels();
                result.labels_.makeImmutable();
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.displayName_ = this.displayName_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.state_ = this.state_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.error_ = this.errorBuilder_ == null ? this.error_ : (Error)this.errorBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.satisfiesPzs_ = this.satisfiesPzs_;
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.satisfiesPzi_ = this.satisfiesPzi_;
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.vpcPeeringConfig_ = this.vpcPeeringConfigBuilder_ == null ? this.vpcPeeringConfig_ : (VpcPeeringConfig)this.vpcPeeringConfigBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            PrivateConnection privateConnection = result;
            privateConnection.bitField0_ = privateConnection.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof PrivateConnection) {
                return this.mergeFrom((PrivateConnection)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(PrivateConnection other) {
            if (other == PrivateConnection.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasCreateTime()) {
                this.mergeCreateTime(other.getCreateTime());
            }
            if (other.hasUpdateTime()) {
                this.mergeUpdateTime(other.getUpdateTime());
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            this.bitField0_ |= 8;
            if (!other.getDisplayName().isEmpty()) {
                this.displayName_ = other.displayName_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.state_ != 0) {
                this.setStateValue(other.getStateValue());
            }
            if (other.hasError()) {
                this.mergeError(other.getError());
            }
            if (other.hasSatisfiesPzs()) {
                this.setSatisfiesPzs(other.getSatisfiesPzs());
            }
            if (other.hasSatisfiesPzi()) {
                this.setSatisfiesPzi(other.getSatisfiesPzi());
            }
            if (other.hasVpcPeeringConfig()) {
                this.mergeVpcPeeringConfig(other.getVpcPeeringConfig());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block18: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block18;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block18;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block18;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block18;
                        }
                        case 34: {
                            MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLabels().getMutableMap().put(labels__.getKey(), labels__.getValue());
                            this.bitField0_ |= 8;
                            continue block18;
                        }
                        case 42: {
                            this.displayName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block18;
                        }
                        case 48: {
                            this.state_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block18;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getErrorFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block18;
                        }
                        case 64: {
                            this.satisfiesPzs_ = input.readBool();
                            this.bitField0_ |= 0x80;
                            continue block18;
                        }
                        case 72: {
                            this.satisfiesPzi_ = input.readBool();
                            this.bitField0_ |= 0x100;
                            continue block18;
                        }
                        case 802: {
                            input.readMessage((MessageLite.Builder)this.getVpcPeeringConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block18;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = PrivateConnection.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            PrivateConnection.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreateTime() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Timestamp getCreateTime() {
            if (this.createTimeBuilder_ == null) {
                return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
            }
            return (Timestamp)this.createTimeBuilder_.getMessage();
        }

        public Builder setCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createTime_ = value;
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setCreateTime(Timestamp.Builder builderForValue) {
            if (this.createTimeBuilder_ == null) {
                this.createTime_ = builderForValue.build();
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.createTime_ != null && this.createTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.createTime_ = value;
                }
            } else {
                this.createTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.createTime_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCreateTime() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreateTimeBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (Timestamp.Builder)this.getCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreateTimeOrBuilder() {
            if (this.createTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.createTimeBuilder_.getMessageOrBuilder();
            }
            return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreateTimeFieldBuilder() {
            if (this.createTimeBuilder_ == null) {
                this.createTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createTime_ = null;
            }
            return this.createTimeBuilder_;
        }

        @Override
        public boolean hasUpdateTime() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Timestamp getUpdateTime() {
            if (this.updateTimeBuilder_ == null) {
                return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
            }
            return (Timestamp)this.updateTimeBuilder_.getMessage();
        }

        public Builder setUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.updateTime_ = value;
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setUpdateTime(Timestamp.Builder builderForValue) {
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = builderForValue.build();
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.updateTime_ != null && this.updateTime_ != Timestamp.getDefaultInstance()) {
                    this.getUpdateTimeBuilder().mergeFrom(value);
                } else {
                    this.updateTime_ = value;
                }
            } else {
                this.updateTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.updateTime_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearUpdateTime() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getUpdateTimeBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (Timestamp.Builder)this.getUpdateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getUpdateTimeOrBuilder() {
            if (this.updateTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.updateTimeBuilder_.getMessageOrBuilder();
            }
            return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getUpdateTimeFieldBuilder() {
            if (this.updateTimeBuilder_ == null) {
                this.updateTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUpdateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.updateTime_ = null;
            }
            return this.updateTimeBuilder_;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            this.bitField0_ |= 8;
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            this.bitField0_ |= 8;
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            this.bitField0_ |= 8;
            return this;
        }

        @Override
        public String getDisplayName() {
            Object ref = this.displayName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.displayName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDisplayNameBytes() {
            Object ref = this.displayName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.displayName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDisplayName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.displayName_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearDisplayName() {
            this.displayName_ = PrivateConnection.getDefaultInstance().getDisplayName();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setDisplayNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            PrivateConnection.checkByteStringIsUtf8((ByteString)value);
            this.displayName_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        public Builder setStateValue(int value) {
            this.state_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        public Builder setState(State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.state_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.state_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasError() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public Error getError() {
            if (this.errorBuilder_ == null) {
                return this.error_ == null ? Error.getDefaultInstance() : this.error_;
            }
            return (Error)this.errorBuilder_.getMessage();
        }

        public Builder setError(Error value) {
            if (this.errorBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.error_ = value;
            } else {
                this.errorBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setError(Error.Builder builderForValue) {
            if (this.errorBuilder_ == null) {
                this.error_ = builderForValue.build();
            } else {
                this.errorBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeError(Error value) {
            if (this.errorBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.error_ != null && this.error_ != Error.getDefaultInstance()) {
                    this.getErrorBuilder().mergeFrom(value);
                } else {
                    this.error_ = value;
                }
            } else {
                this.errorBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.error_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearError() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.error_ = null;
            if (this.errorBuilder_ != null) {
                this.errorBuilder_.dispose();
                this.errorBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Error.Builder getErrorBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (Error.Builder)this.getErrorFieldBuilder().getBuilder();
        }

        @Override
        public ErrorOrBuilder getErrorOrBuilder() {
            if (this.errorBuilder_ != null) {
                return (ErrorOrBuilder)this.errorBuilder_.getMessageOrBuilder();
            }
            return this.error_ == null ? Error.getDefaultInstance() : this.error_;
        }

        private SingleFieldBuilderV3<Error, Error.Builder, ErrorOrBuilder> getErrorFieldBuilder() {
            if (this.errorBuilder_ == null) {
                this.errorBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getError(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.error_ = null;
            }
            return this.errorBuilder_;
        }

        @Override
        public boolean hasSatisfiesPzs() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public boolean getSatisfiesPzs() {
            return this.satisfiesPzs_;
        }

        public Builder setSatisfiesPzs(boolean value) {
            this.satisfiesPzs_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearSatisfiesPzs() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.satisfiesPzs_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSatisfiesPzi() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public boolean getSatisfiesPzi() {
            return this.satisfiesPzi_;
        }

        public Builder setSatisfiesPzi(boolean value) {
            this.satisfiesPzi_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearSatisfiesPzi() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.satisfiesPzi_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasVpcPeeringConfig() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public VpcPeeringConfig getVpcPeeringConfig() {
            if (this.vpcPeeringConfigBuilder_ == null) {
                return this.vpcPeeringConfig_ == null ? VpcPeeringConfig.getDefaultInstance() : this.vpcPeeringConfig_;
            }
            return (VpcPeeringConfig)this.vpcPeeringConfigBuilder_.getMessage();
        }

        public Builder setVpcPeeringConfig(VpcPeeringConfig value) {
            if (this.vpcPeeringConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.vpcPeeringConfig_ = value;
            } else {
                this.vpcPeeringConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setVpcPeeringConfig(VpcPeeringConfig.Builder builderForValue) {
            if (this.vpcPeeringConfigBuilder_ == null) {
                this.vpcPeeringConfig_ = builderForValue.build();
            } else {
                this.vpcPeeringConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergeVpcPeeringConfig(VpcPeeringConfig value) {
            if (this.vpcPeeringConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.vpcPeeringConfig_ != null && this.vpcPeeringConfig_ != VpcPeeringConfig.getDefaultInstance()) {
                    this.getVpcPeeringConfigBuilder().mergeFrom(value);
                } else {
                    this.vpcPeeringConfig_ = value;
                }
            } else {
                this.vpcPeeringConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.vpcPeeringConfig_ != null) {
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            return this;
        }

        public Builder clearVpcPeeringConfig() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.vpcPeeringConfig_ = null;
            if (this.vpcPeeringConfigBuilder_ != null) {
                this.vpcPeeringConfigBuilder_.dispose();
                this.vpcPeeringConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public VpcPeeringConfig.Builder getVpcPeeringConfigBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (VpcPeeringConfig.Builder)this.getVpcPeeringConfigFieldBuilder().getBuilder();
        }

        @Override
        public VpcPeeringConfigOrBuilder getVpcPeeringConfigOrBuilder() {
            if (this.vpcPeeringConfigBuilder_ != null) {
                return (VpcPeeringConfigOrBuilder)this.vpcPeeringConfigBuilder_.getMessageOrBuilder();
            }
            return this.vpcPeeringConfig_ == null ? VpcPeeringConfig.getDefaultInstance() : this.vpcPeeringConfig_;
        }

        private SingleFieldBuilderV3<VpcPeeringConfig, VpcPeeringConfig.Builder, VpcPeeringConfigOrBuilder> getVpcPeeringConfigFieldBuilder() {
            if (this.vpcPeeringConfigBuilder_ == null) {
                this.vpcPeeringConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getVpcPeeringConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.vpcPeeringConfig_ = null;
            }
            return this.vpcPeeringConfigBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)DatastreamResourcesProto.internal_static_google_cloud_datastream_v1_PrivateConnection_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static enum State implements ProtocolMessageEnum
    {
        STATE_UNSPECIFIED(0),
        CREATING(1),
        CREATED(2),
        FAILED(3),
        DELETING(4),
        FAILED_TO_DELETE(5),
        UNRECOGNIZED(-1);

        public static final int STATE_UNSPECIFIED_VALUE = 0;
        public static final int CREATING_VALUE = 1;
        public static final int CREATED_VALUE = 2;
        public static final int FAILED_VALUE = 3;
        public static final int DELETING_VALUE = 4;
        public static final int FAILED_TO_DELETE_VALUE = 5;
        private static final Internal.EnumLiteMap<State> internalValueMap;
        private static final State[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static State valueOf(int value) {
            return State.forNumber(value);
        }

        public static State forNumber(int value) {
            switch (value) {
                case 0: {
                    return STATE_UNSPECIFIED;
                }
                case 1: {
                    return CREATING;
                }
                case 2: {
                    return CREATED;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return DELETING;
                }
                case 5: {
                    return FAILED_TO_DELETE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<State> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return State.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)PrivateConnection.getDescriptor().getEnumTypes().get(0);
        }

        public static State valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != State.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private State(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<State>(){

                public State findValueByNumber(int number) {
                    return State.forNumber(number);
                }
            };
            VALUES = State.values();
        }
    }
}

