/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/query.proto

// Protobuf Java Version: 3.25.8
package com.google.datastore.v1;

public interface FindNearestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.datastore.v1.FindNearest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. An indexed vector property to search upon. Only documents which
   * contain vectors whose dimensionality match the query_vector can be
   * returned.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the vectorProperty field is set.
   */
  boolean hasVectorProperty();

  /**
   *
   *
   * <pre>
   * Required. An indexed vector property to search upon. Only documents which
   * contain vectors whose dimensionality match the query_vector can be
   * returned.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The vectorProperty.
   */
  com.google.datastore.v1.PropertyReference getVectorProperty();

  /**
   *
   *
   * <pre>
   * Required. An indexed vector property to search upon. Only documents which
   * contain vectors whose dimensionality match the query_vector can be
   * returned.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.datastore.v1.PropertyReferenceOrBuilder getVectorPropertyOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. The query vector that we are searching on. Must be a vector of no
   * more than 2048 dimensions.
   * </pre>
   *
   * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the queryVector field is set.
   */
  boolean hasQueryVector();

  /**
   *
   *
   * <pre>
   * Required. The query vector that we are searching on. Must be a vector of no
   * more than 2048 dimensions.
   * </pre>
   *
   * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The queryVector.
   */
  com.google.datastore.v1.Value getQueryVector();

  /**
   *
   *
   * <pre>
   * Required. The query vector that we are searching on. Must be a vector of no
   * more than 2048 dimensions.
   * </pre>
   *
   * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.datastore.v1.ValueOrBuilder getQueryVectorOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. The Distance Measure to use, required.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.FindNearest.DistanceMeasure distance_measure = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for distanceMeasure.
   */
  int getDistanceMeasureValue();

  /**
   *
   *
   * <pre>
   * Required. The Distance Measure to use, required.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.FindNearest.DistanceMeasure distance_measure = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The distanceMeasure.
   */
  com.google.datastore.v1.FindNearest.DistanceMeasure getDistanceMeasure();

  /**
   *
   *
   * <pre>
   * Required. The number of nearest neighbors to return. Must be a positive
   * integer of no more than 100.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the limit field is set.
   */
  boolean hasLimit();

  /**
   *
   *
   * <pre>
   * Required. The number of nearest neighbors to return. Must be a positive
   * integer of no more than 100.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The limit.
   */
  com.google.protobuf.Int32Value getLimit();

  /**
   *
   *
   * <pre>
   * Required. The number of nearest neighbors to return. Must be a positive
   * integer of no more than 100.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  com.google.protobuf.Int32ValueOrBuilder getLimitOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Optional name of the field to output the result of the vector
   * distance calculation. Must conform to [entity
   * property][google.datastore.v1.Entity.properties] limitations.
   * </pre>
   *
   * <code>string distance_result_property = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The distanceResultProperty.
   */
  java.lang.String getDistanceResultProperty();

  /**
   *
   *
   * <pre>
   * Optional. Optional name of the field to output the result of the vector
   * distance calculation. Must conform to [entity
   * property][google.datastore.v1.Entity.properties] limitations.
   * </pre>
   *
   * <code>string distance_result_property = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for distanceResultProperty.
   */
  com.google.protobuf.ByteString getDistanceResultPropertyBytes();

  /**
   *
   *
   * <pre>
   * Optional. Option to specify a threshold for which no less similar documents
   * will be returned. The behavior of the specified `distance_measure` will
   * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
   * increase when the vectors are more similar, the comparison is inverted.
   *
   * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
   * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
   * </pre>
   *
   * <code>
   * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the distanceThreshold field is set.
   */
  boolean hasDistanceThreshold();

  /**
   *
   *
   * <pre>
   * Optional. Option to specify a threshold for which no less similar documents
   * will be returned. The behavior of the specified `distance_measure` will
   * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
   * increase when the vectors are more similar, the comparison is inverted.
   *
   * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
   * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
   * </pre>
   *
   * <code>
   * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The distanceThreshold.
   */
  com.google.protobuf.DoubleValue getDistanceThreshold();

  /**
   *
   *
   * <pre>
   * Optional. Option to specify a threshold for which no less similar documents
   * will be returned. The behavior of the specified `distance_measure` will
   * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
   * increase when the vectors are more similar, the comparison is inverted.
   *
   * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
   * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
   * </pre>
   *
   * <code>
   * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.DoubleValueOrBuilder getDistanceThresholdOrBuilder();
}
