/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1beta2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AutoscalingPolicyName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/autoscalingPolicies/{autoscaling_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String region;
    private final String autoscalingPolicy;

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAutoscalingPolicy() {
        return this.autoscalingPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AutoscalingPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.autoscalingPolicy = (String)Preconditions.checkNotNull((Object)builder.getAutoscalingPolicy());
    }

    public static AutoscalingPolicyName of(String project, String region, String autoscalingPolicy) {
        return AutoscalingPolicyName.newBuilder().setProject(project).setRegion(region).setAutoscalingPolicy(autoscalingPolicy).build();
    }

    public static String format(String project, String region, String autoscalingPolicy) {
        return AutoscalingPolicyName.newBuilder().setProject(project).setRegion(region).setAutoscalingPolicy(autoscalingPolicy).build().toString();
    }

    public static AutoscalingPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AutoscalingPolicyName.parse: formattedString not in valid format");
        return AutoscalingPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("autoscaling_policy"));
    }

    public static List<AutoscalingPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<AutoscalingPolicyName> list = new ArrayList<AutoscalingPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AutoscalingPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AutoscalingPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AutoscalingPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AutoscalingPolicyName autoscalingPolicyName = this;
            synchronized (autoscalingPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"autoscalingPolicy", (Object)this.autoscalingPolicy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "autoscaling_policy", this.autoscalingPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AutoscalingPolicyName) {
            AutoscalingPolicyName that = (AutoscalingPolicyName)o;
            return this.project.equals(that.project) && this.region.equals(that.region) && this.autoscalingPolicy.equals(that.autoscalingPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.region.hashCode();
        h *= 1000003;
        return h ^= this.autoscalingPolicy.hashCode();
    }

    public static class Builder {
        private String project;
        private String region;
        private String autoscalingPolicy;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getAutoscalingPolicy() {
            return this.autoscalingPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setAutoscalingPolicy(String autoscalingPolicy) {
            this.autoscalingPolicy = autoscalingPolicy;
            return this;
        }

        private Builder() {
        }

        private Builder(AutoscalingPolicyName autoscalingPolicyName) {
            this.project = autoscalingPolicyName.project;
            this.region = autoscalingPolicyName.region;
            this.autoscalingPolicy = autoscalingPolicyName.autoscalingPolicy;
        }

        public AutoscalingPolicyName build() {
            return new AutoscalingPolicyName(this);
        }
    }
}

