/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SessionTemplateName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sessionTemplates/{template}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String template;

    @Deprecated
    protected SessionTemplateName() {
        this.project = null;
        this.location = null;
        this.template = null;
    }

    private SessionTemplateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.template = (String)Preconditions.checkNotNull((Object)builder.getTemplate());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTemplate() {
        return this.template;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SessionTemplateName of(String project, String location, String template) {
        return SessionTemplateName.newBuilder().setProject(project).setLocation(location).setTemplate(template).build();
    }

    public static String format(String project, String location, String template) {
        return SessionTemplateName.newBuilder().setProject(project).setLocation(location).setTemplate(template).build().toString();
    }

    public static SessionTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TEMPLATE.validatedMatch(formattedString, "SessionTemplateName.parse: formattedString not in valid format");
        return SessionTemplateName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("template"));
    }

    public static List<SessionTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<SessionTemplateName> list = new ArrayList<SessionTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SessionTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SessionTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SessionTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SessionTemplateName sessionTemplateName = this;
            synchronized (sessionTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.template != null) {
                        fieldMapBuilder.put((Object)"template", (Object)this.template);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "template", this.template});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SessionTemplateName that = (SessionTemplateName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.template, that.template);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.template);
    }

    public static class Builder {
        private String project;
        private String location;
        private String template;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTemplate() {
            return this.template;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTemplate(String template) {
            this.template = template;
            return this;
        }

        private Builder(SessionTemplateName sessionTemplateName) {
            this.project = sessionTemplateName.project;
            this.location = sessionTemplateName.location;
            this.template = sessionTemplateName.template;
        }

        public SessionTemplateName build() {
            return new SessionTemplateName(this);
        }
    }
}

