/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.cloud.dataproc.v1.ClusterOperationStatus;
import com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder;
import com.google.cloud.dataproc.v1.NodeGroupOperationMetadataOrBuilder;
import com.google.cloud.dataproc.v1.OperationsProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class NodeGroupOperationMetadata
extends GeneratedMessageV3
implements NodeGroupOperationMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NODE_GROUP_ID_FIELD_NUMBER = 1;
    private volatile Object nodeGroupId_ = "";
    public static final int CLUSTER_UUID_FIELD_NUMBER = 2;
    private volatile Object clusterUuid_ = "";
    public static final int STATUS_FIELD_NUMBER = 3;
    private ClusterOperationStatus status_;
    public static final int STATUS_HISTORY_FIELD_NUMBER = 4;
    private List<ClusterOperationStatus> statusHistory_;
    public static final int OPERATION_TYPE_FIELD_NUMBER = 5;
    private int operationType_ = 0;
    public static final int DESCRIPTION_FIELD_NUMBER = 6;
    private volatile Object description_ = "";
    public static final int LABELS_FIELD_NUMBER = 7;
    private MapField<String, String> labels_;
    public static final int WARNINGS_FIELD_NUMBER = 8;
    private LazyStringList warnings_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final NodeGroupOperationMetadata DEFAULT_INSTANCE = new NodeGroupOperationMetadata();
    private static final Parser<NodeGroupOperationMetadata> PARSER = new AbstractParser<NodeGroupOperationMetadata>(){

        public NodeGroupOperationMetadata parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = NodeGroupOperationMetadata.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private NodeGroupOperationMetadata(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private NodeGroupOperationMetadata() {
        this.nodeGroupId_ = "";
        this.clusterUuid_ = "";
        this.statusHistory_ = Collections.emptyList();
        this.operationType_ = 0;
        this.description_ = "";
        this.warnings_ = LazyStringArrayList.EMPTY;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new NodeGroupOperationMetadata();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return OperationsProto.internal_static_google_cloud_dataproc_v1_NodeGroupOperationMetadata_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 7: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return OperationsProto.internal_static_google_cloud_dataproc_v1_NodeGroupOperationMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(NodeGroupOperationMetadata.class, Builder.class);
    }

    @Override
    public String getNodeGroupId() {
        Object ref = this.nodeGroupId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.nodeGroupId_ = s;
        return s;
    }

    @Override
    public ByteString getNodeGroupIdBytes() {
        Object ref = this.nodeGroupId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.nodeGroupId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getClusterUuid() {
        Object ref = this.clusterUuid_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.clusterUuid_ = s;
        return s;
    }

    @Override
    public ByteString getClusterUuidBytes() {
        Object ref = this.clusterUuid_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.clusterUuid_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasStatus() {
        return this.status_ != null;
    }

    @Override
    public ClusterOperationStatus getStatus() {
        return this.status_ == null ? ClusterOperationStatus.getDefaultInstance() : this.status_;
    }

    @Override
    public ClusterOperationStatusOrBuilder getStatusOrBuilder() {
        return this.status_ == null ? ClusterOperationStatus.getDefaultInstance() : this.status_;
    }

    @Override
    public List<ClusterOperationStatus> getStatusHistoryList() {
        return this.statusHistory_;
    }

    @Override
    public List<? extends ClusterOperationStatusOrBuilder> getStatusHistoryOrBuilderList() {
        return this.statusHistory_;
    }

    @Override
    public int getStatusHistoryCount() {
        return this.statusHistory_.size();
    }

    @Override
    public ClusterOperationStatus getStatusHistory(int index) {
        return this.statusHistory_.get(index);
    }

    @Override
    public ClusterOperationStatusOrBuilder getStatusHistoryOrBuilder(int index) {
        return this.statusHistory_.get(index);
    }

    @Override
    public int getOperationTypeValue() {
        return this.operationType_;
    }

    @Override
    public NodeGroupOperationType getOperationType() {
        NodeGroupOperationType result = NodeGroupOperationType.forNumber(this.operationType_);
        return result == null ? NodeGroupOperationType.UNRECOGNIZED : result;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    public ProtocolStringList getWarningsList() {
        return this.warnings_;
    }

    @Override
    public int getWarningsCount() {
        return this.warnings_.size();
    }

    @Override
    public String getWarnings(int index) {
        return (String)this.warnings_.get(index);
    }

    @Override
    public ByteString getWarningsBytes(int index) {
        return this.warnings_.getByteString(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.nodeGroupId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.nodeGroupId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterUuid_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.clusterUuid_);
        }
        if (this.status_ != null) {
            output.writeMessage(3, (MessageLite)this.getStatus());
        }
        for (i = 0; i < this.statusHistory_.size(); ++i) {
            output.writeMessage(4, (MessageLite)this.statusHistory_.get(i));
        }
        if (this.operationType_ != NodeGroupOperationType.NODE_GROUP_OPERATION_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.operationType_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.description_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)7);
        for (i = 0; i < this.warnings_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.warnings_.getRaw(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.nodeGroupId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.nodeGroupId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterUuid_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.clusterUuid_);
        }
        if (this.status_ != null) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getStatus());
        }
        for (int i = 0; i < this.statusHistory_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.statusHistory_.get(i)));
        }
        if (this.operationType_ != NodeGroupOperationType.NODE_GROUP_OPERATION_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.operationType_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.description_);
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)labels__);
        }
        int dataSize = 0;
        for (int i = 0; i < this.warnings_.size(); ++i) {
            dataSize += NodeGroupOperationMetadata.computeStringSizeNoTag((Object)this.warnings_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getWarningsList().size();
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeGroupOperationMetadata)) {
            return super.equals(obj);
        }
        NodeGroupOperationMetadata other = (NodeGroupOperationMetadata)obj;
        if (!this.getNodeGroupId().equals(other.getNodeGroupId())) {
            return false;
        }
        if (!this.getClusterUuid().equals(other.getClusterUuid())) {
            return false;
        }
        if (this.hasStatus() != other.hasStatus()) {
            return false;
        }
        if (this.hasStatus() && !this.getStatus().equals(other.getStatus())) {
            return false;
        }
        if (!this.getStatusHistoryList().equals(other.getStatusHistoryList())) {
            return false;
        }
        if (this.operationType_ != other.operationType_) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (!this.getWarningsList().equals(other.getWarningsList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + NodeGroupOperationMetadata.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getNodeGroupId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getClusterUuid().hashCode();
        if (this.hasStatus()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getStatus().hashCode();
        }
        if (this.getStatusHistoryCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getStatusHistoryList().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.operationType_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getDescription().hashCode();
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        if (this.getWarningsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getWarningsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static NodeGroupOperationMetadata parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (NodeGroupOperationMetadata)PARSER.parseFrom(data);
    }

    public static NodeGroupOperationMetadata parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeGroupOperationMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeGroupOperationMetadata parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (NodeGroupOperationMetadata)PARSER.parseFrom(data);
    }

    public static NodeGroupOperationMetadata parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeGroupOperationMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeGroupOperationMetadata parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (NodeGroupOperationMetadata)PARSER.parseFrom(data);
    }

    public static NodeGroupOperationMetadata parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeGroupOperationMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeGroupOperationMetadata parseFrom(InputStream input) throws IOException {
        return (NodeGroupOperationMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static NodeGroupOperationMetadata parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeGroupOperationMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NodeGroupOperationMetadata parseDelimitedFrom(InputStream input) throws IOException {
        return (NodeGroupOperationMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static NodeGroupOperationMetadata parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeGroupOperationMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NodeGroupOperationMetadata parseFrom(CodedInputStream input) throws IOException {
        return (NodeGroupOperationMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static NodeGroupOperationMetadata parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeGroupOperationMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return NodeGroupOperationMetadata.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NodeGroupOperationMetadata prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static NodeGroupOperationMetadata getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<NodeGroupOperationMetadata> parser() {
        return PARSER;
    }

    public Parser<NodeGroupOperationMetadata> getParserForType() {
        return PARSER;
    }

    public NodeGroupOperationMetadata getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements NodeGroupOperationMetadataOrBuilder {
        private int bitField0_;
        private Object nodeGroupId_ = "";
        private Object clusterUuid_ = "";
        private ClusterOperationStatus status_;
        private SingleFieldBuilderV3<ClusterOperationStatus, ClusterOperationStatus.Builder, ClusterOperationStatusOrBuilder> statusBuilder_;
        private List<ClusterOperationStatus> statusHistory_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ClusterOperationStatus, ClusterOperationStatus.Builder, ClusterOperationStatusOrBuilder> statusHistoryBuilder_;
        private int operationType_ = 0;
        private Object description_ = "";
        private MapField<String, String> labels_;
        private LazyStringList warnings_ = LazyStringArrayList.EMPTY;

        public static final Descriptors.Descriptor getDescriptor() {
            return OperationsProto.internal_static_google_cloud_dataproc_v1_NodeGroupOperationMetadata_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 7: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 7: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return OperationsProto.internal_static_google_cloud_dataproc_v1_NodeGroupOperationMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(NodeGroupOperationMetadata.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.nodeGroupId_ = "";
            this.clusterUuid_ = "";
            this.status_ = null;
            if (this.statusBuilder_ != null) {
                this.statusBuilder_.dispose();
                this.statusBuilder_ = null;
            }
            if (this.statusHistoryBuilder_ == null) {
                this.statusHistory_ = Collections.emptyList();
            } else {
                this.statusHistory_ = null;
                this.statusHistoryBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            this.operationType_ = 0;
            this.description_ = "";
            this.internalGetMutableLabels().clear();
            this.warnings_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFF7F;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return OperationsProto.internal_static_google_cloud_dataproc_v1_NodeGroupOperationMetadata_descriptor;
        }

        public NodeGroupOperationMetadata getDefaultInstanceForType() {
            return NodeGroupOperationMetadata.getDefaultInstance();
        }

        public NodeGroupOperationMetadata build() {
            NodeGroupOperationMetadata result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public NodeGroupOperationMetadata buildPartial() {
            NodeGroupOperationMetadata result = new NodeGroupOperationMetadata(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(NodeGroupOperationMetadata result) {
            if (this.statusHistoryBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.statusHistory_ = Collections.unmodifiableList(this.statusHistory_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.statusHistory_ = this.statusHistory_;
            } else {
                result.statusHistory_ = this.statusHistoryBuilder_.build();
            }
            if ((this.bitField0_ & 0x80) != 0) {
                this.warnings_ = this.warnings_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFF7F;
            }
            result.warnings_ = this.warnings_;
        }

        private void buildPartial0(NodeGroupOperationMetadata result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.nodeGroupId_ = this.nodeGroupId_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.clusterUuid_ = this.clusterUuid_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.status_ = this.statusBuilder_ == null ? this.status_ : (ClusterOperationStatus)this.statusBuilder_.build();
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.operationType_ = this.operationType_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.description_ = this.description_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.labels_ = this.internalGetLabels();
                result.labels_.makeImmutable();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof NodeGroupOperationMetadata) {
                return this.mergeFrom((NodeGroupOperationMetadata)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(NodeGroupOperationMetadata other) {
            if (other == NodeGroupOperationMetadata.getDefaultInstance()) {
                return this;
            }
            if (!other.getNodeGroupId().isEmpty()) {
                this.nodeGroupId_ = other.nodeGroupId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getClusterUuid().isEmpty()) {
                this.clusterUuid_ = other.clusterUuid_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.hasStatus()) {
                this.mergeStatus(other.getStatus());
            }
            if (this.statusHistoryBuilder_ == null) {
                if (!other.statusHistory_.isEmpty()) {
                    if (this.statusHistory_.isEmpty()) {
                        this.statusHistory_ = other.statusHistory_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureStatusHistoryIsMutable();
                        this.statusHistory_.addAll(other.statusHistory_);
                    }
                    this.onChanged();
                }
            } else if (!other.statusHistory_.isEmpty()) {
                if (this.statusHistoryBuilder_.isEmpty()) {
                    this.statusHistoryBuilder_.dispose();
                    this.statusHistoryBuilder_ = null;
                    this.statusHistory_ = other.statusHistory_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.statusHistoryBuilder_ = alwaysUseFieldBuilders ? this.getStatusHistoryFieldBuilder() : null;
                } else {
                    this.statusHistoryBuilder_.addAllMessages((Iterable)other.statusHistory_);
                }
            }
            if (other.operationType_ != 0) {
                this.setOperationTypeValue(other.getOperationTypeValue());
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            this.bitField0_ |= 0x40;
            if (!other.warnings_.isEmpty()) {
                if (this.warnings_.isEmpty()) {
                    this.warnings_ = other.warnings_;
                    this.bitField0_ &= 0xFFFFFF7F;
                } else {
                    this.ensureWarningsIsMutable();
                    this.warnings_.addAll((Collection)other.warnings_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block16: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block16;
                        }
                        case 10: {
                            this.nodeGroupId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block16;
                        }
                        case 18: {
                            this.clusterUuid_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block16;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getStatusFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block16;
                        }
                        case 34: {
                            ClusterOperationStatus m = (ClusterOperationStatus)input.readMessage(ClusterOperationStatus.parser(), extensionRegistry);
                            if (this.statusHistoryBuilder_ == null) {
                                this.ensureStatusHistoryIsMutable();
                                this.statusHistory_.add(m);
                                continue block16;
                            }
                            this.statusHistoryBuilder_.addMessage((AbstractMessage)m);
                            continue block16;
                        }
                        case 40: {
                            this.operationType_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block16;
                        }
                        case 50: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block16;
                        }
                        case 58: {
                            MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLabels().getMutableMap().put(labels__.getKey(), labels__.getValue());
                            this.bitField0_ |= 0x40;
                            continue block16;
                        }
                        case 66: {
                            String s = input.readStringRequireUtf8();
                            this.ensureWarningsIsMutable();
                            this.warnings_.add((Object)s);
                            continue block16;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getNodeGroupId() {
            Object ref = this.nodeGroupId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.nodeGroupId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNodeGroupIdBytes() {
            Object ref = this.nodeGroupId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.nodeGroupId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setNodeGroupId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.nodeGroupId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearNodeGroupId() {
            this.nodeGroupId_ = NodeGroupOperationMetadata.getDefaultInstance().getNodeGroupId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNodeGroupIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeGroupOperationMetadata.checkByteStringIsUtf8((ByteString)value);
            this.nodeGroupId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getClusterUuid() {
            Object ref = this.clusterUuid_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.clusterUuid_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClusterUuidBytes() {
            Object ref = this.clusterUuid_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.clusterUuid_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClusterUuid(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clusterUuid_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearClusterUuid() {
            this.clusterUuid_ = NodeGroupOperationMetadata.getDefaultInstance().getClusterUuid();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setClusterUuidBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeGroupOperationMetadata.checkByteStringIsUtf8((ByteString)value);
            this.clusterUuid_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasStatus() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public ClusterOperationStatus getStatus() {
            if (this.statusBuilder_ == null) {
                return this.status_ == null ? ClusterOperationStatus.getDefaultInstance() : this.status_;
            }
            return (ClusterOperationStatus)this.statusBuilder_.getMessage();
        }

        public Builder setStatus(ClusterOperationStatus value) {
            if (this.statusBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.status_ = value;
            } else {
                this.statusBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setStatus(ClusterOperationStatus.Builder builderForValue) {
            if (this.statusBuilder_ == null) {
                this.status_ = builderForValue.build();
            } else {
                this.statusBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeStatus(ClusterOperationStatus value) {
            if (this.statusBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.status_ != null && this.status_ != ClusterOperationStatus.getDefaultInstance()) {
                    this.getStatusBuilder().mergeFrom(value);
                } else {
                    this.status_ = value;
                }
            } else {
                this.statusBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.status_ = null;
            if (this.statusBuilder_ != null) {
                this.statusBuilder_.dispose();
                this.statusBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ClusterOperationStatus.Builder getStatusBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (ClusterOperationStatus.Builder)this.getStatusFieldBuilder().getBuilder();
        }

        @Override
        public ClusterOperationStatusOrBuilder getStatusOrBuilder() {
            if (this.statusBuilder_ != null) {
                return (ClusterOperationStatusOrBuilder)this.statusBuilder_.getMessageOrBuilder();
            }
            return this.status_ == null ? ClusterOperationStatus.getDefaultInstance() : this.status_;
        }

        private SingleFieldBuilderV3<ClusterOperationStatus, ClusterOperationStatus.Builder, ClusterOperationStatusOrBuilder> getStatusFieldBuilder() {
            if (this.statusBuilder_ == null) {
                this.statusBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStatus(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.status_ = null;
            }
            return this.statusBuilder_;
        }

        private void ensureStatusHistoryIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.statusHistory_ = new ArrayList<ClusterOperationStatus>(this.statusHistory_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<ClusterOperationStatus> getStatusHistoryList() {
            if (this.statusHistoryBuilder_ == null) {
                return Collections.unmodifiableList(this.statusHistory_);
            }
            return this.statusHistoryBuilder_.getMessageList();
        }

        @Override
        public int getStatusHistoryCount() {
            if (this.statusHistoryBuilder_ == null) {
                return this.statusHistory_.size();
            }
            return this.statusHistoryBuilder_.getCount();
        }

        @Override
        public ClusterOperationStatus getStatusHistory(int index) {
            if (this.statusHistoryBuilder_ == null) {
                return this.statusHistory_.get(index);
            }
            return (ClusterOperationStatus)this.statusHistoryBuilder_.getMessage(index);
        }

        public Builder setStatusHistory(int index, ClusterOperationStatus value) {
            if (this.statusHistoryBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStatusHistoryIsMutable();
                this.statusHistory_.set(index, value);
                this.onChanged();
            } else {
                this.statusHistoryBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setStatusHistory(int index, ClusterOperationStatus.Builder builderForValue) {
            if (this.statusHistoryBuilder_ == null) {
                this.ensureStatusHistoryIsMutable();
                this.statusHistory_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.statusHistoryBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addStatusHistory(ClusterOperationStatus value) {
            if (this.statusHistoryBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStatusHistoryIsMutable();
                this.statusHistory_.add(value);
                this.onChanged();
            } else {
                this.statusHistoryBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addStatusHistory(int index, ClusterOperationStatus value) {
            if (this.statusHistoryBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStatusHistoryIsMutable();
                this.statusHistory_.add(index, value);
                this.onChanged();
            } else {
                this.statusHistoryBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addStatusHistory(ClusterOperationStatus.Builder builderForValue) {
            if (this.statusHistoryBuilder_ == null) {
                this.ensureStatusHistoryIsMutable();
                this.statusHistory_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.statusHistoryBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addStatusHistory(int index, ClusterOperationStatus.Builder builderForValue) {
            if (this.statusHistoryBuilder_ == null) {
                this.ensureStatusHistoryIsMutable();
                this.statusHistory_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.statusHistoryBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllStatusHistory(Iterable<? extends ClusterOperationStatus> values) {
            if (this.statusHistoryBuilder_ == null) {
                this.ensureStatusHistoryIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.statusHistory_);
                this.onChanged();
            } else {
                this.statusHistoryBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearStatusHistory() {
            if (this.statusHistoryBuilder_ == null) {
                this.statusHistory_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.statusHistoryBuilder_.clear();
            }
            return this;
        }

        public Builder removeStatusHistory(int index) {
            if (this.statusHistoryBuilder_ == null) {
                this.ensureStatusHistoryIsMutable();
                this.statusHistory_.remove(index);
                this.onChanged();
            } else {
                this.statusHistoryBuilder_.remove(index);
            }
            return this;
        }

        public ClusterOperationStatus.Builder getStatusHistoryBuilder(int index) {
            return (ClusterOperationStatus.Builder)this.getStatusHistoryFieldBuilder().getBuilder(index);
        }

        @Override
        public ClusterOperationStatusOrBuilder getStatusHistoryOrBuilder(int index) {
            if (this.statusHistoryBuilder_ == null) {
                return this.statusHistory_.get(index);
            }
            return (ClusterOperationStatusOrBuilder)this.statusHistoryBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ClusterOperationStatusOrBuilder> getStatusHistoryOrBuilderList() {
            if (this.statusHistoryBuilder_ != null) {
                return this.statusHistoryBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.statusHistory_);
        }

        public ClusterOperationStatus.Builder addStatusHistoryBuilder() {
            return (ClusterOperationStatus.Builder)this.getStatusHistoryFieldBuilder().addBuilder((AbstractMessage)ClusterOperationStatus.getDefaultInstance());
        }

        public ClusterOperationStatus.Builder addStatusHistoryBuilder(int index) {
            return (ClusterOperationStatus.Builder)this.getStatusHistoryFieldBuilder().addBuilder(index, (AbstractMessage)ClusterOperationStatus.getDefaultInstance());
        }

        public List<ClusterOperationStatus.Builder> getStatusHistoryBuilderList() {
            return this.getStatusHistoryFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ClusterOperationStatus, ClusterOperationStatus.Builder, ClusterOperationStatusOrBuilder> getStatusHistoryFieldBuilder() {
            if (this.statusHistoryBuilder_ == null) {
                this.statusHistoryBuilder_ = new RepeatedFieldBuilderV3(this.statusHistory_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.statusHistory_ = null;
            }
            return this.statusHistoryBuilder_;
        }

        @Override
        public int getOperationTypeValue() {
            return this.operationType_;
        }

        public Builder setOperationTypeValue(int value) {
            this.operationType_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public NodeGroupOperationType getOperationType() {
            NodeGroupOperationType result = NodeGroupOperationType.forNumber(this.operationType_);
            return result == null ? NodeGroupOperationType.UNRECOGNIZED : result;
        }

        public Builder setOperationType(NodeGroupOperationType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.operationType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearOperationType() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.operationType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = NodeGroupOperationMetadata.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeGroupOperationMetadata.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            this.bitField0_ |= 0x40;
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            this.bitField0_ |= 0x40;
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            this.bitField0_ |= 0x40;
            return this;
        }

        private void ensureWarningsIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.warnings_ = new LazyStringArrayList(this.warnings_);
                this.bitField0_ |= 0x80;
            }
        }

        public ProtocolStringList getWarningsList() {
            return this.warnings_.getUnmodifiableView();
        }

        @Override
        public int getWarningsCount() {
            return this.warnings_.size();
        }

        @Override
        public String getWarnings(int index) {
            return (String)this.warnings_.get(index);
        }

        @Override
        public ByteString getWarningsBytes(int index) {
            return this.warnings_.getByteString(index);
        }

        public Builder setWarnings(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureWarningsIsMutable();
            this.warnings_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addWarnings(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureWarningsIsMutable();
            this.warnings_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllWarnings(Iterable<String> values) {
            this.ensureWarningsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.warnings_);
            this.onChanged();
            return this;
        }

        public Builder clearWarnings() {
            this.warnings_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder addWarningsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeGroupOperationMetadata.checkByteStringIsUtf8((ByteString)value);
            this.ensureWarningsIsMutable();
            this.warnings_.add(value);
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)OperationsProto.internal_static_google_cloud_dataproc_v1_NodeGroupOperationMetadata_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static enum NodeGroupOperationType implements ProtocolMessageEnum
    {
        NODE_GROUP_OPERATION_TYPE_UNSPECIFIED(0),
        CREATE(1),
        UPDATE(2),
        DELETE(3),
        RESIZE(4),
        UNRECOGNIZED(-1);

        public static final int NODE_GROUP_OPERATION_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int CREATE_VALUE = 1;
        public static final int UPDATE_VALUE = 2;
        public static final int DELETE_VALUE = 3;
        public static final int RESIZE_VALUE = 4;
        private static final Internal.EnumLiteMap<NodeGroupOperationType> internalValueMap;
        private static final NodeGroupOperationType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static NodeGroupOperationType valueOf(int value) {
            return NodeGroupOperationType.forNumber(value);
        }

        public static NodeGroupOperationType forNumber(int value) {
            switch (value) {
                case 0: {
                    return NODE_GROUP_OPERATION_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return CREATE;
                }
                case 2: {
                    return UPDATE;
                }
                case 3: {
                    return DELETE;
                }
                case 4: {
                    return RESIZE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<NodeGroupOperationType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)NodeGroupOperationType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return NodeGroupOperationType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)NodeGroupOperationMetadata.getDescriptor().getEnumTypes().get(0);
        }

        public static NodeGroupOperationType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != NodeGroupOperationType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private NodeGroupOperationType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<NodeGroupOperationType>(){

                public NodeGroupOperationType findValueByNumber(int number) {
                    return NodeGroupOperationType.forNumber(number);
                }
            };
            VALUES = NodeGroupOperationType.values();
        }
    }
}

