/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NodeGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_REGION_CLUSTER_NODE_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{node_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String region;
    private final String cluster;
    private final String nodeGroup;

    @Deprecated
    protected NodeGroupName() {
        this.project = null;
        this.region = null;
        this.cluster = null;
        this.nodeGroup = null;
    }

    private NodeGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.nodeGroup = (String)Preconditions.checkNotNull((Object)builder.getNodeGroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getNodeGroup() {
        return this.nodeGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NodeGroupName of(String project, String region, String cluster, String nodeGroup) {
        return NodeGroupName.newBuilder().setProject(project).setRegion(region).setCluster(cluster).setNodeGroup(nodeGroup).build();
    }

    public static String format(String project, String region, String cluster, String nodeGroup) {
        return NodeGroupName.newBuilder().setProject(project).setRegion(region).setCluster(cluster).setNodeGroup(nodeGroup).build().toString();
    }

    public static NodeGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_REGION_CLUSTER_NODE_GROUP.validatedMatch(formattedString, "NodeGroupName.parse: formattedString not in valid format");
        return NodeGroupName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("cluster"), (String)matchMap.get("node_group"));
    }

    public static List<NodeGroupName> parseList(List<String> formattedStrings) {
        ArrayList<NodeGroupName> list = new ArrayList<NodeGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NodeGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NodeGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NodeGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_REGION_CLUSTER_NODE_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NodeGroupName nodeGroupName = this;
            synchronized (nodeGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.region != null) {
                        fieldMapBuilder.put((Object)"region", (Object)this.region);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.nodeGroup != null) {
                        fieldMapBuilder.put((Object)"node_group", (Object)this.nodeGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_REGION_CLUSTER_NODE_GROUP.instantiate(new String[]{"project", this.project, "region", this.region, "cluster", this.cluster, "node_group", this.nodeGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            NodeGroupName that = (NodeGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.region, that.region) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.nodeGroup, that.nodeGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.region);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.nodeGroup);
    }

    public static class Builder {
        private String project;
        private String region;
        private String cluster;
        private String nodeGroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getNodeGroup() {
            return this.nodeGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setNodeGroup(String nodeGroup) {
            this.nodeGroup = nodeGroup;
            return this;
        }

        private Builder(NodeGroupName nodeGroupName) {
            this.project = nodeGroupName.project;
            this.region = nodeGroupName.region;
            this.cluster = nodeGroupName.cluster;
            this.nodeGroup = nodeGroupName.nodeGroup;
        }

        public NodeGroupName build() {
            return new NodeGroupName(this);
        }
    }
}

