/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetadataImportName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE_METADATA_IMPORT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/services/{service}/metadataImports/{metadata_import}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String service;
    private final String metadataImport;

    @Deprecated
    protected MetadataImportName() {
        this.project = null;
        this.location = null;
        this.service = null;
        this.metadataImport = null;
    }

    private MetadataImportName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.metadataImport = (String)Preconditions.checkNotNull((Object)builder.getMetadataImport());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getService() {
        return this.service;
    }

    public String getMetadataImport() {
        return this.metadataImport;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MetadataImportName of(String project, String location, String service, String metadataImport) {
        return MetadataImportName.newBuilder().setProject(project).setLocation(location).setService(service).setMetadataImport(metadataImport).build();
    }

    public static String format(String project, String location, String service, String metadataImport) {
        return MetadataImportName.newBuilder().setProject(project).setLocation(location).setService(service).setMetadataImport(metadataImport).build().toString();
    }

    public static MetadataImportName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SERVICE_METADATA_IMPORT.validatedMatch(formattedString, "MetadataImportName.parse: formattedString not in valid format");
        return MetadataImportName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service"), (String)matchMap.get("metadata_import"));
    }

    public static List<MetadataImportName> parseList(List<String> formattedStrings) {
        ArrayList<MetadataImportName> list = new ArrayList<MetadataImportName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MetadataImportName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MetadataImportName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MetadataImportName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE_METADATA_IMPORT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MetadataImportName metadataImportName = this;
            synchronized (metadataImportName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.service != null) {
                        fieldMapBuilder.put((Object)"service", (Object)this.service);
                    }
                    if (this.metadataImport != null) {
                        fieldMapBuilder.put((Object)"metadata_import", (Object)this.metadataImport);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SERVICE_METADATA_IMPORT.instantiate(new String[]{"project", this.project, "location", this.location, "service", this.service, "metadata_import", this.metadataImport});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MetadataImportName that = (MetadataImportName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.service, that.service) && Objects.equals(this.metadataImport, that.metadataImport);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.service);
        h *= 1000003;
        return h ^= Objects.hashCode(this.metadataImport);
    }

    public static class Builder {
        private String project;
        private String location;
        private String service;
        private String metadataImport;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getService() {
            return this.service;
        }

        public String getMetadataImport() {
            return this.metadataImport;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setMetadataImport(String metadataImport) {
            this.metadataImport = metadataImport;
            return this;
        }

        private Builder(MetadataImportName metadataImportName) {
            this.project = metadataImportName.project;
            this.location = metadataImportName.location;
            this.service = metadataImportName.service;
            this.metadataImport = metadataImportName.metadataImport;
        }

        public MetadataImportName build() {
            return new MetadataImportName(this);
        }
    }
}

