/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NetworkName
implements ResourceName {
    private static final PathTemplate PROJECT_NETWORK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/global/networks/{network}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String network;

    @Deprecated
    protected NetworkName() {
        this.project = null;
        this.network = null;
    }

    private NetworkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.network = (String)Preconditions.checkNotNull((Object)builder.getNetwork());
    }

    public String getProject() {
        return this.project;
    }

    public String getNetwork() {
        return this.network;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NetworkName of(String project, String network) {
        return NetworkName.newBuilder().setProject(project).setNetwork(network).build();
    }

    public static String format(String project, String network) {
        return NetworkName.newBuilder().setProject(project).setNetwork(network).build().toString();
    }

    public static NetworkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NETWORK.validatedMatch(formattedString, "NetworkName.parse: formattedString not in valid format");
        return NetworkName.of((String)matchMap.get("project"), (String)matchMap.get("network"));
    }

    public static List<NetworkName> parseList(List<String> formattedStrings) {
        ArrayList<NetworkName> list = new ArrayList<NetworkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NetworkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NetworkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NetworkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NETWORK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NetworkName networkName = this;
            synchronized (networkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.network != null) {
                        fieldMapBuilder.put((Object)"network", (Object)this.network);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NETWORK.instantiate(new String[]{"project", this.project, "network", this.network});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            NetworkName that = (NetworkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.network, that.network);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.network);
    }

    public static class Builder {
        private String project;
        private String network;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        private Builder(NetworkName networkName) {
            this.project = networkName.project;
            this.network = networkName.network;
        }

        public NetworkName build() {
            return new NetworkName(this);
        }
    }
}

