/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GlossaryTermName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GLOSSARY_GLOSSARY_TERM = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/glossaries/{glossary}/terms/{glossary_term}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String glossary;
    private final String glossaryTerm;

    @Deprecated
    protected GlossaryTermName() {
        this.project = null;
        this.location = null;
        this.glossary = null;
        this.glossaryTerm = null;
    }

    private GlossaryTermName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.glossary = (String)Preconditions.checkNotNull((Object)builder.getGlossary());
        this.glossaryTerm = (String)Preconditions.checkNotNull((Object)builder.getGlossaryTerm());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGlossary() {
        return this.glossary;
    }

    public String getGlossaryTerm() {
        return this.glossaryTerm;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GlossaryTermName of(String project, String location, String glossary, String glossaryTerm) {
        return GlossaryTermName.newBuilder().setProject(project).setLocation(location).setGlossary(glossary).setGlossaryTerm(glossaryTerm).build();
    }

    public static String format(String project, String location, String glossary, String glossaryTerm) {
        return GlossaryTermName.newBuilder().setProject(project).setLocation(location).setGlossary(glossary).setGlossaryTerm(glossaryTerm).build().toString();
    }

    public static GlossaryTermName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GLOSSARY_GLOSSARY_TERM.validatedMatch(formattedString, "GlossaryTermName.parse: formattedString not in valid format");
        return GlossaryTermName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("glossary"), (String)matchMap.get("glossary_term"));
    }

    public static List<GlossaryTermName> parseList(List<String> formattedStrings) {
        ArrayList<GlossaryTermName> list = new ArrayList<GlossaryTermName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GlossaryTermName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GlossaryTermName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GlossaryTermName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GLOSSARY_GLOSSARY_TERM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GlossaryTermName glossaryTermName = this;
            synchronized (glossaryTermName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.glossary != null) {
                        fieldMapBuilder.put((Object)"glossary", (Object)this.glossary);
                    }
                    if (this.glossaryTerm != null) {
                        fieldMapBuilder.put((Object)"glossary_term", (Object)this.glossaryTerm);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GLOSSARY_GLOSSARY_TERM.instantiate(new String[]{"project", this.project, "location", this.location, "glossary", this.glossary, "glossary_term", this.glossaryTerm});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GlossaryTermName that = (GlossaryTermName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.glossary, that.glossary) && Objects.equals(this.glossaryTerm, that.glossaryTerm);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.glossary);
        h *= 1000003;
        return h ^= Objects.hashCode(this.glossaryTerm);
    }

    public static class Builder {
        private String project;
        private String location;
        private String glossary;
        private String glossaryTerm;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGlossary() {
            return this.glossary;
        }

        public String getGlossaryTerm() {
            return this.glossaryTerm;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGlossary(String glossary) {
            this.glossary = glossary;
            return this;
        }

        public Builder setGlossaryTerm(String glossaryTerm) {
            this.glossaryTerm = glossaryTerm;
            return this;
        }

        private Builder(GlossaryTermName glossaryTermName) {
            this.project = glossaryTermName.project;
            this.location = glossaryTermName.location;
            this.glossary = glossaryTermName.glossary;
            this.glossaryTerm = glossaryTermName.glossaryTerm;
        }

        public GlossaryTermName build() {
            return new GlossaryTermName(this);
        }
    }
}

