/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PartitionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_LAKE_ZONE_ENTITY_PARTITION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/entities/{entity}/partitions/{partition}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String lake;
    private final String zone;
    private final String entity;
    private final String partition;

    @Deprecated
    protected PartitionName() {
        this.project = null;
        this.location = null;
        this.lake = null;
        this.zone = null;
        this.entity = null;
        this.partition = null;
    }

    private PartitionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.lake = (String)Preconditions.checkNotNull((Object)builder.getLake());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.entity = (String)Preconditions.checkNotNull((Object)builder.getEntity());
        this.partition = (String)Preconditions.checkNotNull((Object)builder.getPartition());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLake() {
        return this.lake;
    }

    public String getZone() {
        return this.zone;
    }

    public String getEntity() {
        return this.entity;
    }

    public String getPartition() {
        return this.partition;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PartitionName of(String project, String location, String lake, String zone, String entity, String partition) {
        return PartitionName.newBuilder().setProject(project).setLocation(location).setLake(lake).setZone(zone).setEntity(entity).setPartition(partition).build();
    }

    public static String format(String project, String location, String lake, String zone, String entity, String partition) {
        return PartitionName.newBuilder().setProject(project).setLocation(location).setLake(lake).setZone(zone).setEntity(entity).setPartition(partition).build().toString();
    }

    public static PartitionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_LAKE_ZONE_ENTITY_PARTITION.validatedMatch(formattedString, "PartitionName.parse: formattedString not in valid format");
        return PartitionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("lake"), (String)matchMap.get("zone"), (String)matchMap.get("entity"), (String)matchMap.get("partition"));
    }

    public static List<PartitionName> parseList(List<String> formattedStrings) {
        ArrayList<PartitionName> list = new ArrayList<PartitionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PartitionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PartitionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PartitionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_LAKE_ZONE_ENTITY_PARTITION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PartitionName partitionName = this;
            synchronized (partitionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.lake != null) {
                        fieldMapBuilder.put((Object)"lake", (Object)this.lake);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    if (this.entity != null) {
                        fieldMapBuilder.put((Object)"entity", (Object)this.entity);
                    }
                    if (this.partition != null) {
                        fieldMapBuilder.put((Object)"partition", (Object)this.partition);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_LAKE_ZONE_ENTITY_PARTITION.instantiate(new String[]{"project", this.project, "location", this.location, "lake", this.lake, "zone", this.zone, "entity", this.entity, "partition", this.partition});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PartitionName that = (PartitionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.lake, that.lake) && Objects.equals(this.zone, that.zone) && Objects.equals(this.entity, that.entity) && Objects.equals(this.partition, that.partition);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.lake);
        h *= 1000003;
        h ^= Objects.hashCode(this.zone);
        h *= 1000003;
        h ^= Objects.hashCode(this.entity);
        h *= 1000003;
        return h ^= Objects.hashCode(this.partition);
    }

    public static class Builder {
        private String project;
        private String location;
        private String lake;
        private String zone;
        private String entity;
        private String partition;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLake() {
            return this.lake;
        }

        public String getZone() {
            return this.zone;
        }

        public String getEntity() {
            return this.entity;
        }

        public String getPartition() {
            return this.partition;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLake(String lake) {
            this.lake = lake;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder setEntity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder setPartition(String partition) {
            this.partition = partition;
            return this;
        }

        private Builder(PartitionName partitionName) {
            this.project = partitionName.project;
            this.location = partitionName.location;
            this.lake = partitionName.lake;
            this.zone = partitionName.zone;
            this.entity = partitionName.entity;
            this.partition = partitionName.partition;
        }

        public PartitionName build() {
            return new PartitionName(this);
        }
    }
}

