/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.lineage.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RunName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PROCESS_RUN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/processes/{process}/runs/{run}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String process;
    private final String run;

    @Deprecated
    protected RunName() {
        this.project = null;
        this.location = null;
        this.process = null;
        this.run = null;
    }

    private RunName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.process = (String)Preconditions.checkNotNull((Object)builder.getProcess());
        this.run = (String)Preconditions.checkNotNull((Object)builder.getRun());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProcess() {
        return this.process;
    }

    public String getRun() {
        return this.run;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RunName of(String project, String location, String process, String run) {
        return RunName.newBuilder().setProject(project).setLocation(location).setProcess(process).setRun(run).build();
    }

    public static String format(String project, String location, String process, String run) {
        return RunName.newBuilder().setProject(project).setLocation(location).setProcess(process).setRun(run).build().toString();
    }

    public static RunName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PROCESS_RUN.validatedMatch(formattedString, "RunName.parse: formattedString not in valid format");
        return RunName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("process"), (String)matchMap.get("run"));
    }

    public static List<RunName> parseList(List<String> formattedStrings) {
        ArrayList<RunName> list = new ArrayList<RunName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RunName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RunName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RunName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PROCESS_RUN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RunName runName = this;
            synchronized (runName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.process != null) {
                        fieldMapBuilder.put((Object)"process", (Object)this.process);
                    }
                    if (this.run != null) {
                        fieldMapBuilder.put((Object)"run", (Object)this.run);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PROCESS_RUN.instantiate(new String[]{"project", this.project, "location", this.location, "process", this.process, "run", this.run});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RunName that = (RunName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.process, that.process) && Objects.equals(this.run, that.run);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.process);
        h *= 1000003;
        return h ^= Objects.hashCode(this.run);
    }

    public static class Builder {
        private String project;
        private String location;
        private String process;
        private String run;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProcess() {
            return this.process;
        }

        public String getRun() {
            return this.run;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProcess(String process) {
            this.process = process;
            return this;
        }

        public Builder setRun(String run) {
            this.run = run;
            return this;
        }

        private Builder(RunName runName) {
            this.project = runName.project;
            this.location = runName.location;
            this.process = runName.process;
            this.run = runName.run;
        }

        public RunName build() {
            return new RunName(this);
        }
    }
}

