/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataItemName
implements ResourceName {
    private static final PathTemplate PROJECT_DATASET_DATA_ITEM = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/dataItems/{data_item}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataset;
    private final String dataItem;

    @Deprecated
    protected DataItemName() {
        this.project = null;
        this.dataset = null;
        this.dataItem = null;
    }

    private DataItemName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.dataItem = (String)Preconditions.checkNotNull((Object)builder.getDataItem());
    }

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getDataItem() {
        return this.dataItem;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataItemName of(String project, String dataset, String dataItem) {
        return DataItemName.newBuilder().setProject(project).setDataset(dataset).setDataItem(dataItem).build();
    }

    public static String format(String project, String dataset, String dataItem) {
        return DataItemName.newBuilder().setProject(project).setDataset(dataset).setDataItem(dataItem).build().toString();
    }

    public static DataItemName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATASET_DATA_ITEM.validatedMatch(formattedString, "DataItemName.parse: formattedString not in valid format");
        return DataItemName.of((String)matchMap.get("project"), (String)matchMap.get("dataset"), (String)matchMap.get("data_item"));
    }

    public static List<DataItemName> parseList(List<String> formattedStrings) {
        ArrayList<DataItemName> list = new ArrayList<DataItemName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataItemName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataItemName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataItemName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATASET_DATA_ITEM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataItemName dataItemName = this;
            synchronized (dataItemName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    if (this.dataItem != null) {
                        fieldMapBuilder.put((Object)"data_item", (Object)this.dataItem);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATASET_DATA_ITEM.instantiate(new String[]{"project", this.project, "dataset", this.dataset, "data_item", this.dataItem});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DataItemName that = (DataItemName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.dataItem, that.dataItem);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataset);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataItem);
    }

    public static class Builder {
        private String project;
        private String dataset;
        private String dataItem;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getDataItem() {
            return this.dataItem;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setDataItem(String dataItem) {
            this.dataItem = dataItem;
            return this;
        }

        private Builder(DataItemName dataItemName) {
            this.project = dataItemName.project;
            this.dataset = dataItemName.dataset;
            this.dataItem = dataItemName.dataItem;
        }

        public DataItemName build() {
            return new DataItemName(this);
        }
    }
}

