/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AnnotatedDatasetName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataset;
    private final String annotatedDataset;

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getAnnotatedDataset() {
        return this.annotatedDataset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AnnotatedDatasetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.annotatedDataset = (String)Preconditions.checkNotNull((Object)builder.getAnnotatedDataset());
    }

    public static AnnotatedDatasetName of(String project, String dataset, String annotatedDataset) {
        return AnnotatedDatasetName.newBuilder().setProject(project).setDataset(dataset).setAnnotatedDataset(annotatedDataset).build();
    }

    public static String format(String project, String dataset, String annotatedDataset) {
        return AnnotatedDatasetName.newBuilder().setProject(project).setDataset(dataset).setAnnotatedDataset(annotatedDataset).build().toString();
    }

    public static AnnotatedDatasetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AnnotatedDatasetName.parse: formattedString not in valid format");
        return AnnotatedDatasetName.of((String)matchMap.get("project"), (String)matchMap.get("dataset"), (String)matchMap.get("annotated_dataset"));
    }

    public static List<AnnotatedDatasetName> parseList(List<String> formattedStrings) {
        ArrayList<AnnotatedDatasetName> list = new ArrayList<AnnotatedDatasetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnnotatedDatasetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnnotatedDatasetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnnotatedDatasetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnnotatedDatasetName annotatedDatasetName = this;
            synchronized (annotatedDatasetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    fieldMapBuilder.put((Object)"annotatedDataset", (Object)this.annotatedDataset);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "dataset", this.dataset, "annotated_dataset", this.annotatedDataset});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AnnotatedDatasetName) {
            AnnotatedDatasetName that = (AnnotatedDatasetName)o;
            return this.project.equals(that.project) && this.dataset.equals(that.dataset) && this.annotatedDataset.equals(that.annotatedDataset);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.dataset.hashCode();
        h *= 1000003;
        return h ^= this.annotatedDataset.hashCode();
    }

    public static class Builder {
        private String project;
        private String dataset;
        private String annotatedDataset;

        public String getProject() {
            return this.project;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getAnnotatedDataset() {
            return this.annotatedDataset;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setAnnotatedDataset(String annotatedDataset) {
            this.annotatedDataset = annotatedDataset;
            return this;
        }

        private Builder() {
        }

        private Builder(AnnotatedDatasetName annotatedDatasetName) {
            this.project = annotatedDatasetName.project;
            this.dataset = annotatedDatasetName.dataset;
            this.annotatedDataset = annotatedDatasetName.annotatedDataset;
        }

        public AnnotatedDatasetName build() {
            return new AnnotatedDatasetName(this);
        }
    }
}

