/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CompilationResultName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_COMPILATION_RESULT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/compilationResults/{compilation_result}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String compilationResult;

    @Deprecated
    protected CompilationResultName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.compilationResult = null;
    }

    private CompilationResultName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.compilationResult = (String)Preconditions.checkNotNull((Object)builder.getCompilationResult());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getCompilationResult() {
        return this.compilationResult;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CompilationResultName of(String project, String location, String repository, String compilationResult) {
        return CompilationResultName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setCompilationResult(compilationResult).build();
    }

    public static String format(String project, String location, String repository, String compilationResult) {
        return CompilationResultName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setCompilationResult(compilationResult).build().toString();
    }

    public static CompilationResultName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_COMPILATION_RESULT.validatedMatch(formattedString, "CompilationResultName.parse: formattedString not in valid format");
        return CompilationResultName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("compilation_result"));
    }

    public static List<CompilationResultName> parseList(List<String> formattedStrings) {
        ArrayList<CompilationResultName> list = new ArrayList<CompilationResultName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CompilationResultName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CompilationResultName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CompilationResultName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_COMPILATION_RESULT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CompilationResultName compilationResultName = this;
            synchronized (compilationResultName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.compilationResult != null) {
                        fieldMapBuilder.put((Object)"compilation_result", (Object)this.compilationResult);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_COMPILATION_RESULT.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "compilation_result", this.compilationResult});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CompilationResultName that = (CompilationResultName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.compilationResult, that.compilationResult);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.compilationResult);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String compilationResult;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getCompilationResult() {
            return this.compilationResult;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setCompilationResult(String compilationResult) {
            this.compilationResult = compilationResult;
            return this;
        }

        private Builder(CompilationResultName compilationResultName) {
            this.project = compilationResultName.project;
            this.location = compilationResultName.location;
            this.repository = compilationResultName.repository;
            this.compilationResult = compilationResultName.compilationResult;
        }

        public CompilationResultName build() {
            return new CompilationResultName(this);
        }
    }
}

