/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReleaseConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_RELEASE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/releaseConfigs/{release_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String releaseConfig;

    @Deprecated
    protected ReleaseConfigName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.releaseConfig = null;
    }

    private ReleaseConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.releaseConfig = (String)Preconditions.checkNotNull((Object)builder.getReleaseConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getReleaseConfig() {
        return this.releaseConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReleaseConfigName of(String project, String location, String repository, String releaseConfig) {
        return ReleaseConfigName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setReleaseConfig(releaseConfig).build();
    }

    public static String format(String project, String location, String repository, String releaseConfig) {
        return ReleaseConfigName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setReleaseConfig(releaseConfig).build().toString();
    }

    public static ReleaseConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_RELEASE_CONFIG.validatedMatch(formattedString, "ReleaseConfigName.parse: formattedString not in valid format");
        return ReleaseConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("release_config"));
    }

    public static List<ReleaseConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ReleaseConfigName> list = new ArrayList<ReleaseConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReleaseConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReleaseConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReleaseConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_RELEASE_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReleaseConfigName releaseConfigName = this;
            synchronized (releaseConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.releaseConfig != null) {
                        fieldMapBuilder.put((Object)"release_config", (Object)this.releaseConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_RELEASE_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "release_config", this.releaseConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReleaseConfigName that = (ReleaseConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.releaseConfig, that.releaseConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.releaseConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String releaseConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getReleaseConfig() {
            return this.releaseConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setReleaseConfig(String releaseConfig) {
            this.releaseConfig = releaseConfig;
            return this;
        }

        private Builder(ReleaseConfigName releaseConfigName) {
            this.project = releaseConfigName.project;
            this.location = releaseConfigName.location;
            this.repository = releaseConfigName.repository;
            this.releaseConfig = releaseConfigName.releaseConfig;
        }

        public ReleaseConfigName build() {
            return new ReleaseConfigName(this);
        }
    }
}

