/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TaxonomyName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/taxonomies/{taxonomy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String taxonomy;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTaxonomy() {
        return this.taxonomy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TaxonomyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.taxonomy = (String)Preconditions.checkNotNull((Object)builder.getTaxonomy());
    }

    public static TaxonomyName of(String project, String location, String taxonomy) {
        return TaxonomyName.newBuilder().setProject(project).setLocation(location).setTaxonomy(taxonomy).build();
    }

    public static String format(String project, String location, String taxonomy) {
        return TaxonomyName.newBuilder().setProject(project).setLocation(location).setTaxonomy(taxonomy).build().toString();
    }

    public static TaxonomyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TaxonomyName.parse: formattedString not in valid format");
        return TaxonomyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("taxonomy"));
    }

    public static List<TaxonomyName> parseList(List<String> formattedStrings) {
        ArrayList<TaxonomyName> list = new ArrayList<TaxonomyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TaxonomyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TaxonomyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TaxonomyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TaxonomyName taxonomyName = this;
            synchronized (taxonomyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"taxonomy", (Object)this.taxonomy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "taxonomy", this.taxonomy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TaxonomyName) {
            TaxonomyName that = (TaxonomyName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.taxonomy.equals(that.taxonomy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.taxonomy.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String taxonomy;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTaxonomy() {
            return this.taxonomy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTaxonomy(String taxonomy) {
            this.taxonomy = taxonomy;
            return this;
        }

        private Builder() {
        }

        private Builder(TaxonomyName taxonomyName) {
            this.project = taxonomyName.project;
            this.location = taxonomyName.location;
            this.taxonomy = taxonomyName.taxonomy;
        }

        public TaxonomyName build() {
            return new TaxonomyName(this);
        }
    }
}

