/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PolicyTagName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TAXONOMY_POLICY_TAG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/taxonomies/{taxonomy}/policyTags/{policy_tag}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String taxonomy;
    private final String policyTag;

    @Deprecated
    protected PolicyTagName() {
        this.project = null;
        this.location = null;
        this.taxonomy = null;
        this.policyTag = null;
    }

    private PolicyTagName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.taxonomy = (String)Preconditions.checkNotNull((Object)builder.getTaxonomy());
        this.policyTag = (String)Preconditions.checkNotNull((Object)builder.getPolicyTag());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTaxonomy() {
        return this.taxonomy;
    }

    public String getPolicyTag() {
        return this.policyTag;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PolicyTagName of(String project, String location, String taxonomy, String policyTag) {
        return PolicyTagName.newBuilder().setProject(project).setLocation(location).setTaxonomy(taxonomy).setPolicyTag(policyTag).build();
    }

    public static String format(String project, String location, String taxonomy, String policyTag) {
        return PolicyTagName.newBuilder().setProject(project).setLocation(location).setTaxonomy(taxonomy).setPolicyTag(policyTag).build().toString();
    }

    public static PolicyTagName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TAXONOMY_POLICY_TAG.validatedMatch(formattedString, "PolicyTagName.parse: formattedString not in valid format");
        return PolicyTagName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("taxonomy"), (String)matchMap.get("policy_tag"));
    }

    public static List<PolicyTagName> parseList(List<String> formattedStrings) {
        ArrayList<PolicyTagName> list = new ArrayList<PolicyTagName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PolicyTagName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PolicyTagName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PolicyTagName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TAXONOMY_POLICY_TAG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PolicyTagName policyTagName = this;
            synchronized (policyTagName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.taxonomy != null) {
                        fieldMapBuilder.put((Object)"taxonomy", (Object)this.taxonomy);
                    }
                    if (this.policyTag != null) {
                        fieldMapBuilder.put((Object)"policy_tag", (Object)this.policyTag);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TAXONOMY_POLICY_TAG.instantiate(new String[]{"project", this.project, "location", this.location, "taxonomy", this.taxonomy, "policy_tag", this.policyTag});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PolicyTagName that = (PolicyTagName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.taxonomy, that.taxonomy) && Objects.equals(this.policyTag, that.policyTag);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.taxonomy);
        h *= 1000003;
        return h ^= Objects.hashCode(this.policyTag);
    }

    public static class Builder {
        private String project;
        private String location;
        private String taxonomy;
        private String policyTag;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTaxonomy() {
            return this.taxonomy;
        }

        public String getPolicyTag() {
            return this.policyTag;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTaxonomy(String taxonomy) {
            this.taxonomy = taxonomy;
            return this;
        }

        public Builder setPolicyTag(String policyTag) {
            this.policyTag = policyTag;
            return this;
        }

        private Builder(PolicyTagName policyTagName) {
            this.project = policyTagName.project;
            this.location = policyTagName.location;
            this.taxonomy = policyTagName.taxonomy;
            this.policyTag = policyTagName.policyTag;
        }

        public PolicyTagName build() {
            return new PolicyTagName(this);
        }
    }
}

