/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/tags.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.datacatalog.v1beta1;

/**
 *
 *
 * <pre>
 * A tag template defines a tag, which can have one or more typed fields.
 * The template is used to create and attach the tag to Google Cloud resources.
 * [Tag template
 * roles](https://cloud.google.com/iam/docs/understanding-roles#data-catalog-roles)
 * provide permissions to create, edit, and use the template. See, for example,
 * the [TagTemplate
 * User](https://cloud.google.com/data-catalog/docs/how-to/template-user) role,
 * which includes permission to use the tag template to tag resources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.TagTemplate}
 */
public final class TagTemplate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.TagTemplate)
    TagTemplateOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TagTemplate.newBuilder() to construct.
  private TagTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TagTemplate() {
    name_ = "";
    displayName_ = "";
    dataplexTransferStatus_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TagTemplate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1beta1.Tags
        .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetFields();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1beta1.Tags
        .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1beta1.TagTemplate.class,
            com.google.cloud.datacatalog.v1beta1.TagTemplate.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * This enum describes TagTemplate transfer status to Dataplex service.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus}
   */
  public enum DataplexTransferStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. TagTemplate and its tags are only visible and editable in
     * DataCatalog.
     * </pre>
     *
     * <code>DATAPLEX_TRANSFER_STATUS_UNSPECIFIED = 0;</code>
     */
    DATAPLEX_TRANSFER_STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * TagTemplate and its tags are auto-copied to Dataplex service.
     * Visible in both services. Editable in DataCatalog, read-only in Dataplex.
     * Deprecated: Individual TagTemplate migration is deprecated in favor of
     * organization or project wide TagTemplate migration opt-in.
     * </pre>
     *
     * <code>MIGRATED = 1 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    MIGRATED(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. TagTemplate and its tags are only visible and editable in
     * DataCatalog.
     * </pre>
     *
     * <code>DATAPLEX_TRANSFER_STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int DATAPLEX_TRANSFER_STATUS_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * TagTemplate and its tags are auto-copied to Dataplex service.
     * Visible in both services. Editable in DataCatalog, read-only in Dataplex.
     * Deprecated: Individual TagTemplate migration is deprecated in favor of
     * organization or project wide TagTemplate migration opt-in.
     * </pre>
     *
     * <code>MIGRATED = 1 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int MIGRATED_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataplexTransferStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataplexTransferStatus forNumber(int value) {
      switch (value) {
        case 0:
          return DATAPLEX_TRANSFER_STATUS_UNSPECIFIED;
        case 1:
          return MIGRATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataplexTransferStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataplexTransferStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DataplexTransferStatus>() {
              public DataplexTransferStatus findValueByNumber(int number) {
                return DataplexTransferStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.TagTemplate.getDescriptor().getEnumTypes().get(0);
    }

    private static final DataplexTransferStatus[] VALUES = values();

    public static DataplexTransferStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataplexTransferStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the tag template in URL format. Example:
   *
   * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
   *
   * Note that this TagTemplate and its child resources may not actually be
   * stored in the location in this name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the tag template in URL format. Example:
   *
   * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
   *
   * Note that this TagTemplate and its child resources may not actually be
   * stored in the location in this name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * The display name for this template. Defaults to an empty string.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The display name for this template. Defaults to an empty string.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIELDS_FIELD_NUMBER = 3;

  private static final class FieldsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
                    newDefaultInstance(
                        com.google.cloud.datacatalog.v1beta1.Tags
                            .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_FieldsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.datacatalog.v1beta1.TagTemplateField.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
      fields_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
      internalGetFields() {
    if (fields_ == null) {
      return com.google.protobuf.MapField.emptyMapField(FieldsDefaultEntryHolder.defaultEntry);
    }
    return fields_;
  }

  public int getFieldsCount() {
    return internalGetFields().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Required. Map of tag template field IDs to the settings for the field.
   * This map is an exhaustive list of the allowed fields. This map must contain
   * at least one field and at most 500 fields.
   *
   * The keys to this map are tag template field IDs. Field IDs can contain
   * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
   * Field IDs must be at least 1 character long and at most
   * 64 characters long. Field IDs must start with a letter or underscore.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public boolean containsFields(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetFields().getMap().containsKey(key);
  }

  /** Use {@link #getFieldsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
      getFields() {
    return getFieldsMap();
  }

  /**
   *
   *
   * <pre>
   * Required. Map of tag template field IDs to the settings for the field.
   * This map is an exhaustive list of the allowed fields. This map must contain
   * at least one field and at most 500 fields.
   *
   * The keys to this map are tag template field IDs. Field IDs can contain
   * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
   * Field IDs must be at least 1 character long and at most
   * 64 characters long. Field IDs must start with a letter or underscore.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
      getFieldsMap() {
    return internalGetFields().getMap();
  }

  /**
   *
   *
   * <pre>
   * Required. Map of tag template field IDs to the settings for the field.
   * This map is an exhaustive list of the allowed fields. This map must contain
   * at least one field and at most 500 fields.
   *
   * The keys to this map are tag template field IDs. Field IDs can contain
   * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
   * Field IDs must be at least 1 character long and at most
   * 64 characters long. Field IDs must start with a letter or underscore.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.datacatalog.v1beta1.TagTemplateField getFieldsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.datacatalog.v1beta1.TagTemplateField defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField> map =
        internalGetFields().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Required. Map of tag template field IDs to the settings for the field.
   * This map is an exhaustive list of the allowed fields. This map must contain
   * at least one field and at most 500 fields.
   *
   * The keys to this map are tag template field IDs. Field IDs can contain
   * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
   * Field IDs must be at least 1 character long and at most
   * 64 characters long. Field IDs must start with a letter or underscore.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.TagTemplateField getFieldsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField> map =
        internalGetFields().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DATAPLEX_TRANSFER_STATUS_FIELD_NUMBER = 7;
  private int dataplexTransferStatus_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Transfer status of the TagTemplate
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus dataplex_transfer_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for dataplexTransferStatus.
   */
  @java.lang.Override
  public int getDataplexTransferStatusValue() {
    return dataplexTransferStatus_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Transfer status of the TagTemplate
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus dataplex_transfer_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataplexTransferStatus.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus
      getDataplexTransferStatus() {
    com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus result =
        com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus.forNumber(
            dataplexTransferStatus_);
    return result == null
        ? com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetFields(), FieldsDefaultEntryHolder.defaultEntry, 3);
    if (dataplexTransferStatus_
        != com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus
            .DATAPLEX_TRANSFER_STATUS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, dataplexTransferStatus_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        entry : internalGetFields().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
          fields__ =
              FieldsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, fields__);
    }
    if (dataplexTransferStatus_
        != com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus
            .DATAPLEX_TRANSFER_STATUS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, dataplexTransferStatus_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.TagTemplate)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1beta1.TagTemplate other =
        (com.google.cloud.datacatalog.v1beta1.TagTemplate) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!internalGetFields().equals(other.internalGetFields())) return false;
    if (dataplexTransferStatus_ != other.dataplexTransferStatus_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (!internalGetFields().getMap().isEmpty()) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFields().hashCode();
    }
    hash = (37 * hash) + DATAPLEX_TRANSFER_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + dataplexTransferStatus_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1beta1.TagTemplate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A tag template defines a tag, which can have one or more typed fields.
   * The template is used to create and attach the tag to Google Cloud resources.
   * [Tag template
   * roles](https://cloud.google.com/iam/docs/understanding-roles#data-catalog-roles)
   * provide permissions to create, edit, and use the template. See, for example,
   * the [TagTemplate
   * User](https://cloud.google.com/data-catalog/docs/how-to/template-user) role,
   * which includes permission to use the tag template to tag resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.TagTemplate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.TagTemplate)
      com.google.cloud.datacatalog.v1beta1.TagTemplateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.Tags
          .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetFields();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableFields();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.Tags
          .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.TagTemplate.class,
              com.google.cloud.datacatalog.v1beta1.TagTemplate.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1beta1.TagTemplate.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      internalGetMutableFields().clear();
      dataplexTransferStatus_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1beta1.Tags
          .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TagTemplate getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1beta1.TagTemplate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TagTemplate build() {
      com.google.cloud.datacatalog.v1beta1.TagTemplate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TagTemplate buildPartial() {
      com.google.cloud.datacatalog.v1beta1.TagTemplate result =
          new com.google.cloud.datacatalog.v1beta1.TagTemplate(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1beta1.TagTemplate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.fields_ = internalGetFields().build(FieldsDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dataplexTransferStatus_ = dataplexTransferStatus_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1beta1.TagTemplate) {
        return mergeFrom((com.google.cloud.datacatalog.v1beta1.TagTemplate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1beta1.TagTemplate other) {
      if (other == com.google.cloud.datacatalog.v1beta1.TagTemplate.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableFields().mergeFrom(other.internalGetFields());
      bitField0_ |= 0x00000004;
      if (other.dataplexTransferStatus_ != 0) {
        setDataplexTransferStatusValue(other.getDataplexTransferStatusValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
                    fields__ =
                        input.readMessage(
                            FieldsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableFields()
                    .ensureBuilderMap()
                    .put(fields__.getKey(), fields__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 56:
              {
                dataplexTransferStatus_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the tag template in URL format. Example:
     *
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     *
     * Note that this TagTemplate and its child resources may not actually be
     * stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the tag template in URL format. Example:
     *
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     *
     * Note that this TagTemplate and its child resources may not actually be
     * stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the tag template in URL format. Example:
     *
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     *
     * Note that this TagTemplate and its child resources may not actually be
     * stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the tag template in URL format. Example:
     *
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     *
     * Note that this TagTemplate and its child resources may not actually be
     * stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the tag template in URL format. Example:
     *
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     *
     * Note that this TagTemplate and its child resources may not actually be
     * stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * The display name for this template. Defaults to an empty string.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name for this template. Defaults to an empty string.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name for this template. Defaults to an empty string.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name for this template. Defaults to an empty string.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name for this template. Defaults to an empty string.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private static final class FieldsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.datacatalog.v1beta1.TagTemplateFieldOrBuilder,
            com.google.cloud.datacatalog.v1beta1.TagTemplateField> {
      @java.lang.Override
      public com.google.cloud.datacatalog.v1beta1.TagTemplateField build(
          com.google.cloud.datacatalog.v1beta1.TagTemplateFieldOrBuilder val) {
        if (val instanceof com.google.cloud.datacatalog.v1beta1.TagTemplateField) {
          return (com.google.cloud.datacatalog.v1beta1.TagTemplateField) val;
        }
        return ((com.google.cloud.datacatalog.v1beta1.TagTemplateField.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
          defaultEntry() {
        return FieldsDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final FieldsConverter fieldsConverter = new FieldsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.datacatalog.v1beta1.TagTemplateFieldOrBuilder,
            com.google.cloud.datacatalog.v1beta1.TagTemplateField,
            com.google.cloud.datacatalog.v1beta1.TagTemplateField.Builder>
        fields_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.datacatalog.v1beta1.TagTemplateFieldOrBuilder,
            com.google.cloud.datacatalog.v1beta1.TagTemplateField,
            com.google.cloud.datacatalog.v1beta1.TagTemplateField.Builder>
        internalGetFields() {
      if (fields_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(fieldsConverter);
      }
      return fields_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.datacatalog.v1beta1.TagTemplateFieldOrBuilder,
            com.google.cloud.datacatalog.v1beta1.TagTemplateField,
            com.google.cloud.datacatalog.v1beta1.TagTemplateField.Builder>
        internalGetMutableFields() {
      if (fields_ == null) {
        fields_ = new com.google.protobuf.MapFieldBuilder<>(fieldsConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return fields_;
    }

    public int getFieldsCount() {
      return internalGetFields().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     *
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public boolean containsFields(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetFields().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getFieldsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        getFields() {
      return getFieldsMap();
    }

    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     *
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        getFieldsMap() {
      return internalGetFields().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     *
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.datacatalog.v1beta1.TagTemplateField getFieldsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.datacatalog.v1beta1.TagTemplateField defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateFieldOrBuilder>
          map = internalGetMutableFields().ensureBuilderMap();
      return map.containsKey(key) ? fieldsConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     *
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TagTemplateField getFieldsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateFieldOrBuilder>
          map = internalGetMutableFields().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return fieldsConverter.build(map.get(key));
    }

    public Builder clearFields() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableFields().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     *
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeFields(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableFields().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        getMutableFields() {
      bitField0_ |= 0x00000004;
      return internalGetMutableFields().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     *
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putFields(
        java.lang.String key, com.google.cloud.datacatalog.v1beta1.TagTemplateField value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableFields().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     *
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putAllFields(
        java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableFields().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     *
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.TagTemplateField.Builder putFieldsBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<
              java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateFieldOrBuilder>
          builderMap = internalGetMutableFields().ensureBuilderMap();
      com.google.cloud.datacatalog.v1beta1.TagTemplateFieldOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.datacatalog.v1beta1.TagTemplateField.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.datacatalog.v1beta1.TagTemplateField) {
        entry = ((com.google.cloud.datacatalog.v1beta1.TagTemplateField) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.datacatalog.v1beta1.TagTemplateField.Builder) entry;
    }

    private int dataplexTransferStatus_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Transfer status of the TagTemplate
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus dataplex_transfer_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for dataplexTransferStatus.
     */
    @java.lang.Override
    public int getDataplexTransferStatusValue() {
      return dataplexTransferStatus_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Transfer status of the TagTemplate
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus dataplex_transfer_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for dataplexTransferStatus to set.
     * @return This builder for chaining.
     */
    public Builder setDataplexTransferStatusValue(int value) {
      dataplexTransferStatus_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Transfer status of the TagTemplate
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus dataplex_transfer_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataplexTransferStatus.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus
        getDataplexTransferStatus() {
      com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus result =
          com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus.forNumber(
              dataplexTransferStatus_);
      return result == null
          ? com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. Transfer status of the TagTemplate
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus dataplex_transfer_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The dataplexTransferStatus to set.
     * @return This builder for chaining.
     */
    public Builder setDataplexTransferStatus(
        com.google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      dataplexTransferStatus_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Transfer status of the TagTemplate
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus dataplex_transfer_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataplexTransferStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      dataplexTransferStatus_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.TagTemplate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.TagTemplate)
  private static final com.google.cloud.datacatalog.v1beta1.TagTemplate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.TagTemplate();
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TagTemplate> PARSER =
      new com.google.protobuf.AbstractParser<TagTemplate>() {
        @java.lang.Override
        public TagTemplate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TagTemplate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TagTemplate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.TagTemplate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
