/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/physical_schema.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Native schema used by a resource represented as an entry. Used by query
 * engines for deserializing and parsing source data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema}
 */
public final class PhysicalSchema extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.PhysicalSchema)
    PhysicalSchemaOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PhysicalSchema.newBuilder() to construct.
  private PhysicalSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PhysicalSchema() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PhysicalSchema();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
        .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
        .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.PhysicalSchema.class,
            com.google.cloud.datacatalog.v1.PhysicalSchema.Builder.class);
  }

  public interface AvroSchemaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * JSON source of the Avro schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    java.lang.String getText();

    /**
     *
     *
     * <pre>
     * JSON source of the Avro schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();
  }

  /**
   *
   *
   * <pre>
   * Schema in Avro JSON format.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema}
   */
  public static final class AvroSchema extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema)
      AvroSchemaOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AvroSchema.newBuilder() to construct.
    private AvroSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AvroSchema() {
      text_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AvroSchema();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_AvroSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_AvroSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.class,
              com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.Builder.class);
    }

    public static final int TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";

    /**
     *
     *
     * <pre>
     * JSON source of the Avro schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * JSON source of the Avro schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema other =
          (com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) obj;

      if (!getText().equals(other.getText())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Schema in Avro JSON format.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema)
        com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchemaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_AvroSchema_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_AvroSchema_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.class,
                com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.Builder.class);
      }

      // Construct using com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        text_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_AvroSchema_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema build() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema buildPartial() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema result =
            new com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.text_ = text_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) {
          return mergeFrom((com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema other) {
        if (other == com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.getDefaultInstance())
          return this;
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object text_ = "";

      /**
       *
       *
       * <pre>
       * JSON source of the Avro schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * JSON source of the Avro schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * JSON source of the Avro schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * JSON source of the Avro schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * JSON source of the Avro schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema)
    private static final com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema();
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AvroSchema> PARSER =
        new com.google.protobuf.AbstractParser<AvroSchema>() {
          @java.lang.Override
          public AvroSchema parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AvroSchema> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AvroSchema> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ThriftSchemaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Thrift IDL source of the schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    java.lang.String getText();

    /**
     *
     *
     * <pre>
     * Thrift IDL source of the schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();
  }

  /**
   *
   *
   * <pre>
   * Schema in Thrift format.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema}
   */
  public static final class ThriftSchema extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema)
      ThriftSchemaOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ThriftSchema.newBuilder() to construct.
    private ThriftSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ThriftSchema() {
      text_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ThriftSchema();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ThriftSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ThriftSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.class,
              com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.Builder.class);
    }

    public static final int TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";

    /**
     *
     *
     * <pre>
     * Thrift IDL source of the schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Thrift IDL source of the schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema other =
          (com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) obj;

      if (!getText().equals(other.getText())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Schema in Thrift format.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema)
        com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchemaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ThriftSchema_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ThriftSchema_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.class,
                com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.Builder.class);
      }

      // Construct using com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        text_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ThriftSchema_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema
          getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema build() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema buildPartial() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema result =
            new com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.text_ = text_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) {
          return mergeFrom((com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema other) {
        if (other
            == com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.getDefaultInstance())
          return this;
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object text_ = "";

      /**
       *
       *
       * <pre>
       * Thrift IDL source of the schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Thrift IDL source of the schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Thrift IDL source of the schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Thrift IDL source of the schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Thrift IDL source of the schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema)
    private static final com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema();
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ThriftSchema> PARSER =
        new com.google.protobuf.AbstractParser<ThriftSchema>() {
          @java.lang.Override
          public ThriftSchema parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ThriftSchema> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ThriftSchema> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ProtobufSchemaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Protocol buffer source of the schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    java.lang.String getText();

    /**
     *
     *
     * <pre>
     * Protocol buffer source of the schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();
  }

  /**
   *
   *
   * <pre>
   * Schema in protocol buffer format.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema}
   */
  public static final class ProtobufSchema extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema)
      ProtobufSchemaOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ProtobufSchema.newBuilder() to construct.
    private ProtobufSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ProtobufSchema() {
      text_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ProtobufSchema();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ProtobufSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ProtobufSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.class,
              com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.Builder.class);
    }

    public static final int TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";

    /**
     *
     *
     * <pre>
     * Protocol buffer source of the schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Protocol buffer source of the schema.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema other =
          (com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) obj;

      if (!getText().equals(other.getText())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Schema in protocol buffer format.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema)
        com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchemaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ProtobufSchema_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ProtobufSchema_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.class,
                com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.Builder.class);
      }

      // Construct using com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        text_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ProtobufSchema_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema
          getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema build() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema buildPartial() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema result =
            new com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.text_ = text_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) {
          return mergeFrom((com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema other) {
        if (other
            == com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.getDefaultInstance())
          return this;
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object text_ = "";

      /**
       *
       *
       * <pre>
       * Protocol buffer source of the schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Protocol buffer source of the schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Protocol buffer source of the schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Protocol buffer source of the schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Protocol buffer source of the schema.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema)
    private static final com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema();
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ProtobufSchema> PARSER =
        new com.google.protobuf.AbstractParser<ProtobufSchema>() {
          @java.lang.Override
          public ProtobufSchema parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ProtobufSchema> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ProtobufSchema> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ParquetSchemaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * Marks a Parquet-encoded data source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema}
   */
  public static final class ParquetSchema extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema)
      ParquetSchemaOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ParquetSchema.newBuilder() to construct.
    private ParquetSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ParquetSchema() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ParquetSchema();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ParquetSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ParquetSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.class,
              com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema other =
          (com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Marks a Parquet-encoded data source.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema)
        com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchemaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ParquetSchema_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ParquetSchema_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.class,
                com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.Builder.class);
      }

      // Construct using com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_ParquetSchema_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema
          getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema build() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema buildPartial() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema result =
            new com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) {
          return mergeFrom((com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema other) {
        if (other
            == com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema)
    private static final com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema();
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ParquetSchema> PARSER =
        new com.google.protobuf.AbstractParser<ParquetSchema>() {
          @java.lang.Override
          public ParquetSchema parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ParquetSchema> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ParquetSchema> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OrcSchemaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * Marks an ORC-encoded data source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema}
   */
  public static final class OrcSchema extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema)
      OrcSchemaOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use OrcSchema.newBuilder() to construct.
    private OrcSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OrcSchema() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OrcSchema();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_OrcSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_OrcSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.class,
              com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema other =
          (com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Marks an ORC-encoded data source.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema)
        com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchemaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_OrcSchema_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_OrcSchema_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.class,
                com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.Builder.class);
      }

      // Construct using com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_OrcSchema_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema build() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema buildPartial() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema result =
            new com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) {
          return mergeFrom((com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema other) {
        if (other == com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema)
    private static final com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema();
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OrcSchema> PARSER =
        new com.google.protobuf.AbstractParser<OrcSchema>() {
          @java.lang.Override
          public OrcSchema parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OrcSchema> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OrcSchema> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CsvSchemaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * Marks a CSV-encoded data source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema}
   */
  public static final class CsvSchema extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema)
      CsvSchemaOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CsvSchema.newBuilder() to construct.
    private CsvSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CsvSchema() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CsvSchema();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_CsvSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_CsvSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.class,
              com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema other =
          (com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Marks a CSV-encoded data source.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema)
        com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchemaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_CsvSchema_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_CsvSchema_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.class,
                com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.Builder.class);
      }

      // Construct using com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
            .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_CsvSchema_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema build() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema buildPartial() {
        com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema result =
            new com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) {
          return mergeFrom((com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema other) {
        if (other == com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema)
    private static final com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema();
    }

    public static com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CsvSchema> PARSER =
        new com.google.protobuf.AbstractParser<CsvSchema>() {
          @java.lang.Override
          public CsvSchema parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CsvSchema> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CsvSchema> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int schemaCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object schema_;

  public enum SchemaCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AVRO(1),
    THRIFT(2),
    PROTOBUF(3),
    PARQUET(4),
    ORC(5),
    CSV(6),
    SCHEMA_NOT_SET(0);
    private final int value;

    private SchemaCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SchemaCase valueOf(int value) {
      return forNumber(value);
    }

    public static SchemaCase forNumber(int value) {
      switch (value) {
        case 1:
          return AVRO;
        case 2:
          return THRIFT;
        case 3:
          return PROTOBUF;
        case 4:
          return PARQUET;
        case 5:
          return ORC;
        case 6:
          return CSV;
        case 0:
          return SCHEMA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SchemaCase getSchemaCase() {
    return SchemaCase.forNumber(schemaCase_);
  }

  public static final int AVRO_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Schema in Avro JSON format.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
   *
   * @return Whether the avro field is set.
   */
  @java.lang.Override
  public boolean hasAvro() {
    return schemaCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Schema in Avro JSON format.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
   *
   * @return The avro.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema getAvro() {
    if (schemaCase_ == 1) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Schema in Avro JSON format.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchemaOrBuilder getAvroOrBuilder() {
    if (schemaCase_ == 1) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.getDefaultInstance();
  }

  public static final int THRIFT_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Schema in Thrift format.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
   *
   * @return Whether the thrift field is set.
   */
  @java.lang.Override
  public boolean hasThrift() {
    return schemaCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Schema in Thrift format.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
   *
   * @return The thrift.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema getThrift() {
    if (schemaCase_ == 2) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Schema in Thrift format.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchemaOrBuilder getThriftOrBuilder() {
    if (schemaCase_ == 2) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.getDefaultInstance();
  }

  public static final int PROTOBUF_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Schema in protocol buffer format.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
   *
   * @return Whether the protobuf field is set.
   */
  @java.lang.Override
  public boolean hasProtobuf() {
    return schemaCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Schema in protocol buffer format.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
   *
   * @return The protobuf.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema getProtobuf() {
    if (schemaCase_ == 3) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Schema in protocol buffer format.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchemaOrBuilder
      getProtobufOrBuilder() {
    if (schemaCase_ == 3) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.getDefaultInstance();
  }

  public static final int PARQUET_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Marks a Parquet-encoded data source.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
   *
   * @return Whether the parquet field is set.
   */
  @java.lang.Override
  public boolean hasParquet() {
    return schemaCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Marks a Parquet-encoded data source.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
   *
   * @return The parquet.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema getParquet() {
    if (schemaCase_ == 4) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Marks a Parquet-encoded data source.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchemaOrBuilder
      getParquetOrBuilder() {
    if (schemaCase_ == 4) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.getDefaultInstance();
  }

  public static final int ORC_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Marks an ORC-encoded data source.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
   *
   * @return Whether the orc field is set.
   */
  @java.lang.Override
  public boolean hasOrc() {
    return schemaCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Marks an ORC-encoded data source.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
   *
   * @return The orc.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema getOrc() {
    if (schemaCase_ == 5) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Marks an ORC-encoded data source.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchemaOrBuilder getOrcOrBuilder() {
    if (schemaCase_ == 5) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.getDefaultInstance();
  }

  public static final int CSV_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Marks a CSV-encoded data source.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
   *
   * @return Whether the csv field is set.
   */
  @java.lang.Override
  public boolean hasCsv() {
    return schemaCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Marks a CSV-encoded data source.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
   *
   * @return The csv.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema getCsv() {
    if (schemaCase_ == 6) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Marks a CSV-encoded data source.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchemaOrBuilder getCsvOrBuilder() {
    if (schemaCase_ == 6) {
      return (com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) schema_;
    }
    return com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (schemaCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) schema_);
    }
    if (schemaCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) schema_);
    }
    if (schemaCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) schema_);
    }
    if (schemaCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) schema_);
    }
    if (schemaCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) schema_);
    }
    if (schemaCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) schema_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (schemaCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) schema_);
    }
    if (schemaCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) schema_);
    }
    if (schemaCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) schema_);
    }
    if (schemaCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) schema_);
    }
    if (schemaCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) schema_);
    }
    if (schemaCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) schema_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.PhysicalSchema)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.PhysicalSchema other =
        (com.google.cloud.datacatalog.v1.PhysicalSchema) obj;

    if (!getSchemaCase().equals(other.getSchemaCase())) return false;
    switch (schemaCase_) {
      case 1:
        if (!getAvro().equals(other.getAvro())) return false;
        break;
      case 2:
        if (!getThrift().equals(other.getThrift())) return false;
        break;
      case 3:
        if (!getProtobuf().equals(other.getProtobuf())) return false;
        break;
      case 4:
        if (!getParquet().equals(other.getParquet())) return false;
        break;
      case 5:
        if (!getOrc().equals(other.getOrc())) return false;
        break;
      case 6:
        if (!getCsv().equals(other.getCsv())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (schemaCase_) {
      case 1:
        hash = (37 * hash) + AVRO_FIELD_NUMBER;
        hash = (53 * hash) + getAvro().hashCode();
        break;
      case 2:
        hash = (37 * hash) + THRIFT_FIELD_NUMBER;
        hash = (53 * hash) + getThrift().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PROTOBUF_FIELD_NUMBER;
        hash = (53 * hash) + getProtobuf().hashCode();
        break;
      case 4:
        hash = (37 * hash) + PARQUET_FIELD_NUMBER;
        hash = (53 * hash) + getParquet().hashCode();
        break;
      case 5:
        hash = (37 * hash) + ORC_FIELD_NUMBER;
        hash = (53 * hash) + getOrc().hashCode();
        break;
      case 6:
        hash = (37 * hash) + CSV_FIELD_NUMBER;
        hash = (53 * hash) + getCsv().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.PhysicalSchema prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Native schema used by a resource represented as an entry. Used by query
   * engines for deserializing and parsing source data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.PhysicalSchema}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.PhysicalSchema)
      com.google.cloud.datacatalog.v1.PhysicalSchemaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.PhysicalSchema.class,
              com.google.cloud.datacatalog.v1.PhysicalSchema.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.PhysicalSchema.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (avroBuilder_ != null) {
        avroBuilder_.clear();
      }
      if (thriftBuilder_ != null) {
        thriftBuilder_.clear();
      }
      if (protobufBuilder_ != null) {
        protobufBuilder_.clear();
      }
      if (parquetBuilder_ != null) {
        parquetBuilder_.clear();
      }
      if (orcBuilder_ != null) {
        orcBuilder_.clear();
      }
      if (csvBuilder_ != null) {
        csvBuilder_.clear();
      }
      schemaCase_ = 0;
      schema_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.PhysicalSchemaProto
          .internal_static_google_cloud_datacatalog_v1_PhysicalSchema_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.PhysicalSchema.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema build() {
      com.google.cloud.datacatalog.v1.PhysicalSchema result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema buildPartial() {
      com.google.cloud.datacatalog.v1.PhysicalSchema result =
          new com.google.cloud.datacatalog.v1.PhysicalSchema(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.PhysicalSchema result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.datacatalog.v1.PhysicalSchema result) {
      result.schemaCase_ = schemaCase_;
      result.schema_ = this.schema_;
      if (schemaCase_ == 1 && avroBuilder_ != null) {
        result.schema_ = avroBuilder_.build();
      }
      if (schemaCase_ == 2 && thriftBuilder_ != null) {
        result.schema_ = thriftBuilder_.build();
      }
      if (schemaCase_ == 3 && protobufBuilder_ != null) {
        result.schema_ = protobufBuilder_.build();
      }
      if (schemaCase_ == 4 && parquetBuilder_ != null) {
        result.schema_ = parquetBuilder_.build();
      }
      if (schemaCase_ == 5 && orcBuilder_ != null) {
        result.schema_ = orcBuilder_.build();
      }
      if (schemaCase_ == 6 && csvBuilder_ != null) {
        result.schema_ = csvBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.PhysicalSchema) {
        return mergeFrom((com.google.cloud.datacatalog.v1.PhysicalSchema) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.PhysicalSchema other) {
      if (other == com.google.cloud.datacatalog.v1.PhysicalSchema.getDefaultInstance()) return this;
      switch (other.getSchemaCase()) {
        case AVRO:
          {
            mergeAvro(other.getAvro());
            break;
          }
        case THRIFT:
          {
            mergeThrift(other.getThrift());
            break;
          }
        case PROTOBUF:
          {
            mergeProtobuf(other.getProtobuf());
            break;
          }
        case PARQUET:
          {
            mergeParquet(other.getParquet());
            break;
          }
        case ORC:
          {
            mergeOrc(other.getOrc());
            break;
          }
        case CSV:
          {
            mergeCsv(other.getCsv());
            break;
          }
        case SCHEMA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAvroFieldBuilder().getBuilder(), extensionRegistry);
                schemaCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getThriftFieldBuilder().getBuilder(), extensionRegistry);
                schemaCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getProtobufFieldBuilder().getBuilder(), extensionRegistry);
                schemaCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getParquetFieldBuilder().getBuilder(), extensionRegistry);
                schemaCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getOrcFieldBuilder().getBuilder(), extensionRegistry);
                schemaCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCsvFieldBuilder().getBuilder(), extensionRegistry);
                schemaCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int schemaCase_ = 0;
    private java.lang.Object schema_;

    public SchemaCase getSchemaCase() {
      return SchemaCase.forNumber(schemaCase_);
    }

    public Builder clearSchema() {
      schemaCase_ = 0;
      schema_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchemaOrBuilder>
        avroBuilder_;

    /**
     *
     *
     * <pre>
     * Schema in Avro JSON format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
     *
     * @return Whether the avro field is set.
     */
    @java.lang.Override
    public boolean hasAvro() {
      return schemaCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Schema in Avro JSON format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
     *
     * @return The avro.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema getAvro() {
      if (avroBuilder_ == null) {
        if (schemaCase_ == 1) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 1) {
          return avroBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Schema in Avro JSON format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
     */
    public Builder setAvro(com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema value) {
      if (avroBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        avroBuilder_.setMessage(value);
      }
      schemaCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in Avro JSON format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
     */
    public Builder setAvro(
        com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.Builder builderForValue) {
      if (avroBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        avroBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in Avro JSON format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
     */
    public Builder mergeAvro(com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema value) {
      if (avroBuilder_ == null) {
        if (schemaCase_ == 1
            && schema_
                != com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.getDefaultInstance()) {
          schema_ =
              com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.newBuilder(
                      (com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 1) {
          avroBuilder_.mergeFrom(value);
        } else {
          avroBuilder_.setMessage(value);
        }
      }
      schemaCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in Avro JSON format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
     */
    public Builder clearAvro() {
      if (avroBuilder_ == null) {
        if (schemaCase_ == 1) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 1) {
          schemaCase_ = 0;
          schema_ = null;
        }
        avroBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in Avro JSON format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
     */
    public com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.Builder getAvroBuilder() {
      return getAvroFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Schema in Avro JSON format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchemaOrBuilder getAvroOrBuilder() {
      if ((schemaCase_ == 1) && (avroBuilder_ != null)) {
        return avroBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 1) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Schema in Avro JSON format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema avro = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchemaOrBuilder>
        getAvroFieldBuilder() {
      if (avroBuilder_ == null) {
        if (!(schemaCase_ == 1)) {
          schema_ = com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.getDefaultInstance();
        }
        avroBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema,
                com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema.Builder,
                com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchemaOrBuilder>(
                (com.google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 1;
      onChanged();
      return avroBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchemaOrBuilder>
        thriftBuilder_;

    /**
     *
     *
     * <pre>
     * Schema in Thrift format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
     *
     * @return Whether the thrift field is set.
     */
    @java.lang.Override
    public boolean hasThrift() {
      return schemaCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Schema in Thrift format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
     *
     * @return The thrift.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema getThrift() {
      if (thriftBuilder_ == null) {
        if (schemaCase_ == 2) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 2) {
          return thriftBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Schema in Thrift format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
     */
    public Builder setThrift(com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema value) {
      if (thriftBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        thriftBuilder_.setMessage(value);
      }
      schemaCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in Thrift format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
     */
    public Builder setThrift(
        com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.Builder builderForValue) {
      if (thriftBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        thriftBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in Thrift format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
     */
    public Builder mergeThrift(com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema value) {
      if (thriftBuilder_ == null) {
        if (schemaCase_ == 2
            && schema_
                != com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema
                    .getDefaultInstance()) {
          schema_ =
              com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.newBuilder(
                      (com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 2) {
          thriftBuilder_.mergeFrom(value);
        } else {
          thriftBuilder_.setMessage(value);
        }
      }
      schemaCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in Thrift format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
     */
    public Builder clearThrift() {
      if (thriftBuilder_ == null) {
        if (schemaCase_ == 2) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 2) {
          schemaCase_ = 0;
          schema_ = null;
        }
        thriftBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in Thrift format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
     */
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.Builder getThriftBuilder() {
      return getThriftFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Schema in Thrift format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchemaOrBuilder
        getThriftOrBuilder() {
      if ((schemaCase_ == 2) && (thriftBuilder_ != null)) {
        return thriftBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 2) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Schema in Thrift format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema thrift = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchemaOrBuilder>
        getThriftFieldBuilder() {
      if (thriftBuilder_ == null) {
        if (!(schemaCase_ == 2)) {
          schema_ =
              com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.getDefaultInstance();
        }
        thriftBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema,
                com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema.Builder,
                com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchemaOrBuilder>(
                (com.google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 2;
      onChanged();
      return thriftBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchemaOrBuilder>
        protobufBuilder_;

    /**
     *
     *
     * <pre>
     * Schema in protocol buffer format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
     *
     * @return Whether the protobuf field is set.
     */
    @java.lang.Override
    public boolean hasProtobuf() {
      return schemaCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Schema in protocol buffer format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
     *
     * @return The protobuf.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema getProtobuf() {
      if (protobufBuilder_ == null) {
        if (schemaCase_ == 3) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 3) {
          return protobufBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Schema in protocol buffer format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
     */
    public Builder setProtobuf(
        com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema value) {
      if (protobufBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        protobufBuilder_.setMessage(value);
      }
      schemaCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in protocol buffer format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
     */
    public Builder setProtobuf(
        com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.Builder builderForValue) {
      if (protobufBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        protobufBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in protocol buffer format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
     */
    public Builder mergeProtobuf(
        com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema value) {
      if (protobufBuilder_ == null) {
        if (schemaCase_ == 3
            && schema_
                != com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema
                    .getDefaultInstance()) {
          schema_ =
              com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.newBuilder(
                      (com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 3) {
          protobufBuilder_.mergeFrom(value);
        } else {
          protobufBuilder_.setMessage(value);
        }
      }
      schemaCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in protocol buffer format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
     */
    public Builder clearProtobuf() {
      if (protobufBuilder_ == null) {
        if (schemaCase_ == 3) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 3) {
          schemaCase_ = 0;
          schema_ = null;
        }
        protobufBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Schema in protocol buffer format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
     */
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.Builder
        getProtobufBuilder() {
      return getProtobufFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Schema in protocol buffer format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchemaOrBuilder
        getProtobufOrBuilder() {
      if ((schemaCase_ == 3) && (protobufBuilder_ != null)) {
        return protobufBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 3) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Schema in protocol buffer format.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema protobuf = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchemaOrBuilder>
        getProtobufFieldBuilder() {
      if (protobufBuilder_ == null) {
        if (!(schemaCase_ == 3)) {
          schema_ =
              com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.getDefaultInstance();
        }
        protobufBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema,
                com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema.Builder,
                com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchemaOrBuilder>(
                (com.google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 3;
      onChanged();
      return protobufBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchemaOrBuilder>
        parquetBuilder_;

    /**
     *
     *
     * <pre>
     * Marks a Parquet-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
     *
     * @return Whether the parquet field is set.
     */
    @java.lang.Override
    public boolean hasParquet() {
      return schemaCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Marks a Parquet-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
     *
     * @return The parquet.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema getParquet() {
      if (parquetBuilder_ == null) {
        if (schemaCase_ == 4) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 4) {
          return parquetBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Marks a Parquet-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
     */
    public Builder setParquet(com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema value) {
      if (parquetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        parquetBuilder_.setMessage(value);
      }
      schemaCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks a Parquet-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
     */
    public Builder setParquet(
        com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.Builder builderForValue) {
      if (parquetBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        parquetBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks a Parquet-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
     */
    public Builder mergeParquet(
        com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema value) {
      if (parquetBuilder_ == null) {
        if (schemaCase_ == 4
            && schema_
                != com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema
                    .getDefaultInstance()) {
          schema_ =
              com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.newBuilder(
                      (com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 4) {
          parquetBuilder_.mergeFrom(value);
        } else {
          parquetBuilder_.setMessage(value);
        }
      }
      schemaCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks a Parquet-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
     */
    public Builder clearParquet() {
      if (parquetBuilder_ == null) {
        if (schemaCase_ == 4) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 4) {
          schemaCase_ = 0;
          schema_ = null;
        }
        parquetBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks a Parquet-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
     */
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.Builder
        getParquetBuilder() {
      return getParquetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Marks a Parquet-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchemaOrBuilder
        getParquetOrBuilder() {
      if ((schemaCase_ == 4) && (parquetBuilder_ != null)) {
        return parquetBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 4) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Marks a Parquet-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema parquet = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchemaOrBuilder>
        getParquetFieldBuilder() {
      if (parquetBuilder_ == null) {
        if (!(schemaCase_ == 4)) {
          schema_ =
              com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.getDefaultInstance();
        }
        parquetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema,
                com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema.Builder,
                com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchemaOrBuilder>(
                (com.google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 4;
      onChanged();
      return parquetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchemaOrBuilder>
        orcBuilder_;

    /**
     *
     *
     * <pre>
     * Marks an ORC-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
     *
     * @return Whether the orc field is set.
     */
    @java.lang.Override
    public boolean hasOrc() {
      return schemaCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Marks an ORC-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
     *
     * @return The orc.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema getOrc() {
      if (orcBuilder_ == null) {
        if (schemaCase_ == 5) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 5) {
          return orcBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Marks an ORC-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
     */
    public Builder setOrc(com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema value) {
      if (orcBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        orcBuilder_.setMessage(value);
      }
      schemaCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks an ORC-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
     */
    public Builder setOrc(
        com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.Builder builderForValue) {
      if (orcBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        orcBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks an ORC-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
     */
    public Builder mergeOrc(com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema value) {
      if (orcBuilder_ == null) {
        if (schemaCase_ == 5
            && schema_
                != com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.getDefaultInstance()) {
          schema_ =
              com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.newBuilder(
                      (com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 5) {
          orcBuilder_.mergeFrom(value);
        } else {
          orcBuilder_.setMessage(value);
        }
      }
      schemaCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks an ORC-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
     */
    public Builder clearOrc() {
      if (orcBuilder_ == null) {
        if (schemaCase_ == 5) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 5) {
          schemaCase_ = 0;
          schema_ = null;
        }
        orcBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks an ORC-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
     */
    public com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.Builder getOrcBuilder() {
      return getOrcFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Marks an ORC-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchemaOrBuilder getOrcOrBuilder() {
      if ((schemaCase_ == 5) && (orcBuilder_ != null)) {
        return orcBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 5) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Marks an ORC-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema orc = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchemaOrBuilder>
        getOrcFieldBuilder() {
      if (orcBuilder_ == null) {
        if (!(schemaCase_ == 5)) {
          schema_ = com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.getDefaultInstance();
        }
        orcBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema,
                com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema.Builder,
                com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchemaOrBuilder>(
                (com.google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 5;
      onChanged();
      return orcBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchemaOrBuilder>
        csvBuilder_;

    /**
     *
     *
     * <pre>
     * Marks a CSV-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
     *
     * @return Whether the csv field is set.
     */
    @java.lang.Override
    public boolean hasCsv() {
      return schemaCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Marks a CSV-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
     *
     * @return The csv.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema getCsv() {
      if (csvBuilder_ == null) {
        if (schemaCase_ == 6) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 6) {
          return csvBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Marks a CSV-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
     */
    public Builder setCsv(com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema value) {
      if (csvBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        csvBuilder_.setMessage(value);
      }
      schemaCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks a CSV-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
     */
    public Builder setCsv(
        com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.Builder builderForValue) {
      if (csvBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        csvBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks a CSV-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
     */
    public Builder mergeCsv(com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema value) {
      if (csvBuilder_ == null) {
        if (schemaCase_ == 6
            && schema_
                != com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.getDefaultInstance()) {
          schema_ =
              com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.newBuilder(
                      (com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 6) {
          csvBuilder_.mergeFrom(value);
        } else {
          csvBuilder_.setMessage(value);
        }
      }
      schemaCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks a CSV-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
     */
    public Builder clearCsv() {
      if (csvBuilder_ == null) {
        if (schemaCase_ == 6) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 6) {
          schemaCase_ = 0;
          schema_ = null;
        }
        csvBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Marks a CSV-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
     */
    public com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.Builder getCsvBuilder() {
      return getCsvFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Marks a CSV-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchemaOrBuilder getCsvOrBuilder() {
      if ((schemaCase_ == 6) && (csvBuilder_ != null)) {
        return csvBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 6) {
          return (com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) schema_;
        }
        return com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Marks a CSV-encoded data source.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema csv = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema,
            com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.Builder,
            com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchemaOrBuilder>
        getCsvFieldBuilder() {
      if (csvBuilder_ == null) {
        if (!(schemaCase_ == 6)) {
          schema_ = com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.getDefaultInstance();
        }
        csvBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema,
                com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema.Builder,
                com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchemaOrBuilder>(
                (com.google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 6;
      onChanged();
      return csvBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.PhysicalSchema)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.PhysicalSchema)
  private static final com.google.cloud.datacatalog.v1.PhysicalSchema DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.PhysicalSchema();
  }

  public static com.google.cloud.datacatalog.v1.PhysicalSchema getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PhysicalSchema> PARSER =
      new com.google.protobuf.AbstractParser<PhysicalSchema>() {
        @java.lang.Override
        public PhysicalSchema parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PhysicalSchema> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PhysicalSchema> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PhysicalSchema getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
