/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TaxonomyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TAXONOMY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/taxonomies/{taxonomy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String taxonomy;

    @Deprecated
    protected TaxonomyName() {
        this.project = null;
        this.location = null;
        this.taxonomy = null;
    }

    private TaxonomyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.taxonomy = (String)Preconditions.checkNotNull((Object)builder.getTaxonomy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTaxonomy() {
        return this.taxonomy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TaxonomyName of(String project, String location, String taxonomy) {
        return TaxonomyName.newBuilder().setProject(project).setLocation(location).setTaxonomy(taxonomy).build();
    }

    public static String format(String project, String location, String taxonomy) {
        return TaxonomyName.newBuilder().setProject(project).setLocation(location).setTaxonomy(taxonomy).build().toString();
    }

    public static TaxonomyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TAXONOMY.validatedMatch(formattedString, "TaxonomyName.parse: formattedString not in valid format");
        return TaxonomyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("taxonomy"));
    }

    public static List<TaxonomyName> parseList(List<String> formattedStrings) {
        ArrayList<TaxonomyName> list = new ArrayList<TaxonomyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TaxonomyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TaxonomyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TaxonomyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TAXONOMY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TaxonomyName taxonomyName = this;
            synchronized (taxonomyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.taxonomy != null) {
                        fieldMapBuilder.put((Object)"taxonomy", (Object)this.taxonomy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TAXONOMY.instantiate(new String[]{"project", this.project, "location", this.location, "taxonomy", this.taxonomy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TaxonomyName that = (TaxonomyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.taxonomy, that.taxonomy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.taxonomy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String taxonomy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTaxonomy() {
            return this.taxonomy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTaxonomy(String taxonomy) {
            this.taxonomy = taxonomy;
            return this;
        }

        private Builder(TaxonomyName taxonomyName) {
            this.project = taxonomyName.project;
            this.location = taxonomyName.location;
            this.taxonomy = taxonomyName.taxonomy;
        }

        public TaxonomyName build() {
            return new TaxonomyName(this);
        }
    }
}

