/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EntryGroupName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entryGroups/{entry_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String entryGroup;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEntryGroup() {
        return this.entryGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private EntryGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entryGroup = (String)Preconditions.checkNotNull((Object)builder.getEntryGroup());
    }

    public static EntryGroupName of(String project, String location, String entryGroup) {
        return EntryGroupName.newBuilder().setProject(project).setLocation(location).setEntryGroup(entryGroup).build();
    }

    public static String format(String project, String location, String entryGroup) {
        return EntryGroupName.newBuilder().setProject(project).setLocation(location).setEntryGroup(entryGroup).build().toString();
    }

    public static EntryGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "EntryGroupName.parse: formattedString not in valid format");
        return EntryGroupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("entry_group"));
    }

    public static List<EntryGroupName> parseList(List<String> formattedStrings) {
        ArrayList<EntryGroupName> list = new ArrayList<EntryGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntryGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntryGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntryGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntryGroupName entryGroupName = this;
            synchronized (entryGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"entryGroup", (Object)this.entryGroup);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "entry_group", this.entryGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EntryGroupName) {
            EntryGroupName that = (EntryGroupName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.entryGroup.equals(that.entryGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.entryGroup.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String entryGroup;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntryGroup() {
            return this.entryGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEntryGroup(String entryGroup) {
            this.entryGroup = entryGroup;
            return this;
        }

        private Builder() {
        }

        private Builder(EntryGroupName entryGroupName) {
            this.project = entryGroupName.project;
            this.location = entryGroupName.location;
            this.entryGroup = entryGroupName.entryGroup;
        }

        public EntryGroupName build() {
            return new EntryGroupName(this);
        }
    }
}

