/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RuleSetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RULE_SET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/ruleSets/{rule_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String ruleSet;

    @Deprecated
    protected RuleSetName() {
        this.project = null;
        this.location = null;
        this.ruleSet = null;
    }

    private RuleSetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.ruleSet = (String)Preconditions.checkNotNull((Object)builder.getRuleSet());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RuleSetName of(String project, String location, String ruleSet) {
        return RuleSetName.newBuilder().setProject(project).setLocation(location).setRuleSet(ruleSet).build();
    }

    public static String format(String project, String location, String ruleSet) {
        return RuleSetName.newBuilder().setProject(project).setLocation(location).setRuleSet(ruleSet).build().toString();
    }

    public static RuleSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RULE_SET.validatedMatch(formattedString, "RuleSetName.parse: formattedString not in valid format");
        return RuleSetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("rule_set"));
    }

    public static List<RuleSetName> parseList(List<String> formattedStrings) {
        ArrayList<RuleSetName> list = new ArrayList<RuleSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RuleSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RuleSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RuleSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RULE_SET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RuleSetName ruleSetName = this;
            synchronized (ruleSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.ruleSet != null) {
                        fieldMapBuilder.put((Object)"rule_set", (Object)this.ruleSet);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RULE_SET.instantiate(new String[]{"project", this.project, "location", this.location, "rule_set", this.ruleSet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RuleSetName that = (RuleSetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.ruleSet, that.ruleSet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.ruleSet);
    }

    public static class Builder {
        private String project;
        private String location;
        private String ruleSet;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRuleSet() {
            return this.ruleSet;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRuleSet(String ruleSet) {
            this.ruleSet = ruleSet;
            return this;
        }

        private Builder(RuleSetName ruleSetName) {
            this.project = ruleSetName.project;
            this.location = ruleSetName.location;
            this.ruleSet = ruleSetName.ruleSet;
        }

        public RuleSetName build() {
            return new RuleSetName(this);
        }
    }
}

