/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.configdelivery.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VariantName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESOURCE_BUNDLE_RELEASE_VARIANT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/resourceBundles/{resource_bundle}/releases/{release}/variants/{variant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String resourceBundle;
    private final String release;
    private final String variant;

    @Deprecated
    protected VariantName() {
        this.project = null;
        this.location = null;
        this.resourceBundle = null;
        this.release = null;
        this.variant = null;
    }

    private VariantName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.resourceBundle = (String)Preconditions.checkNotNull((Object)builder.getResourceBundle());
        this.release = (String)Preconditions.checkNotNull((Object)builder.getRelease());
        this.variant = (String)Preconditions.checkNotNull((Object)builder.getVariant());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public String getRelease() {
        return this.release;
    }

    public String getVariant() {
        return this.variant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VariantName of(String project, String location, String resourceBundle, String release, String variant) {
        return VariantName.newBuilder().setProject(project).setLocation(location).setResourceBundle(resourceBundle).setRelease(release).setVariant(variant).build();
    }

    public static String format(String project, String location, String resourceBundle, String release, String variant) {
        return VariantName.newBuilder().setProject(project).setLocation(location).setResourceBundle(resourceBundle).setRelease(release).setVariant(variant).build().toString();
    }

    public static VariantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESOURCE_BUNDLE_RELEASE_VARIANT.validatedMatch(formattedString, "VariantName.parse: formattedString not in valid format");
        return VariantName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("resource_bundle"), (String)matchMap.get("release"), (String)matchMap.get("variant"));
    }

    public static List<VariantName> parseList(List<String> formattedStrings) {
        ArrayList<VariantName> list = new ArrayList<VariantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VariantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VariantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VariantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESOURCE_BUNDLE_RELEASE_VARIANT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VariantName variantName = this;
            synchronized (variantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.resourceBundle != null) {
                        fieldMapBuilder.put((Object)"resource_bundle", (Object)this.resourceBundle);
                    }
                    if (this.release != null) {
                        fieldMapBuilder.put((Object)"release", (Object)this.release);
                    }
                    if (this.variant != null) {
                        fieldMapBuilder.put((Object)"variant", (Object)this.variant);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESOURCE_BUNDLE_RELEASE_VARIANT.instantiate(new String[]{"project", this.project, "location", this.location, "resource_bundle", this.resourceBundle, "release", this.release, "variant", this.variant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VariantName that = (VariantName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.resourceBundle, that.resourceBundle) && Objects.equals(this.release, that.release) && Objects.equals(this.variant, that.variant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.resourceBundle);
        h *= 1000003;
        h ^= Objects.hashCode(this.release);
        h *= 1000003;
        return h ^= Objects.hashCode(this.variant);
    }

    public static class Builder {
        private String project;
        private String location;
        private String resourceBundle;
        private String release;
        private String variant;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getResourceBundle() {
            return this.resourceBundle;
        }

        public String getRelease() {
            return this.release;
        }

        public String getVariant() {
            return this.variant;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setResourceBundle(String resourceBundle) {
            this.resourceBundle = resourceBundle;
            return this;
        }

        public Builder setRelease(String release) {
            this.release = release;
            return this;
        }

        public Builder setVariant(String variant) {
            this.variant = variant;
            return this;
        }

        private Builder(VariantName variantName) {
            this.project = variantName.project;
            this.location = variantName.location;
            this.resourceBundle = variantName.resourceBundle;
            this.release = variantName.release;
            this.variant = variantName.variant;
        }

        public VariantName build() {
            return new VariantName(this);
        }
    }
}

