/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.configdelivery.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RolloutName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FLEET_PACKAGE_ROLLOUT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/fleetPackages/{fleet_package}/rollouts/{rollout}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String fleetPackage;
    private final String rollout;

    @Deprecated
    protected RolloutName() {
        this.project = null;
        this.location = null;
        this.fleetPackage = null;
        this.rollout = null;
    }

    private RolloutName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.fleetPackage = (String)Preconditions.checkNotNull((Object)builder.getFleetPackage());
        this.rollout = (String)Preconditions.checkNotNull((Object)builder.getRollout());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFleetPackage() {
        return this.fleetPackage;
    }

    public String getRollout() {
        return this.rollout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RolloutName of(String project, String location, String fleetPackage, String rollout) {
        return RolloutName.newBuilder().setProject(project).setLocation(location).setFleetPackage(fleetPackage).setRollout(rollout).build();
    }

    public static String format(String project, String location, String fleetPackage, String rollout) {
        return RolloutName.newBuilder().setProject(project).setLocation(location).setFleetPackage(fleetPackage).setRollout(rollout).build().toString();
    }

    public static RolloutName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FLEET_PACKAGE_ROLLOUT.validatedMatch(formattedString, "RolloutName.parse: formattedString not in valid format");
        return RolloutName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("fleet_package"), (String)matchMap.get("rollout"));
    }

    public static List<RolloutName> parseList(List<String> formattedStrings) {
        ArrayList<RolloutName> list = new ArrayList<RolloutName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RolloutName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RolloutName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RolloutName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FLEET_PACKAGE_ROLLOUT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RolloutName rolloutName = this;
            synchronized (rolloutName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.fleetPackage != null) {
                        fieldMapBuilder.put((Object)"fleet_package", (Object)this.fleetPackage);
                    }
                    if (this.rollout != null) {
                        fieldMapBuilder.put((Object)"rollout", (Object)this.rollout);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FLEET_PACKAGE_ROLLOUT.instantiate(new String[]{"project", this.project, "location", this.location, "fleet_package", this.fleetPackage, "rollout", this.rollout});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RolloutName that = (RolloutName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.fleetPackage, that.fleetPackage) && Objects.equals(this.rollout, that.rollout);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.fleetPackage);
        h *= 1000003;
        return h ^= Objects.hashCode(this.rollout);
    }

    public static class Builder {
        private String project;
        private String location;
        private String fleetPackage;
        private String rollout;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFleetPackage() {
            return this.fleetPackage;
        }

        public String getRollout() {
            return this.rollout;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFleetPackage(String fleetPackage) {
            this.fleetPackage = fleetPackage;
            return this;
        }

        public Builder setRollout(String rollout) {
            this.rollout = rollout;
            return this;
        }

        private Builder(RolloutName rolloutName) {
            this.project = rolloutName.project;
            this.location = rolloutName.location;
            this.fleetPackage = rolloutName.fleetPackage;
            this.rollout = rolloutName.rollout;
        }

        public RolloutName build() {
            return new RolloutName(this);
        }
    }
}

