/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.configdelivery.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReleaseName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESOURCE_BUNDLE_RELEASE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/resourceBundles/{resource_bundle}/releases/{release}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String resourceBundle;
    private final String release;

    @Deprecated
    protected ReleaseName() {
        this.project = null;
        this.location = null;
        this.resourceBundle = null;
        this.release = null;
    }

    private ReleaseName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.resourceBundle = (String)Preconditions.checkNotNull((Object)builder.getResourceBundle());
        this.release = (String)Preconditions.checkNotNull((Object)builder.getRelease());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public String getRelease() {
        return this.release;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReleaseName of(String project, String location, String resourceBundle, String release) {
        return ReleaseName.newBuilder().setProject(project).setLocation(location).setResourceBundle(resourceBundle).setRelease(release).build();
    }

    public static String format(String project, String location, String resourceBundle, String release) {
        return ReleaseName.newBuilder().setProject(project).setLocation(location).setResourceBundle(resourceBundle).setRelease(release).build().toString();
    }

    public static ReleaseName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESOURCE_BUNDLE_RELEASE.validatedMatch(formattedString, "ReleaseName.parse: formattedString not in valid format");
        return ReleaseName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("resource_bundle"), (String)matchMap.get("release"));
    }

    public static List<ReleaseName> parseList(List<String> formattedStrings) {
        ArrayList<ReleaseName> list = new ArrayList<ReleaseName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReleaseName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReleaseName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReleaseName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESOURCE_BUNDLE_RELEASE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReleaseName releaseName = this;
            synchronized (releaseName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.resourceBundle != null) {
                        fieldMapBuilder.put((Object)"resource_bundle", (Object)this.resourceBundle);
                    }
                    if (this.release != null) {
                        fieldMapBuilder.put((Object)"release", (Object)this.release);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESOURCE_BUNDLE_RELEASE.instantiate(new String[]{"project", this.project, "location", this.location, "resource_bundle", this.resourceBundle, "release", this.release});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReleaseName that = (ReleaseName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.resourceBundle, that.resourceBundle) && Objects.equals(this.release, that.release);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.resourceBundle);
        h *= 1000003;
        return h ^= Objects.hashCode(this.release);
    }

    public static class Builder {
        private String project;
        private String location;
        private String resourceBundle;
        private String release;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getResourceBundle() {
            return this.resourceBundle;
        }

        public String getRelease() {
            return this.release;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setResourceBundle(String resourceBundle) {
            this.resourceBundle = resourceBundle;
            return this;
        }

        public Builder setRelease(String release) {
            this.release = release;
            return this;
        }

        private Builder(ReleaseName releaseName) {
            this.project = releaseName.project;
            this.location = releaseName.location;
            this.resourceBundle = releaseName.resourceBundle;
            this.release = releaseName.release;
        }

        public ReleaseName build() {
            return new ReleaseName(this);
        }
    }
}

