/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.configdelivery.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FleetPackageName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FLEET_PACKAGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/fleetPackages/{fleet_package}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String fleetPackage;

    @Deprecated
    protected FleetPackageName() {
        this.project = null;
        this.location = null;
        this.fleetPackage = null;
    }

    private FleetPackageName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.fleetPackage = (String)Preconditions.checkNotNull((Object)builder.getFleetPackage());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFleetPackage() {
        return this.fleetPackage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FleetPackageName of(String project, String location, String fleetPackage) {
        return FleetPackageName.newBuilder().setProject(project).setLocation(location).setFleetPackage(fleetPackage).build();
    }

    public static String format(String project, String location, String fleetPackage) {
        return FleetPackageName.newBuilder().setProject(project).setLocation(location).setFleetPackage(fleetPackage).build().toString();
    }

    public static FleetPackageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FLEET_PACKAGE.validatedMatch(formattedString, "FleetPackageName.parse: formattedString not in valid format");
        return FleetPackageName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("fleet_package"));
    }

    public static List<FleetPackageName> parseList(List<String> formattedStrings) {
        ArrayList<FleetPackageName> list = new ArrayList<FleetPackageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FleetPackageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FleetPackageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FleetPackageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FLEET_PACKAGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FleetPackageName fleetPackageName = this;
            synchronized (fleetPackageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.fleetPackage != null) {
                        fieldMapBuilder.put((Object)"fleet_package", (Object)this.fleetPackage);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FLEET_PACKAGE.instantiate(new String[]{"project", this.project, "location", this.location, "fleet_package", this.fleetPackage});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FleetPackageName that = (FleetPackageName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.fleetPackage, that.fleetPackage);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.fleetPackage);
    }

    public static class Builder {
        private String project;
        private String location;
        private String fleetPackage;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFleetPackage() {
            return this.fleetPackage;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFleetPackage(String fleetPackage) {
            this.fleetPackage = fleetPackage;
            return this;
        }

        private Builder(FleetPackageName fleetPackageName) {
            this.project = fleetPackageName.project;
            this.location = fleetPackageName.location;
            this.fleetPackage = fleetPackageName.fleetPackage;
        }

        public FleetPackageName build() {
            return new FleetPackageName(this);
        }
    }
}

