/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.configdelivery.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceBundleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESOURCE_BUNDLE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/resourceBundles/{resource_bundle}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String resourceBundle;

    @Deprecated
    protected ResourceBundleName() {
        this.project = null;
        this.location = null;
        this.resourceBundle = null;
    }

    private ResourceBundleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.resourceBundle = (String)Preconditions.checkNotNull((Object)builder.getResourceBundle());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ResourceBundleName of(String project, String location, String resourceBundle) {
        return ResourceBundleName.newBuilder().setProject(project).setLocation(location).setResourceBundle(resourceBundle).build();
    }

    public static String format(String project, String location, String resourceBundle) {
        return ResourceBundleName.newBuilder().setProject(project).setLocation(location).setResourceBundle(resourceBundle).build().toString();
    }

    public static ResourceBundleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESOURCE_BUNDLE.validatedMatch(formattedString, "ResourceBundleName.parse: formattedString not in valid format");
        return ResourceBundleName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("resource_bundle"));
    }

    public static List<ResourceBundleName> parseList(List<String> formattedStrings) {
        ArrayList<ResourceBundleName> list = new ArrayList<ResourceBundleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ResourceBundleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ResourceBundleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ResourceBundleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESOURCE_BUNDLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ResourceBundleName resourceBundleName = this;
            synchronized (resourceBundleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.resourceBundle != null) {
                        fieldMapBuilder.put((Object)"resource_bundle", (Object)this.resourceBundle);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESOURCE_BUNDLE.instantiate(new String[]{"project", this.project, "location", this.location, "resource_bundle", this.resourceBundle});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ResourceBundleName that = (ResourceBundleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.resourceBundle, that.resourceBundle);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.resourceBundle);
    }

    public static class Builder {
        private String project;
        private String location;
        private String resourceBundle;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getResourceBundle() {
            return this.resourceBundle;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setResourceBundle(String resourceBundle) {
            this.resourceBundle = resourceBundle;
            return this;
        }

        private Builder(ResourceBundleName resourceBundleName) {
            this.project = resourceBundleName.project;
            this.location = resourceBundleName.location;
            this.resourceBundle = resourceBundleName.resourceBundle;
        }

        public ResourceBundleName build() {
            return new ResourceBundleName(this);
        }
    }
}

