/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.confidentialcomputing.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChallengeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_UUID = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/challenges/{uuid}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String uuid;

    @Deprecated
    protected ChallengeName() {
        this.project = null;
        this.location = null;
        this.uuid = null;
    }

    private ChallengeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.uuid = (String)Preconditions.checkNotNull((Object)builder.getUuid());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getUuid() {
        return this.uuid;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChallengeName of(String project, String location, String uuid) {
        return ChallengeName.newBuilder().setProject(project).setLocation(location).setUuid(uuid).build();
    }

    public static String format(String project, String location, String uuid) {
        return ChallengeName.newBuilder().setProject(project).setLocation(location).setUuid(uuid).build().toString();
    }

    public static ChallengeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_UUID.validatedMatch(formattedString, "ChallengeName.parse: formattedString not in valid format");
        return ChallengeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("uuid"));
    }

    public static List<ChallengeName> parseList(List<String> formattedStrings) {
        ArrayList<ChallengeName> list = new ArrayList<ChallengeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChallengeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChallengeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChallengeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_UUID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChallengeName challengeName = this;
            synchronized (challengeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.uuid != null) {
                        fieldMapBuilder.put((Object)"uuid", (Object)this.uuid);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_UUID.instantiate(new String[]{"project", this.project, "location", this.location, "uuid", this.uuid});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ChallengeName that = (ChallengeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.uuid, that.uuid);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.uuid);
    }

    public static class Builder {
        private String project;
        private String location;
        private String uuid;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        private Builder(ChallengeName challengeName) {
            this.project = challengeName.project;
            this.location = challengeName.location;
            this.uuid = challengeName.uuid;
        }

        public ChallengeName build() {
            return new ChallengeName(this);
        }
    }
}

