/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.TestFailure}
 */
public final class TestFailure extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.TestFailure)
    TestFailureOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TestFailure.newBuilder() to construct.
  private TestFailure(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TestFailure() {
    actualOutputUrl_ = "";
    actualService_ = "";
    expectedOutputUrl_ = "";
    expectedService_ = "";
    headers_ = java.util.Collections.emptyList();
    host_ = "";
    path_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TestFailure();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_TestFailure_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_TestFailure_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.TestFailure.class,
            com.google.cloud.compute.v1.TestFailure.Builder.class);
  }

  private int bitField0_;
  public static final int ACTUAL_OUTPUT_URL_FIELD_NUMBER = 287075458;

  @SuppressWarnings("serial")
  private volatile java.lang.Object actualOutputUrl_ = "";

  /**
   *
   *
   * <pre>
   * The actual output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
   * </pre>
   *
   * <code>optional string actual_output_url = 287075458;</code>
   *
   * @return Whether the actualOutputUrl field is set.
   */
  @java.lang.Override
  public boolean hasActualOutputUrl() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The actual output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
   * </pre>
   *
   * <code>optional string actual_output_url = 287075458;</code>
   *
   * @return The actualOutputUrl.
   */
  @java.lang.Override
  public java.lang.String getActualOutputUrl() {
    java.lang.Object ref = actualOutputUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      actualOutputUrl_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The actual output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
   * </pre>
   *
   * <code>optional string actual_output_url = 287075458;</code>
   *
   * @return The bytes for actualOutputUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActualOutputUrlBytes() {
    java.lang.Object ref = actualOutputUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      actualOutputUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTUAL_REDIRECT_RESPONSE_CODE_FIELD_NUMBER = 42926553;
  private int actualRedirectResponseCode_ = 0;

  /**
   *
   *
   * <pre>
   * Actual HTTP status code for rule with `urlRedirect` calculated by load balancer
   * </pre>
   *
   * <code>optional int32 actual_redirect_response_code = 42926553;</code>
   *
   * @return Whether the actualRedirectResponseCode field is set.
   */
  @java.lang.Override
  public boolean hasActualRedirectResponseCode() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Actual HTTP status code for rule with `urlRedirect` calculated by load balancer
   * </pre>
   *
   * <code>optional int32 actual_redirect_response_code = 42926553;</code>
   *
   * @return The actualRedirectResponseCode.
   */
  @java.lang.Override
  public int getActualRedirectResponseCode() {
    return actualRedirectResponseCode_;
  }

  public static final int ACTUAL_SERVICE_FIELD_NUMBER = 440379652;

  @SuppressWarnings("serial")
  private volatile java.lang.Object actualService_ = "";

  /**
   *
   *
   * <pre>
   * BackendService or BackendBucket returned by load balancer.
   * </pre>
   *
   * <code>optional string actual_service = 440379652;</code>
   *
   * @return Whether the actualService field is set.
   */
  @java.lang.Override
  public boolean hasActualService() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * BackendService or BackendBucket returned by load balancer.
   * </pre>
   *
   * <code>optional string actual_service = 440379652;</code>
   *
   * @return The actualService.
   */
  @java.lang.Override
  public java.lang.String getActualService() {
    java.lang.Object ref = actualService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      actualService_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * BackendService or BackendBucket returned by load balancer.
   * </pre>
   *
   * <code>optional string actual_service = 440379652;</code>
   *
   * @return The bytes for actualService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActualServiceBytes() {
    java.lang.Object ref = actualService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      actualService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPECTED_OUTPUT_URL_FIELD_NUMBER = 433967384;

  @SuppressWarnings("serial")
  private volatile java.lang.Object expectedOutputUrl_ = "";

  /**
   *
   *
   * <pre>
   * The expected output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
   * </pre>
   *
   * <code>optional string expected_output_url = 433967384;</code>
   *
   * @return Whether the expectedOutputUrl field is set.
   */
  @java.lang.Override
  public boolean hasExpectedOutputUrl() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The expected output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
   * </pre>
   *
   * <code>optional string expected_output_url = 433967384;</code>
   *
   * @return The expectedOutputUrl.
   */
  @java.lang.Override
  public java.lang.String getExpectedOutputUrl() {
    java.lang.Object ref = expectedOutputUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      expectedOutputUrl_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The expected output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
   * </pre>
   *
   * <code>optional string expected_output_url = 433967384;</code>
   *
   * @return The bytes for expectedOutputUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExpectedOutputUrlBytes() {
    java.lang.Object ref = expectedOutputUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      expectedOutputUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPECTED_REDIRECT_RESPONSE_CODE_FIELD_NUMBER = 18888047;
  private int expectedRedirectResponseCode_ = 0;

  /**
   *
   *
   * <pre>
   * Expected HTTP status code for rule with `urlRedirect` calculated by load balancer
   * </pre>
   *
   * <code>optional int32 expected_redirect_response_code = 18888047;</code>
   *
   * @return Whether the expectedRedirectResponseCode field is set.
   */
  @java.lang.Override
  public boolean hasExpectedRedirectResponseCode() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Expected HTTP status code for rule with `urlRedirect` calculated by load balancer
   * </pre>
   *
   * <code>optional int32 expected_redirect_response_code = 18888047;</code>
   *
   * @return The expectedRedirectResponseCode.
   */
  @java.lang.Override
  public int getExpectedRedirectResponseCode() {
    return expectedRedirectResponseCode_;
  }

  public static final int EXPECTED_SERVICE_FIELD_NUMBER = 133987374;

  @SuppressWarnings("serial")
  private volatile java.lang.Object expectedService_ = "";

  /**
   *
   *
   * <pre>
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   * </pre>
   *
   * <code>optional string expected_service = 133987374;</code>
   *
   * @return Whether the expectedService field is set.
   */
  @java.lang.Override
  public boolean hasExpectedService() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   * </pre>
   *
   * <code>optional string expected_service = 133987374;</code>
   *
   * @return The expectedService.
   */
  @java.lang.Override
  public java.lang.String getExpectedService() {
    java.lang.Object ref = expectedService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      expectedService_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   * </pre>
   *
   * <code>optional string expected_service = 133987374;</code>
   *
   * @return The bytes for expectedService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExpectedServiceBytes() {
    java.lang.Object ref = expectedService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      expectedService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADERS_FIELD_NUMBER = 258436998;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.UrlMapTestHeader> headers_;

  /**
   *
   *
   * <pre>
   * HTTP headers of the request.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.UrlMapTestHeader> getHeadersList() {
    return headers_;
  }

  /**
   *
   *
   * <pre>
   * HTTP headers of the request.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.UrlMapTestHeaderOrBuilder>
      getHeadersOrBuilderList() {
    return headers_;
  }

  /**
   *
   *
   * <pre>
   * HTTP headers of the request.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
   */
  @java.lang.Override
  public int getHeadersCount() {
    return headers_.size();
  }

  /**
   *
   *
   * <pre>
   * HTTP headers of the request.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UrlMapTestHeader getHeaders(int index) {
    return headers_.get(index);
  }

  /**
   *
   *
   * <pre>
   * HTTP headers of the request.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UrlMapTestHeaderOrBuilder getHeadersOrBuilder(int index) {
    return headers_.get(index);
  }

  public static final int HOST_FIELD_NUMBER = 3208616;

  @SuppressWarnings("serial")
  private volatile java.lang.Object host_ = "";

  /**
   *
   *
   * <pre>
   * Host portion of the URL.
   * </pre>
   *
   * <code>optional string host = 3208616;</code>
   *
   * @return Whether the host field is set.
   */
  @java.lang.Override
  public boolean hasHost() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Host portion of the URL.
   * </pre>
   *
   * <code>optional string host = 3208616;</code>
   *
   * @return The host.
   */
  @java.lang.Override
  public java.lang.String getHost() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      host_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Host portion of the URL.
   * </pre>
   *
   * <code>optional string host = 3208616;</code>
   *
   * @return The bytes for host.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostBytes() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      host_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PATH_FIELD_NUMBER = 3433509;

  @SuppressWarnings("serial")
  private volatile java.lang.Object path_ = "";

  /**
   *
   *
   * <pre>
   * Path portion including query parameters in the URL.
   * </pre>
   *
   * <code>optional string path = 3433509;</code>
   *
   * @return Whether the path field is set.
   */
  @java.lang.Override
  public boolean hasPath() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Path portion including query parameters in the URL.
   * </pre>
   *
   * <code>optional string path = 3433509;</code>
   *
   * @return The path.
   */
  @java.lang.Override
  public java.lang.String getPath() {
    java.lang.Object ref = path_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      path_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Path portion including query parameters in the URL.
   * </pre>
   *
   * <code>optional string path = 3433509;</code>
   *
   * @return The bytes for path.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPathBytes() {
    java.lang.Object ref = path_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      path_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3208616, host_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3433509, path_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(18888047, expectedRedirectResponseCode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(42926553, actualRedirectResponseCode_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 133987374, expectedService_);
    }
    for (int i = 0; i < headers_.size(); i++) {
      output.writeMessage(258436998, headers_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 287075458, actualOutputUrl_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 433967384, expectedOutputUrl_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 440379652, actualService_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3208616, host_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3433509, path_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              18888047, expectedRedirectResponseCode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              42926553, actualRedirectResponseCode_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(133987374, expectedService_);
    }
    for (int i = 0; i < headers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(258436998, headers_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(287075458, actualOutputUrl_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(433967384, expectedOutputUrl_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(440379652, actualService_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.TestFailure)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.TestFailure other = (com.google.cloud.compute.v1.TestFailure) obj;

    if (hasActualOutputUrl() != other.hasActualOutputUrl()) return false;
    if (hasActualOutputUrl()) {
      if (!getActualOutputUrl().equals(other.getActualOutputUrl())) return false;
    }
    if (hasActualRedirectResponseCode() != other.hasActualRedirectResponseCode()) return false;
    if (hasActualRedirectResponseCode()) {
      if (getActualRedirectResponseCode() != other.getActualRedirectResponseCode()) return false;
    }
    if (hasActualService() != other.hasActualService()) return false;
    if (hasActualService()) {
      if (!getActualService().equals(other.getActualService())) return false;
    }
    if (hasExpectedOutputUrl() != other.hasExpectedOutputUrl()) return false;
    if (hasExpectedOutputUrl()) {
      if (!getExpectedOutputUrl().equals(other.getExpectedOutputUrl())) return false;
    }
    if (hasExpectedRedirectResponseCode() != other.hasExpectedRedirectResponseCode()) return false;
    if (hasExpectedRedirectResponseCode()) {
      if (getExpectedRedirectResponseCode() != other.getExpectedRedirectResponseCode())
        return false;
    }
    if (hasExpectedService() != other.hasExpectedService()) return false;
    if (hasExpectedService()) {
      if (!getExpectedService().equals(other.getExpectedService())) return false;
    }
    if (!getHeadersList().equals(other.getHeadersList())) return false;
    if (hasHost() != other.hasHost()) return false;
    if (hasHost()) {
      if (!getHost().equals(other.getHost())) return false;
    }
    if (hasPath() != other.hasPath()) return false;
    if (hasPath()) {
      if (!getPath().equals(other.getPath())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasActualOutputUrl()) {
      hash = (37 * hash) + ACTUAL_OUTPUT_URL_FIELD_NUMBER;
      hash = (53 * hash) + getActualOutputUrl().hashCode();
    }
    if (hasActualRedirectResponseCode()) {
      hash = (37 * hash) + ACTUAL_REDIRECT_RESPONSE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getActualRedirectResponseCode();
    }
    if (hasActualService()) {
      hash = (37 * hash) + ACTUAL_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getActualService().hashCode();
    }
    if (hasExpectedOutputUrl()) {
      hash = (37 * hash) + EXPECTED_OUTPUT_URL_FIELD_NUMBER;
      hash = (53 * hash) + getExpectedOutputUrl().hashCode();
    }
    if (hasExpectedRedirectResponseCode()) {
      hash = (37 * hash) + EXPECTED_REDIRECT_RESPONSE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getExpectedRedirectResponseCode();
    }
    if (hasExpectedService()) {
      hash = (37 * hash) + EXPECTED_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getExpectedService().hashCode();
    }
    if (getHeadersCount() > 0) {
      hash = (37 * hash) + HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getHeadersList().hashCode();
    }
    if (hasHost()) {
      hash = (37 * hash) + HOST_FIELD_NUMBER;
      hash = (53 * hash) + getHost().hashCode();
    }
    if (hasPath()) {
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.TestFailure parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.TestFailure parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.TestFailure parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.TestFailure parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.TestFailure parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.TestFailure parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.TestFailure parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.TestFailure parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.TestFailure parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.TestFailure parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.TestFailure parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.TestFailure parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.TestFailure prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.TestFailure}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.TestFailure)
      com.google.cloud.compute.v1.TestFailureOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_TestFailure_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_TestFailure_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.TestFailure.class,
              com.google.cloud.compute.v1.TestFailure.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.TestFailure.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      actualOutputUrl_ = "";
      actualRedirectResponseCode_ = 0;
      actualService_ = "";
      expectedOutputUrl_ = "";
      expectedRedirectResponseCode_ = 0;
      expectedService_ = "";
      if (headersBuilder_ == null) {
        headers_ = java.util.Collections.emptyList();
      } else {
        headers_ = null;
        headersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      host_ = "";
      path_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_TestFailure_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.TestFailure getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.TestFailure.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.TestFailure build() {
      com.google.cloud.compute.v1.TestFailure result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.TestFailure buildPartial() {
      com.google.cloud.compute.v1.TestFailure result =
          new com.google.cloud.compute.v1.TestFailure(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.TestFailure result) {
      if (headersBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          headers_ = java.util.Collections.unmodifiableList(headers_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.headers_ = headers_;
      } else {
        result.headers_ = headersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.TestFailure result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.actualOutputUrl_ = actualOutputUrl_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.actualRedirectResponseCode_ = actualRedirectResponseCode_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.actualService_ = actualService_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.expectedOutputUrl_ = expectedOutputUrl_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.expectedRedirectResponseCode_ = expectedRedirectResponseCode_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.expectedService_ = expectedService_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.host_ = host_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.path_ = path_;
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.TestFailure) {
        return mergeFrom((com.google.cloud.compute.v1.TestFailure) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.TestFailure other) {
      if (other == com.google.cloud.compute.v1.TestFailure.getDefaultInstance()) return this;
      if (other.hasActualOutputUrl()) {
        actualOutputUrl_ = other.actualOutputUrl_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasActualRedirectResponseCode()) {
        setActualRedirectResponseCode(other.getActualRedirectResponseCode());
      }
      if (other.hasActualService()) {
        actualService_ = other.actualService_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasExpectedOutputUrl()) {
        expectedOutputUrl_ = other.expectedOutputUrl_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasExpectedRedirectResponseCode()) {
        setExpectedRedirectResponseCode(other.getExpectedRedirectResponseCode());
      }
      if (other.hasExpectedService()) {
        expectedService_ = other.expectedService_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (headersBuilder_ == null) {
        if (!other.headers_.isEmpty()) {
          if (headers_.isEmpty()) {
            headers_ = other.headers_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureHeadersIsMutable();
            headers_.addAll(other.headers_);
          }
          onChanged();
        }
      } else {
        if (!other.headers_.isEmpty()) {
          if (headersBuilder_.isEmpty()) {
            headersBuilder_.dispose();
            headersBuilder_ = null;
            headers_ = other.headers_;
            bitField0_ = (bitField0_ & ~0x00000040);
            headersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getHeadersFieldBuilder()
                    : null;
          } else {
            headersBuilder_.addAllMessages(other.headers_);
          }
        }
      }
      if (other.hasHost()) {
        host_ = other.host_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasPath()) {
        path_ = other.path_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 25668930:
              {
                host_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 25668930
            case 27468074:
              {
                path_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 27468074
            case 151104376:
              {
                expectedRedirectResponseCode_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 151104376
            case 343412424:
              {
                actualRedirectResponseCode_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 343412424
            case 1071898994:
              {
                expectedService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 1071898994
            case 2067495986:
              {
                com.google.cloud.compute.v1.UrlMapTestHeader m =
                    input.readMessage(
                        com.google.cloud.compute.v1.UrlMapTestHeader.parser(), extensionRegistry);
                if (headersBuilder_ == null) {
                  ensureHeadersIsMutable();
                  headers_.add(m);
                } else {
                  headersBuilder_.addMessage(m);
                }
                break;
              } // case 2067495986
            case -1998363630:
              {
                actualOutputUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1998363630
            case -823228222:
              {
                expectedOutputUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -823228222
            case -771930078:
              {
                actualService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -771930078
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object actualOutputUrl_ = "";

    /**
     *
     *
     * <pre>
     * The actual output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string actual_output_url = 287075458;</code>
     *
     * @return Whether the actualOutputUrl field is set.
     */
    public boolean hasActualOutputUrl() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The actual output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string actual_output_url = 287075458;</code>
     *
     * @return The actualOutputUrl.
     */
    public java.lang.String getActualOutputUrl() {
      java.lang.Object ref = actualOutputUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        actualOutputUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The actual output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string actual_output_url = 287075458;</code>
     *
     * @return The bytes for actualOutputUrl.
     */
    public com.google.protobuf.ByteString getActualOutputUrlBytes() {
      java.lang.Object ref = actualOutputUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        actualOutputUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The actual output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string actual_output_url = 287075458;</code>
     *
     * @param value The actualOutputUrl to set.
     * @return This builder for chaining.
     */
    public Builder setActualOutputUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      actualOutputUrl_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The actual output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string actual_output_url = 287075458;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActualOutputUrl() {
      actualOutputUrl_ = getDefaultInstance().getActualOutputUrl();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The actual output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string actual_output_url = 287075458;</code>
     *
     * @param value The bytes for actualOutputUrl to set.
     * @return This builder for chaining.
     */
    public Builder setActualOutputUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      actualOutputUrl_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int actualRedirectResponseCode_;

    /**
     *
     *
     * <pre>
     * Actual HTTP status code for rule with `urlRedirect` calculated by load balancer
     * </pre>
     *
     * <code>optional int32 actual_redirect_response_code = 42926553;</code>
     *
     * @return Whether the actualRedirectResponseCode field is set.
     */
    @java.lang.Override
    public boolean hasActualRedirectResponseCode() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Actual HTTP status code for rule with `urlRedirect` calculated by load balancer
     * </pre>
     *
     * <code>optional int32 actual_redirect_response_code = 42926553;</code>
     *
     * @return The actualRedirectResponseCode.
     */
    @java.lang.Override
    public int getActualRedirectResponseCode() {
      return actualRedirectResponseCode_;
    }

    /**
     *
     *
     * <pre>
     * Actual HTTP status code for rule with `urlRedirect` calculated by load balancer
     * </pre>
     *
     * <code>optional int32 actual_redirect_response_code = 42926553;</code>
     *
     * @param value The actualRedirectResponseCode to set.
     * @return This builder for chaining.
     */
    public Builder setActualRedirectResponseCode(int value) {

      actualRedirectResponseCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Actual HTTP status code for rule with `urlRedirect` calculated by load balancer
     * </pre>
     *
     * <code>optional int32 actual_redirect_response_code = 42926553;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActualRedirectResponseCode() {
      bitField0_ = (bitField0_ & ~0x00000002);
      actualRedirectResponseCode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object actualService_ = "";

    /**
     *
     *
     * <pre>
     * BackendService or BackendBucket returned by load balancer.
     * </pre>
     *
     * <code>optional string actual_service = 440379652;</code>
     *
     * @return Whether the actualService field is set.
     */
    public boolean hasActualService() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * BackendService or BackendBucket returned by load balancer.
     * </pre>
     *
     * <code>optional string actual_service = 440379652;</code>
     *
     * @return The actualService.
     */
    public java.lang.String getActualService() {
      java.lang.Object ref = actualService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        actualService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * BackendService or BackendBucket returned by load balancer.
     * </pre>
     *
     * <code>optional string actual_service = 440379652;</code>
     *
     * @return The bytes for actualService.
     */
    public com.google.protobuf.ByteString getActualServiceBytes() {
      java.lang.Object ref = actualService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        actualService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * BackendService or BackendBucket returned by load balancer.
     * </pre>
     *
     * <code>optional string actual_service = 440379652;</code>
     *
     * @param value The actualService to set.
     * @return This builder for chaining.
     */
    public Builder setActualService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      actualService_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * BackendService or BackendBucket returned by load balancer.
     * </pre>
     *
     * <code>optional string actual_service = 440379652;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActualService() {
      actualService_ = getDefaultInstance().getActualService();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * BackendService or BackendBucket returned by load balancer.
     * </pre>
     *
     * <code>optional string actual_service = 440379652;</code>
     *
     * @param value The bytes for actualService to set.
     * @return This builder for chaining.
     */
    public Builder setActualServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      actualService_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object expectedOutputUrl_ = "";

    /**
     *
     *
     * <pre>
     * The expected output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string expected_output_url = 433967384;</code>
     *
     * @return Whether the expectedOutputUrl field is set.
     */
    public boolean hasExpectedOutputUrl() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The expected output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string expected_output_url = 433967384;</code>
     *
     * @return The expectedOutputUrl.
     */
    public java.lang.String getExpectedOutputUrl() {
      java.lang.Object ref = expectedOutputUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        expectedOutputUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The expected output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string expected_output_url = 433967384;</code>
     *
     * @return The bytes for expectedOutputUrl.
     */
    public com.google.protobuf.ByteString getExpectedOutputUrlBytes() {
      java.lang.Object ref = expectedOutputUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        expectedOutputUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The expected output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string expected_output_url = 433967384;</code>
     *
     * @param value The expectedOutputUrl to set.
     * @return This builder for chaining.
     */
    public Builder setExpectedOutputUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      expectedOutputUrl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The expected output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string expected_output_url = 433967384;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpectedOutputUrl() {
      expectedOutputUrl_ = getDefaultInstance().getExpectedOutputUrl();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The expected output URL evaluated by a load balancer containing the scheme, host, path and query parameters.
     * </pre>
     *
     * <code>optional string expected_output_url = 433967384;</code>
     *
     * @param value The bytes for expectedOutputUrl to set.
     * @return This builder for chaining.
     */
    public Builder setExpectedOutputUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      expectedOutputUrl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int expectedRedirectResponseCode_;

    /**
     *
     *
     * <pre>
     * Expected HTTP status code for rule with `urlRedirect` calculated by load balancer
     * </pre>
     *
     * <code>optional int32 expected_redirect_response_code = 18888047;</code>
     *
     * @return Whether the expectedRedirectResponseCode field is set.
     */
    @java.lang.Override
    public boolean hasExpectedRedirectResponseCode() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Expected HTTP status code for rule with `urlRedirect` calculated by load balancer
     * </pre>
     *
     * <code>optional int32 expected_redirect_response_code = 18888047;</code>
     *
     * @return The expectedRedirectResponseCode.
     */
    @java.lang.Override
    public int getExpectedRedirectResponseCode() {
      return expectedRedirectResponseCode_;
    }

    /**
     *
     *
     * <pre>
     * Expected HTTP status code for rule with `urlRedirect` calculated by load balancer
     * </pre>
     *
     * <code>optional int32 expected_redirect_response_code = 18888047;</code>
     *
     * @param value The expectedRedirectResponseCode to set.
     * @return This builder for chaining.
     */
    public Builder setExpectedRedirectResponseCode(int value) {

      expectedRedirectResponseCode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Expected HTTP status code for rule with `urlRedirect` calculated by load balancer
     * </pre>
     *
     * <code>optional int32 expected_redirect_response_code = 18888047;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpectedRedirectResponseCode() {
      bitField0_ = (bitField0_ & ~0x00000010);
      expectedRedirectResponseCode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object expectedService_ = "";

    /**
     *
     *
     * <pre>
     * Expected BackendService or BackendBucket resource the given URL should be mapped to.
     * </pre>
     *
     * <code>optional string expected_service = 133987374;</code>
     *
     * @return Whether the expectedService field is set.
     */
    public boolean hasExpectedService() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Expected BackendService or BackendBucket resource the given URL should be mapped to.
     * </pre>
     *
     * <code>optional string expected_service = 133987374;</code>
     *
     * @return The expectedService.
     */
    public java.lang.String getExpectedService() {
      java.lang.Object ref = expectedService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        expectedService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Expected BackendService or BackendBucket resource the given URL should be mapped to.
     * </pre>
     *
     * <code>optional string expected_service = 133987374;</code>
     *
     * @return The bytes for expectedService.
     */
    public com.google.protobuf.ByteString getExpectedServiceBytes() {
      java.lang.Object ref = expectedService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        expectedService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Expected BackendService or BackendBucket resource the given URL should be mapped to.
     * </pre>
     *
     * <code>optional string expected_service = 133987374;</code>
     *
     * @param value The expectedService to set.
     * @return This builder for chaining.
     */
    public Builder setExpectedService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      expectedService_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Expected BackendService or BackendBucket resource the given URL should be mapped to.
     * </pre>
     *
     * <code>optional string expected_service = 133987374;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpectedService() {
      expectedService_ = getDefaultInstance().getExpectedService();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Expected BackendService or BackendBucket resource the given URL should be mapped to.
     * </pre>
     *
     * <code>optional string expected_service = 133987374;</code>
     *
     * @param value The bytes for expectedService to set.
     * @return This builder for chaining.
     */
    public Builder setExpectedServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      expectedService_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.UrlMapTestHeader> headers_ =
        java.util.Collections.emptyList();

    private void ensureHeadersIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        headers_ = new java.util.ArrayList<com.google.cloud.compute.v1.UrlMapTestHeader>(headers_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.UrlMapTestHeader,
            com.google.cloud.compute.v1.UrlMapTestHeader.Builder,
            com.google.cloud.compute.v1.UrlMapTestHeaderOrBuilder>
        headersBuilder_;

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.UrlMapTestHeader> getHeadersList() {
      if (headersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(headers_);
      } else {
        return headersBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public int getHeadersCount() {
      if (headersBuilder_ == null) {
        return headers_.size();
      } else {
        return headersBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public com.google.cloud.compute.v1.UrlMapTestHeader getHeaders(int index) {
      if (headersBuilder_ == null) {
        return headers_.get(index);
      } else {
        return headersBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public Builder setHeaders(int index, com.google.cloud.compute.v1.UrlMapTestHeader value) {
      if (headersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeadersIsMutable();
        headers_.set(index, value);
        onChanged();
      } else {
        headersBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public Builder setHeaders(
        int index, com.google.cloud.compute.v1.UrlMapTestHeader.Builder builderForValue) {
      if (headersBuilder_ == null) {
        ensureHeadersIsMutable();
        headers_.set(index, builderForValue.build());
        onChanged();
      } else {
        headersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public Builder addHeaders(com.google.cloud.compute.v1.UrlMapTestHeader value) {
      if (headersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeadersIsMutable();
        headers_.add(value);
        onChanged();
      } else {
        headersBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public Builder addHeaders(int index, com.google.cloud.compute.v1.UrlMapTestHeader value) {
      if (headersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeadersIsMutable();
        headers_.add(index, value);
        onChanged();
      } else {
        headersBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public Builder addHeaders(
        com.google.cloud.compute.v1.UrlMapTestHeader.Builder builderForValue) {
      if (headersBuilder_ == null) {
        ensureHeadersIsMutable();
        headers_.add(builderForValue.build());
        onChanged();
      } else {
        headersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public Builder addHeaders(
        int index, com.google.cloud.compute.v1.UrlMapTestHeader.Builder builderForValue) {
      if (headersBuilder_ == null) {
        ensureHeadersIsMutable();
        headers_.add(index, builderForValue.build());
        onChanged();
      } else {
        headersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public Builder addAllHeaders(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.UrlMapTestHeader> values) {
      if (headersBuilder_ == null) {
        ensureHeadersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, headers_);
        onChanged();
      } else {
        headersBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public Builder clearHeaders() {
      if (headersBuilder_ == null) {
        headers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        headersBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public Builder removeHeaders(int index) {
      if (headersBuilder_ == null) {
        ensureHeadersIsMutable();
        headers_.remove(index);
        onChanged();
      } else {
        headersBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public com.google.cloud.compute.v1.UrlMapTestHeader.Builder getHeadersBuilder(int index) {
      return getHeadersFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public com.google.cloud.compute.v1.UrlMapTestHeaderOrBuilder getHeadersOrBuilder(int index) {
      if (headersBuilder_ == null) {
        return headers_.get(index);
      } else {
        return headersBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.UrlMapTestHeaderOrBuilder>
        getHeadersOrBuilderList() {
      if (headersBuilder_ != null) {
        return headersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(headers_);
      }
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public com.google.cloud.compute.v1.UrlMapTestHeader.Builder addHeadersBuilder() {
      return getHeadersFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.UrlMapTestHeader.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public com.google.cloud.compute.v1.UrlMapTestHeader.Builder addHeadersBuilder(int index) {
      return getHeadersFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.UrlMapTestHeader.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * HTTP headers of the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTestHeader headers = 258436998;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.UrlMapTestHeader.Builder>
        getHeadersBuilderList() {
      return getHeadersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.UrlMapTestHeader,
            com.google.cloud.compute.v1.UrlMapTestHeader.Builder,
            com.google.cloud.compute.v1.UrlMapTestHeaderOrBuilder>
        getHeadersFieldBuilder() {
      if (headersBuilder_ == null) {
        headersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.UrlMapTestHeader,
                com.google.cloud.compute.v1.UrlMapTestHeader.Builder,
                com.google.cloud.compute.v1.UrlMapTestHeaderOrBuilder>(
                headers_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        headers_ = null;
      }
      return headersBuilder_;
    }

    private java.lang.Object host_ = "";

    /**
     *
     *
     * <pre>
     * Host portion of the URL.
     * </pre>
     *
     * <code>optional string host = 3208616;</code>
     *
     * @return Whether the host field is set.
     */
    public boolean hasHost() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Host portion of the URL.
     * </pre>
     *
     * <code>optional string host = 3208616;</code>
     *
     * @return The host.
     */
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Host portion of the URL.
     * </pre>
     *
     * <code>optional string host = 3208616;</code>
     *
     * @return The bytes for host.
     */
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Host portion of the URL.
     * </pre>
     *
     * <code>optional string host = 3208616;</code>
     *
     * @param value The host to set.
     * @return This builder for chaining.
     */
    public Builder setHost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      host_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Host portion of the URL.
     * </pre>
     *
     * <code>optional string host = 3208616;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHost() {
      host_ = getDefaultInstance().getHost();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Host portion of the URL.
     * </pre>
     *
     * <code>optional string host = 3208616;</code>
     *
     * @param value The bytes for host to set.
     * @return This builder for chaining.
     */
    public Builder setHostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      host_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object path_ = "";

    /**
     *
     *
     * <pre>
     * Path portion including query parameters in the URL.
     * </pre>
     *
     * <code>optional string path = 3433509;</code>
     *
     * @return Whether the path field is set.
     */
    public boolean hasPath() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Path portion including query parameters in the URL.
     * </pre>
     *
     * <code>optional string path = 3433509;</code>
     *
     * @return The path.
     */
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Path portion including query parameters in the URL.
     * </pre>
     *
     * <code>optional string path = 3433509;</code>
     *
     * @return The bytes for path.
     */
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Path portion including query parameters in the URL.
     * </pre>
     *
     * <code>optional string path = 3433509;</code>
     *
     * @param value The path to set.
     * @return This builder for chaining.
     */
    public Builder setPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      path_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Path portion including query parameters in the URL.
     * </pre>
     *
     * <code>optional string path = 3433509;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPath() {
      path_ = getDefaultInstance().getPath();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Path portion including query parameters in the URL.
     * </pre>
     *
     * <code>optional string path = 3433509;</code>
     *
     * @param value The bytes for path to set.
     * @return This builder for chaining.
     */
    public Builder setPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      path_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.TestFailure)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.TestFailure)
  private static final com.google.cloud.compute.v1.TestFailure DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.TestFailure();
  }

  public static com.google.cloud.compute.v1.TestFailure getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TestFailure> PARSER =
      new com.google.protobuf.AbstractParser<TestFailure>() {
        @java.lang.Override
        public TestFailure parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TestFailure> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TestFailure> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.TestFailure getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
