/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterStatusBgpPeerStatus}
 */
public final class RouterStatusBgpPeerStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterStatusBgpPeerStatus)
    RouterStatusBgpPeerStatusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RouterStatusBgpPeerStatus.newBuilder() to construct.
  private RouterStatusBgpPeerStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterStatusBgpPeerStatus() {
    advertisedRoutes_ = java.util.Collections.emptyList();
    ipAddress_ = "";
    ipv4NexthopAddress_ = "";
    ipv6NexthopAddress_ = "";
    linkedVpnTunnel_ = "";
    name_ = "";
    peerIpAddress_ = "";
    peerIpv4NexthopAddress_ = "";
    peerIpv6NexthopAddress_ = "";
    routerApplianceInstance_ = "";
    state_ = "";
    status_ = "";
    statusReason_ = "";
    uptime_ = "";
    uptimeSeconds_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterStatusBgpPeerStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterStatusBgpPeerStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterStatusBgpPeerStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.class,
            com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Status of the BGP peer: {UP, DOWN}
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterStatusBgpPeerStatus.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /** <code>DOWN = 2104482;</code> */
    DOWN(2104482),
    /** <code>UNKNOWN = 433141802;</code> */
    UNKNOWN(433141802),
    /** <code>UP = 2715;</code> */
    UP(2715),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /** <code>DOWN = 2104482;</code> */
    public static final int DOWN_VALUE = 2104482;

    /** <code>UNKNOWN = 433141802;</code> */
    public static final int UNKNOWN_VALUE = 433141802;

    /** <code>UP = 2715;</code> */
    public static final int UP_VALUE = 2715;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 2104482:
          return DOWN;
        case 433141802:
          return UNKNOWN;
        case 2715:
          return UP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterStatusBgpPeerStatus.Status)
  }

  /**
   *
   *
   * <pre>
   * Indicates why particular status was returned.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterStatusBgpPeerStatus.StatusReason}
   */
  public enum StatusReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS_REASON = 0;</code>
     */
    UNDEFINED_STATUS_REASON(0),
    /**
     *
     *
     * <pre>
     * BGP peer disabled because it requires IPv4 but the underlying connection is IPv6-only.
     * </pre>
     *
     * <code>IPV4_PEER_ON_IPV6_ONLY_CONNECTION = 435936662;</code>
     */
    IPV4_PEER_ON_IPV6_ONLY_CONNECTION(435936662),
    /**
     *
     *
     * <pre>
     * BGP peer disabled because it requires IPv6 but the underlying connection is IPv4-only.
     * </pre>
     *
     * <code>IPV6_PEER_ON_IPV4_ONLY_CONNECTION = 436304082;</code>
     */
    IPV6_PEER_ON_IPV4_ONLY_CONNECTION(436304082),
    /**
     *
     *
     * <pre>
     * Indicates internal problems with configuration of MD5 authentication. This particular reason can only be returned when md5AuthEnabled is true and status is DOWN.
     * </pre>
     *
     * <code>MD5_AUTH_INTERNAL_PROBLEM = 140462259;</code>
     */
    MD5_AUTH_INTERNAL_PROBLEM(140462259),
    /** <code>STATUS_REASON_UNSPECIFIED = 394331913;</code> */
    STATUS_REASON_UNSPECIFIED(394331913),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS_REASON = 0;</code>
     */
    public static final int UNDEFINED_STATUS_REASON_VALUE = 0;

    /**
     *
     *
     * <pre>
     * BGP peer disabled because it requires IPv4 but the underlying connection is IPv6-only.
     * </pre>
     *
     * <code>IPV4_PEER_ON_IPV6_ONLY_CONNECTION = 435936662;</code>
     */
    public static final int IPV4_PEER_ON_IPV6_ONLY_CONNECTION_VALUE = 435936662;

    /**
     *
     *
     * <pre>
     * BGP peer disabled because it requires IPv6 but the underlying connection is IPv4-only.
     * </pre>
     *
     * <code>IPV6_PEER_ON_IPV4_ONLY_CONNECTION = 436304082;</code>
     */
    public static final int IPV6_PEER_ON_IPV4_ONLY_CONNECTION_VALUE = 436304082;

    /**
     *
     *
     * <pre>
     * Indicates internal problems with configuration of MD5 authentication. This particular reason can only be returned when md5AuthEnabled is true and status is DOWN.
     * </pre>
     *
     * <code>MD5_AUTH_INTERNAL_PROBLEM = 140462259;</code>
     */
    public static final int MD5_AUTH_INTERNAL_PROBLEM_VALUE = 140462259;

    /** <code>STATUS_REASON_UNSPECIFIED = 394331913;</code> */
    public static final int STATUS_REASON_UNSPECIFIED_VALUE = 394331913;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StatusReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static StatusReason forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS_REASON;
        case 435936662:
          return IPV4_PEER_ON_IPV6_ONLY_CONNECTION;
        case 436304082:
          return IPV6_PEER_ON_IPV4_ONLY_CONNECTION;
        case 140462259:
          return MD5_AUTH_INTERNAL_PROBLEM;
        case 394331913:
          return STATUS_REASON_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<StatusReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<StatusReason> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<StatusReason>() {
          public StatusReason findValueByNumber(int number) {
            return StatusReason.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final StatusReason[] VALUES = values();

    public static StatusReason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private StatusReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterStatusBgpPeerStatus.StatusReason)
  }

  private int bitField0_;
  public static final int ADVERTISED_ROUTES_FIELD_NUMBER = 333393068;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Route> advertisedRoutes_;

  /**
   *
   *
   * <pre>
   * Routes that were advertised to the remote BGP peer
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Route> getAdvertisedRoutesList() {
    return advertisedRoutes_;
  }

  /**
   *
   *
   * <pre>
   * Routes that were advertised to the remote BGP peer
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouteOrBuilder>
      getAdvertisedRoutesOrBuilderList() {
    return advertisedRoutes_;
  }

  /**
   *
   *
   * <pre>
   * Routes that were advertised to the remote BGP peer
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
   */
  @java.lang.Override
  public int getAdvertisedRoutesCount() {
    return advertisedRoutes_.size();
  }

  /**
   *
   *
   * <pre>
   * Routes that were advertised to the remote BGP peer
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Route getAdvertisedRoutes(int index) {
    return advertisedRoutes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Routes that were advertised to the remote BGP peer
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouteOrBuilder getAdvertisedRoutesOrBuilder(int index) {
    return advertisedRoutes_.get(index);
  }

  public static final int BFD_STATUS_FIELD_NUMBER = 395631729;
  private com.google.cloud.compute.v1.BfdStatus bfdStatus_;

  /**
   * <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code>
   *
   * @return Whether the bfdStatus field is set.
   */
  @java.lang.Override
  public boolean hasBfdStatus() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code>
   *
   * @return The bfdStatus.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BfdStatus getBfdStatus() {
    return bfdStatus_ == null
        ? com.google.cloud.compute.v1.BfdStatus.getDefaultInstance()
        : bfdStatus_;
  }

  /** <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.BfdStatusOrBuilder getBfdStatusOrBuilder() {
    return bfdStatus_ == null
        ? com.google.cloud.compute.v1.BfdStatus.getDefaultInstance()
        : bfdStatus_;
  }

  public static final int ENABLE_IPV4_FIELD_NUMBER = 181467937;
  private boolean enableIpv4_ = false;

  /**
   *
   *
   * <pre>
   * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
   * </pre>
   *
   * <code>optional bool enable_ipv4 = 181467937;</code>
   *
   * @return Whether the enableIpv4 field is set.
   */
  @java.lang.Override
  public boolean hasEnableIpv4() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
   * </pre>
   *
   * <code>optional bool enable_ipv4 = 181467937;</code>
   *
   * @return The enableIpv4.
   */
  @java.lang.Override
  public boolean getEnableIpv4() {
    return enableIpv4_;
  }

  public static final int ENABLE_IPV6_FIELD_NUMBER = 181467939;
  private boolean enableIpv6_ = false;

  /**
   *
   *
   * <pre>
   * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
   * </pre>
   *
   * <code>optional bool enable_ipv6 = 181467939;</code>
   *
   * @return Whether the enableIpv6 field is set.
   */
  @java.lang.Override
  public boolean hasEnableIpv6() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
   * </pre>
   *
   * <code>optional bool enable_ipv6 = 181467939;</code>
   *
   * @return The enableIpv6.
   */
  @java.lang.Override
  public boolean getEnableIpv6() {
    return enableIpv6_;
  }

  public static final int IP_ADDRESS_FIELD_NUMBER = 406272220;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipAddress_ = "";

  /**
   *
   *
   * <pre>
   * IP address of the local BGP interface.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return Whether the ipAddress field is set.
   */
  @java.lang.Override
  public boolean hasIpAddress() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * IP address of the local BGP interface.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return The ipAddress.
   */
  @java.lang.Override
  public java.lang.String getIpAddress() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IP address of the local BGP interface.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return The bytes for ipAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpAddressBytes() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IPV4_NEXTHOP_ADDRESS_FIELD_NUMBER = 5703377;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipv4NexthopAddress_ = "";

  /**
   *
   *
   * <pre>
   * IPv4 address of the local BGP interface.
   * </pre>
   *
   * <code>optional string ipv4_nexthop_address = 5703377;</code>
   *
   * @return Whether the ipv4NexthopAddress field is set.
   */
  @java.lang.Override
  public boolean hasIpv4NexthopAddress() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * IPv4 address of the local BGP interface.
   * </pre>
   *
   * <code>optional string ipv4_nexthop_address = 5703377;</code>
   *
   * @return The ipv4NexthopAddress.
   */
  @java.lang.Override
  public java.lang.String getIpv4NexthopAddress() {
    java.lang.Object ref = ipv4NexthopAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipv4NexthopAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IPv4 address of the local BGP interface.
   * </pre>
   *
   * <code>optional string ipv4_nexthop_address = 5703377;</code>
   *
   * @return The bytes for ipv4NexthopAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpv4NexthopAddressBytes() {
    java.lang.Object ref = ipv4NexthopAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipv4NexthopAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IPV6_NEXTHOP_ADDRESS_FIELD_NUMBER = 27968211;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipv6NexthopAddress_ = "";

  /**
   *
   *
   * <pre>
   * IPv6 address of the local BGP interface.
   * </pre>
   *
   * <code>optional string ipv6_nexthop_address = 27968211;</code>
   *
   * @return Whether the ipv6NexthopAddress field is set.
   */
  @java.lang.Override
  public boolean hasIpv6NexthopAddress() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * IPv6 address of the local BGP interface.
   * </pre>
   *
   * <code>optional string ipv6_nexthop_address = 27968211;</code>
   *
   * @return The ipv6NexthopAddress.
   */
  @java.lang.Override
  public java.lang.String getIpv6NexthopAddress() {
    java.lang.Object ref = ipv6NexthopAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipv6NexthopAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IPv6 address of the local BGP interface.
   * </pre>
   *
   * <code>optional string ipv6_nexthop_address = 27968211;</code>
   *
   * @return The bytes for ipv6NexthopAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpv6NexthopAddressBytes() {
    java.lang.Object ref = ipv6NexthopAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipv6NexthopAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKED_VPN_TUNNEL_FIELD_NUMBER = 352296953;

  @SuppressWarnings("serial")
  private volatile java.lang.Object linkedVpnTunnel_ = "";

  /**
   *
   *
   * <pre>
   * URL of the VPN tunnel that this BGP peer controls.
   * </pre>
   *
   * <code>optional string linked_vpn_tunnel = 352296953;</code>
   *
   * @return Whether the linkedVpnTunnel field is set.
   */
  @java.lang.Override
  public boolean hasLinkedVpnTunnel() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * URL of the VPN tunnel that this BGP peer controls.
   * </pre>
   *
   * <code>optional string linked_vpn_tunnel = 352296953;</code>
   *
   * @return The linkedVpnTunnel.
   */
  @java.lang.Override
  public java.lang.String getLinkedVpnTunnel() {
    java.lang.Object ref = linkedVpnTunnel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      linkedVpnTunnel_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URL of the VPN tunnel that this BGP peer controls.
   * </pre>
   *
   * <code>optional string linked_vpn_tunnel = 352296953;</code>
   *
   * @return The bytes for linkedVpnTunnel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLinkedVpnTunnelBytes() {
    java.lang.Object ref = linkedVpnTunnel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      linkedVpnTunnel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MD5_AUTH_ENABLED_FIELD_NUMBER = 451152075;
  private boolean md5AuthEnabled_ = false;

  /**
   *
   *
   * <pre>
   * Informs whether MD5 authentication is enabled on this BGP peer.
   * </pre>
   *
   * <code>optional bool md5_auth_enabled = 451152075;</code>
   *
   * @return Whether the md5AuthEnabled field is set.
   */
  @java.lang.Override
  public boolean hasMd5AuthEnabled() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Informs whether MD5 authentication is enabled on this BGP peer.
   * </pre>
   *
   * <code>optional bool md5_auth_enabled = 451152075;</code>
   *
   * @return The md5AuthEnabled.
   */
  @java.lang.Override
  public boolean getMd5AuthEnabled() {
    return md5AuthEnabled_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of this BGP peer. Unique within the Routers resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of this BGP peer. Unique within the Routers resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of this BGP peer. Unique within the Routers resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NUM_LEARNED_ROUTES_FIELD_NUMBER = 135457535;
  private int numLearnedRoutes_ = 0;

  /**
   *
   *
   * <pre>
   * Number of routes learned from the remote BGP Peer.
   * </pre>
   *
   * <code>optional uint32 num_learned_routes = 135457535;</code>
   *
   * @return Whether the numLearnedRoutes field is set.
   */
  @java.lang.Override
  public boolean hasNumLearnedRoutes() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Number of routes learned from the remote BGP Peer.
   * </pre>
   *
   * <code>optional uint32 num_learned_routes = 135457535;</code>
   *
   * @return The numLearnedRoutes.
   */
  @java.lang.Override
  public int getNumLearnedRoutes() {
    return numLearnedRoutes_;
  }

  public static final int PEER_IP_ADDRESS_FIELD_NUMBER = 207735769;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerIpAddress_ = "";

  /**
   *
   *
   * <pre>
   * IP address of the remote BGP interface.
   * </pre>
   *
   * <code>optional string peer_ip_address = 207735769;</code>
   *
   * @return Whether the peerIpAddress field is set.
   */
  @java.lang.Override
  public boolean hasPeerIpAddress() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * IP address of the remote BGP interface.
   * </pre>
   *
   * <code>optional string peer_ip_address = 207735769;</code>
   *
   * @return The peerIpAddress.
   */
  @java.lang.Override
  public java.lang.String getPeerIpAddress() {
    java.lang.Object ref = peerIpAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerIpAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IP address of the remote BGP interface.
   * </pre>
   *
   * <code>optional string peer_ip_address = 207735769;</code>
   *
   * @return The bytes for peerIpAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerIpAddressBytes() {
    java.lang.Object ref = peerIpAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerIpAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_IPV4_NEXTHOP_ADDRESS_FIELD_NUMBER = 469221774;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerIpv4NexthopAddress_ = "";

  /**
   *
   *
   * <pre>
   * IPv4 address of the remote BGP interface.
   * </pre>
   *
   * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
   *
   * @return Whether the peerIpv4NexthopAddress field is set.
   */
  @java.lang.Override
  public boolean hasPeerIpv4NexthopAddress() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * IPv4 address of the remote BGP interface.
   * </pre>
   *
   * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
   *
   * @return The peerIpv4NexthopAddress.
   */
  @java.lang.Override
  public java.lang.String getPeerIpv4NexthopAddress() {
    java.lang.Object ref = peerIpv4NexthopAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerIpv4NexthopAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IPv4 address of the remote BGP interface.
   * </pre>
   *
   * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
   *
   * @return The bytes for peerIpv4NexthopAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerIpv4NexthopAddressBytes() {
    java.lang.Object ref = peerIpv4NexthopAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerIpv4NexthopAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_IPV6_NEXTHOP_ADDRESS_FIELD_NUMBER = 491486608;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerIpv6NexthopAddress_ = "";

  /**
   *
   *
   * <pre>
   * IPv6 address of the remote BGP interface.
   * </pre>
   *
   * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
   *
   * @return Whether the peerIpv6NexthopAddress field is set.
   */
  @java.lang.Override
  public boolean hasPeerIpv6NexthopAddress() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * IPv6 address of the remote BGP interface.
   * </pre>
   *
   * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
   *
   * @return The peerIpv6NexthopAddress.
   */
  @java.lang.Override
  public java.lang.String getPeerIpv6NexthopAddress() {
    java.lang.Object ref = peerIpv6NexthopAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerIpv6NexthopAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IPv6 address of the remote BGP interface.
   * </pre>
   *
   * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
   *
   * @return The bytes for peerIpv6NexthopAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerIpv6NexthopAddressBytes() {
    java.lang.Object ref = peerIpv6NexthopAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerIpv6NexthopAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROUTER_APPLIANCE_INSTANCE_FIELD_NUMBER = 468312989;

  @SuppressWarnings("serial")
  private volatile java.lang.Object routerApplianceInstance_ = "";

  /**
   *
   *
   * <pre>
   * [Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.
   * </pre>
   *
   * <code>optional string router_appliance_instance = 468312989;</code>
   *
   * @return Whether the routerApplianceInstance field is set.
   */
  @java.lang.Override
  public boolean hasRouterApplianceInstance() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.
   * </pre>
   *
   * <code>optional string router_appliance_instance = 468312989;</code>
   *
   * @return The routerApplianceInstance.
   */
  @java.lang.Override
  public java.lang.String getRouterApplianceInstance() {
    java.lang.Object ref = routerApplianceInstance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      routerApplianceInstance_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.
   * </pre>
   *
   * <code>optional string router_appliance_instance = 468312989;</code>
   *
   * @return The bytes for routerApplianceInstance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRouterApplianceInstanceBytes() {
    java.lang.Object ref = routerApplianceInstance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      routerApplianceInstance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 109757585;

  @SuppressWarnings("serial")
  private volatile java.lang.Object state_ = "";

  /**
   *
   *
   * <pre>
   * The state of the BGP session. For a list of possible values for this field, see BGP session states.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The state of the BGP session. For a list of possible values for this field, see BGP session states.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public java.lang.String getState() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      state_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The state of the BGP session. For a list of possible values for this field, see BGP session states.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The bytes for state.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateBytes() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      state_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * Status of the BGP peer: {UP, DOWN}
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Status of the BGP peer: {UP, DOWN}
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Status of the BGP peer: {UP, DOWN}
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_REASON_FIELD_NUMBER = 342706993;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusReason_ = "";

  /**
   *
   *
   * <pre>
   * Indicates why particular status was returned.
   * Check the StatusReason enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status_reason = 342706993;</code>
   *
   * @return Whether the statusReason field is set.
   */
  @java.lang.Override
  public boolean hasStatusReason() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Indicates why particular status was returned.
   * Check the StatusReason enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status_reason = 342706993;</code>
   *
   * @return The statusReason.
   */
  @java.lang.Override
  public java.lang.String getStatusReason() {
    java.lang.Object ref = statusReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusReason_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Indicates why particular status was returned.
   * Check the StatusReason enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status_reason = 342706993;</code>
   *
   * @return The bytes for statusReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusReasonBytes() {
    java.lang.Object ref = statusReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPTIME_FIELD_NUMBER = 235379688;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uptime_ = "";

  /**
   *
   *
   * <pre>
   * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
   * </pre>
   *
   * <code>optional string uptime = 235379688;</code>
   *
   * @return Whether the uptime field is set.
   */
  @java.lang.Override
  public boolean hasUptime() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
   * </pre>
   *
   * <code>optional string uptime = 235379688;</code>
   *
   * @return The uptime.
   */
  @java.lang.Override
  public java.lang.String getUptime() {
    java.lang.Object ref = uptime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uptime_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
   * </pre>
   *
   * <code>optional string uptime = 235379688;</code>
   *
   * @return The bytes for uptime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUptimeBytes() {
    java.lang.Object ref = uptime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uptime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPTIME_SECONDS_FIELD_NUMBER = 104736040;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uptimeSeconds_ = "";

  /**
   *
   *
   * <pre>
   * Time this session has been up, in seconds. Format: 145
   * </pre>
   *
   * <code>optional string uptime_seconds = 104736040;</code>
   *
   * @return Whether the uptimeSeconds field is set.
   */
  @java.lang.Override
  public boolean hasUptimeSeconds() {
    return ((bitField0_ & 0x00040000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Time this session has been up, in seconds. Format: 145
   * </pre>
   *
   * <code>optional string uptime_seconds = 104736040;</code>
   *
   * @return The uptimeSeconds.
   */
  @java.lang.Override
  public java.lang.String getUptimeSeconds() {
    java.lang.Object ref = uptimeSeconds_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uptimeSeconds_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Time this session has been up, in seconds. Format: 145
   * </pre>
   *
   * <code>optional string uptime_seconds = 104736040;</code>
   *
   * @return The bytes for uptimeSeconds.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUptimeSecondsBytes() {
    java.lang.Object ref = uptimeSeconds_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uptimeSeconds_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5703377, ipv4NexthopAddress_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27968211, ipv6NexthopAddress_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 104736040, uptimeSeconds_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 109757585, state_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeUInt32(135457535, numLearnedRoutes_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(181467937, enableIpv4_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(181467939, enableIpv6_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 207735769, peerIpAddress_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 235379688, uptime_);
    }
    for (int i = 0; i < advertisedRoutes_.size(); i++) {
      output.writeMessage(333393068, advertisedRoutes_.get(i));
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 342706993, statusReason_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 352296953, linkedVpnTunnel_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(395631729, getBfdStatus());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 406272220, ipAddress_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeBool(451152075, md5AuthEnabled_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 468312989, routerApplianceInstance_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 469221774, peerIpv4NexthopAddress_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 491486608, peerIpv6NexthopAddress_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(5703377, ipv4NexthopAddress_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(27968211, ipv6NexthopAddress_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(104736040, uptimeSeconds_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(109757585, state_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(135457535, numLearnedRoutes_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(181467937, enableIpv4_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(181467939, enableIpv6_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(207735769, peerIpAddress_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(235379688, uptime_);
    }
    for (int i = 0; i < advertisedRoutes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              333393068, advertisedRoutes_.get(i));
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(342706993, statusReason_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(352296953, linkedVpnTunnel_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(395631729, getBfdStatus());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(406272220, ipAddress_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(451152075, md5AuthEnabled_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              468312989, routerApplianceInstance_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              469221774, peerIpv4NexthopAddress_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              491486608, peerIpv6NexthopAddress_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterStatusBgpPeerStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterStatusBgpPeerStatus other =
        (com.google.cloud.compute.v1.RouterStatusBgpPeerStatus) obj;

    if (!getAdvertisedRoutesList().equals(other.getAdvertisedRoutesList())) return false;
    if (hasBfdStatus() != other.hasBfdStatus()) return false;
    if (hasBfdStatus()) {
      if (!getBfdStatus().equals(other.getBfdStatus())) return false;
    }
    if (hasEnableIpv4() != other.hasEnableIpv4()) return false;
    if (hasEnableIpv4()) {
      if (getEnableIpv4() != other.getEnableIpv4()) return false;
    }
    if (hasEnableIpv6() != other.hasEnableIpv6()) return false;
    if (hasEnableIpv6()) {
      if (getEnableIpv6() != other.getEnableIpv6()) return false;
    }
    if (hasIpAddress() != other.hasIpAddress()) return false;
    if (hasIpAddress()) {
      if (!getIpAddress().equals(other.getIpAddress())) return false;
    }
    if (hasIpv4NexthopAddress() != other.hasIpv4NexthopAddress()) return false;
    if (hasIpv4NexthopAddress()) {
      if (!getIpv4NexthopAddress().equals(other.getIpv4NexthopAddress())) return false;
    }
    if (hasIpv6NexthopAddress() != other.hasIpv6NexthopAddress()) return false;
    if (hasIpv6NexthopAddress()) {
      if (!getIpv6NexthopAddress().equals(other.getIpv6NexthopAddress())) return false;
    }
    if (hasLinkedVpnTunnel() != other.hasLinkedVpnTunnel()) return false;
    if (hasLinkedVpnTunnel()) {
      if (!getLinkedVpnTunnel().equals(other.getLinkedVpnTunnel())) return false;
    }
    if (hasMd5AuthEnabled() != other.hasMd5AuthEnabled()) return false;
    if (hasMd5AuthEnabled()) {
      if (getMd5AuthEnabled() != other.getMd5AuthEnabled()) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNumLearnedRoutes() != other.hasNumLearnedRoutes()) return false;
    if (hasNumLearnedRoutes()) {
      if (getNumLearnedRoutes() != other.getNumLearnedRoutes()) return false;
    }
    if (hasPeerIpAddress() != other.hasPeerIpAddress()) return false;
    if (hasPeerIpAddress()) {
      if (!getPeerIpAddress().equals(other.getPeerIpAddress())) return false;
    }
    if (hasPeerIpv4NexthopAddress() != other.hasPeerIpv4NexthopAddress()) return false;
    if (hasPeerIpv4NexthopAddress()) {
      if (!getPeerIpv4NexthopAddress().equals(other.getPeerIpv4NexthopAddress())) return false;
    }
    if (hasPeerIpv6NexthopAddress() != other.hasPeerIpv6NexthopAddress()) return false;
    if (hasPeerIpv6NexthopAddress()) {
      if (!getPeerIpv6NexthopAddress().equals(other.getPeerIpv6NexthopAddress())) return false;
    }
    if (hasRouterApplianceInstance() != other.hasRouterApplianceInstance()) return false;
    if (hasRouterApplianceInstance()) {
      if (!getRouterApplianceInstance().equals(other.getRouterApplianceInstance())) return false;
    }
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (!getState().equals(other.getState())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasStatusReason() != other.hasStatusReason()) return false;
    if (hasStatusReason()) {
      if (!getStatusReason().equals(other.getStatusReason())) return false;
    }
    if (hasUptime() != other.hasUptime()) return false;
    if (hasUptime()) {
      if (!getUptime().equals(other.getUptime())) return false;
    }
    if (hasUptimeSeconds() != other.hasUptimeSeconds()) return false;
    if (hasUptimeSeconds()) {
      if (!getUptimeSeconds().equals(other.getUptimeSeconds())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAdvertisedRoutesCount() > 0) {
      hash = (37 * hash) + ADVERTISED_ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getAdvertisedRoutesList().hashCode();
    }
    if (hasBfdStatus()) {
      hash = (37 * hash) + BFD_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getBfdStatus().hashCode();
    }
    if (hasEnableIpv4()) {
      hash = (37 * hash) + ENABLE_IPV4_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableIpv4());
    }
    if (hasEnableIpv6()) {
      hash = (37 * hash) + ENABLE_IPV6_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableIpv6());
    }
    if (hasIpAddress()) {
      hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpAddress().hashCode();
    }
    if (hasIpv4NexthopAddress()) {
      hash = (37 * hash) + IPV4_NEXTHOP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpv4NexthopAddress().hashCode();
    }
    if (hasIpv6NexthopAddress()) {
      hash = (37 * hash) + IPV6_NEXTHOP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpv6NexthopAddress().hashCode();
    }
    if (hasLinkedVpnTunnel()) {
      hash = (37 * hash) + LINKED_VPN_TUNNEL_FIELD_NUMBER;
      hash = (53 * hash) + getLinkedVpnTunnel().hashCode();
    }
    if (hasMd5AuthEnabled()) {
      hash = (37 * hash) + MD5_AUTH_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMd5AuthEnabled());
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNumLearnedRoutes()) {
      hash = (37 * hash) + NUM_LEARNED_ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getNumLearnedRoutes();
    }
    if (hasPeerIpAddress()) {
      hash = (37 * hash) + PEER_IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getPeerIpAddress().hashCode();
    }
    if (hasPeerIpv4NexthopAddress()) {
      hash = (37 * hash) + PEER_IPV4_NEXTHOP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getPeerIpv4NexthopAddress().hashCode();
    }
    if (hasPeerIpv6NexthopAddress()) {
      hash = (37 * hash) + PEER_IPV6_NEXTHOP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getPeerIpv6NexthopAddress().hashCode();
    }
    if (hasRouterApplianceInstance()) {
      hash = (37 * hash) + ROUTER_APPLIANCE_INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getRouterApplianceInstance().hashCode();
    }
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasStatusReason()) {
      hash = (37 * hash) + STATUS_REASON_FIELD_NUMBER;
      hash = (53 * hash) + getStatusReason().hashCode();
    }
    if (hasUptime()) {
      hash = (37 * hash) + UPTIME_FIELD_NUMBER;
      hash = (53 * hash) + getUptime().hashCode();
    }
    if (hasUptimeSeconds()) {
      hash = (37 * hash) + UPTIME_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + getUptimeSeconds().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.RouterStatusBgpPeerStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterStatusBgpPeerStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterStatusBgpPeerStatus)
      com.google.cloud.compute.v1.RouterStatusBgpPeerStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatusBgpPeerStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatusBgpPeerStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.class,
              com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAdvertisedRoutesFieldBuilder();
        getBfdStatusFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (advertisedRoutesBuilder_ == null) {
        advertisedRoutes_ = java.util.Collections.emptyList();
      } else {
        advertisedRoutes_ = null;
        advertisedRoutesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      bfdStatus_ = null;
      if (bfdStatusBuilder_ != null) {
        bfdStatusBuilder_.dispose();
        bfdStatusBuilder_ = null;
      }
      enableIpv4_ = false;
      enableIpv6_ = false;
      ipAddress_ = "";
      ipv4NexthopAddress_ = "";
      ipv6NexthopAddress_ = "";
      linkedVpnTunnel_ = "";
      md5AuthEnabled_ = false;
      name_ = "";
      numLearnedRoutes_ = 0;
      peerIpAddress_ = "";
      peerIpv4NexthopAddress_ = "";
      peerIpv6NexthopAddress_ = "";
      routerApplianceInstance_ = "";
      state_ = "";
      status_ = "";
      statusReason_ = "";
      uptime_ = "";
      uptimeSeconds_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatusBgpPeerStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatusBgpPeerStatus getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatusBgpPeerStatus build() {
      com.google.cloud.compute.v1.RouterStatusBgpPeerStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatusBgpPeerStatus buildPartial() {
      com.google.cloud.compute.v1.RouterStatusBgpPeerStatus result =
          new com.google.cloud.compute.v1.RouterStatusBgpPeerStatus(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.RouterStatusBgpPeerStatus result) {
      if (advertisedRoutesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          advertisedRoutes_ = java.util.Collections.unmodifiableList(advertisedRoutes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.advertisedRoutes_ = advertisedRoutes_;
      } else {
        result.advertisedRoutes_ = advertisedRoutesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterStatusBgpPeerStatus result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.bfdStatus_ = bfdStatusBuilder_ == null ? bfdStatus_ : bfdStatusBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.enableIpv4_ = enableIpv4_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enableIpv6_ = enableIpv6_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ipAddress_ = ipAddress_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ipv4NexthopAddress_ = ipv4NexthopAddress_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.ipv6NexthopAddress_ = ipv6NexthopAddress_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.linkedVpnTunnel_ = linkedVpnTunnel_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.md5AuthEnabled_ = md5AuthEnabled_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.numLearnedRoutes_ = numLearnedRoutes_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.peerIpAddress_ = peerIpAddress_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.peerIpv4NexthopAddress_ = peerIpv4NexthopAddress_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.peerIpv6NexthopAddress_ = peerIpv6NexthopAddress_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.routerApplianceInstance_ = routerApplianceInstance_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.state_ = state_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.statusReason_ = statusReason_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.uptime_ = uptime_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.uptimeSeconds_ = uptimeSeconds_;
        to_bitField0_ |= 0x00040000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterStatusBgpPeerStatus) {
        return mergeFrom((com.google.cloud.compute.v1.RouterStatusBgpPeerStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterStatusBgpPeerStatus other) {
      if (other == com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.getDefaultInstance())
        return this;
      if (advertisedRoutesBuilder_ == null) {
        if (!other.advertisedRoutes_.isEmpty()) {
          if (advertisedRoutes_.isEmpty()) {
            advertisedRoutes_ = other.advertisedRoutes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAdvertisedRoutesIsMutable();
            advertisedRoutes_.addAll(other.advertisedRoutes_);
          }
          onChanged();
        }
      } else {
        if (!other.advertisedRoutes_.isEmpty()) {
          if (advertisedRoutesBuilder_.isEmpty()) {
            advertisedRoutesBuilder_.dispose();
            advertisedRoutesBuilder_ = null;
            advertisedRoutes_ = other.advertisedRoutes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            advertisedRoutesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAdvertisedRoutesFieldBuilder()
                    : null;
          } else {
            advertisedRoutesBuilder_.addAllMessages(other.advertisedRoutes_);
          }
        }
      }
      if (other.hasBfdStatus()) {
        mergeBfdStatus(other.getBfdStatus());
      }
      if (other.hasEnableIpv4()) {
        setEnableIpv4(other.getEnableIpv4());
      }
      if (other.hasEnableIpv6()) {
        setEnableIpv6(other.getEnableIpv6());
      }
      if (other.hasIpAddress()) {
        ipAddress_ = other.ipAddress_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasIpv4NexthopAddress()) {
        ipv4NexthopAddress_ = other.ipv4NexthopAddress_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasIpv6NexthopAddress()) {
        ipv6NexthopAddress_ = other.ipv6NexthopAddress_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasLinkedVpnTunnel()) {
        linkedVpnTunnel_ = other.linkedVpnTunnel_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasMd5AuthEnabled()) {
        setMd5AuthEnabled(other.getMd5AuthEnabled());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasNumLearnedRoutes()) {
        setNumLearnedRoutes(other.getNumLearnedRoutes());
      }
      if (other.hasPeerIpAddress()) {
        peerIpAddress_ = other.peerIpAddress_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasPeerIpv4NexthopAddress()) {
        peerIpv4NexthopAddress_ = other.peerIpv4NexthopAddress_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasPeerIpv6NexthopAddress()) {
        peerIpv6NexthopAddress_ = other.peerIpv6NexthopAddress_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasRouterApplianceInstance()) {
        routerApplianceInstance_ = other.routerApplianceInstance_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasState()) {
        state_ = other.state_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasStatusReason()) {
        statusReason_ = other.statusReason_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasUptime()) {
        uptime_ = other.uptime_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasUptimeSeconds()) {
        uptimeSeconds_ = other.uptimeSeconds_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26989658
            case 45627018:
              {
                ipv4NexthopAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 45627018
            case 223745690:
              {
                ipv6NexthopAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 223745690
            case 837888322:
              {
                uptimeSeconds_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 837888322
            case 878060682:
              {
                state_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 878060682
            case 1083660280:
              {
                numLearnedRoutes_ = input.readUInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 1083660280
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 1450082194
            case 1451743496:
              {
                enableIpv4_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 1451743496
            case 1451743512:
              {
                enableIpv6_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 1451743512
            case 1661886154:
              {
                peerIpAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 1661886154
            case 1883037506:
              {
                uptime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 1883037506
            case -1627822750:
              {
                com.google.cloud.compute.v1.Route m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Route.parser(), extensionRegistry);
                if (advertisedRoutesBuilder_ == null) {
                  ensureAdvertisedRoutesIsMutable();
                  advertisedRoutes_.add(m);
                } else {
                  advertisedRoutesBuilder_.addMessage(m);
                }
                break;
              } // case -1627822750
            case -1553311350:
              {
                statusReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case -1553311350
            case -1476591670:
              {
                linkedVpnTunnel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -1476591670
            case -1129913462:
              {
                input.readMessage(getBfdStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1129913462
            case -1044789534:
              {
                ipAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -1044789534
            case -685750696:
              {
                md5AuthEnabled_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case -685750696
            case -548463382:
              {
                routerApplianceInstance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -548463382
            case -541193102:
              {
                peerIpv4NexthopAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case -541193102
            case -363074430:
              {
                peerIpv6NexthopAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case -363074430
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.Route> advertisedRoutes_ =
        java.util.Collections.emptyList();

    private void ensureAdvertisedRoutesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        advertisedRoutes_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.Route>(advertisedRoutes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Route,
            com.google.cloud.compute.v1.Route.Builder,
            com.google.cloud.compute.v1.RouteOrBuilder>
        advertisedRoutesBuilder_;

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Route> getAdvertisedRoutesList() {
      if (advertisedRoutesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(advertisedRoutes_);
      } else {
        return advertisedRoutesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public int getAdvertisedRoutesCount() {
      if (advertisedRoutesBuilder_ == null) {
        return advertisedRoutes_.size();
      } else {
        return advertisedRoutesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public com.google.cloud.compute.v1.Route getAdvertisedRoutes(int index) {
      if (advertisedRoutesBuilder_ == null) {
        return advertisedRoutes_.get(index);
      } else {
        return advertisedRoutesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public Builder setAdvertisedRoutes(int index, com.google.cloud.compute.v1.Route value) {
      if (advertisedRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvertisedRoutesIsMutable();
        advertisedRoutes_.set(index, value);
        onChanged();
      } else {
        advertisedRoutesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public Builder setAdvertisedRoutes(
        int index, com.google.cloud.compute.v1.Route.Builder builderForValue) {
      if (advertisedRoutesBuilder_ == null) {
        ensureAdvertisedRoutesIsMutable();
        advertisedRoutes_.set(index, builderForValue.build());
        onChanged();
      } else {
        advertisedRoutesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public Builder addAdvertisedRoutes(com.google.cloud.compute.v1.Route value) {
      if (advertisedRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvertisedRoutesIsMutable();
        advertisedRoutes_.add(value);
        onChanged();
      } else {
        advertisedRoutesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public Builder addAdvertisedRoutes(int index, com.google.cloud.compute.v1.Route value) {
      if (advertisedRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvertisedRoutesIsMutable();
        advertisedRoutes_.add(index, value);
        onChanged();
      } else {
        advertisedRoutesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public Builder addAdvertisedRoutes(com.google.cloud.compute.v1.Route.Builder builderForValue) {
      if (advertisedRoutesBuilder_ == null) {
        ensureAdvertisedRoutesIsMutable();
        advertisedRoutes_.add(builderForValue.build());
        onChanged();
      } else {
        advertisedRoutesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public Builder addAdvertisedRoutes(
        int index, com.google.cloud.compute.v1.Route.Builder builderForValue) {
      if (advertisedRoutesBuilder_ == null) {
        ensureAdvertisedRoutesIsMutable();
        advertisedRoutes_.add(index, builderForValue.build());
        onChanged();
      } else {
        advertisedRoutesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public Builder addAllAdvertisedRoutes(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Route> values) {
      if (advertisedRoutesBuilder_ == null) {
        ensureAdvertisedRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, advertisedRoutes_);
        onChanged();
      } else {
        advertisedRoutesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public Builder clearAdvertisedRoutes() {
      if (advertisedRoutesBuilder_ == null) {
        advertisedRoutes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        advertisedRoutesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public Builder removeAdvertisedRoutes(int index) {
      if (advertisedRoutesBuilder_ == null) {
        ensureAdvertisedRoutesIsMutable();
        advertisedRoutes_.remove(index);
        onChanged();
      } else {
        advertisedRoutesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public com.google.cloud.compute.v1.Route.Builder getAdvertisedRoutesBuilder(int index) {
      return getAdvertisedRoutesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public com.google.cloud.compute.v1.RouteOrBuilder getAdvertisedRoutesOrBuilder(int index) {
      if (advertisedRoutesBuilder_ == null) {
        return advertisedRoutes_.get(index);
      } else {
        return advertisedRoutesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouteOrBuilder>
        getAdvertisedRoutesOrBuilderList() {
      if (advertisedRoutesBuilder_ != null) {
        return advertisedRoutesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(advertisedRoutes_);
      }
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public com.google.cloud.compute.v1.Route.Builder addAdvertisedRoutesBuilder() {
      return getAdvertisedRoutesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Route.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public com.google.cloud.compute.v1.Route.Builder addAdvertisedRoutesBuilder(int index) {
      return getAdvertisedRoutesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Route.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Routes that were advertised to the remote BGP peer
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route advertised_routes = 333393068;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Route.Builder>
        getAdvertisedRoutesBuilderList() {
      return getAdvertisedRoutesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Route,
            com.google.cloud.compute.v1.Route.Builder,
            com.google.cloud.compute.v1.RouteOrBuilder>
        getAdvertisedRoutesFieldBuilder() {
      if (advertisedRoutesBuilder_ == null) {
        advertisedRoutesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Route,
                com.google.cloud.compute.v1.Route.Builder,
                com.google.cloud.compute.v1.RouteOrBuilder>(
                advertisedRoutes_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        advertisedRoutes_ = null;
      }
      return advertisedRoutesBuilder_;
    }

    private com.google.cloud.compute.v1.BfdStatus bfdStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BfdStatus,
            com.google.cloud.compute.v1.BfdStatus.Builder,
            com.google.cloud.compute.v1.BfdStatusOrBuilder>
        bfdStatusBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code>
     *
     * @return Whether the bfdStatus field is set.
     */
    public boolean hasBfdStatus() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code>
     *
     * @return The bfdStatus.
     */
    public com.google.cloud.compute.v1.BfdStatus getBfdStatus() {
      if (bfdStatusBuilder_ == null) {
        return bfdStatus_ == null
            ? com.google.cloud.compute.v1.BfdStatus.getDefaultInstance()
            : bfdStatus_;
      } else {
        return bfdStatusBuilder_.getMessage();
      }
    }

    /** <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code> */
    public Builder setBfdStatus(com.google.cloud.compute.v1.BfdStatus value) {
      if (bfdStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bfdStatus_ = value;
      } else {
        bfdStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /** <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code> */
    public Builder setBfdStatus(com.google.cloud.compute.v1.BfdStatus.Builder builderForValue) {
      if (bfdStatusBuilder_ == null) {
        bfdStatus_ = builderForValue.build();
      } else {
        bfdStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /** <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code> */
    public Builder mergeBfdStatus(com.google.cloud.compute.v1.BfdStatus value) {
      if (bfdStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && bfdStatus_ != null
            && bfdStatus_ != com.google.cloud.compute.v1.BfdStatus.getDefaultInstance()) {
          getBfdStatusBuilder().mergeFrom(value);
        } else {
          bfdStatus_ = value;
        }
      } else {
        bfdStatusBuilder_.mergeFrom(value);
      }
      if (bfdStatus_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /** <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code> */
    public Builder clearBfdStatus() {
      bitField0_ = (bitField0_ & ~0x00000002);
      bfdStatus_ = null;
      if (bfdStatusBuilder_ != null) {
        bfdStatusBuilder_.dispose();
        bfdStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /** <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code> */
    public com.google.cloud.compute.v1.BfdStatus.Builder getBfdStatusBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getBfdStatusFieldBuilder().getBuilder();
    }

    /** <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code> */
    public com.google.cloud.compute.v1.BfdStatusOrBuilder getBfdStatusOrBuilder() {
      if (bfdStatusBuilder_ != null) {
        return bfdStatusBuilder_.getMessageOrBuilder();
      } else {
        return bfdStatus_ == null
            ? com.google.cloud.compute.v1.BfdStatus.getDefaultInstance()
            : bfdStatus_;
      }
    }

    /** <code>optional .google.cloud.compute.v1.BfdStatus bfd_status = 395631729;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BfdStatus,
            com.google.cloud.compute.v1.BfdStatus.Builder,
            com.google.cloud.compute.v1.BfdStatusOrBuilder>
        getBfdStatusFieldBuilder() {
      if (bfdStatusBuilder_ == null) {
        bfdStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BfdStatus,
                com.google.cloud.compute.v1.BfdStatus.Builder,
                com.google.cloud.compute.v1.BfdStatusOrBuilder>(
                getBfdStatus(), getParentForChildren(), isClean());
        bfdStatus_ = null;
      }
      return bfdStatusBuilder_;
    }

    private boolean enableIpv4_;

    /**
     *
     *
     * <pre>
     * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
     * </pre>
     *
     * <code>optional bool enable_ipv4 = 181467937;</code>
     *
     * @return Whether the enableIpv4 field is set.
     */
    @java.lang.Override
    public boolean hasEnableIpv4() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
     * </pre>
     *
     * <code>optional bool enable_ipv4 = 181467937;</code>
     *
     * @return The enableIpv4.
     */
    @java.lang.Override
    public boolean getEnableIpv4() {
      return enableIpv4_;
    }

    /**
     *
     *
     * <pre>
     * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
     * </pre>
     *
     * <code>optional bool enable_ipv4 = 181467937;</code>
     *
     * @param value The enableIpv4 to set.
     * @return This builder for chaining.
     */
    public Builder setEnableIpv4(boolean value) {

      enableIpv4_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
     * </pre>
     *
     * <code>optional bool enable_ipv4 = 181467937;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableIpv4() {
      bitField0_ = (bitField0_ & ~0x00000004);
      enableIpv4_ = false;
      onChanged();
      return this;
    }

    private boolean enableIpv6_;

    /**
     *
     *
     * <pre>
     * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
     * </pre>
     *
     * <code>optional bool enable_ipv6 = 181467939;</code>
     *
     * @return Whether the enableIpv6 field is set.
     */
    @java.lang.Override
    public boolean hasEnableIpv6() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
     * </pre>
     *
     * <code>optional bool enable_ipv6 = 181467939;</code>
     *
     * @return The enableIpv6.
     */
    @java.lang.Override
    public boolean getEnableIpv6() {
      return enableIpv6_;
    }

    /**
     *
     *
     * <pre>
     * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
     * </pre>
     *
     * <code>optional bool enable_ipv6 = 181467939;</code>
     *
     * @param value The enableIpv6 to set.
     * @return This builder for chaining.
     */
    public Builder setEnableIpv6(boolean value) {

      enableIpv6_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
     * </pre>
     *
     * <code>optional bool enable_ipv6 = 181467939;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableIpv6() {
      bitField0_ = (bitField0_ & ~0x00000008);
      enableIpv6_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object ipAddress_ = "";

    /**
     *
     *
     * <pre>
     * IP address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return Whether the ipAddress field is set.
     */
    public boolean hasIpAddress() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * IP address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return The ipAddress.
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IP address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return The bytes for ipAddress.
     */
    public com.google.protobuf.ByteString getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IP address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @param value The ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipAddress_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IP address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpAddress() {
      ipAddress_ = getDefaultInstance().getIpAddress();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IP address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @param value The bytes for ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipAddress_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object ipv4NexthopAddress_ = "";

    /**
     *
     *
     * <pre>
     * IPv4 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @return Whether the ipv4NexthopAddress field is set.
     */
    public boolean hasIpv4NexthopAddress() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @return The ipv4NexthopAddress.
     */
    public java.lang.String getIpv4NexthopAddress() {
      java.lang.Object ref = ipv4NexthopAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipv4NexthopAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @return The bytes for ipv4NexthopAddress.
     */
    public com.google.protobuf.ByteString getIpv4NexthopAddressBytes() {
      java.lang.Object ref = ipv4NexthopAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipv4NexthopAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @param value The ipv4NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpv4NexthopAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipv4NexthopAddress_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpv4NexthopAddress() {
      ipv4NexthopAddress_ = getDefaultInstance().getIpv4NexthopAddress();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @param value The bytes for ipv4NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpv4NexthopAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipv4NexthopAddress_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object ipv6NexthopAddress_ = "";

    /**
     *
     *
     * <pre>
     * IPv6 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @return Whether the ipv6NexthopAddress field is set.
     */
    public boolean hasIpv6NexthopAddress() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @return The ipv6NexthopAddress.
     */
    public java.lang.String getIpv6NexthopAddress() {
      java.lang.Object ref = ipv6NexthopAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipv6NexthopAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @return The bytes for ipv6NexthopAddress.
     */
    public com.google.protobuf.ByteString getIpv6NexthopAddressBytes() {
      java.lang.Object ref = ipv6NexthopAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipv6NexthopAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @param value The ipv6NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpv6NexthopAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipv6NexthopAddress_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpv6NexthopAddress() {
      ipv6NexthopAddress_ = getDefaultInstance().getIpv6NexthopAddress();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the local BGP interface.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @param value The bytes for ipv6NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpv6NexthopAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipv6NexthopAddress_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object linkedVpnTunnel_ = "";

    /**
     *
     *
     * <pre>
     * URL of the VPN tunnel that this BGP peer controls.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @return Whether the linkedVpnTunnel field is set.
     */
    public boolean hasLinkedVpnTunnel() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * URL of the VPN tunnel that this BGP peer controls.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @return The linkedVpnTunnel.
     */
    public java.lang.String getLinkedVpnTunnel() {
      java.lang.Object ref = linkedVpnTunnel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        linkedVpnTunnel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the VPN tunnel that this BGP peer controls.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @return The bytes for linkedVpnTunnel.
     */
    public com.google.protobuf.ByteString getLinkedVpnTunnelBytes() {
      java.lang.Object ref = linkedVpnTunnel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        linkedVpnTunnel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the VPN tunnel that this BGP peer controls.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @param value The linkedVpnTunnel to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedVpnTunnel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      linkedVpnTunnel_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the VPN tunnel that this BGP peer controls.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinkedVpnTunnel() {
      linkedVpnTunnel_ = getDefaultInstance().getLinkedVpnTunnel();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the VPN tunnel that this BGP peer controls.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @param value The bytes for linkedVpnTunnel to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedVpnTunnelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      linkedVpnTunnel_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private boolean md5AuthEnabled_;

    /**
     *
     *
     * <pre>
     * Informs whether MD5 authentication is enabled on this BGP peer.
     * </pre>
     *
     * <code>optional bool md5_auth_enabled = 451152075;</code>
     *
     * @return Whether the md5AuthEnabled field is set.
     */
    @java.lang.Override
    public boolean hasMd5AuthEnabled() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Informs whether MD5 authentication is enabled on this BGP peer.
     * </pre>
     *
     * <code>optional bool md5_auth_enabled = 451152075;</code>
     *
     * @return The md5AuthEnabled.
     */
    @java.lang.Override
    public boolean getMd5AuthEnabled() {
      return md5AuthEnabled_;
    }

    /**
     *
     *
     * <pre>
     * Informs whether MD5 authentication is enabled on this BGP peer.
     * </pre>
     *
     * <code>optional bool md5_auth_enabled = 451152075;</code>
     *
     * @param value The md5AuthEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setMd5AuthEnabled(boolean value) {

      md5AuthEnabled_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Informs whether MD5 authentication is enabled on this BGP peer.
     * </pre>
     *
     * <code>optional bool md5_auth_enabled = 451152075;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMd5AuthEnabled() {
      bitField0_ = (bitField0_ & ~0x00000100);
      md5AuthEnabled_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. Unique within the Routers resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. Unique within the Routers resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. Unique within the Routers resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. Unique within the Routers resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. Unique within the Routers resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. Unique within the Routers resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private int numLearnedRoutes_;

    /**
     *
     *
     * <pre>
     * Number of routes learned from the remote BGP Peer.
     * </pre>
     *
     * <code>optional uint32 num_learned_routes = 135457535;</code>
     *
     * @return Whether the numLearnedRoutes field is set.
     */
    @java.lang.Override
    public boolean hasNumLearnedRoutes() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Number of routes learned from the remote BGP Peer.
     * </pre>
     *
     * <code>optional uint32 num_learned_routes = 135457535;</code>
     *
     * @return The numLearnedRoutes.
     */
    @java.lang.Override
    public int getNumLearnedRoutes() {
      return numLearnedRoutes_;
    }

    /**
     *
     *
     * <pre>
     * Number of routes learned from the remote BGP Peer.
     * </pre>
     *
     * <code>optional uint32 num_learned_routes = 135457535;</code>
     *
     * @param value The numLearnedRoutes to set.
     * @return This builder for chaining.
     */
    public Builder setNumLearnedRoutes(int value) {

      numLearnedRoutes_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Number of routes learned from the remote BGP Peer.
     * </pre>
     *
     * <code>optional uint32 num_learned_routes = 135457535;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumLearnedRoutes() {
      bitField0_ = (bitField0_ & ~0x00000400);
      numLearnedRoutes_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object peerIpAddress_ = "";

    /**
     *
     *
     * <pre>
     * IP address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return Whether the peerIpAddress field is set.
     */
    public boolean hasPeerIpAddress() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * IP address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return The peerIpAddress.
     */
    public java.lang.String getPeerIpAddress() {
      java.lang.Object ref = peerIpAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerIpAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IP address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return The bytes for peerIpAddress.
     */
    public com.google.protobuf.ByteString getPeerIpAddressBytes() {
      java.lang.Object ref = peerIpAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerIpAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IP address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @param value The peerIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerIpAddress_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IP address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerIpAddress() {
      peerIpAddress_ = getDefaultInstance().getPeerIpAddress();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IP address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @param value The bytes for peerIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerIpAddress_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object peerIpv4NexthopAddress_ = "";

    /**
     *
     *
     * <pre>
     * IPv4 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @return Whether the peerIpv4NexthopAddress field is set.
     */
    public boolean hasPeerIpv4NexthopAddress() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @return The peerIpv4NexthopAddress.
     */
    public java.lang.String getPeerIpv4NexthopAddress() {
      java.lang.Object ref = peerIpv4NexthopAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerIpv4NexthopAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @return The bytes for peerIpv4NexthopAddress.
     */
    public com.google.protobuf.ByteString getPeerIpv4NexthopAddressBytes() {
      java.lang.Object ref = peerIpv4NexthopAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerIpv4NexthopAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @param value The peerIpv4NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpv4NexthopAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerIpv4NexthopAddress_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerIpv4NexthopAddress() {
      peerIpv4NexthopAddress_ = getDefaultInstance().getPeerIpv4NexthopAddress();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @param value The bytes for peerIpv4NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpv4NexthopAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerIpv4NexthopAddress_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object peerIpv6NexthopAddress_ = "";

    /**
     *
     *
     * <pre>
     * IPv6 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @return Whether the peerIpv6NexthopAddress field is set.
     */
    public boolean hasPeerIpv6NexthopAddress() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @return The peerIpv6NexthopAddress.
     */
    public java.lang.String getPeerIpv6NexthopAddress() {
      java.lang.Object ref = peerIpv6NexthopAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerIpv6NexthopAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @return The bytes for peerIpv6NexthopAddress.
     */
    public com.google.protobuf.ByteString getPeerIpv6NexthopAddressBytes() {
      java.lang.Object ref = peerIpv6NexthopAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerIpv6NexthopAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @param value The peerIpv6NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpv6NexthopAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerIpv6NexthopAddress_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerIpv6NexthopAddress() {
      peerIpv6NexthopAddress_ = getDefaultInstance().getPeerIpv6NexthopAddress();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the remote BGP interface.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @param value The bytes for peerIpv6NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpv6NexthopAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerIpv6NexthopAddress_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object routerApplianceInstance_ = "";

    /**
     *
     *
     * <pre>
     * [Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @return Whether the routerApplianceInstance field is set.
     */
    public boolean hasRouterApplianceInstance() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @return The routerApplianceInstance.
     */
    public java.lang.String getRouterApplianceInstance() {
      java.lang.Object ref = routerApplianceInstance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        routerApplianceInstance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @return The bytes for routerApplianceInstance.
     */
    public com.google.protobuf.ByteString getRouterApplianceInstanceBytes() {
      java.lang.Object ref = routerApplianceInstance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        routerApplianceInstance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @param value The routerApplianceInstance to set.
     * @return This builder for chaining.
     */
    public Builder setRouterApplianceInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      routerApplianceInstance_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouterApplianceInstance() {
      routerApplianceInstance_ = getDefaultInstance().getRouterApplianceInstance();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @param value The bytes for routerApplianceInstance to set.
     * @return This builder for chaining.
     */
    public Builder setRouterApplianceInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      routerApplianceInstance_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object state_ = "";

    /**
     *
     *
     * <pre>
     * The state of the BGP session. For a list of possible values for this field, see BGP session states.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return Whether the state field is set.
     */
    public boolean hasState() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The state of the BGP session. For a list of possible values for this field, see BGP session states.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The state.
     */
    public java.lang.String getState() {
      java.lang.Object ref = state_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        state_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The state of the BGP session. For a list of possible values for this field, see BGP session states.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The bytes for state.
     */
    public com.google.protobuf.ByteString getStateBytes() {
      java.lang.Object ref = state_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        state_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The state of the BGP session. For a list of possible values for this field, see BGP session states.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      state_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The state of the BGP session. For a list of possible values for this field, see BGP session states.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      state_ = getDefaultInstance().getState();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The state of the BGP session. For a list of possible values for this field, see BGP session states.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The bytes for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      state_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * Status of the BGP peer: {UP, DOWN}
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Status of the BGP peer: {UP, DOWN}
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Status of the BGP peer: {UP, DOWN}
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Status of the BGP peer: {UP, DOWN}
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Status of the BGP peer: {UP, DOWN}
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Status of the BGP peer: {UP, DOWN}
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object statusReason_ = "";

    /**
     *
     *
     * <pre>
     * Indicates why particular status was returned.
     * Check the StatusReason enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status_reason = 342706993;</code>
     *
     * @return Whether the statusReason field is set.
     */
    public boolean hasStatusReason() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates why particular status was returned.
     * Check the StatusReason enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status_reason = 342706993;</code>
     *
     * @return The statusReason.
     */
    public java.lang.String getStatusReason() {
      java.lang.Object ref = statusReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates why particular status was returned.
     * Check the StatusReason enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status_reason = 342706993;</code>
     *
     * @return The bytes for statusReason.
     */
    public com.google.protobuf.ByteString getStatusReasonBytes() {
      java.lang.Object ref = statusReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates why particular status was returned.
     * Check the StatusReason enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status_reason = 342706993;</code>
     *
     * @param value The statusReason to set.
     * @return This builder for chaining.
     */
    public Builder setStatusReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusReason_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates why particular status was returned.
     * Check the StatusReason enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status_reason = 342706993;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusReason() {
      statusReason_ = getDefaultInstance().getStatusReason();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates why particular status was returned.
     * Check the StatusReason enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status_reason = 342706993;</code>
     *
     * @param value The bytes for statusReason to set.
     * @return This builder for chaining.
     */
    public Builder setStatusReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusReason_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object uptime_ = "";

    /**
     *
     *
     * <pre>
     * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
     * </pre>
     *
     * <code>optional string uptime = 235379688;</code>
     *
     * @return Whether the uptime field is set.
     */
    public boolean hasUptime() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
     * </pre>
     *
     * <code>optional string uptime = 235379688;</code>
     *
     * @return The uptime.
     */
    public java.lang.String getUptime() {
      java.lang.Object ref = uptime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uptime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
     * </pre>
     *
     * <code>optional string uptime = 235379688;</code>
     *
     * @return The bytes for uptime.
     */
    public com.google.protobuf.ByteString getUptimeBytes() {
      java.lang.Object ref = uptime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uptime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
     * </pre>
     *
     * <code>optional string uptime = 235379688;</code>
     *
     * @param value The uptime to set.
     * @return This builder for chaining.
     */
    public Builder setUptime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uptime_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
     * </pre>
     *
     * <code>optional string uptime = 235379688;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUptime() {
      uptime_ = getDefaultInstance().getUptime();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time this session has been up. Format: 14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
     * </pre>
     *
     * <code>optional string uptime = 235379688;</code>
     *
     * @param value The bytes for uptime to set.
     * @return This builder for chaining.
     */
    public Builder setUptimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uptime_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private java.lang.Object uptimeSeconds_ = "";

    /**
     *
     *
     * <pre>
     * Time this session has been up, in seconds. Format: 145
     * </pre>
     *
     * <code>optional string uptime_seconds = 104736040;</code>
     *
     * @return Whether the uptimeSeconds field is set.
     */
    public boolean hasUptimeSeconds() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Time this session has been up, in seconds. Format: 145
     * </pre>
     *
     * <code>optional string uptime_seconds = 104736040;</code>
     *
     * @return The uptimeSeconds.
     */
    public java.lang.String getUptimeSeconds() {
      java.lang.Object ref = uptimeSeconds_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uptimeSeconds_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Time this session has been up, in seconds. Format: 145
     * </pre>
     *
     * <code>optional string uptime_seconds = 104736040;</code>
     *
     * @return The bytes for uptimeSeconds.
     */
    public com.google.protobuf.ByteString getUptimeSecondsBytes() {
      java.lang.Object ref = uptimeSeconds_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uptimeSeconds_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Time this session has been up, in seconds. Format: 145
     * </pre>
     *
     * <code>optional string uptime_seconds = 104736040;</code>
     *
     * @param value The uptimeSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setUptimeSeconds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uptimeSeconds_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time this session has been up, in seconds. Format: 145
     * </pre>
     *
     * <code>optional string uptime_seconds = 104736040;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUptimeSeconds() {
      uptimeSeconds_ = getDefaultInstance().getUptimeSeconds();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time this session has been up, in seconds. Format: 145
     * </pre>
     *
     * <code>optional string uptime_seconds = 104736040;</code>
     *
     * @param value The bytes for uptimeSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setUptimeSecondsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uptimeSeconds_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterStatusBgpPeerStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterStatusBgpPeerStatus)
  private static final com.google.cloud.compute.v1.RouterStatusBgpPeerStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterStatusBgpPeerStatus();
  }

  public static com.google.cloud.compute.v1.RouterStatusBgpPeerStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterStatusBgpPeerStatus> PARSER =
      new com.google.protobuf.AbstractParser<RouterStatusBgpPeerStatus>() {
        @java.lang.Override
        public RouterStatusBgpPeerStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterStatusBgpPeerStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterStatusBgpPeerStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterStatusBgpPeerStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
