/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * An InstanceSchedulePolicy specifies when and how frequent certain operations are performed on the instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy}
 */
public final class ResourcePolicyInstanceSchedulePolicy
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy)
    ResourcePolicyInstanceSchedulePolicyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ResourcePolicyInstanceSchedulePolicy.newBuilder() to construct.
  private ResourcePolicyInstanceSchedulePolicy(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourcePolicyInstanceSchedulePolicy() {
    expirationTime_ = "";
    startTime_ = "";
    timeZone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourcePolicyInstanceSchedulePolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourcePolicyInstanceSchedulePolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourcePolicyInstanceSchedulePolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.class,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.Builder.class);
  }

  private int bitField0_;
  public static final int EXPIRATION_TIME_FIELD_NUMBER = 230299229;

  @SuppressWarnings("serial")
  private volatile java.lang.Object expirationTime_ = "";

  /**
   *
   *
   * <pre>
   * The expiration time of the schedule. The timestamp is an RFC3339 string.
   * </pre>
   *
   * <code>optional string expiration_time = 230299229;</code>
   *
   * @return Whether the expirationTime field is set.
   */
  @java.lang.Override
  public boolean hasExpirationTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The expiration time of the schedule. The timestamp is an RFC3339 string.
   * </pre>
   *
   * <code>optional string expiration_time = 230299229;</code>
   *
   * @return The expirationTime.
   */
  @java.lang.Override
  public java.lang.String getExpirationTime() {
    java.lang.Object ref = expirationTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      expirationTime_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The expiration time of the schedule. The timestamp is an RFC3339 string.
   * </pre>
   *
   * <code>optional string expiration_time = 230299229;</code>
   *
   * @return The bytes for expirationTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExpirationTimeBytes() {
    java.lang.Object ref = expirationTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      expirationTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 37467274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object startTime_ = "";

  /**
   *
   *
   * <pre>
   * The start time of the schedule. The timestamp is an RFC3339 string.
   * </pre>
   *
   * <code>optional string start_time = 37467274;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The start time of the schedule. The timestamp is an RFC3339 string.
   * </pre>
   *
   * <code>optional string start_time = 37467274;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public java.lang.String getStartTime() {
    java.lang.Object ref = startTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startTime_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The start time of the schedule. The timestamp is an RFC3339 string.
   * </pre>
   *
   * <code>optional string start_time = 37467274;</code>
   *
   * @return The bytes for startTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStartTimeBytes() {
    java.lang.Object ref = startTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      startTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 36848094;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";

  /**
   *
   *
   * <pre>
   * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
   * </pre>
   *
   * <code>optional string time_zone = 36848094;</code>
   *
   * @return Whether the timeZone field is set.
   */
  @java.lang.Override
  public boolean hasTimeZone() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
   * </pre>
   *
   * <code>optional string time_zone = 36848094;</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
   * </pre>
   *
   * <code>optional string time_zone = 36848094;</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VM_START_SCHEDULE_FIELD_NUMBER = 17762396;
  private com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vmStartSchedule_;

  /**
   *
   *
   * <pre>
   * Specifies the schedule for starting instances.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
   * </code>
   *
   * @return Whether the vmStartSchedule field is set.
   */
  @java.lang.Override
  public boolean hasVmStartSchedule() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the schedule for starting instances.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
   * </code>
   *
   * @return The vmStartSchedule.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
      getVmStartSchedule() {
    return vmStartSchedule_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
            .getDefaultInstance()
        : vmStartSchedule_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the schedule for starting instances.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyScheduleOrBuilder
      getVmStartScheduleOrBuilder() {
    return vmStartSchedule_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
            .getDefaultInstance()
        : vmStartSchedule_;
  }

  public static final int VM_STOP_SCHEDULE_FIELD_NUMBER = 426242732;
  private com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vmStopSchedule_;

  /**
   *
   *
   * <pre>
   * Specifies the schedule for stopping instances.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
   * </code>
   *
   * @return Whether the vmStopSchedule field is set.
   */
  @java.lang.Override
  public boolean hasVmStopSchedule() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the schedule for stopping instances.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
   * </code>
   *
   * @return The vmStopSchedule.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
      getVmStopSchedule() {
    return vmStopSchedule_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
            .getDefaultInstance()
        : vmStopSchedule_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the schedule for stopping instances.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyScheduleOrBuilder
      getVmStopScheduleOrBuilder() {
    return vmStopSchedule_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
            .getDefaultInstance()
        : vmStopSchedule_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(17762396, getVmStartSchedule());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 36848094, timeZone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 37467274, startTime_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 230299229, expirationTime_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(426242732, getVmStopSchedule());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(17762396, getVmStartSchedule());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(36848094, timeZone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(37467274, startTime_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(230299229, expirationTime_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(426242732, getVmStopSchedule());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy other =
        (com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy) obj;

    if (hasExpirationTime() != other.hasExpirationTime()) return false;
    if (hasExpirationTime()) {
      if (!getExpirationTime().equals(other.getExpirationTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasTimeZone() != other.hasTimeZone()) return false;
    if (hasTimeZone()) {
      if (!getTimeZone().equals(other.getTimeZone())) return false;
    }
    if (hasVmStartSchedule() != other.hasVmStartSchedule()) return false;
    if (hasVmStartSchedule()) {
      if (!getVmStartSchedule().equals(other.getVmStartSchedule())) return false;
    }
    if (hasVmStopSchedule() != other.hasVmStopSchedule()) return false;
    if (hasVmStopSchedule()) {
      if (!getVmStopSchedule().equals(other.getVmStopSchedule())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasExpirationTime()) {
      hash = (37 * hash) + EXPIRATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpirationTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasTimeZone()) {
      hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getTimeZone().hashCode();
    }
    if (hasVmStartSchedule()) {
      hash = (37 * hash) + VM_START_SCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + getVmStartSchedule().hashCode();
    }
    if (hasVmStopSchedule()) {
      hash = (37 * hash) + VM_STOP_SCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + getVmStopSchedule().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An InstanceSchedulePolicy specifies when and how frequent certain operations are performed on the instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy)
      com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicyInstanceSchedulePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicyInstanceSchedulePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.class,
              com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVmStartScheduleFieldBuilder();
        getVmStopScheduleFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      expirationTime_ = "";
      startTime_ = "";
      timeZone_ = "";
      vmStartSchedule_ = null;
      if (vmStartScheduleBuilder_ != null) {
        vmStartScheduleBuilder_.dispose();
        vmStartScheduleBuilder_ = null;
      }
      vmStopSchedule_ = null;
      if (vmStopScheduleBuilder_ != null) {
        vmStopScheduleBuilder_.dispose();
        vmStopScheduleBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicyInstanceSchedulePolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy build() {
      com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy buildPartial() {
      com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy result =
          new com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.expirationTime_ = expirationTime_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.startTime_ = startTime_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.timeZone_ = timeZone_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.vmStartSchedule_ =
            vmStartScheduleBuilder_ == null ? vmStartSchedule_ : vmStartScheduleBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.vmStopSchedule_ =
            vmStopScheduleBuilder_ == null ? vmStopSchedule_ : vmStopScheduleBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy) {
        return mergeFrom((com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy other) {
      if (other
          == com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.getDefaultInstance())
        return this;
      if (other.hasExpirationTime()) {
        expirationTime_ = other.expirationTime_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasStartTime()) {
        startTime_ = other.startTime_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasTimeZone()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasVmStartSchedule()) {
        mergeVmStartSchedule(other.getVmStartSchedule());
      }
      if (other.hasVmStopSchedule()) {
        mergeVmStopSchedule(other.getVmStopSchedule());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 142099170:
              {
                input.readMessage(getVmStartScheduleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 142099170
            case 294784754:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 294784754
            case 299738194:
              {
                startTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 299738194
            case 1842393834:
              {
                expirationTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1842393834
            case -885025438:
              {
                input.readMessage(getVmStopScheduleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case -885025438
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object expirationTime_ = "";

    /**
     *
     *
     * <pre>
     * The expiration time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string expiration_time = 230299229;</code>
     *
     * @return Whether the expirationTime field is set.
     */
    public boolean hasExpirationTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The expiration time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string expiration_time = 230299229;</code>
     *
     * @return The expirationTime.
     */
    public java.lang.String getExpirationTime() {
      java.lang.Object ref = expirationTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        expirationTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The expiration time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string expiration_time = 230299229;</code>
     *
     * @return The bytes for expirationTime.
     */
    public com.google.protobuf.ByteString getExpirationTimeBytes() {
      java.lang.Object ref = expirationTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        expirationTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The expiration time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string expiration_time = 230299229;</code>
     *
     * @param value The expirationTime to set.
     * @return This builder for chaining.
     */
    public Builder setExpirationTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      expirationTime_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The expiration time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string expiration_time = 230299229;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpirationTime() {
      expirationTime_ = getDefaultInstance().getExpirationTime();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The expiration time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string expiration_time = 230299229;</code>
     *
     * @param value The bytes for expirationTime to set.
     * @return This builder for chaining.
     */
    public Builder setExpirationTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      expirationTime_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object startTime_ = "";

    /**
     *
     *
     * <pre>
     * The start time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The start time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @return The startTime.
     */
    public java.lang.String getStartTime() {
      java.lang.Object ref = startTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The start time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @return The bytes for startTime.
     */
    public com.google.protobuf.ByteString getStartTimeBytes() {
      java.lang.Object ref = startTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        startTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The start time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @param value The startTime to set.
     * @return This builder for chaining.
     */
    public Builder setStartTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      startTime_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The start time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartTime() {
      startTime_ = getDefaultInstance().getStartTime();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The start time of the schedule. The timestamp is an RFC3339 string.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @param value The bytes for startTime to set.
     * @return This builder for chaining.
     */
    public Builder setStartTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      startTime_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";

    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @return Whether the timeZone field is set.
     */
    public boolean hasTimeZone() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
        vmStartSchedule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule.Builder,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyScheduleOrBuilder>
        vmStartScheduleBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies the schedule for starting instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
     * </code>
     *
     * @return Whether the vmStartSchedule field is set.
     */
    public boolean hasVmStartSchedule() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for starting instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
     * </code>
     *
     * @return The vmStartSchedule.
     */
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
        getVmStartSchedule() {
      if (vmStartScheduleBuilder_ == null) {
        return vmStartSchedule_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
                .getDefaultInstance()
            : vmStartSchedule_;
      } else {
        return vmStartScheduleBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for starting instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
     * </code>
     */
    public Builder setVmStartSchedule(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule value) {
      if (vmStartScheduleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vmStartSchedule_ = value;
      } else {
        vmStartScheduleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for starting instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
     * </code>
     */
    public Builder setVmStartSchedule(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule.Builder
            builderForValue) {
      if (vmStartScheduleBuilder_ == null) {
        vmStartSchedule_ = builderForValue.build();
      } else {
        vmStartScheduleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for starting instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
     * </code>
     */
    public Builder mergeVmStartSchedule(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule value) {
      if (vmStartScheduleBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && vmStartSchedule_ != null
            && vmStartSchedule_
                != com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
                    .getDefaultInstance()) {
          getVmStartScheduleBuilder().mergeFrom(value);
        } else {
          vmStartSchedule_ = value;
        }
      } else {
        vmStartScheduleBuilder_.mergeFrom(value);
      }
      if (vmStartSchedule_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for starting instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
     * </code>
     */
    public Builder clearVmStartSchedule() {
      bitField0_ = (bitField0_ & ~0x00000008);
      vmStartSchedule_ = null;
      if (vmStartScheduleBuilder_ != null) {
        vmStartScheduleBuilder_.dispose();
        vmStartScheduleBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for starting instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule.Builder
        getVmStartScheduleBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getVmStartScheduleFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for starting instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyScheduleOrBuilder
        getVmStartScheduleOrBuilder() {
      if (vmStartScheduleBuilder_ != null) {
        return vmStartScheduleBuilder_.getMessageOrBuilder();
      } else {
        return vmStartSchedule_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
                .getDefaultInstance()
            : vmStartSchedule_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for starting instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_start_schedule = 17762396;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule.Builder,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyScheduleOrBuilder>
        getVmStartScheduleFieldBuilder() {
      if (vmStartScheduleBuilder_ == null) {
        vmStartScheduleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule,
                com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule.Builder,
                com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyScheduleOrBuilder>(
                getVmStartSchedule(), getParentForChildren(), isClean());
        vmStartSchedule_ = null;
      }
      return vmStartScheduleBuilder_;
    }

    private com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
        vmStopSchedule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule.Builder,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyScheduleOrBuilder>
        vmStopScheduleBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies the schedule for stopping instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
     * </code>
     *
     * @return Whether the vmStopSchedule field is set.
     */
    public boolean hasVmStopSchedule() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for stopping instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
     * </code>
     *
     * @return The vmStopSchedule.
     */
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
        getVmStopSchedule() {
      if (vmStopScheduleBuilder_ == null) {
        return vmStopSchedule_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
                .getDefaultInstance()
            : vmStopSchedule_;
      } else {
        return vmStopScheduleBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for stopping instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
     * </code>
     */
    public Builder setVmStopSchedule(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule value) {
      if (vmStopScheduleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vmStopSchedule_ = value;
      } else {
        vmStopScheduleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for stopping instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
     * </code>
     */
    public Builder setVmStopSchedule(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule.Builder
            builderForValue) {
      if (vmStopScheduleBuilder_ == null) {
        vmStopSchedule_ = builderForValue.build();
      } else {
        vmStopScheduleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for stopping instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
     * </code>
     */
    public Builder mergeVmStopSchedule(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule value) {
      if (vmStopScheduleBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && vmStopSchedule_ != null
            && vmStopSchedule_
                != com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
                    .getDefaultInstance()) {
          getVmStopScheduleBuilder().mergeFrom(value);
        } else {
          vmStopSchedule_ = value;
        }
      } else {
        vmStopScheduleBuilder_.mergeFrom(value);
      }
      if (vmStopSchedule_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for stopping instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
     * </code>
     */
    public Builder clearVmStopSchedule() {
      bitField0_ = (bitField0_ & ~0x00000010);
      vmStopSchedule_ = null;
      if (vmStopScheduleBuilder_ != null) {
        vmStopScheduleBuilder_.dispose();
        vmStopScheduleBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for stopping instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule.Builder
        getVmStopScheduleBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getVmStopScheduleFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for stopping instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyScheduleOrBuilder
        getVmStopScheduleOrBuilder() {
      if (vmStopScheduleBuilder_ != null) {
        return vmStopScheduleBuilder_.getMessageOrBuilder();
      } else {
        return vmStopSchedule_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule
                .getDefaultInstance()
            : vmStopSchedule_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the schedule for stopping instances.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule vm_stop_schedule = 426242732;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule.Builder,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyScheduleOrBuilder>
        getVmStopScheduleFieldBuilder() {
      if (vmStopScheduleBuilder_ == null) {
        vmStopScheduleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule,
                com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicySchedule.Builder,
                com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyScheduleOrBuilder>(
                getVmStopSchedule(), getParentForChildren(), isClean());
        vmStopSchedule_ = null;
      }
      return vmStopScheduleBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy)
  private static final com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy();
  }

  public static com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourcePolicyInstanceSchedulePolicy> PARSER =
      new com.google.protobuf.AbstractParser<ResourcePolicyInstanceSchedulePolicy>() {
        @java.lang.Override
        public ResourcePolicyInstanceSchedulePolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResourcePolicyInstanceSchedulePolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourcePolicyInstanceSchedulePolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
