/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A routing configuration attached to a network resource. The message includes the list of routers associated with the network, and a flag indicating the type of routing behavior to enforce network-wide.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.NetworkRoutingConfig}
 */
public final class NetworkRoutingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.NetworkRoutingConfig)
    NetworkRoutingConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use NetworkRoutingConfig.newBuilder() to construct.
  private NetworkRoutingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkRoutingConfig() {
    bgpBestPathSelectionMode_ = "";
    bgpInterRegionCost_ = "";
    effectiveBgpInterRegionCost_ = "";
    routingMode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkRoutingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkRoutingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkRoutingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.NetworkRoutingConfig.class,
            com.google.cloud.compute.v1.NetworkRoutingConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NetworkRoutingConfig.BgpBestPathSelectionMode}
   */
  public enum BgpBestPathSelectionMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BGP_BEST_PATH_SELECTION_MODE = 0;</code>
     */
    UNDEFINED_BGP_BEST_PATH_SELECTION_MODE(0),
    /** <code>LEGACY = 94234569;</code> */
    LEGACY(94234569),
    /** <code>STANDARD = 484642493;</code> */
    STANDARD(484642493),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BGP_BEST_PATH_SELECTION_MODE = 0;</code>
     */
    public static final int UNDEFINED_BGP_BEST_PATH_SELECTION_MODE_VALUE = 0;

    /** <code>LEGACY = 94234569;</code> */
    public static final int LEGACY_VALUE = 94234569;

    /** <code>STANDARD = 484642493;</code> */
    public static final int STANDARD_VALUE = 484642493;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BgpBestPathSelectionMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BgpBestPathSelectionMode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BGP_BEST_PATH_SELECTION_MODE;
        case 94234569:
          return LEGACY;
        case 484642493:
          return STANDARD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BgpBestPathSelectionMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BgpBestPathSelectionMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<BgpBestPathSelectionMode>() {
              public BgpBestPathSelectionMode findValueByNumber(int number) {
                return BgpBestPathSelectionMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NetworkRoutingConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final BgpBestPathSelectionMode[] VALUES = values();

    public static BgpBestPathSelectionMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BgpBestPathSelectionMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NetworkRoutingConfig.BgpBestPathSelectionMode)
  }

  /**
   *
   *
   * <pre>
   * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
   * Additional supported values which may be not listed in the enum directly due to technical reasons:
   * ADD_COST_TO_MED
   * DEFAULT
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NetworkRoutingConfig.BgpInterRegionCost}
   */
  public enum BgpInterRegionCost implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BGP_INTER_REGION_COST = 0;</code>
     */
    UNDEFINED_BGP_INTER_REGION_COST(0),
    /** <code>ADD_COST_TO_MED = 490583004;</code> */
    ADD_COST_TO_MED(490583004),
    /** <code>DEFAULT = 115302945;</code> */
    DEFAULT(115302945),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BGP_INTER_REGION_COST = 0;</code>
     */
    public static final int UNDEFINED_BGP_INTER_REGION_COST_VALUE = 0;

    /** <code>ADD_COST_TO_MED = 490583004;</code> */
    public static final int ADD_COST_TO_MED_VALUE = 490583004;

    /** <code>DEFAULT = 115302945;</code> */
    public static final int DEFAULT_VALUE = 115302945;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BgpInterRegionCost valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BgpInterRegionCost forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BGP_INTER_REGION_COST;
        case 490583004:
          return ADD_COST_TO_MED;
        case 115302945:
          return DEFAULT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BgpInterRegionCost>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BgpInterRegionCost>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<BgpInterRegionCost>() {
              public BgpInterRegionCost findValueByNumber(int number) {
                return BgpInterRegionCost.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NetworkRoutingConfig.getDescriptor().getEnumTypes().get(1);
    }

    private static final BgpInterRegionCost[] VALUES = values();

    public static BgpInterRegionCost valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BgpInterRegionCost(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NetworkRoutingConfig.BgpInterRegionCost)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Effective value of the bgp_inter_region_cost field.
   * Additional supported values which may be not listed in the enum directly due to technical reasons:
   * ADD_COST_TO_MED
   * DEFAULT
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NetworkRoutingConfig.EffectiveBgpInterRegionCost}
   */
  public enum EffectiveBgpInterRegionCost implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_EFFECTIVE_BGP_INTER_REGION_COST = 0;</code>
     */
    UNDEFINED_EFFECTIVE_BGP_INTER_REGION_COST(0),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_EFFECTIVE_BGP_INTER_REGION_COST = 0;</code>
     */
    public static final int UNDEFINED_EFFECTIVE_BGP_INTER_REGION_COST_VALUE = 0;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EffectiveBgpInterRegionCost valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EffectiveBgpInterRegionCost forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_EFFECTIVE_BGP_INTER_REGION_COST;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EffectiveBgpInterRegionCost>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EffectiveBgpInterRegionCost>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EffectiveBgpInterRegionCost>() {
              public EffectiveBgpInterRegionCost findValueByNumber(int number) {
                return EffectiveBgpInterRegionCost.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NetworkRoutingConfig.getDescriptor().getEnumTypes().get(2);
    }

    private static final EffectiveBgpInterRegionCost[] VALUES = values();

    public static EffectiveBgpInterRegionCost valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EffectiveBgpInterRegionCost(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NetworkRoutingConfig.EffectiveBgpInterRegionCost)
  }

  /**
   *
   *
   * <pre>
   * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NetworkRoutingConfig.RoutingMode}
   */
  public enum RoutingMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ROUTING_MODE = 0;</code>
     */
    UNDEFINED_ROUTING_MODE(0),
    /** <code>GLOBAL = 494663587;</code> */
    GLOBAL(494663587),
    /** <code>REGIONAL = 92288543;</code> */
    REGIONAL(92288543),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ROUTING_MODE = 0;</code>
     */
    public static final int UNDEFINED_ROUTING_MODE_VALUE = 0;

    /** <code>GLOBAL = 494663587;</code> */
    public static final int GLOBAL_VALUE = 494663587;

    /** <code>REGIONAL = 92288543;</code> */
    public static final int REGIONAL_VALUE = 92288543;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RoutingMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RoutingMode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ROUTING_MODE;
        case 494663587:
          return GLOBAL;
        case 92288543:
          return REGIONAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RoutingMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RoutingMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RoutingMode>() {
          public RoutingMode findValueByNumber(int number) {
            return RoutingMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NetworkRoutingConfig.getDescriptor().getEnumTypes().get(3);
    }

    private static final RoutingMode[] VALUES = values();

    public static RoutingMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RoutingMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NetworkRoutingConfig.RoutingMode)
  }

  private int bitField0_;
  public static final int BGP_ALWAYS_COMPARE_MED_FIELD_NUMBER = 213102902;
  private boolean bgpAlwaysCompareMed_ = false;

  /**
   *
   *
   * <pre>
   * Enable comparison of Multi-Exit Discriminators (MED) across routes with different neighbor ASNs when using the STANDARD BGP best path selection algorithm.
   * </pre>
   *
   * <code>optional bool bgp_always_compare_med = 213102902;</code>
   *
   * @return Whether the bgpAlwaysCompareMed field is set.
   */
  @java.lang.Override
  public boolean hasBgpAlwaysCompareMed() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Enable comparison of Multi-Exit Discriminators (MED) across routes with different neighbor ASNs when using the STANDARD BGP best path selection algorithm.
   * </pre>
   *
   * <code>optional bool bgp_always_compare_med = 213102902;</code>
   *
   * @return The bgpAlwaysCompareMed.
   */
  @java.lang.Override
  public boolean getBgpAlwaysCompareMed() {
    return bgpAlwaysCompareMed_;
  }

  public static final int BGP_BEST_PATH_SELECTION_MODE_FIELD_NUMBER = 317816297;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bgpBestPathSelectionMode_ = "";

  /**
   *
   *
   * <pre>
   * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
   * Check the BgpBestPathSelectionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bgp_best_path_selection_mode = 317816297;</code>
   *
   * @return Whether the bgpBestPathSelectionMode field is set.
   */
  @java.lang.Override
  public boolean hasBgpBestPathSelectionMode() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
   * Check the BgpBestPathSelectionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bgp_best_path_selection_mode = 317816297;</code>
   *
   * @return The bgpBestPathSelectionMode.
   */
  @java.lang.Override
  public java.lang.String getBgpBestPathSelectionMode() {
    java.lang.Object ref = bgpBestPathSelectionMode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bgpBestPathSelectionMode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
   * Check the BgpBestPathSelectionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bgp_best_path_selection_mode = 317816297;</code>
   *
   * @return The bytes for bgpBestPathSelectionMode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBgpBestPathSelectionModeBytes() {
    java.lang.Object ref = bgpBestPathSelectionMode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bgpBestPathSelectionMode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BGP_INTER_REGION_COST_FIELD_NUMBER = 462142689;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bgpInterRegionCost_ = "";

  /**
   *
   *
   * <pre>
   * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
   * Check the BgpInterRegionCost enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bgp_inter_region_cost = 462142689;</code>
   *
   * @return Whether the bgpInterRegionCost field is set.
   */
  @java.lang.Override
  public boolean hasBgpInterRegionCost() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
   * Check the BgpInterRegionCost enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bgp_inter_region_cost = 462142689;</code>
   *
   * @return The bgpInterRegionCost.
   */
  @java.lang.Override
  public java.lang.String getBgpInterRegionCost() {
    java.lang.Object ref = bgpInterRegionCost_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bgpInterRegionCost_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
   * Check the BgpInterRegionCost enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bgp_inter_region_cost = 462142689;</code>
   *
   * @return The bytes for bgpInterRegionCost.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBgpInterRegionCostBytes() {
    java.lang.Object ref = bgpInterRegionCost_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bgpInterRegionCost_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EFFECTIVE_BGP_ALWAYS_COMPARE_MED_FIELD_NUMBER = 214661838;
  private boolean effectiveBgpAlwaysCompareMed_ = false;

  /**
   *
   *
   * <pre>
   * [Output Only] Effective value of the bgp_always_compare_med field.
   * </pre>
   *
   * <code>optional bool effective_bgp_always_compare_med = 214661838;</code>
   *
   * @return Whether the effectiveBgpAlwaysCompareMed field is set.
   */
  @java.lang.Override
  public boolean hasEffectiveBgpAlwaysCompareMed() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Effective value of the bgp_always_compare_med field.
   * </pre>
   *
   * <code>optional bool effective_bgp_always_compare_med = 214661838;</code>
   *
   * @return The effectiveBgpAlwaysCompareMed.
   */
  @java.lang.Override
  public boolean getEffectiveBgpAlwaysCompareMed() {
    return effectiveBgpAlwaysCompareMed_;
  }

  public static final int EFFECTIVE_BGP_INTER_REGION_COST_FIELD_NUMBER = 185098313;

  @SuppressWarnings("serial")
  private volatile java.lang.Object effectiveBgpInterRegionCost_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Effective value of the bgp_inter_region_cost field.
   * Check the EffectiveBgpInterRegionCost enum for the list of possible values.
   * </pre>
   *
   * <code>optional string effective_bgp_inter_region_cost = 185098313;</code>
   *
   * @return Whether the effectiveBgpInterRegionCost field is set.
   */
  @java.lang.Override
  public boolean hasEffectiveBgpInterRegionCost() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Effective value of the bgp_inter_region_cost field.
   * Check the EffectiveBgpInterRegionCost enum for the list of possible values.
   * </pre>
   *
   * <code>optional string effective_bgp_inter_region_cost = 185098313;</code>
   *
   * @return The effectiveBgpInterRegionCost.
   */
  @java.lang.Override
  public java.lang.String getEffectiveBgpInterRegionCost() {
    java.lang.Object ref = effectiveBgpInterRegionCost_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      effectiveBgpInterRegionCost_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Effective value of the bgp_inter_region_cost field.
   * Check the EffectiveBgpInterRegionCost enum for the list of possible values.
   * </pre>
   *
   * <code>optional string effective_bgp_inter_region_cost = 185098313;</code>
   *
   * @return The bytes for effectiveBgpInterRegionCost.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEffectiveBgpInterRegionCostBytes() {
    java.lang.Object ref = effectiveBgpInterRegionCost_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      effectiveBgpInterRegionCost_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROUTING_MODE_FIELD_NUMBER = 475143548;

  @SuppressWarnings("serial")
  private volatile java.lang.Object routingMode_ = "";

  /**
   *
   *
   * <pre>
   * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
   * Check the RoutingMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string routing_mode = 475143548;</code>
   *
   * @return Whether the routingMode field is set.
   */
  @java.lang.Override
  public boolean hasRoutingMode() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
   * Check the RoutingMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string routing_mode = 475143548;</code>
   *
   * @return The routingMode.
   */
  @java.lang.Override
  public java.lang.String getRoutingMode() {
    java.lang.Object ref = routingMode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      routingMode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
   * Check the RoutingMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string routing_mode = 475143548;</code>
   *
   * @return The bytes for routingMode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRoutingModeBytes() {
    java.lang.Object ref = routingMode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      routingMode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 185098313, effectiveBgpInterRegionCost_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(213102902, bgpAlwaysCompareMed_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(214661838, effectiveBgpAlwaysCompareMed_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 317816297, bgpBestPathSelectionMode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 462142689, bgpInterRegionCost_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 475143548, routingMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              185098313, effectiveBgpInterRegionCost_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(213102902, bgpAlwaysCompareMed_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              214661838, effectiveBgpAlwaysCompareMed_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              317816297, bgpBestPathSelectionMode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(462142689, bgpInterRegionCost_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(475143548, routingMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.NetworkRoutingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.NetworkRoutingConfig other =
        (com.google.cloud.compute.v1.NetworkRoutingConfig) obj;

    if (hasBgpAlwaysCompareMed() != other.hasBgpAlwaysCompareMed()) return false;
    if (hasBgpAlwaysCompareMed()) {
      if (getBgpAlwaysCompareMed() != other.getBgpAlwaysCompareMed()) return false;
    }
    if (hasBgpBestPathSelectionMode() != other.hasBgpBestPathSelectionMode()) return false;
    if (hasBgpBestPathSelectionMode()) {
      if (!getBgpBestPathSelectionMode().equals(other.getBgpBestPathSelectionMode())) return false;
    }
    if (hasBgpInterRegionCost() != other.hasBgpInterRegionCost()) return false;
    if (hasBgpInterRegionCost()) {
      if (!getBgpInterRegionCost().equals(other.getBgpInterRegionCost())) return false;
    }
    if (hasEffectiveBgpAlwaysCompareMed() != other.hasEffectiveBgpAlwaysCompareMed()) return false;
    if (hasEffectiveBgpAlwaysCompareMed()) {
      if (getEffectiveBgpAlwaysCompareMed() != other.getEffectiveBgpAlwaysCompareMed())
        return false;
    }
    if (hasEffectiveBgpInterRegionCost() != other.hasEffectiveBgpInterRegionCost()) return false;
    if (hasEffectiveBgpInterRegionCost()) {
      if (!getEffectiveBgpInterRegionCost().equals(other.getEffectiveBgpInterRegionCost()))
        return false;
    }
    if (hasRoutingMode() != other.hasRoutingMode()) return false;
    if (hasRoutingMode()) {
      if (!getRoutingMode().equals(other.getRoutingMode())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBgpAlwaysCompareMed()) {
      hash = (37 * hash) + BGP_ALWAYS_COMPARE_MED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBgpAlwaysCompareMed());
    }
    if (hasBgpBestPathSelectionMode()) {
      hash = (37 * hash) + BGP_BEST_PATH_SELECTION_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getBgpBestPathSelectionMode().hashCode();
    }
    if (hasBgpInterRegionCost()) {
      hash = (37 * hash) + BGP_INTER_REGION_COST_FIELD_NUMBER;
      hash = (53 * hash) + getBgpInterRegionCost().hashCode();
    }
    if (hasEffectiveBgpAlwaysCompareMed()) {
      hash = (37 * hash) + EFFECTIVE_BGP_ALWAYS_COMPARE_MED_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEffectiveBgpAlwaysCompareMed());
    }
    if (hasEffectiveBgpInterRegionCost()) {
      hash = (37 * hash) + EFFECTIVE_BGP_INTER_REGION_COST_FIELD_NUMBER;
      hash = (53 * hash) + getEffectiveBgpInterRegionCost().hashCode();
    }
    if (hasRoutingMode()) {
      hash = (37 * hash) + ROUTING_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getRoutingMode().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.NetworkRoutingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A routing configuration attached to a network resource. The message includes the list of routers associated with the network, and a flag indicating the type of routing behavior to enforce network-wide.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.NetworkRoutingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.NetworkRoutingConfig)
      com.google.cloud.compute.v1.NetworkRoutingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkRoutingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkRoutingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.NetworkRoutingConfig.class,
              com.google.cloud.compute.v1.NetworkRoutingConfig.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.NetworkRoutingConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bgpAlwaysCompareMed_ = false;
      bgpBestPathSelectionMode_ = "";
      bgpInterRegionCost_ = "";
      effectiveBgpAlwaysCompareMed_ = false;
      effectiveBgpInterRegionCost_ = "";
      routingMode_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkRoutingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkRoutingConfig getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.NetworkRoutingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkRoutingConfig build() {
      com.google.cloud.compute.v1.NetworkRoutingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkRoutingConfig buildPartial() {
      com.google.cloud.compute.v1.NetworkRoutingConfig result =
          new com.google.cloud.compute.v1.NetworkRoutingConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.NetworkRoutingConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bgpAlwaysCompareMed_ = bgpAlwaysCompareMed_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.bgpBestPathSelectionMode_ = bgpBestPathSelectionMode_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.bgpInterRegionCost_ = bgpInterRegionCost_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.effectiveBgpAlwaysCompareMed_ = effectiveBgpAlwaysCompareMed_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.effectiveBgpInterRegionCost_ = effectiveBgpInterRegionCost_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.routingMode_ = routingMode_;
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.NetworkRoutingConfig) {
        return mergeFrom((com.google.cloud.compute.v1.NetworkRoutingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.NetworkRoutingConfig other) {
      if (other == com.google.cloud.compute.v1.NetworkRoutingConfig.getDefaultInstance())
        return this;
      if (other.hasBgpAlwaysCompareMed()) {
        setBgpAlwaysCompareMed(other.getBgpAlwaysCompareMed());
      }
      if (other.hasBgpBestPathSelectionMode()) {
        bgpBestPathSelectionMode_ = other.bgpBestPathSelectionMode_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasBgpInterRegionCost()) {
        bgpInterRegionCost_ = other.bgpInterRegionCost_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasEffectiveBgpAlwaysCompareMed()) {
        setEffectiveBgpAlwaysCompareMed(other.getEffectiveBgpAlwaysCompareMed());
      }
      if (other.hasEffectiveBgpInterRegionCost()) {
        effectiveBgpInterRegionCost_ = other.effectiveBgpInterRegionCost_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasRoutingMode()) {
        routingMode_ = other.routingMode_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1480786506:
              {
                effectiveBgpInterRegionCost_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 1480786506
            case 1704823216:
              {
                bgpAlwaysCompareMed_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 1704823216
            case 1717294704:
              {
                effectiveBgpAlwaysCompareMed_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 1717294704
            case -1752436918:
              {
                bgpBestPathSelectionMode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -1752436918
            case -597825782:
              {
                bgpInterRegionCost_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -597825782
            case -493818910:
              {
                routingMode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -493818910
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean bgpAlwaysCompareMed_;

    /**
     *
     *
     * <pre>
     * Enable comparison of Multi-Exit Discriminators (MED) across routes with different neighbor ASNs when using the STANDARD BGP best path selection algorithm.
     * </pre>
     *
     * <code>optional bool bgp_always_compare_med = 213102902;</code>
     *
     * @return Whether the bgpAlwaysCompareMed field is set.
     */
    @java.lang.Override
    public boolean hasBgpAlwaysCompareMed() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Enable comparison of Multi-Exit Discriminators (MED) across routes with different neighbor ASNs when using the STANDARD BGP best path selection algorithm.
     * </pre>
     *
     * <code>optional bool bgp_always_compare_med = 213102902;</code>
     *
     * @return The bgpAlwaysCompareMed.
     */
    @java.lang.Override
    public boolean getBgpAlwaysCompareMed() {
      return bgpAlwaysCompareMed_;
    }

    /**
     *
     *
     * <pre>
     * Enable comparison of Multi-Exit Discriminators (MED) across routes with different neighbor ASNs when using the STANDARD BGP best path selection algorithm.
     * </pre>
     *
     * <code>optional bool bgp_always_compare_med = 213102902;</code>
     *
     * @param value The bgpAlwaysCompareMed to set.
     * @return This builder for chaining.
     */
    public Builder setBgpAlwaysCompareMed(boolean value) {

      bgpAlwaysCompareMed_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enable comparison of Multi-Exit Discriminators (MED) across routes with different neighbor ASNs when using the STANDARD BGP best path selection algorithm.
     * </pre>
     *
     * <code>optional bool bgp_always_compare_med = 213102902;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBgpAlwaysCompareMed() {
      bitField0_ = (bitField0_ & ~0x00000001);
      bgpAlwaysCompareMed_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object bgpBestPathSelectionMode_ = "";

    /**
     *
     *
     * <pre>
     * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
     * Check the BgpBestPathSelectionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_best_path_selection_mode = 317816297;</code>
     *
     * @return Whether the bgpBestPathSelectionMode field is set.
     */
    public boolean hasBgpBestPathSelectionMode() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
     * Check the BgpBestPathSelectionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_best_path_selection_mode = 317816297;</code>
     *
     * @return The bgpBestPathSelectionMode.
     */
    public java.lang.String getBgpBestPathSelectionMode() {
      java.lang.Object ref = bgpBestPathSelectionMode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bgpBestPathSelectionMode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
     * Check the BgpBestPathSelectionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_best_path_selection_mode = 317816297;</code>
     *
     * @return The bytes for bgpBestPathSelectionMode.
     */
    public com.google.protobuf.ByteString getBgpBestPathSelectionModeBytes() {
      java.lang.Object ref = bgpBestPathSelectionMode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bgpBestPathSelectionMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
     * Check the BgpBestPathSelectionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_best_path_selection_mode = 317816297;</code>
     *
     * @param value The bgpBestPathSelectionMode to set.
     * @return This builder for chaining.
     */
    public Builder setBgpBestPathSelectionMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bgpBestPathSelectionMode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
     * Check the BgpBestPathSelectionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_best_path_selection_mode = 317816297;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBgpBestPathSelectionMode() {
      bgpBestPathSelectionMode_ = getDefaultInstance().getBgpBestPathSelectionMode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
     * Check the BgpBestPathSelectionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_best_path_selection_mode = 317816297;</code>
     *
     * @param value The bytes for bgpBestPathSelectionMode to set.
     * @return This builder for chaining.
     */
    public Builder setBgpBestPathSelectionModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bgpBestPathSelectionMode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object bgpInterRegionCost_ = "";

    /**
     *
     *
     * <pre>
     * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
     * Check the BgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_inter_region_cost = 462142689;</code>
     *
     * @return Whether the bgpInterRegionCost field is set.
     */
    public boolean hasBgpInterRegionCost() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
     * Check the BgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_inter_region_cost = 462142689;</code>
     *
     * @return The bgpInterRegionCost.
     */
    public java.lang.String getBgpInterRegionCost() {
      java.lang.Object ref = bgpInterRegionCost_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bgpInterRegionCost_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
     * Check the BgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_inter_region_cost = 462142689;</code>
     *
     * @return The bytes for bgpInterRegionCost.
     */
    public com.google.protobuf.ByteString getBgpInterRegionCostBytes() {
      java.lang.Object ref = bgpInterRegionCost_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bgpInterRegionCost_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
     * Check the BgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_inter_region_cost = 462142689;</code>
     *
     * @param value The bgpInterRegionCost to set.
     * @return This builder for chaining.
     */
    public Builder setBgpInterRegionCost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bgpInterRegionCost_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
     * Check the BgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_inter_region_cost = 462142689;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBgpInterRegionCost() {
      bgpInterRegionCost_ = getDefaultInstance().getBgpInterRegionCost();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
     * Check the BgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_inter_region_cost = 462142689;</code>
     *
     * @param value The bytes for bgpInterRegionCost to set.
     * @return This builder for chaining.
     */
    public Builder setBgpInterRegionCostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bgpInterRegionCost_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean effectiveBgpAlwaysCompareMed_;

    /**
     *
     *
     * <pre>
     * [Output Only] Effective value of the bgp_always_compare_med field.
     * </pre>
     *
     * <code>optional bool effective_bgp_always_compare_med = 214661838;</code>
     *
     * @return Whether the effectiveBgpAlwaysCompareMed field is set.
     */
    @java.lang.Override
    public boolean hasEffectiveBgpAlwaysCompareMed() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Effective value of the bgp_always_compare_med field.
     * </pre>
     *
     * <code>optional bool effective_bgp_always_compare_med = 214661838;</code>
     *
     * @return The effectiveBgpAlwaysCompareMed.
     */
    @java.lang.Override
    public boolean getEffectiveBgpAlwaysCompareMed() {
      return effectiveBgpAlwaysCompareMed_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Effective value of the bgp_always_compare_med field.
     * </pre>
     *
     * <code>optional bool effective_bgp_always_compare_med = 214661838;</code>
     *
     * @param value The effectiveBgpAlwaysCompareMed to set.
     * @return This builder for chaining.
     */
    public Builder setEffectiveBgpAlwaysCompareMed(boolean value) {

      effectiveBgpAlwaysCompareMed_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Effective value of the bgp_always_compare_med field.
     * </pre>
     *
     * <code>optional bool effective_bgp_always_compare_med = 214661838;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEffectiveBgpAlwaysCompareMed() {
      bitField0_ = (bitField0_ & ~0x00000008);
      effectiveBgpAlwaysCompareMed_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object effectiveBgpInterRegionCost_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Effective value of the bgp_inter_region_cost field.
     * Check the EffectiveBgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string effective_bgp_inter_region_cost = 185098313;</code>
     *
     * @return Whether the effectiveBgpInterRegionCost field is set.
     */
    public boolean hasEffectiveBgpInterRegionCost() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Effective value of the bgp_inter_region_cost field.
     * Check the EffectiveBgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string effective_bgp_inter_region_cost = 185098313;</code>
     *
     * @return The effectiveBgpInterRegionCost.
     */
    public java.lang.String getEffectiveBgpInterRegionCost() {
      java.lang.Object ref = effectiveBgpInterRegionCost_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        effectiveBgpInterRegionCost_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Effective value of the bgp_inter_region_cost field.
     * Check the EffectiveBgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string effective_bgp_inter_region_cost = 185098313;</code>
     *
     * @return The bytes for effectiveBgpInterRegionCost.
     */
    public com.google.protobuf.ByteString getEffectiveBgpInterRegionCostBytes() {
      java.lang.Object ref = effectiveBgpInterRegionCost_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        effectiveBgpInterRegionCost_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Effective value of the bgp_inter_region_cost field.
     * Check the EffectiveBgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string effective_bgp_inter_region_cost = 185098313;</code>
     *
     * @param value The effectiveBgpInterRegionCost to set.
     * @return This builder for chaining.
     */
    public Builder setEffectiveBgpInterRegionCost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      effectiveBgpInterRegionCost_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Effective value of the bgp_inter_region_cost field.
     * Check the EffectiveBgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string effective_bgp_inter_region_cost = 185098313;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEffectiveBgpInterRegionCost() {
      effectiveBgpInterRegionCost_ = getDefaultInstance().getEffectiveBgpInterRegionCost();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Effective value of the bgp_inter_region_cost field.
     * Check the EffectiveBgpInterRegionCost enum for the list of possible values.
     * </pre>
     *
     * <code>optional string effective_bgp_inter_region_cost = 185098313;</code>
     *
     * @param value The bytes for effectiveBgpInterRegionCost to set.
     * @return This builder for chaining.
     */
    public Builder setEffectiveBgpInterRegionCostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      effectiveBgpInterRegionCost_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object routingMode_ = "";

    /**
     *
     *
     * <pre>
     * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
     * Check the RoutingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string routing_mode = 475143548;</code>
     *
     * @return Whether the routingMode field is set.
     */
    public boolean hasRoutingMode() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
     * Check the RoutingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string routing_mode = 475143548;</code>
     *
     * @return The routingMode.
     */
    public java.lang.String getRoutingMode() {
      java.lang.Object ref = routingMode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        routingMode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
     * Check the RoutingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string routing_mode = 475143548;</code>
     *
     * @return The bytes for routingMode.
     */
    public com.google.protobuf.ByteString getRoutingModeBytes() {
      java.lang.Object ref = routingMode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        routingMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
     * Check the RoutingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string routing_mode = 475143548;</code>
     *
     * @param value The routingMode to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      routingMode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
     * Check the RoutingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string routing_mode = 475143548;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoutingMode() {
      routingMode_ = getDefaultInstance().getRoutingMode();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
     * Check the RoutingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string routing_mode = 475143548;</code>
     *
     * @param value The bytes for routingMode to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      routingMode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.NetworkRoutingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.NetworkRoutingConfig)
  private static final com.google.cloud.compute.v1.NetworkRoutingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.NetworkRoutingConfig();
  }

  public static com.google.cloud.compute.v1.NetworkRoutingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkRoutingConfig> PARSER =
      new com.google.protobuf.AbstractParser<NetworkRoutingConfig>() {
        @java.lang.Override
        public NetworkRoutingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkRoutingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkRoutingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkRoutingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
