/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a machine image resource. A machine image is a Compute Engine resource that stores all the configuration, metadata, permissions, and data from one or more disks required to create a Virtual machine (VM) instance. For more information, see Machine images.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.MachineImage}
 */
public final class MachineImage extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.MachineImage)
    MachineImageOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use MachineImage.newBuilder() to construct.
  private MachineImage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MachineImage() {
    creationTimestamp_ = "";
    description_ = "";
    kind_ = "";
    labelFingerprint_ = "";
    name_ = "";
    savedDisks_ = java.util.Collections.emptyList();
    selfLink_ = "";
    sourceDiskEncryptionKeys_ = java.util.Collections.emptyList();
    sourceInstance_ = "";
    status_ = "";
    storageLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MachineImage();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_MachineImage_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_MachineImage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.MachineImage.class,
            com.google.cloud.compute.v1.MachineImage.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.MachineImage.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /** <code>CREATING = 455564985;</code> */
    CREATING(455564985),
    /** <code>DELETING = 528602024;</code> */
    DELETING(528602024),
    /** <code>INVALID = 530283991;</code> */
    INVALID(530283991),
    /** <code>READY = 77848963;</code> */
    READY(77848963),
    /** <code>UPLOADING = 267603489;</code> */
    UPLOADING(267603489),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /** <code>CREATING = 455564985;</code> */
    public static final int CREATING_VALUE = 455564985;

    /** <code>DELETING = 528602024;</code> */
    public static final int DELETING_VALUE = 528602024;

    /** <code>INVALID = 530283991;</code> */
    public static final int INVALID_VALUE = 530283991;

    /** <code>READY = 77848963;</code> */
    public static final int READY_VALUE = 77848963;

    /** <code>UPLOADING = 267603489;</code> */
    public static final int UPLOADING_VALUE = 267603489;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 455564985:
          return CREATING;
        case 528602024:
          return DELETING;
        case 530283991:
          return INVALID;
        case 77848963:
          return READY;
        case 267603489:
          return UPLOADING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.MachineImage.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.MachineImage.Status)
  }

  private int bitField0_;
  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GUEST_FLUSH_FIELD_NUMBER = 385550813;
  private boolean guestFlush_ = false;

  /**
   *
   *
   * <pre>
   * [Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process.
   * </pre>
   *
   * <code>optional bool guest_flush = 385550813;</code>
   *
   * @return Whether the guestFlush field is set.
   */
  @java.lang.Override
  public boolean hasGuestFlush() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process.
   * </pre>
   *
   * <code>optional bool guest_flush = 385550813;</code>
   *
   * @return The guestFlush.
   */
  @java.lang.Override
  public boolean getGuestFlush() {
    return guestFlush_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] A unique identifier for this machine image. The server defines this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A unique identifier for this machine image. The server defines this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INSTANCE_PROPERTIES_FIELD_NUMBER = 215355165;
  private com.google.cloud.compute.v1.InstanceProperties instanceProperties_;

  /**
   *
   *
   * <pre>
   * [Output Only] Properties of source instance
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
   * </code>
   *
   * @return Whether the instanceProperties field is set.
   */
  @java.lang.Override
  public boolean hasInstanceProperties() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Properties of source instance
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
   * </code>
   *
   * @return The instanceProperties.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceProperties getInstanceProperties() {
    return instanceProperties_ == null
        ? com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()
        : instanceProperties_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Properties of source instance
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstancePropertiesOrBuilder getInstancePropertiesOrBuilder() {
    return instanceProperties_ == null
        ? com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()
        : instanceProperties_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The resource type, which is always compute#machineImage for machine image.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The resource type, which is always compute#machineImage for machine image.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The resource type, which is always compute#machineImage for machine image.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FINGERPRINT_FIELD_NUMBER = 178124825;

  @SuppressWarnings("serial")
  private volatile java.lang.Object labelFingerprint_ = "";

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  @java.lang.Override
  public boolean hasLabelFingerprint() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  @java.lang.Override
  public java.lang.String getLabelFingerprint() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labelFingerprint_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelFingerprintBytes() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labelFingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_MachineImage_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this machine image. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this machine image. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this machine image. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this machine image. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MACHINE_IMAGE_ENCRYPTION_KEY_FIELD_NUMBER = 528089087;
  private com.google.cloud.compute.v1.CustomerEncryptionKey machineImageEncryptionKey_;

  /**
   *
   *
   * <pre>
   * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
   * </code>
   *
   * @return Whether the machineImageEncryptionKey field is set.
   */
  @java.lang.Override
  public boolean hasMachineImageEncryptionKey() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
   * </code>
   *
   * @return The machineImageEncryptionKey.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKey getMachineImageEncryptionKey() {
    return machineImageEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : machineImageEncryptionKey_;
  }

  /**
   *
   *
   * <pre>
   * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getMachineImageEncryptionKeyOrBuilder() {
    return machineImageEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : machineImageEncryptionKey_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 480964257;
  private boolean satisfiesPzi_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 480964257;</code>
   *
   * @return Whether the satisfiesPzi field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzi() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 480964257;</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 480964267;
  private boolean satisfiesPzs_ = false;

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzs() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SAVED_DISKS_FIELD_NUMBER = 397424318;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.SavedDisk> savedDisks_;

  /**
   *
   *
   * <pre>
   * An array of Machine Image specific properties for disks attached to the source instance
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.SavedDisk> getSavedDisksList() {
    return savedDisks_;
  }

  /**
   *
   *
   * <pre>
   * An array of Machine Image specific properties for disks attached to the source instance
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.SavedDiskOrBuilder>
      getSavedDisksOrBuilderList() {
    return savedDisks_;
  }

  /**
   *
   *
   * <pre>
   * An array of Machine Image specific properties for disks attached to the source instance
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
   */
  @java.lang.Override
  public int getSavedDisksCount() {
    return savedDisks_.size();
  }

  /**
   *
   *
   * <pre>
   * An array of Machine Image specific properties for disks attached to the source instance
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SavedDisk getSavedDisks(int index) {
    return savedDisks_.get(index);
  }

  /**
   *
   *
   * <pre>
   * An array of Machine Image specific properties for disks attached to the source instance
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SavedDiskOrBuilder getSavedDisksOrBuilder(int index) {
    return savedDisks_.get(index);
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The URL for this machine image. The server defines this URL.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The URL for this machine image. The server defines this URL.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The URL for this machine image. The server defines this URL.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_DISK_ENCRYPTION_KEYS_FIELD_NUMBER = 370408498;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.SourceDiskEncryptionKey>
      sourceDiskEncryptionKeys_;

  /**
   *
   *
   * <pre>
   * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.SourceDiskEncryptionKey>
      getSourceDiskEncryptionKeysList() {
    return sourceDiskEncryptionKeys_;
  }

  /**
   *
   *
   * <pre>
   * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.SourceDiskEncryptionKeyOrBuilder>
      getSourceDiskEncryptionKeysOrBuilderList() {
    return sourceDiskEncryptionKeys_;
  }

  /**
   *
   *
   * <pre>
   * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
   * </code>
   */
  @java.lang.Override
  public int getSourceDiskEncryptionKeysCount() {
    return sourceDiskEncryptionKeys_.size();
  }

  /**
   *
   *
   * <pre>
   * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SourceDiskEncryptionKey getSourceDiskEncryptionKeys(
      int index) {
    return sourceDiskEncryptionKeys_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SourceDiskEncryptionKeyOrBuilder
      getSourceDiskEncryptionKeysOrBuilder(int index) {
    return sourceDiskEncryptionKeys_.get(index);
  }

  public static final int SOURCE_INSTANCE_FIELD_NUMBER = 396315705;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceInstance_ = "";

  /**
   *
   *
   * <pre>
   * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
   * </pre>
   *
   * <code>optional string source_instance = 396315705;</code>
   *
   * @return Whether the sourceInstance field is set.
   */
  @java.lang.Override
  public boolean hasSourceInstance() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
   * </pre>
   *
   * <code>optional string source_instance = 396315705;</code>
   *
   * @return The sourceInstance.
   */
  @java.lang.Override
  public java.lang.String getSourceInstance() {
    java.lang.Object ref = sourceInstance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceInstance_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
   * </pre>
   *
   * <code>optional string source_instance = 396315705;</code>
   *
   * @return The bytes for sourceInstance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceInstanceBytes() {
    java.lang.Object ref = sourceInstance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceInstance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_INSTANCE_PROPERTIES_FIELD_NUMBER = 475195641;
  private com.google.cloud.compute.v1.SourceInstanceProperties sourceInstanceProperties_;

  /**
   *
   *
   * <pre>
   * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
   * </code>
   *
   * @return Whether the sourceInstanceProperties field is set.
   */
  @java.lang.Override
  public boolean hasSourceInstanceProperties() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
   * </code>
   *
   * @return The sourceInstanceProperties.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SourceInstanceProperties getSourceInstanceProperties() {
    return sourceInstanceProperties_ == null
        ? com.google.cloud.compute.v1.SourceInstanceProperties.getDefaultInstance()
        : sourceInstanceProperties_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SourceInstancePropertiesOrBuilder
      getSourceInstancePropertiesOrBuilder() {
    return sourceInstanceProperties_ == null
        ? com.google.cloud.compute.v1.SourceInstanceProperties.getDefaultInstance()
        : sourceInstanceProperties_;
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STORAGE_LOCATIONS_FIELD_NUMBER = 328005274;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList storageLocations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @return A list containing the storageLocations.
   */
  public com.google.protobuf.ProtocolStringList getStorageLocationsList() {
    return storageLocations_;
  }

  /**
   *
   *
   * <pre>
   * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @return The count of storageLocations.
   */
  public int getStorageLocationsCount() {
    return storageLocations_.size();
  }

  /**
   *
   *
   * <pre>
   * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @param index The index of the element to return.
   * @return The storageLocations at the given index.
   */
  public java.lang.String getStorageLocations(int index) {
    return storageLocations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the storageLocations at the given index.
   */
  public com.google.protobuf.ByteString getStorageLocationsBytes(int index) {
    return storageLocations_.getByteString(index);
  }

  public static final int TOTAL_STORAGE_BYTES_FIELD_NUMBER = 81855468;
  private long totalStorageBytes_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Total size of the storage used by the machine image.
   * </pre>
   *
   * <code>optional int64 total_storage_bytes = 81855468;</code>
   *
   * @return Whether the totalStorageBytes field is set.
   */
  @java.lang.Override
  public boolean hasTotalStorageBytes() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Total size of the storage used by the machine image.
   * </pre>
   *
   * <code>optional int64 total_storage_bytes = 81855468;</code>
   *
   * @return The totalStorageBytes.
   */
  @java.lang.Override
  public long getTotalStorageBytes() {
    return totalStorageBytes_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeInt64(81855468, totalStorageBytes_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(215355165, getInstanceProperties());
    }
    for (int i = 0; i < storageLocations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 328005274, storageLocations_.getRaw(i));
    }
    for (int i = 0; i < sourceDiskEncryptionKeys_.size(); i++) {
      output.writeMessage(370408498, sourceDiskEncryptionKeys_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(385550813, guestFlush_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 396315705, sourceInstance_);
    }
    for (int i = 0; i < savedDisks_.size(); i++) {
      output.writeMessage(397424318, savedDisks_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(475195641, getSourceInstanceProperties());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeBool(480964257, satisfiesPzi_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeBool(480964267, satisfiesPzs_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(528089087, getMachineImageEncryptionKey());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(81855468, totalStorageBytes_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              215355165, getInstanceProperties());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < storageLocations_.size(); i++) {
        dataSize += computeStringSizeNoTag(storageLocations_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getStorageLocationsList().size();
    }
    for (int i = 0; i < sourceDiskEncryptionKeys_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              370408498, sourceDiskEncryptionKeys_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(385550813, guestFlush_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(396315705, sourceInstance_);
    }
    for (int i = 0; i < savedDisks_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(397424318, savedDisks_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              475195641, getSourceInstanceProperties());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(480964257, satisfiesPzi_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(480964267, satisfiesPzs_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              528089087, getMachineImageEncryptionKey());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.MachineImage)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.MachineImage other = (com.google.cloud.compute.v1.MachineImage) obj;

    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasGuestFlush() != other.hasGuestFlush()) return false;
    if (hasGuestFlush()) {
      if (getGuestFlush() != other.getGuestFlush()) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasInstanceProperties() != other.hasInstanceProperties()) return false;
    if (hasInstanceProperties()) {
      if (!getInstanceProperties().equals(other.getInstanceProperties())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLabelFingerprint() != other.hasLabelFingerprint()) return false;
    if (hasLabelFingerprint()) {
      if (!getLabelFingerprint().equals(other.getLabelFingerprint())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasMachineImageEncryptionKey() != other.hasMachineImageEncryptionKey()) return false;
    if (hasMachineImageEncryptionKey()) {
      if (!getMachineImageEncryptionKey().equals(other.getMachineImageEncryptionKey()))
        return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasSatisfiesPzi() != other.hasSatisfiesPzi()) return false;
    if (hasSatisfiesPzi()) {
      if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    }
    if (hasSatisfiesPzs() != other.hasSatisfiesPzs()) return false;
    if (hasSatisfiesPzs()) {
      if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    }
    if (!getSavedDisksList().equals(other.getSavedDisksList())) return false;
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getSourceDiskEncryptionKeysList().equals(other.getSourceDiskEncryptionKeysList()))
      return false;
    if (hasSourceInstance() != other.hasSourceInstance()) return false;
    if (hasSourceInstance()) {
      if (!getSourceInstance().equals(other.getSourceInstance())) return false;
    }
    if (hasSourceInstanceProperties() != other.hasSourceInstanceProperties()) return false;
    if (hasSourceInstanceProperties()) {
      if (!getSourceInstanceProperties().equals(other.getSourceInstanceProperties())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getStorageLocationsList().equals(other.getStorageLocationsList())) return false;
    if (hasTotalStorageBytes() != other.hasTotalStorageBytes()) return false;
    if (hasTotalStorageBytes()) {
      if (getTotalStorageBytes() != other.getTotalStorageBytes()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasGuestFlush()) {
      hash = (37 * hash) + GUEST_FLUSH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGuestFlush());
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasInstanceProperties()) {
      hash = (37 * hash) + INSTANCE_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceProperties().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLabelFingerprint()) {
      hash = (37 * hash) + LABEL_FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getLabelFingerprint().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasMachineImageEncryptionKey()) {
      hash = (37 * hash) + MACHINE_IMAGE_ENCRYPTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getMachineImageEncryptionKey().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasSatisfiesPzi()) {
      hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    }
    if (hasSatisfiesPzs()) {
      hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    }
    if (getSavedDisksCount() > 0) {
      hash = (37 * hash) + SAVED_DISKS_FIELD_NUMBER;
      hash = (53 * hash) + getSavedDisksList().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (getSourceDiskEncryptionKeysCount() > 0) {
      hash = (37 * hash) + SOURCE_DISK_ENCRYPTION_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceDiskEncryptionKeysList().hashCode();
    }
    if (hasSourceInstance()) {
      hash = (37 * hash) + SOURCE_INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceInstance().hashCode();
    }
    if (hasSourceInstanceProperties()) {
      hash = (37 * hash) + SOURCE_INSTANCE_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getSourceInstanceProperties().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getStorageLocationsCount() > 0) {
      hash = (37 * hash) + STORAGE_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getStorageLocationsList().hashCode();
    }
    if (hasTotalStorageBytes()) {
      hash = (37 * hash) + TOTAL_STORAGE_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalStorageBytes());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.MachineImage parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.MachineImage parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MachineImage parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.MachineImage parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MachineImage parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.MachineImage parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MachineImage parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.MachineImage parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MachineImage parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.MachineImage parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MachineImage parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.MachineImage parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.MachineImage prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a machine image resource. A machine image is a Compute Engine resource that stores all the configuration, metadata, permissions, and data from one or more disks required to create a Virtual machine (VM) instance. For more information, see Machine images.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.MachineImage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.MachineImage)
      com.google.cloud.compute.v1.MachineImageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_MachineImage_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_MachineImage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.MachineImage.class,
              com.google.cloud.compute.v1.MachineImage.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.MachineImage.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInstancePropertiesFieldBuilder();
        getMachineImageEncryptionKeyFieldBuilder();
        getSavedDisksFieldBuilder();
        getSourceDiskEncryptionKeysFieldBuilder();
        getSourceInstancePropertiesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      creationTimestamp_ = "";
      description_ = "";
      guestFlush_ = false;
      id_ = 0L;
      instanceProperties_ = null;
      if (instancePropertiesBuilder_ != null) {
        instancePropertiesBuilder_.dispose();
        instancePropertiesBuilder_ = null;
      }
      kind_ = "";
      labelFingerprint_ = "";
      internalGetMutableLabels().clear();
      machineImageEncryptionKey_ = null;
      if (machineImageEncryptionKeyBuilder_ != null) {
        machineImageEncryptionKeyBuilder_.dispose();
        machineImageEncryptionKeyBuilder_ = null;
      }
      name_ = "";
      satisfiesPzi_ = false;
      satisfiesPzs_ = false;
      if (savedDisksBuilder_ == null) {
        savedDisks_ = java.util.Collections.emptyList();
      } else {
        savedDisks_ = null;
        savedDisksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      selfLink_ = "";
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        sourceDiskEncryptionKeys_ = java.util.Collections.emptyList();
      } else {
        sourceDiskEncryptionKeys_ = null;
        sourceDiskEncryptionKeysBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      sourceInstance_ = "";
      sourceInstanceProperties_ = null;
      if (sourceInstancePropertiesBuilder_ != null) {
        sourceInstancePropertiesBuilder_.dispose();
        sourceInstancePropertiesBuilder_ = null;
      }
      status_ = "";
      storageLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      totalStorageBytes_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_MachineImage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.MachineImage getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.MachineImage.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.MachineImage build() {
      com.google.cloud.compute.v1.MachineImage result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.MachineImage buildPartial() {
      com.google.cloud.compute.v1.MachineImage result =
          new com.google.cloud.compute.v1.MachineImage(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.MachineImage result) {
      if (savedDisksBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          savedDisks_ = java.util.Collections.unmodifiableList(savedDisks_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.savedDisks_ = savedDisks_;
      } else {
        result.savedDisks_ = savedDisksBuilder_.build();
      }
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          sourceDiskEncryptionKeys_ =
              java.util.Collections.unmodifiableList(sourceDiskEncryptionKeys_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.sourceDiskEncryptionKeys_ = sourceDiskEncryptionKeys_;
      } else {
        result.sourceDiskEncryptionKeys_ = sourceDiskEncryptionKeysBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.MachineImage result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.guestFlush_ = guestFlush_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.instanceProperties_ =
            instancePropertiesBuilder_ == null
                ? instanceProperties_
                : instancePropertiesBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labelFingerprint_ = labelFingerprint_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.machineImageEncryptionKey_ =
            machineImageEncryptionKeyBuilder_ == null
                ? machineImageEncryptionKey_
                : machineImageEncryptionKeyBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.sourceInstance_ = sourceInstance_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.sourceInstanceProperties_ =
            sourceInstancePropertiesBuilder_ == null
                ? sourceInstanceProperties_
                : sourceInstancePropertiesBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        storageLocations_.makeImmutable();
        result.storageLocations_ = storageLocations_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.totalStorageBytes_ = totalStorageBytes_;
        to_bitField0_ |= 0x00008000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.MachineImage) {
        return mergeFrom((com.google.cloud.compute.v1.MachineImage) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.MachineImage other) {
      if (other == com.google.cloud.compute.v1.MachineImage.getDefaultInstance()) return this;
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasGuestFlush()) {
        setGuestFlush(other.getGuestFlush());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasInstanceProperties()) {
        mergeInstanceProperties(other.getInstanceProperties());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasLabelFingerprint()) {
        labelFingerprint_ = other.labelFingerprint_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (other.hasMachineImageEncryptionKey()) {
        mergeMachineImageEncryptionKey(other.getMachineImageEncryptionKey());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasSatisfiesPzi()) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      if (other.hasSatisfiesPzs()) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (savedDisksBuilder_ == null) {
        if (!other.savedDisks_.isEmpty()) {
          if (savedDisks_.isEmpty()) {
            savedDisks_ = other.savedDisks_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureSavedDisksIsMutable();
            savedDisks_.addAll(other.savedDisks_);
          }
          onChanged();
        }
      } else {
        if (!other.savedDisks_.isEmpty()) {
          if (savedDisksBuilder_.isEmpty()) {
            savedDisksBuilder_.dispose();
            savedDisksBuilder_ = null;
            savedDisks_ = other.savedDisks_;
            bitField0_ = (bitField0_ & ~0x00001000);
            savedDisksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSavedDisksFieldBuilder()
                    : null;
          } else {
            savedDisksBuilder_.addAllMessages(other.savedDisks_);
          }
        }
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        if (!other.sourceDiskEncryptionKeys_.isEmpty()) {
          if (sourceDiskEncryptionKeys_.isEmpty()) {
            sourceDiskEncryptionKeys_ = other.sourceDiskEncryptionKeys_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureSourceDiskEncryptionKeysIsMutable();
            sourceDiskEncryptionKeys_.addAll(other.sourceDiskEncryptionKeys_);
          }
          onChanged();
        }
      } else {
        if (!other.sourceDiskEncryptionKeys_.isEmpty()) {
          if (sourceDiskEncryptionKeysBuilder_.isEmpty()) {
            sourceDiskEncryptionKeysBuilder_.dispose();
            sourceDiskEncryptionKeysBuilder_ = null;
            sourceDiskEncryptionKeys_ = other.sourceDiskEncryptionKeys_;
            bitField0_ = (bitField0_ & ~0x00004000);
            sourceDiskEncryptionKeysBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSourceDiskEncryptionKeysFieldBuilder()
                    : null;
          } else {
            sourceDiskEncryptionKeysBuilder_.addAllMessages(other.sourceDiskEncryptionKeys_);
          }
        }
      }
      if (other.hasSourceInstance()) {
        sourceInstance_ = other.sourceInstance_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasSourceInstanceProperties()) {
        mergeSourceInstanceProperties(other.getSourceInstanceProperties());
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (!other.storageLocations_.isEmpty()) {
        if (storageLocations_.isEmpty()) {
          storageLocations_ = other.storageLocations_;
          bitField0_ |= 0x00040000;
        } else {
          ensureStorageLocationsIsMutable();
          storageLocations_.addAll(other.storageLocations_);
        }
        onChanged();
      }
      if (other.hasTotalStorageBytes()) {
        setTotalStorageBytes(other.getTotalStorageBytes());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 244202930
            case 654843744:
              {
                totalStorageBytes_ = input.readInt64();
                bitField0_ |= 0x00080000;
                break;
              } // case 654843744
            case 1424998602:
              {
                labelFingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 1424998602
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 1450082194
            case 1722841322:
              {
                input.readMessage(
                    getInstancePropertiesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 1722841322
            case -1670925102:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStorageLocationsIsMutable();
                storageLocations_.add(s);
                break;
              } // case -1670925102
            case -1331699310:
              {
                com.google.cloud.compute.v1.SourceDiskEncryptionKey m =
                    input.readMessage(
                        com.google.cloud.compute.v1.SourceDiskEncryptionKey.parser(),
                        extensionRegistry);
                if (sourceDiskEncryptionKeysBuilder_ == null) {
                  ensureSourceDiskEncryptionKeysIsMutable();
                  sourceDiskEncryptionKeys_.add(m);
                } else {
                  sourceDiskEncryptionKeysBuilder_.addMessage(m);
                }
                break;
              } // case -1331699310
            case -1210560792:
              {
                guestFlush_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case -1210560792
            case -1124441654:
              {
                sourceInstance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case -1124441654
            case -1115572750:
              {
                com.google.cloud.compute.v1.SavedDisk m =
                    input.readMessage(
                        com.google.cloud.compute.v1.SavedDisk.parser(), extensionRegistry);
                if (savedDisksBuilder_ == null) {
                  ensureSavedDisksIsMutable();
                  savedDisks_.add(m);
                } else {
                  savedDisksBuilder_.addMessage(m);
                }
                break;
              } // case -1115572750
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case -645248918
            case -493402166:
              {
                input.readMessage(
                    getSourceInstancePropertiesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case -493402166
            case -447253240:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case -447253240
            case -447253160:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case -447253160
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case -293404678
            case -70254598:
              {
                input.readMessage(
                    getMachineImageEncryptionKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case -70254598
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean guestFlush_;

    /**
     *
     *
     * <pre>
     * [Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @return Whether the guestFlush field is set.
     */
    @java.lang.Override
    public boolean hasGuestFlush() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @return The guestFlush.
     */
    @java.lang.Override
    public boolean getGuestFlush() {
      return guestFlush_;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @param value The guestFlush to set.
     * @return This builder for chaining.
     */
    public Builder setGuestFlush(boolean value) {

      guestFlush_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGuestFlush() {
      bitField0_ = (bitField0_ & ~0x00000004);
      guestFlush_ = false;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] A unique identifier for this machine image. The server defines this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A unique identifier for this machine image. The server defines this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A unique identifier for this machine image. The server defines this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A unique identifier for this machine image. The server defines this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000008);
      id_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InstanceProperties instanceProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceProperties,
            com.google.cloud.compute.v1.InstanceProperties.Builder,
            com.google.cloud.compute.v1.InstancePropertiesOrBuilder>
        instancePropertiesBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Properties of source instance
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     *
     * @return Whether the instanceProperties field is set.
     */
    public boolean hasInstanceProperties() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Properties of source instance
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     *
     * @return The instanceProperties.
     */
    public com.google.cloud.compute.v1.InstanceProperties getInstanceProperties() {
      if (instancePropertiesBuilder_ == null) {
        return instanceProperties_ == null
            ? com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()
            : instanceProperties_;
      } else {
        return instancePropertiesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Properties of source instance
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public Builder setInstanceProperties(com.google.cloud.compute.v1.InstanceProperties value) {
      if (instancePropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceProperties_ = value;
      } else {
        instancePropertiesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Properties of source instance
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public Builder setInstanceProperties(
        com.google.cloud.compute.v1.InstanceProperties.Builder builderForValue) {
      if (instancePropertiesBuilder_ == null) {
        instanceProperties_ = builderForValue.build();
      } else {
        instancePropertiesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Properties of source instance
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public Builder mergeInstanceProperties(com.google.cloud.compute.v1.InstanceProperties value) {
      if (instancePropertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && instanceProperties_ != null
            && instanceProperties_
                != com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()) {
          getInstancePropertiesBuilder().mergeFrom(value);
        } else {
          instanceProperties_ = value;
        }
      } else {
        instancePropertiesBuilder_.mergeFrom(value);
      }
      if (instanceProperties_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Properties of source instance
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public Builder clearInstanceProperties() {
      bitField0_ = (bitField0_ & ~0x00000010);
      instanceProperties_ = null;
      if (instancePropertiesBuilder_ != null) {
        instancePropertiesBuilder_.dispose();
        instancePropertiesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Properties of source instance
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceProperties.Builder getInstancePropertiesBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getInstancePropertiesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Properties of source instance
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public com.google.cloud.compute.v1.InstancePropertiesOrBuilder
        getInstancePropertiesOrBuilder() {
      if (instancePropertiesBuilder_ != null) {
        return instancePropertiesBuilder_.getMessageOrBuilder();
      } else {
        return instanceProperties_ == null
            ? com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()
            : instanceProperties_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Properties of source instance
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceProperties,
            com.google.cloud.compute.v1.InstanceProperties.Builder,
            com.google.cloud.compute.v1.InstancePropertiesOrBuilder>
        getInstancePropertiesFieldBuilder() {
      if (instancePropertiesBuilder_ == null) {
        instancePropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InstanceProperties,
                com.google.cloud.compute.v1.InstanceProperties.Builder,
                com.google.cloud.compute.v1.InstancePropertiesOrBuilder>(
                getInstanceProperties(), getParentForChildren(), isClean());
        instanceProperties_ = null;
      }
      return instancePropertiesBuilder_;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#machineImage for machine image.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#machineImage for machine image.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#machineImage for machine image.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#machineImage for machine image.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#machineImage for machine image.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#machineImage for machine image.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object labelFingerprint_ = "";

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return Whether the labelFingerprint field is set.
     */
    public boolean hasLabelFingerprint() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The labelFingerprint.
     */
    public java.lang.String getLabelFingerprint() {
      java.lang.Object ref = labelFingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelFingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The bytes for labelFingerprint.
     */
    public com.google.protobuf.ByteString getLabelFingerprintBytes() {
      java.lang.Object ref = labelFingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labelFingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labelFingerprint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelFingerprint() {
      labelFingerprint_ = getDefaultInstance().getLabelFingerprint();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The bytes for labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labelFingerprint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this machine image. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this machine image. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this machine image. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this machine image. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this machine image. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this machine image. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this machine image. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private com.google.cloud.compute.v1.CustomerEncryptionKey machineImageEncryptionKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        machineImageEncryptionKeyBuilder_;

    /**
     *
     *
     * <pre>
     * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
     * </code>
     *
     * @return Whether the machineImageEncryptionKey field is set.
     */
    public boolean hasMachineImageEncryptionKey() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
     * </code>
     *
     * @return The machineImageEncryptionKey.
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey getMachineImageEncryptionKey() {
      if (machineImageEncryptionKeyBuilder_ == null) {
        return machineImageEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : machineImageEncryptionKey_;
      } else {
        return machineImageEncryptionKeyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
     * </code>
     */
    public Builder setMachineImageEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (machineImageEncryptionKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineImageEncryptionKey_ = value;
      } else {
        machineImageEncryptionKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
     * </code>
     */
    public Builder setMachineImageEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey.Builder builderForValue) {
      if (machineImageEncryptionKeyBuilder_ == null) {
        machineImageEncryptionKey_ = builderForValue.build();
      } else {
        machineImageEncryptionKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
     * </code>
     */
    public Builder mergeMachineImageEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (machineImageEncryptionKeyBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && machineImageEncryptionKey_ != null
            && machineImageEncryptionKey_
                != com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()) {
          getMachineImageEncryptionKeyBuilder().mergeFrom(value);
        } else {
          machineImageEncryptionKey_ = value;
        }
      } else {
        machineImageEncryptionKeyBuilder_.mergeFrom(value);
      }
      if (machineImageEncryptionKey_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
     * </code>
     */
    public Builder clearMachineImageEncryptionKey() {
      bitField0_ = (bitField0_ & ~0x00000100);
      machineImageEncryptionKey_ = null;
      if (machineImageEncryptionKeyBuilder_ != null) {
        machineImageEncryptionKeyBuilder_.dispose();
        machineImageEncryptionKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey.Builder
        getMachineImageEncryptionKeyBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getMachineImageEncryptionKeyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
        getMachineImageEncryptionKeyOrBuilder() {
      if (machineImageEncryptionKeyBuilder_ != null) {
        return machineImageEncryptionKeyBuilder_.getMessageOrBuilder();
      } else {
        return machineImageEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : machineImageEncryptionKey_;
      }
    }

    /**
     *
     *
     * <pre>
     * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        getMachineImageEncryptionKeyFieldBuilder() {
      if (machineImageEncryptionKeyBuilder_ == null) {
        machineImageEncryptionKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CustomerEncryptionKey,
                com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
                com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>(
                getMachineImageEncryptionKey(), getParentForChildren(), isClean());
        machineImageEncryptionKey_ = null;
      }
      return machineImageEncryptionKeyBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @return Whether the satisfiesPzi field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzi() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00000400);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return Whether the satisfiesPzs field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzs() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00000800);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.SavedDisk> savedDisks_ =
        java.util.Collections.emptyList();

    private void ensureSavedDisksIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        savedDisks_ = new java.util.ArrayList<com.google.cloud.compute.v1.SavedDisk>(savedDisks_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SavedDisk,
            com.google.cloud.compute.v1.SavedDisk.Builder,
            com.google.cloud.compute.v1.SavedDiskOrBuilder>
        savedDisksBuilder_;

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.SavedDisk> getSavedDisksList() {
      if (savedDisksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(savedDisks_);
      } else {
        return savedDisksBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public int getSavedDisksCount() {
      if (savedDisksBuilder_ == null) {
        return savedDisks_.size();
      } else {
        return savedDisksBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public com.google.cloud.compute.v1.SavedDisk getSavedDisks(int index) {
      if (savedDisksBuilder_ == null) {
        return savedDisks_.get(index);
      } else {
        return savedDisksBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public Builder setSavedDisks(int index, com.google.cloud.compute.v1.SavedDisk value) {
      if (savedDisksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSavedDisksIsMutable();
        savedDisks_.set(index, value);
        onChanged();
      } else {
        savedDisksBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public Builder setSavedDisks(
        int index, com.google.cloud.compute.v1.SavedDisk.Builder builderForValue) {
      if (savedDisksBuilder_ == null) {
        ensureSavedDisksIsMutable();
        savedDisks_.set(index, builderForValue.build());
        onChanged();
      } else {
        savedDisksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public Builder addSavedDisks(com.google.cloud.compute.v1.SavedDisk value) {
      if (savedDisksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSavedDisksIsMutable();
        savedDisks_.add(value);
        onChanged();
      } else {
        savedDisksBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public Builder addSavedDisks(int index, com.google.cloud.compute.v1.SavedDisk value) {
      if (savedDisksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSavedDisksIsMutable();
        savedDisks_.add(index, value);
        onChanged();
      } else {
        savedDisksBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public Builder addSavedDisks(com.google.cloud.compute.v1.SavedDisk.Builder builderForValue) {
      if (savedDisksBuilder_ == null) {
        ensureSavedDisksIsMutable();
        savedDisks_.add(builderForValue.build());
        onChanged();
      } else {
        savedDisksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public Builder addSavedDisks(
        int index, com.google.cloud.compute.v1.SavedDisk.Builder builderForValue) {
      if (savedDisksBuilder_ == null) {
        ensureSavedDisksIsMutable();
        savedDisks_.add(index, builderForValue.build());
        onChanged();
      } else {
        savedDisksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public Builder addAllSavedDisks(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.SavedDisk> values) {
      if (savedDisksBuilder_ == null) {
        ensureSavedDisksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, savedDisks_);
        onChanged();
      } else {
        savedDisksBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public Builder clearSavedDisks() {
      if (savedDisksBuilder_ == null) {
        savedDisks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        savedDisksBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public Builder removeSavedDisks(int index) {
      if (savedDisksBuilder_ == null) {
        ensureSavedDisksIsMutable();
        savedDisks_.remove(index);
        onChanged();
      } else {
        savedDisksBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public com.google.cloud.compute.v1.SavedDisk.Builder getSavedDisksBuilder(int index) {
      return getSavedDisksFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public com.google.cloud.compute.v1.SavedDiskOrBuilder getSavedDisksOrBuilder(int index) {
      if (savedDisksBuilder_ == null) {
        return savedDisks_.get(index);
      } else {
        return savedDisksBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.SavedDiskOrBuilder>
        getSavedDisksOrBuilderList() {
      if (savedDisksBuilder_ != null) {
        return savedDisksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(savedDisks_);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public com.google.cloud.compute.v1.SavedDisk.Builder addSavedDisksBuilder() {
      return getSavedDisksFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.SavedDisk.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public com.google.cloud.compute.v1.SavedDisk.Builder addSavedDisksBuilder(int index) {
      return getSavedDisksFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.SavedDisk.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * An array of Machine Image specific properties for disks attached to the source instance
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.SavedDisk.Builder>
        getSavedDisksBuilderList() {
      return getSavedDisksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SavedDisk,
            com.google.cloud.compute.v1.SavedDisk.Builder,
            com.google.cloud.compute.v1.SavedDiskOrBuilder>
        getSavedDisksFieldBuilder() {
      if (savedDisksBuilder_ == null) {
        savedDisksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.SavedDisk,
                com.google.cloud.compute.v1.SavedDisk.Builder,
                com.google.cloud.compute.v1.SavedDiskOrBuilder>(
                savedDisks_, ((bitField0_ & 0x00001000) != 0), getParentForChildren(), isClean());
        savedDisks_ = null;
      }
      return savedDisksBuilder_;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this machine image. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this machine image. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this machine image. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this machine image. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this machine image. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this machine image. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.SourceDiskEncryptionKey>
        sourceDiskEncryptionKeys_ = java.util.Collections.emptyList();

    private void ensureSourceDiskEncryptionKeysIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        sourceDiskEncryptionKeys_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.SourceDiskEncryptionKey>(
                sourceDiskEncryptionKeys_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SourceDiskEncryptionKey,
            com.google.cloud.compute.v1.SourceDiskEncryptionKey.Builder,
            com.google.cloud.compute.v1.SourceDiskEncryptionKeyOrBuilder>
        sourceDiskEncryptionKeysBuilder_;

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.SourceDiskEncryptionKey>
        getSourceDiskEncryptionKeysList() {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sourceDiskEncryptionKeys_);
      } else {
        return sourceDiskEncryptionKeysBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public int getSourceDiskEncryptionKeysCount() {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        return sourceDiskEncryptionKeys_.size();
      } else {
        return sourceDiskEncryptionKeysBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public com.google.cloud.compute.v1.SourceDiskEncryptionKey getSourceDiskEncryptionKeys(
        int index) {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        return sourceDiskEncryptionKeys_.get(index);
      } else {
        return sourceDiskEncryptionKeysBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public Builder setSourceDiskEncryptionKeys(
        int index, com.google.cloud.compute.v1.SourceDiskEncryptionKey value) {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceDiskEncryptionKeysIsMutable();
        sourceDiskEncryptionKeys_.set(index, value);
        onChanged();
      } else {
        sourceDiskEncryptionKeysBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public Builder setSourceDiskEncryptionKeys(
        int index, com.google.cloud.compute.v1.SourceDiskEncryptionKey.Builder builderForValue) {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        ensureSourceDiskEncryptionKeysIsMutable();
        sourceDiskEncryptionKeys_.set(index, builderForValue.build());
        onChanged();
      } else {
        sourceDiskEncryptionKeysBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public Builder addSourceDiskEncryptionKeys(
        com.google.cloud.compute.v1.SourceDiskEncryptionKey value) {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceDiskEncryptionKeysIsMutable();
        sourceDiskEncryptionKeys_.add(value);
        onChanged();
      } else {
        sourceDiskEncryptionKeysBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public Builder addSourceDiskEncryptionKeys(
        int index, com.google.cloud.compute.v1.SourceDiskEncryptionKey value) {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceDiskEncryptionKeysIsMutable();
        sourceDiskEncryptionKeys_.add(index, value);
        onChanged();
      } else {
        sourceDiskEncryptionKeysBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public Builder addSourceDiskEncryptionKeys(
        com.google.cloud.compute.v1.SourceDiskEncryptionKey.Builder builderForValue) {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        ensureSourceDiskEncryptionKeysIsMutable();
        sourceDiskEncryptionKeys_.add(builderForValue.build());
        onChanged();
      } else {
        sourceDiskEncryptionKeysBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public Builder addSourceDiskEncryptionKeys(
        int index, com.google.cloud.compute.v1.SourceDiskEncryptionKey.Builder builderForValue) {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        ensureSourceDiskEncryptionKeysIsMutable();
        sourceDiskEncryptionKeys_.add(index, builderForValue.build());
        onChanged();
      } else {
        sourceDiskEncryptionKeysBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public Builder addAllSourceDiskEncryptionKeys(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.SourceDiskEncryptionKey> values) {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        ensureSourceDiskEncryptionKeysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceDiskEncryptionKeys_);
        onChanged();
      } else {
        sourceDiskEncryptionKeysBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public Builder clearSourceDiskEncryptionKeys() {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        sourceDiskEncryptionKeys_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        sourceDiskEncryptionKeysBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public Builder removeSourceDiskEncryptionKeys(int index) {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        ensureSourceDiskEncryptionKeysIsMutable();
        sourceDiskEncryptionKeys_.remove(index);
        onChanged();
      } else {
        sourceDiskEncryptionKeysBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public com.google.cloud.compute.v1.SourceDiskEncryptionKey.Builder
        getSourceDiskEncryptionKeysBuilder(int index) {
      return getSourceDiskEncryptionKeysFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public com.google.cloud.compute.v1.SourceDiskEncryptionKeyOrBuilder
        getSourceDiskEncryptionKeysOrBuilder(int index) {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        return sourceDiskEncryptionKeys_.get(index);
      } else {
        return sourceDiskEncryptionKeysBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.SourceDiskEncryptionKeyOrBuilder>
        getSourceDiskEncryptionKeysOrBuilderList() {
      if (sourceDiskEncryptionKeysBuilder_ != null) {
        return sourceDiskEncryptionKeysBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sourceDiskEncryptionKeys_);
      }
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public com.google.cloud.compute.v1.SourceDiskEncryptionKey.Builder
        addSourceDiskEncryptionKeysBuilder() {
      return getSourceDiskEncryptionKeysFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.SourceDiskEncryptionKey.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public com.google.cloud.compute.v1.SourceDiskEncryptionKey.Builder
        addSourceDiskEncryptionKeysBuilder(int index) {
      return getSourceDiskEncryptionKeysFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.SourceDiskEncryptionKey.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.SourceDiskEncryptionKey.Builder>
        getSourceDiskEncryptionKeysBuilderList() {
      return getSourceDiskEncryptionKeysFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SourceDiskEncryptionKey,
            com.google.cloud.compute.v1.SourceDiskEncryptionKey.Builder,
            com.google.cloud.compute.v1.SourceDiskEncryptionKeyOrBuilder>
        getSourceDiskEncryptionKeysFieldBuilder() {
      if (sourceDiskEncryptionKeysBuilder_ == null) {
        sourceDiskEncryptionKeysBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.SourceDiskEncryptionKey,
                com.google.cloud.compute.v1.SourceDiskEncryptionKey.Builder,
                com.google.cloud.compute.v1.SourceDiskEncryptionKeyOrBuilder>(
                sourceDiskEncryptionKeys_,
                ((bitField0_ & 0x00004000) != 0),
                getParentForChildren(),
                isClean());
        sourceDiskEncryptionKeys_ = null;
      }
      return sourceDiskEncryptionKeysBuilder_;
    }

    private java.lang.Object sourceInstance_ = "";

    /**
     *
     *
     * <pre>
     * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
     * </pre>
     *
     * <code>optional string source_instance = 396315705;</code>
     *
     * @return Whether the sourceInstance field is set.
     */
    public boolean hasSourceInstance() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
     * </pre>
     *
     * <code>optional string source_instance = 396315705;</code>
     *
     * @return The sourceInstance.
     */
    public java.lang.String getSourceInstance() {
      java.lang.Object ref = sourceInstance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceInstance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
     * </pre>
     *
     * <code>optional string source_instance = 396315705;</code>
     *
     * @return The bytes for sourceInstance.
     */
    public com.google.protobuf.ByteString getSourceInstanceBytes() {
      java.lang.Object ref = sourceInstance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceInstance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
     * </pre>
     *
     * <code>optional string source_instance = 396315705;</code>
     *
     * @param value The sourceInstance to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceInstance_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
     * </pre>
     *
     * <code>optional string source_instance = 396315705;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceInstance() {
      sourceInstance_ = getDefaultInstance().getSourceInstance();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
     * </pre>
     *
     * <code>optional string source_instance = 396315705;</code>
     *
     * @param value The bytes for sourceInstance to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceInstance_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SourceInstanceProperties sourceInstanceProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SourceInstanceProperties,
            com.google.cloud.compute.v1.SourceInstanceProperties.Builder,
            com.google.cloud.compute.v1.SourceInstancePropertiesOrBuilder>
        sourceInstancePropertiesBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
     * </code>
     *
     * @return Whether the sourceInstanceProperties field is set.
     */
    public boolean hasSourceInstanceProperties() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
     * </code>
     *
     * @return The sourceInstanceProperties.
     */
    public com.google.cloud.compute.v1.SourceInstanceProperties getSourceInstanceProperties() {
      if (sourceInstancePropertiesBuilder_ == null) {
        return sourceInstanceProperties_ == null
            ? com.google.cloud.compute.v1.SourceInstanceProperties.getDefaultInstance()
            : sourceInstanceProperties_;
      } else {
        return sourceInstancePropertiesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
     * </code>
     */
    public Builder setSourceInstanceProperties(
        com.google.cloud.compute.v1.SourceInstanceProperties value) {
      if (sourceInstancePropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceInstanceProperties_ = value;
      } else {
        sourceInstancePropertiesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
     * </code>
     */
    public Builder setSourceInstanceProperties(
        com.google.cloud.compute.v1.SourceInstanceProperties.Builder builderForValue) {
      if (sourceInstancePropertiesBuilder_ == null) {
        sourceInstanceProperties_ = builderForValue.build();
      } else {
        sourceInstancePropertiesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
     * </code>
     */
    public Builder mergeSourceInstanceProperties(
        com.google.cloud.compute.v1.SourceInstanceProperties value) {
      if (sourceInstancePropertiesBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && sourceInstanceProperties_ != null
            && sourceInstanceProperties_
                != com.google.cloud.compute.v1.SourceInstanceProperties.getDefaultInstance()) {
          getSourceInstancePropertiesBuilder().mergeFrom(value);
        } else {
          sourceInstanceProperties_ = value;
        }
      } else {
        sourceInstancePropertiesBuilder_.mergeFrom(value);
      }
      if (sourceInstanceProperties_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
     * </code>
     */
    public Builder clearSourceInstanceProperties() {
      bitField0_ = (bitField0_ & ~0x00010000);
      sourceInstanceProperties_ = null;
      if (sourceInstancePropertiesBuilder_ != null) {
        sourceInstancePropertiesBuilder_.dispose();
        sourceInstancePropertiesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
     * </code>
     */
    public com.google.cloud.compute.v1.SourceInstanceProperties.Builder
        getSourceInstancePropertiesBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getSourceInstancePropertiesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
     * </code>
     */
    public com.google.cloud.compute.v1.SourceInstancePropertiesOrBuilder
        getSourceInstancePropertiesOrBuilder() {
      if (sourceInstancePropertiesBuilder_ != null) {
        return sourceInstancePropertiesBuilder_.getMessageOrBuilder();
      } else {
        return sourceInstanceProperties_ == null
            ? com.google.cloud.compute.v1.SourceInstanceProperties.getDefaultInstance()
            : sourceInstanceProperties_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SourceInstanceProperties,
            com.google.cloud.compute.v1.SourceInstanceProperties.Builder,
            com.google.cloud.compute.v1.SourceInstancePropertiesOrBuilder>
        getSourceInstancePropertiesFieldBuilder() {
      if (sourceInstancePropertiesBuilder_ == null) {
        sourceInstancePropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SourceInstanceProperties,
                com.google.cloud.compute.v1.SourceInstanceProperties.Builder,
                com.google.cloud.compute.v1.SourceInstancePropertiesOrBuilder>(
                getSourceInstanceProperties(), getParentForChildren(), isClean());
        sourceInstanceProperties_ = null;
      }
      return sourceInstancePropertiesBuilder_;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList storageLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureStorageLocationsIsMutable() {
      if (!storageLocations_.isModifiable()) {
        storageLocations_ = new com.google.protobuf.LazyStringArrayList(storageLocations_);
      }
      bitField0_ |= 0x00040000;
    }

    /**
     *
     *
     * <pre>
     * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @return A list containing the storageLocations.
     */
    public com.google.protobuf.ProtocolStringList getStorageLocationsList() {
      storageLocations_.makeImmutable();
      return storageLocations_;
    }

    /**
     *
     *
     * <pre>
     * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @return The count of storageLocations.
     */
    public int getStorageLocationsCount() {
      return storageLocations_.size();
    }

    /**
     *
     *
     * <pre>
     * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param index The index of the element to return.
     * @return The storageLocations at the given index.
     */
    public java.lang.String getStorageLocations(int index) {
      return storageLocations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the storageLocations at the given index.
     */
    public com.google.protobuf.ByteString getStorageLocationsBytes(int index) {
      return storageLocations_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param index The index to set the value at.
     * @param value The storageLocations to set.
     * @return This builder for chaining.
     */
    public Builder setStorageLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStorageLocationsIsMutable();
      storageLocations_.set(index, value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param value The storageLocations to add.
     * @return This builder for chaining.
     */
    public Builder addStorageLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStorageLocationsIsMutable();
      storageLocations_.add(value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param values The storageLocations to add.
     * @return This builder for chaining.
     */
    public Builder addAllStorageLocations(java.lang.Iterable<java.lang.String> values) {
      ensureStorageLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, storageLocations_);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageLocations() {
      storageLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00040000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param value The bytes of the storageLocations to add.
     * @return This builder for chaining.
     */
    public Builder addStorageLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStorageLocationsIsMutable();
      storageLocations_.add(value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private long totalStorageBytes_;

    /**
     *
     *
     * <pre>
     * [Output Only] Total size of the storage used by the machine image.
     * </pre>
     *
     * <code>optional int64 total_storage_bytes = 81855468;</code>
     *
     * @return Whether the totalStorageBytes field is set.
     */
    @java.lang.Override
    public boolean hasTotalStorageBytes() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Total size of the storage used by the machine image.
     * </pre>
     *
     * <code>optional int64 total_storage_bytes = 81855468;</code>
     *
     * @return The totalStorageBytes.
     */
    @java.lang.Override
    public long getTotalStorageBytes() {
      return totalStorageBytes_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Total size of the storage used by the machine image.
     * </pre>
     *
     * <code>optional int64 total_storage_bytes = 81855468;</code>
     *
     * @param value The totalStorageBytes to set.
     * @return This builder for chaining.
     */
    public Builder setTotalStorageBytes(long value) {

      totalStorageBytes_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Total size of the storage used by the machine image.
     * </pre>
     *
     * <code>optional int64 total_storage_bytes = 81855468;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalStorageBytes() {
      bitField0_ = (bitField0_ & ~0x00080000);
      totalStorageBytes_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.MachineImage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.MachineImage)
  private static final com.google.cloud.compute.v1.MachineImage DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.MachineImage();
  }

  public static com.google.cloud.compute.v1.MachineImage getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MachineImage> PARSER =
      new com.google.protobuf.AbstractParser<MachineImage>() {
        @java.lang.Override
        public MachineImage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MachineImage> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MachineImage> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.MachineImage getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
