/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * LINT.IfChange
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput}
 */
public final class InterconnectGroupsCreateMembersInterconnectInput
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput)
    InterconnectGroupsCreateMembersInterconnectInputOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectGroupsCreateMembersInterconnectInput.newBuilder() to construct.
  private InterconnectGroupsCreateMembersInterconnectInput(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectGroupsCreateMembersInterconnectInput() {
    customerName_ = "";
    description_ = "";
    facility_ = "";
    interconnectType_ = "";
    linkType_ = "";
    name_ = "";
    nocContactEmail_ = "";
    remoteLocation_ = "";
    requestedFeatures_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectGroupsCreateMembersInterconnectInput();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectGroupsCreateMembersInterconnectInput_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectGroupsCreateMembersInterconnectInput_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.class,
            com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.InterconnectType}
   */
  public enum InterconnectType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INTERCONNECT_TYPE = 0;</code>
     */
    UNDEFINED_INTERCONNECT_TYPE(0),
    /**
     *
     *
     * <pre>
     * A dedicated physical interconnection with the customer.
     * </pre>
     *
     * <code>DEDICATED = 258411983;</code>
     */
    DEDICATED(258411983),
    /**
     *
     *
     * <pre>
     * [Deprecated] A private, physical interconnection with the customer.
     * </pre>
     *
     * <code>IT_PRIVATE = 335677007;</code>
     */
    IT_PRIVATE(335677007),
    /**
     *
     *
     * <pre>
     * A partner-managed interconnection shared between customers via partner.
     * </pre>
     *
     * <code>PARTNER = 461924520;</code>
     */
    PARTNER(461924520),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INTERCONNECT_TYPE = 0;</code>
     */
    public static final int UNDEFINED_INTERCONNECT_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * A dedicated physical interconnection with the customer.
     * </pre>
     *
     * <code>DEDICATED = 258411983;</code>
     */
    public static final int DEDICATED_VALUE = 258411983;

    /**
     *
     *
     * <pre>
     * [Deprecated] A private, physical interconnection with the customer.
     * </pre>
     *
     * <code>IT_PRIVATE = 335677007;</code>
     */
    public static final int IT_PRIVATE_VALUE = 335677007;

    /**
     *
     *
     * <pre>
     * A partner-managed interconnection shared between customers via partner.
     * </pre>
     *
     * <code>PARTNER = 461924520;</code>
     */
    public static final int PARTNER_VALUE = 461924520;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InterconnectType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static InterconnectType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_INTERCONNECT_TYPE;
        case 258411983:
          return DEDICATED;
        case 335677007:
          return IT_PRIVATE;
        case 461924520:
          return PARTNER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<InterconnectType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<InterconnectType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<InterconnectType>() {
              public InterconnectType findValueByNumber(int number) {
                return InterconnectType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final InterconnectType[] VALUES = values();

    public static InterconnectType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private InterconnectType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.InterconnectType)
  }

  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.LinkType}
   */
  public enum LinkType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LINK_TYPE = 0;</code>
     */
    UNDEFINED_LINK_TYPE(0),
    /**
     *
     *
     * <pre>
     * 100G Ethernet, LR Optics.
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_100G_LR = 337672551;</code>
     */
    LINK_TYPE_ETHERNET_100G_LR(337672551),
    /**
     *
     *
     * <pre>
     * 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_10G_LR = 236739749;</code>
     */
    LINK_TYPE_ETHERNET_10G_LR(236739749),
    /**
     *
     *
     * <pre>
     * 400G Ethernet, LR4 Optics.
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_400G_LR4 = 127023690;</code>
     */
    LINK_TYPE_ETHERNET_400G_LR4(127023690),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LINK_TYPE = 0;</code>
     */
    public static final int UNDEFINED_LINK_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * 100G Ethernet, LR Optics.
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_100G_LR = 337672551;</code>
     */
    public static final int LINK_TYPE_ETHERNET_100G_LR_VALUE = 337672551;

    /**
     *
     *
     * <pre>
     * 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_10G_LR = 236739749;</code>
     */
    public static final int LINK_TYPE_ETHERNET_10G_LR_VALUE = 236739749;

    /**
     *
     *
     * <pre>
     * 400G Ethernet, LR4 Optics.
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_400G_LR4 = 127023690;</code>
     */
    public static final int LINK_TYPE_ETHERNET_400G_LR4_VALUE = 127023690;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LinkType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LinkType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_LINK_TYPE;
        case 337672551:
          return LINK_TYPE_ETHERNET_100G_LR;
        case 236739749:
          return LINK_TYPE_ETHERNET_10G_LR;
        case 127023690:
          return LINK_TYPE_ETHERNET_400G_LR4;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LinkType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LinkType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LinkType>() {
          public LinkType findValueByNumber(int number) {
            return LinkType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
          .getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final LinkType[] VALUES = values();

    public static LinkType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LinkType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.LinkType)
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.RequestedFeatures}
   */
  public enum RequestedFeatures implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_REQUESTED_FEATURES = 0;</code>
     */
    UNDEFINED_REQUESTED_FEATURES(0),
    /**
     *
     *
     * <pre>
     * Media Access Control security (MACsec)
     * </pre>
     *
     * <code>IF_MACSEC = 396279300;</code>
     */
    IF_MACSEC(396279300),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_REQUESTED_FEATURES = 0;</code>
     */
    public static final int UNDEFINED_REQUESTED_FEATURES_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Media Access Control security (MACsec)
     * </pre>
     *
     * <code>IF_MACSEC = 396279300;</code>
     */
    public static final int IF_MACSEC_VALUE = 396279300;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequestedFeatures valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RequestedFeatures forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_REQUESTED_FEATURES;
        case 396279300:
          return IF_MACSEC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RequestedFeatures>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RequestedFeatures>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RequestedFeatures>() {
              public RequestedFeatures findValueByNumber(int number) {
                return RequestedFeatures.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
          .getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final RequestedFeatures[] VALUES = values();

    public static RequestedFeatures valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RequestedFeatures(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.RequestedFeatures)
  }

  private int bitField0_;
  public static final int ADMIN_ENABLED_FIELD_NUMBER = 445675089;
  private boolean adminEnabled_ = false;

  /**
   *
   *
   * <pre>
   * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return Whether the adminEnabled field is set.
   */
  @java.lang.Override
  public boolean hasAdminEnabled() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return The adminEnabled.
   */
  @java.lang.Override
  public boolean getAdminEnabled() {
    return adminEnabled_;
  }

  public static final int CUSTOMER_NAME_FIELD_NUMBER = 3665484;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customerName_ = "";

  /**
   *
   *
   * <pre>
   * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
   * </pre>
   *
   * <code>optional string customer_name = 3665484;</code>
   *
   * @return Whether the customerName field is set.
   */
  @java.lang.Override
  public boolean hasCustomerName() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
   * </pre>
   *
   * <code>optional string customer_name = 3665484;</code>
   *
   * @return The customerName.
   */
  @java.lang.Override
  public java.lang.String getCustomerName() {
    java.lang.Object ref = customerName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customerName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
   * </pre>
   *
   * <code>optional string customer_name = 3665484;</code>
   *
   * @return The bytes for customerName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomerNameBytes() {
    java.lang.Object ref = customerName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customerName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FACILITY_FIELD_NUMBER = 501116579;

  @SuppressWarnings("serial")
  private volatile java.lang.Object facility_ = "";

  /**
   *
   *
   * <pre>
   * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
   * </pre>
   *
   * <code>optional string facility = 501116579;</code>
   *
   * @return Whether the facility field is set.
   */
  @java.lang.Override
  public boolean hasFacility() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
   * </pre>
   *
   * <code>optional string facility = 501116579;</code>
   *
   * @return The facility.
   */
  @java.lang.Override
  public java.lang.String getFacility() {
    java.lang.Object ref = facility_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      facility_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
   * </pre>
   *
   * <code>optional string facility = 501116579;</code>
   *
   * @return The bytes for facility.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFacilityBytes() {
    java.lang.Object ref = facility_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      facility_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTERCONNECT_TYPE_FIELD_NUMBER = 515165259;

  @SuppressWarnings("serial")
  private volatile java.lang.Object interconnectType_ = "";

  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * Check the InterconnectType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interconnect_type = 515165259;</code>
   *
   * @return Whether the interconnectType field is set.
   */
  @java.lang.Override
  public boolean hasInterconnectType() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * Check the InterconnectType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interconnect_type = 515165259;</code>
   *
   * @return The interconnectType.
   */
  @java.lang.Override
  public java.lang.String getInterconnectType() {
    java.lang.Object ref = interconnectType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      interconnectType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * Check the InterconnectType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interconnect_type = 515165259;</code>
   *
   * @return The bytes for interconnectType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInterconnectTypeBytes() {
    java.lang.Object ref = interconnectType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      interconnectType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINK_TYPE_FIELD_NUMBER = 523207775;

  @SuppressWarnings("serial")
  private volatile java.lang.Object linkType_ = "";

  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * Check the LinkType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string link_type = 523207775;</code>
   *
   * @return Whether the linkType field is set.
   */
  @java.lang.Override
  public boolean hasLinkType() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * Check the LinkType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string link_type = 523207775;</code>
   *
   * @return The linkType.
   */
  @java.lang.Override
  public java.lang.String getLinkType() {
    java.lang.Object ref = linkType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      linkType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * Check the LinkType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string link_type = 523207775;</code>
   *
   * @return The bytes for linkType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLinkTypeBytes() {
    java.lang.Object ref = linkType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      linkType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOC_CONTACT_EMAIL_FIELD_NUMBER = 14072832;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nocContactEmail_ = "";

  /**
   *
   *
   * <pre>
   * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
   * </pre>
   *
   * <code>optional string noc_contact_email = 14072832;</code>
   *
   * @return Whether the nocContactEmail field is set.
   */
  @java.lang.Override
  public boolean hasNocContactEmail() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
   * </pre>
   *
   * <code>optional string noc_contact_email = 14072832;</code>
   *
   * @return The nocContactEmail.
   */
  @java.lang.Override
  public java.lang.String getNocContactEmail() {
    java.lang.Object ref = nocContactEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nocContactEmail_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
   * </pre>
   *
   * <code>optional string noc_contact_email = 14072832;</code>
   *
   * @return The bytes for nocContactEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNocContactEmailBytes() {
    java.lang.Object ref = nocContactEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nocContactEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REMOTE_LOCATION_FIELD_NUMBER = 324388750;

  @SuppressWarnings("serial")
  private volatile java.lang.Object remoteLocation_ = "";

  /**
   *
   *
   * <pre>
   * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
   * </pre>
   *
   * <code>optional string remote_location = 324388750;</code>
   *
   * @return Whether the remoteLocation field is set.
   */
  @java.lang.Override
  public boolean hasRemoteLocation() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
   * </pre>
   *
   * <code>optional string remote_location = 324388750;</code>
   *
   * @return The remoteLocation.
   */
  @java.lang.Override
  public java.lang.String getRemoteLocation() {
    java.lang.Object ref = remoteLocation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      remoteLocation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
   * </pre>
   *
   * <code>optional string remote_location = 324388750;</code>
   *
   * @return The bytes for remoteLocation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRemoteLocationBytes() {
    java.lang.Object ref = remoteLocation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      remoteLocation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUESTED_FEATURES_FIELD_NUMBER = 461240814;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList requestedFeatures_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
   * Check the RequestedFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string requested_features = 461240814;</code>
   *
   * @return A list containing the requestedFeatures.
   */
  public com.google.protobuf.ProtocolStringList getRequestedFeaturesList() {
    return requestedFeatures_;
  }

  /**
   *
   *
   * <pre>
   * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
   * Check the RequestedFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string requested_features = 461240814;</code>
   *
   * @return The count of requestedFeatures.
   */
  public int getRequestedFeaturesCount() {
    return requestedFeatures_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
   * Check the RequestedFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string requested_features = 461240814;</code>
   *
   * @param index The index of the element to return.
   * @return The requestedFeatures at the given index.
   */
  public java.lang.String getRequestedFeatures(int index) {
    return requestedFeatures_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
   * Check the RequestedFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string requested_features = 461240814;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the requestedFeatures at the given index.
   */
  public com.google.protobuf.ByteString getRequestedFeaturesBytes(int index) {
    return requestedFeatures_.getByteString(index);
  }

  public static final int REQUESTED_LINK_COUNT_FIELD_NUMBER = 45051387;
  private int requestedLinkCount_ = 0;

  /**
   *
   *
   * <pre>
   * Target number of physical links in the link bundle, as requested by the customer.
   * </pre>
   *
   * <code>optional int32 requested_link_count = 45051387;</code>
   *
   * @return Whether the requestedLinkCount field is set.
   */
  @java.lang.Override
  public boolean hasRequestedLinkCount() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Target number of physical links in the link bundle, as requested by the customer.
   * </pre>
   *
   * <code>optional int32 requested_link_count = 45051387;</code>
   *
   * @return The requestedLinkCount.
   */
  @java.lang.Override
  public int getRequestedLinkCount() {
    return requestedLinkCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3665484, customerName_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14072832, nocContactEmail_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeInt32(45051387, requestedLinkCount_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 324388750, remoteLocation_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(445675089, adminEnabled_);
    }
    for (int i = 0; i < requestedFeatures_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 461240814, requestedFeatures_.getRaw(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 501116579, facility_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 515165259, interconnectType_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 523207775, linkType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3665484, customerName_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14072832, nocContactEmail_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(45051387, requestedLinkCount_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(324388750, remoteLocation_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(445675089, adminEnabled_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < requestedFeatures_.size(); i++) {
        dataSize += computeStringSizeNoTag(requestedFeatures_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getRequestedFeaturesList().size();
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(501116579, facility_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(515165259, interconnectType_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(523207775, linkType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput other =
        (com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput) obj;

    if (hasAdminEnabled() != other.hasAdminEnabled()) return false;
    if (hasAdminEnabled()) {
      if (getAdminEnabled() != other.getAdminEnabled()) return false;
    }
    if (hasCustomerName() != other.hasCustomerName()) return false;
    if (hasCustomerName()) {
      if (!getCustomerName().equals(other.getCustomerName())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasFacility() != other.hasFacility()) return false;
    if (hasFacility()) {
      if (!getFacility().equals(other.getFacility())) return false;
    }
    if (hasInterconnectType() != other.hasInterconnectType()) return false;
    if (hasInterconnectType()) {
      if (!getInterconnectType().equals(other.getInterconnectType())) return false;
    }
    if (hasLinkType() != other.hasLinkType()) return false;
    if (hasLinkType()) {
      if (!getLinkType().equals(other.getLinkType())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNocContactEmail() != other.hasNocContactEmail()) return false;
    if (hasNocContactEmail()) {
      if (!getNocContactEmail().equals(other.getNocContactEmail())) return false;
    }
    if (hasRemoteLocation() != other.hasRemoteLocation()) return false;
    if (hasRemoteLocation()) {
      if (!getRemoteLocation().equals(other.getRemoteLocation())) return false;
    }
    if (!getRequestedFeaturesList().equals(other.getRequestedFeaturesList())) return false;
    if (hasRequestedLinkCount() != other.hasRequestedLinkCount()) return false;
    if (hasRequestedLinkCount()) {
      if (getRequestedLinkCount() != other.getRequestedLinkCount()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdminEnabled()) {
      hash = (37 * hash) + ADMIN_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAdminEnabled());
    }
    if (hasCustomerName()) {
      hash = (37 * hash) + CUSTOMER_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getCustomerName().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasFacility()) {
      hash = (37 * hash) + FACILITY_FIELD_NUMBER;
      hash = (53 * hash) + getFacility().hashCode();
    }
    if (hasInterconnectType()) {
      hash = (37 * hash) + INTERCONNECT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getInterconnectType().hashCode();
    }
    if (hasLinkType()) {
      hash = (37 * hash) + LINK_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getLinkType().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNocContactEmail()) {
      hash = (37 * hash) + NOC_CONTACT_EMAIL_FIELD_NUMBER;
      hash = (53 * hash) + getNocContactEmail().hashCode();
    }
    if (hasRemoteLocation()) {
      hash = (37 * hash) + REMOTE_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getRemoteLocation().hashCode();
    }
    if (getRequestedFeaturesCount() > 0) {
      hash = (37 * hash) + REQUESTED_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedFeaturesList().hashCode();
    }
    if (hasRequestedLinkCount()) {
      hash = (37 * hash) + REQUESTED_LINK_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedLinkCount();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * LINT.IfChange
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput)
      com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInputOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroupsCreateMembersInterconnectInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroupsCreateMembersInterconnectInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.class,
              com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      adminEnabled_ = false;
      customerName_ = "";
      description_ = "";
      facility_ = "";
      interconnectType_ = "";
      linkType_ = "";
      name_ = "";
      nocContactEmail_ = "";
      remoteLocation_ = "";
      requestedFeatures_ = com.google.protobuf.LazyStringArrayList.emptyList();
      requestedLinkCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroupsCreateMembersInterconnectInput_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput build() {
      com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
        buildPartial() {
      com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput result =
          new com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.adminEnabled_ = adminEnabled_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.customerName_ = customerName_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.facility_ = facility_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.interconnectType_ = interconnectType_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.linkType_ = linkType_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.nocContactEmail_ = nocContactEmail_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.remoteLocation_ = remoteLocation_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        requestedFeatures_.makeImmutable();
        result.requestedFeatures_ = requestedFeatures_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.requestedLinkCount_ = requestedLinkCount_;
        to_bitField0_ |= 0x00000200;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput) {
        return mergeFrom(
            (com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput other) {
      if (other
          == com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
              .getDefaultInstance()) return this;
      if (other.hasAdminEnabled()) {
        setAdminEnabled(other.getAdminEnabled());
      }
      if (other.hasCustomerName()) {
        customerName_ = other.customerName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasFacility()) {
        facility_ = other.facility_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasInterconnectType()) {
        interconnectType_ = other.interconnectType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasLinkType()) {
        linkType_ = other.linkType_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasNocContactEmail()) {
        nocContactEmail_ = other.nocContactEmail_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasRemoteLocation()) {
        remoteLocation_ = other.remoteLocation_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.requestedFeatures_.isEmpty()) {
        if (requestedFeatures_.isEmpty()) {
          requestedFeatures_ = other.requestedFeatures_;
          bitField0_ |= 0x00000200;
        } else {
          ensureRequestedFeaturesIsMutable();
          requestedFeatures_.addAll(other.requestedFeatures_);
        }
        onChanged();
      }
      if (other.hasRequestedLinkCount()) {
        setRequestedLinkCount(other.getRequestedLinkCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26989658
            case 29323874:
              {
                customerName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 29323874
            case 112582658:
              {
                nocContactEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 112582658
            case 360411096:
              {
                requestedLinkCount_ = input.readInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 360411096
            case -1699857294:
              {
                remoteLocation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case -1699857294
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -729566584:
              {
                adminEnabled_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -729566584
            case -605040782:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRequestedFeaturesIsMutable();
                requestedFeatures_.add(s);
                break;
              } // case -605040782
            case -286034662:
              {
                facility_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -286034662
            case -173645222:
              {
                interconnectType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -173645222
            case -109305094:
              {
                linkType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -109305094
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean adminEnabled_;

    /**
     *
     *
     * <pre>
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return Whether the adminEnabled field is set.
     */
    @java.lang.Override
    public boolean hasAdminEnabled() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return The adminEnabled.
     */
    @java.lang.Override
    public boolean getAdminEnabled() {
      return adminEnabled_;
    }

    /**
     *
     *
     * <pre>
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @param value The adminEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setAdminEnabled(boolean value) {

      adminEnabled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdminEnabled() {
      bitField0_ = (bitField0_ & ~0x00000001);
      adminEnabled_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object customerName_ = "";

    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @return Whether the customerName field is set.
     */
    public boolean hasCustomerName() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @return The customerName.
     */
    public java.lang.String getCustomerName() {
      java.lang.Object ref = customerName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customerName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @return The bytes for customerName.
     */
    public com.google.protobuf.ByteString getCustomerNameBytes() {
      java.lang.Object ref = customerName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customerName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @param value The customerName to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customerName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomerName() {
      customerName_ = getDefaultInstance().getCustomerName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @param value The bytes for customerName to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customerName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object facility_ = "";

    /**
     *
     *
     * <pre>
     * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
     * </pre>
     *
     * <code>optional string facility = 501116579;</code>
     *
     * @return Whether the facility field is set.
     */
    public boolean hasFacility() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
     * </pre>
     *
     * <code>optional string facility = 501116579;</code>
     *
     * @return The facility.
     */
    public java.lang.String getFacility() {
      java.lang.Object ref = facility_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        facility_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
     * </pre>
     *
     * <code>optional string facility = 501116579;</code>
     *
     * @return The bytes for facility.
     */
    public com.google.protobuf.ByteString getFacilityBytes() {
      java.lang.Object ref = facility_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        facility_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
     * </pre>
     *
     * <code>optional string facility = 501116579;</code>
     *
     * @param value The facility to set.
     * @return This builder for chaining.
     */
    public Builder setFacility(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      facility_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
     * </pre>
     *
     * <code>optional string facility = 501116579;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFacility() {
      facility_ = getDefaultInstance().getFacility();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A zone-free location to use for all Interconnects created in this call, like "iad-1234".
     * </pre>
     *
     * <code>optional string facility = 501116579;</code>
     *
     * @param value The bytes for facility to set.
     * @return This builder for chaining.
     */
    public Builder setFacilityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      facility_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object interconnectType_ = "";

    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @return Whether the interconnectType field is set.
     */
    public boolean hasInterconnectType() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @return The interconnectType.
     */
    public java.lang.String getInterconnectType() {
      java.lang.Object ref = interconnectType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        interconnectType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @return The bytes for interconnectType.
     */
    public com.google.protobuf.ByteString getInterconnectTypeBytes() {
      java.lang.Object ref = interconnectType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        interconnectType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @param value The interconnectType to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnectType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      interconnectType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterconnectType() {
      interconnectType_ = getDefaultInstance().getInterconnectType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @param value The bytes for interconnectType to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnectTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      interconnectType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object linkType_ = "";

    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @return Whether the linkType field is set.
     */
    public boolean hasLinkType() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @return The linkType.
     */
    public java.lang.String getLinkType() {
      java.lang.Object ref = linkType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        linkType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @return The bytes for linkType.
     */
    public com.google.protobuf.ByteString getLinkTypeBytes() {
      java.lang.Object ref = linkType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        linkType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @param value The linkType to set.
     * @return This builder for chaining.
     */
    public Builder setLinkType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      linkType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinkType() {
      linkType_ = getDefaultInstance().getLinkType();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @param value The bytes for linkType to set.
     * @return This builder for chaining.
     */
    public Builder setLinkTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      linkType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the Interconnects to be created. This must be specified on the template and/or on each individual interconnect. The name, if not empty, must be 1-63 characters long, and comply with RFC1035. Specifically, any nonempty name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object nocContactEmail_ = "";

    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @return Whether the nocContactEmail field is set.
     */
    public boolean hasNocContactEmail() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @return The nocContactEmail.
     */
    public java.lang.String getNocContactEmail() {
      java.lang.Object ref = nocContactEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nocContactEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @return The bytes for nocContactEmail.
     */
    public com.google.protobuf.ByteString getNocContactEmailBytes() {
      java.lang.Object ref = nocContactEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nocContactEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @param value The nocContactEmail to set.
     * @return This builder for chaining.
     */
    public Builder setNocContactEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nocContactEmail_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNocContactEmail() {
      nocContactEmail_ = getDefaultInstance().getNocContactEmail();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @param value The bytes for nocContactEmail to set.
     * @return This builder for chaining.
     */
    public Builder setNocContactEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nocContactEmail_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object remoteLocation_ = "";

    /**
     *
     *
     * <pre>
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
     * </pre>
     *
     * <code>optional string remote_location = 324388750;</code>
     *
     * @return Whether the remoteLocation field is set.
     */
    public boolean hasRemoteLocation() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
     * </pre>
     *
     * <code>optional string remote_location = 324388750;</code>
     *
     * @return The remoteLocation.
     */
    public java.lang.String getRemoteLocation() {
      java.lang.Object ref = remoteLocation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        remoteLocation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
     * </pre>
     *
     * <code>optional string remote_location = 324388750;</code>
     *
     * @return The bytes for remoteLocation.
     */
    public com.google.protobuf.ByteString getRemoteLocationBytes() {
      java.lang.Object ref = remoteLocation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        remoteLocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
     * </pre>
     *
     * <code>optional string remote_location = 324388750;</code>
     *
     * @param value The remoteLocation to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      remoteLocation_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
     * </pre>
     *
     * <code>optional string remote_location = 324388750;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemoteLocation() {
      remoteLocation_ = getDefaultInstance().getRemoteLocation();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside of Google's network that the interconnect is connected to.
     * </pre>
     *
     * <code>optional string remote_location = 324388750;</code>
     *
     * @param value The bytes for remoteLocation to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      remoteLocation_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList requestedFeatures_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRequestedFeaturesIsMutable() {
      if (!requestedFeatures_.isModifiable()) {
        requestedFeatures_ = new com.google.protobuf.LazyStringArrayList(requestedFeatures_);
      }
      bitField0_ |= 0x00000200;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string requested_features = 461240814;</code>
     *
     * @return A list containing the requestedFeatures.
     */
    public com.google.protobuf.ProtocolStringList getRequestedFeaturesList() {
      requestedFeatures_.makeImmutable();
      return requestedFeatures_;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string requested_features = 461240814;</code>
     *
     * @return The count of requestedFeatures.
     */
    public int getRequestedFeaturesCount() {
      return requestedFeatures_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string requested_features = 461240814;</code>
     *
     * @param index The index of the element to return.
     * @return The requestedFeatures at the given index.
     */
    public java.lang.String getRequestedFeatures(int index) {
      return requestedFeatures_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string requested_features = 461240814;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the requestedFeatures at the given index.
     */
    public com.google.protobuf.ByteString getRequestedFeaturesBytes(int index) {
      return requestedFeatures_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string requested_features = 461240814;</code>
     *
     * @param index The index to set the value at.
     * @param value The requestedFeatures to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedFeatures(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequestedFeaturesIsMutable();
      requestedFeatures_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string requested_features = 461240814;</code>
     *
     * @param value The requestedFeatures to add.
     * @return This builder for chaining.
     */
    public Builder addRequestedFeatures(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequestedFeaturesIsMutable();
      requestedFeatures_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string requested_features = 461240814;</code>
     *
     * @param values The requestedFeatures to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequestedFeatures(java.lang.Iterable<java.lang.String> values) {
      ensureRequestedFeaturesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, requestedFeatures_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string requested_features = 461240814;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestedFeatures() {
      requestedFeatures_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of features requested for this Interconnect connection, which can take one of the following values: - IF_MACSEC If specified then the connection is created on MACsec capable hardware ports. If not specified, the default value is false, which allocates non-MACsec capable ports first if available. This parameter can be provided only with Interconnect INSERT. It isn't valid for Interconnect PATCH.
     * Check the RequestedFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string requested_features = 461240814;</code>
     *
     * @param value The bytes of the requestedFeatures to add.
     * @return This builder for chaining.
     */
    public Builder addRequestedFeaturesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRequestedFeaturesIsMutable();
      requestedFeatures_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private int requestedLinkCount_;

    /**
     *
     *
     * <pre>
     * Target number of physical links in the link bundle, as requested by the customer.
     * </pre>
     *
     * <code>optional int32 requested_link_count = 45051387;</code>
     *
     * @return Whether the requestedLinkCount field is set.
     */
    @java.lang.Override
    public boolean hasRequestedLinkCount() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Target number of physical links in the link bundle, as requested by the customer.
     * </pre>
     *
     * <code>optional int32 requested_link_count = 45051387;</code>
     *
     * @return The requestedLinkCount.
     */
    @java.lang.Override
    public int getRequestedLinkCount() {
      return requestedLinkCount_;
    }

    /**
     *
     *
     * <pre>
     * Target number of physical links in the link bundle, as requested by the customer.
     * </pre>
     *
     * <code>optional int32 requested_link_count = 45051387;</code>
     *
     * @param value The requestedLinkCount to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedLinkCount(int value) {

      requestedLinkCount_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Target number of physical links in the link bundle, as requested by the customer.
     * </pre>
     *
     * <code>optional int32 requested_link_count = 45051387;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestedLinkCount() {
      bitField0_ = (bitField0_ & ~0x00000400);
      requestedLinkCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput)
  private static final com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput();
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectGroupsCreateMembersInterconnectInput>
      PARSER =
          new com.google.protobuf.AbstractParser<
              InterconnectGroupsCreateMembersInterconnectInput>() {
            @java.lang.Override
            public InterconnectGroupsCreateMembersInterconnectInput parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<InterconnectGroupsCreateMembersInterconnectInput>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectGroupsCreateMembersInterconnectInput>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectGroupsCreateMembersInterconnectInput
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
