/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * An interconnect attachment group resource allows customers to create, analyze, and expand highly available deployments.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectAttachmentGroup}
 */
public final class InterconnectAttachmentGroup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectAttachmentGroup)
    InterconnectAttachmentGroupOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectAttachmentGroup.newBuilder() to construct.
  private InterconnectAttachmentGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectAttachmentGroup() {
    creationTimestamp_ = "";
    description_ = "";
    etag_ = "";
    interconnectGroup_ = "";
    kind_ = "";
    name_ = "";
    selfLink_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectAttachmentGroup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroup_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 334744496:
        return internalGetAttachments();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectAttachmentGroup.class,
            com.google.cloud.compute.v1.InterconnectAttachmentGroup.Builder.class);
  }

  private int bitField0_;
  public static final int ATTACHMENTS_FIELD_NUMBER = 334744496;

  private static final class AttachmentsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
                    newDefaultInstance(
                        com.google.cloud.compute.v1.Compute
                            .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroup_AttachmentsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
      attachments_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
      internalGetAttachments() {
    if (attachments_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AttachmentsDefaultEntryHolder.defaultEntry);
    }
    return attachments_;
  }

  public int getAttachmentsCount() {
    return internalGetAttachments().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
   * </code>
   */
  @java.lang.Override
  public boolean containsAttachments(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAttachments().getMap().containsKey(key);
  }

  /** Use {@link #getAttachmentsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
      getAttachments() {
    return getAttachmentsMap();
  }

  /**
   *
   *
   * <pre>
   * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
      getAttachmentsMap() {
    return internalGetAttachments().getMap();
  }

  /**
   *
   *
   * <pre>
   * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment
      getAttachmentsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
        map = internalGetAttachments().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment getAttachmentsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
        map = internalGetAttachments().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CONFIGURED_FIELD_NUMBER = 295631422;
  private com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured_;

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
   * </code>
   *
   * @return Whether the configured field is set.
   */
  @java.lang.Override
  public boolean hasConfigured() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
   * </code>
   *
   * @return The configured.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured getConfigured() {
    return configured_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured.getDefaultInstance()
        : configured_;
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredOrBuilder
      getConfiguredOrBuilder() {
    return configured_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured.getDefaultInstance()
        : configured_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 3123477;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by AIP 154.
   * </pre>
   *
   * <code>optional string etag = 3123477;</code>
   *
   * @return Whether the etag field is set.
   */
  @java.lang.Override
  public boolean hasEtag() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by AIP 154.
   * </pre>
   *
   * <code>optional string etag = 3123477;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by AIP 154.
   * </pre>
   *
   * <code>optional string etag = 3123477;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INTENT_FIELD_NUMBER = 426849948;
  private com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent_;

  /**
   * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
   * </code>
   *
   * @return Whether the intent field is set.
   */
  @java.lang.Override
  public boolean hasIntent() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
   * </code>
   *
   * @return The intent.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent getIntent() {
    return intent_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent.getDefaultInstance()
        : intent_;
  }

  /**
   * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentGroupIntentOrBuilder
      getIntentOrBuilder() {
    return intent_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent.getDefaultInstance()
        : intent_;
  }

  public static final int INTERCONNECT_GROUP_FIELD_NUMBER = 388651918;

  @SuppressWarnings("serial")
  private volatile java.lang.Object interconnectGroup_ = "";

  /**
   *
   *
   * <pre>
   * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not need to set this unless directed by Google Support.
   * </pre>
   *
   * <code>optional string interconnect_group = 388651918;</code>
   *
   * @return Whether the interconnectGroup field is set.
   */
  @java.lang.Override
  public boolean hasInterconnectGroup() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not need to set this unless directed by Google Support.
   * </pre>
   *
   * <code>optional string interconnect_group = 388651918;</code>
   *
   * @return The interconnectGroup.
   */
  @java.lang.Override
  public java.lang.String getInterconnectGroup() {
    java.lang.Object ref = interconnectGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      interconnectGroup_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not need to set this unless directed by Google Support.
   * </pre>
   *
   * <code>optional string interconnect_group = 388651918;</code>
   *
   * @return The bytes for interconnectGroup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInterconnectGroupBytes() {
    java.lang.Object ref = interconnectGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      interconnectGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOGICAL_STRUCTURE_FIELD_NUMBER = 142412989;
  private com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logicalStructure_;

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
   * </code>
   *
   * @return Whether the logicalStructure field is set.
   */
  @java.lang.Override
  public boolean hasLogicalStructure() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
   * </code>
   *
   * @return The logicalStructure.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure
      getLogicalStructure() {
    return logicalStructure_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure
            .getDefaultInstance()
        : logicalStructure_;
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructureOrBuilder
      getLogicalStructureOrBuilder() {
    return logicalStructure_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure
            .getDefaultInstance()
        : logicalStructure_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3123477, etag_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(142412989, getLogicalStructure());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(295631422, getConfigured());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAttachments(), AttachmentsDefaultEntryHolder.defaultEntry, 334744496);
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 388651918, interconnectGroup_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(426849948, getIntent());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3123477, etag_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              142412989, getLogicalStructure());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(295631422, getConfigured());
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
        entry : internalGetAttachments().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
          attachments__ =
              AttachmentsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(334744496, attachments__);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(388651918, interconnectGroup_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(426849948, getIntent());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InterconnectAttachmentGroup)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectAttachmentGroup other =
        (com.google.cloud.compute.v1.InterconnectAttachmentGroup) obj;

    if (!internalGetAttachments().equals(other.internalGetAttachments())) return false;
    if (hasConfigured() != other.hasConfigured()) return false;
    if (hasConfigured()) {
      if (!getConfigured().equals(other.getConfigured())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEtag() != other.hasEtag()) return false;
    if (hasEtag()) {
      if (!getEtag().equals(other.getEtag())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasIntent() != other.hasIntent()) return false;
    if (hasIntent()) {
      if (!getIntent().equals(other.getIntent())) return false;
    }
    if (hasInterconnectGroup() != other.hasInterconnectGroup()) return false;
    if (hasInterconnectGroup()) {
      if (!getInterconnectGroup().equals(other.getInterconnectGroup())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLogicalStructure() != other.hasLogicalStructure()) return false;
    if (hasLogicalStructure()) {
      if (!getLogicalStructure().equals(other.getLogicalStructure())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetAttachments().getMap().isEmpty()) {
      hash = (37 * hash) + ATTACHMENTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAttachments().hashCode();
    }
    if (hasConfigured()) {
      hash = (37 * hash) + CONFIGURED_FIELD_NUMBER;
      hash = (53 * hash) + getConfigured().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEtag()) {
      hash = (37 * hash) + ETAG_FIELD_NUMBER;
      hash = (53 * hash) + getEtag().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasIntent()) {
      hash = (37 * hash) + INTENT_FIELD_NUMBER;
      hash = (53 * hash) + getIntent().hashCode();
    }
    if (hasInterconnectGroup()) {
      hash = (37 * hash) + INTERCONNECT_GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getInterconnectGroup().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLogicalStructure()) {
      hash = (37 * hash) + LOGICAL_STRUCTURE_FIELD_NUMBER;
      hash = (53 * hash) + getLogicalStructure().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectAttachmentGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An interconnect attachment group resource allows customers to create, analyze, and expand highly available deployments.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectAttachmentGroup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectAttachmentGroup)
      com.google.cloud.compute.v1.InterconnectAttachmentGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroup_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 334744496:
          return internalGetAttachments();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 334744496:
          return internalGetMutableAttachments();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectAttachmentGroup.class,
              com.google.cloud.compute.v1.InterconnectAttachmentGroup.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InterconnectAttachmentGroup.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfiguredFieldBuilder();
        getIntentFieldBuilder();
        getLogicalStructureFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableAttachments().clear();
      configured_ = null;
      if (configuredBuilder_ != null) {
        configuredBuilder_.dispose();
        configuredBuilder_ = null;
      }
      creationTimestamp_ = "";
      description_ = "";
      etag_ = "";
      id_ = 0L;
      intent_ = null;
      if (intentBuilder_ != null) {
        intentBuilder_.dispose();
        intentBuilder_ = null;
      }
      interconnectGroup_ = "";
      kind_ = "";
      logicalStructure_ = null;
      if (logicalStructureBuilder_ != null) {
        logicalStructureBuilder_.dispose();
        logicalStructureBuilder_ = null;
      }
      name_ = "";
      selfLink_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachmentGroup getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectAttachmentGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachmentGroup build() {
      com.google.cloud.compute.v1.InterconnectAttachmentGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachmentGroup buildPartial() {
      com.google.cloud.compute.v1.InterconnectAttachmentGroup result =
          new com.google.cloud.compute.v1.InterconnectAttachmentGroup(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.InterconnectAttachmentGroup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.attachments_ =
            internalGetAttachments().build(AttachmentsDefaultEntryHolder.defaultEntry);
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.configured_ = configuredBuilder_ == null ? configured_ : configuredBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.etag_ = etag_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.intent_ = intentBuilder_ == null ? intent_ : intentBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.interconnectGroup_ = interconnectGroup_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.logicalStructure_ =
            logicalStructureBuilder_ == null ? logicalStructure_ : logicalStructureBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000400;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InterconnectAttachmentGroup) {
        return mergeFrom((com.google.cloud.compute.v1.InterconnectAttachmentGroup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InterconnectAttachmentGroup other) {
      if (other == com.google.cloud.compute.v1.InterconnectAttachmentGroup.getDefaultInstance())
        return this;
      internalGetMutableAttachments().mergeFrom(other.internalGetAttachments());
      bitField0_ |= 0x00000001;
      if (other.hasConfigured()) {
        mergeConfigured(other.getConfigured());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasEtag()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasIntent()) {
        mergeIntent(other.getIntent());
      }
      if (other.hasInterconnectGroup()) {
        interconnectGroup_ = other.interconnectGroup_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasLogicalStructure()) {
        mergeLogicalStructure(other.getLogicalStructure());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 26840
            case 24987818:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 24987818
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 1139303914:
              {
                input.readMessage(
                    getLogicalStructureFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 1139303914
            case -1929915918:
              {
                input.readMessage(getConfiguredFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1929915918
            case -1617011326:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
                    attachments__ =
                        input.readMessage(
                            AttachmentsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableAttachments()
                    .ensureBuilderMap()
                    .put(attachments__.getKey(), attachments__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case -1617011326
            case -1185751950:
              {
                interconnectGroup_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -1185751950
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -911466526
            case -880167710:
              {
                input.readMessage(getIntentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case -880167710
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -645248918
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private static final class AttachmentsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachmentOrBuilder,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment> {
      @java.lang.Override
      public com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment build(
          com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachmentOrBuilder val) {
        if (val instanceof com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment) {
          return (com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment) val;
        }
        return ((com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment.Builder) val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
          defaultEntry() {
        return AttachmentsDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final AttachmentsConverter attachmentsConverter = new AttachmentsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachmentOrBuilder,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment.Builder>
        attachments_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachmentOrBuilder,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment.Builder>
        internalGetAttachments() {
      if (attachments_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(attachmentsConverter);
      }
      return attachments_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachmentOrBuilder,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment.Builder>
        internalGetMutableAttachments() {
      if (attachments_ == null) {
        attachments_ = new com.google.protobuf.MapFieldBuilder<>(attachmentsConverter);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return attachments_;
    }

    public int getAttachmentsCount() {
      return internalGetAttachments().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
     * </code>
     */
    @java.lang.Override
    public boolean containsAttachments(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttachments().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getAttachmentsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
        getAttachments() {
      return getAttachmentsMap();
    }

    /**
     *
     *
     * <pre>
     * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
        getAttachmentsMap() {
      return internalGetAttachments().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment
        getAttachmentsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachmentOrBuilder>
          map = internalGetMutableAttachments().ensureBuilderMap();
      return map.containsKey(key) ? attachmentsConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment getAttachmentsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachmentOrBuilder>
          map = internalGetMutableAttachments().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return attachmentsConverter.build(map.get(key));
    }

    public Builder clearAttachments() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableAttachments().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
     * </code>
     */
    public Builder removeAttachments(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAttachments().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
        getMutableAttachments() {
      bitField0_ |= 0x00000001;
      return internalGetMutableAttachments().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
     * </code>
     */
    public Builder putAttachments(
        java.lang.String key,
        com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAttachments().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
     * </code>
     */
    public Builder putAllAttachments(
        java.util.Map<
                java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableAttachments().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Attachments in the AttachmentGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Attachments per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectAttachmentGroupAttachment&gt; attachments = 334744496;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment.Builder
        putAttachmentsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachmentOrBuilder>
          builderMap = internalGetMutableAttachments().ensureBuilderMap();
      com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachmentOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment) {
        entry =
            ((com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.compute.v1.InterconnectAttachmentGroupAttachment.Builder) entry;
    }

    private com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredOrBuilder>
        configuredBuilder_;

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
     * </code>
     *
     * @return Whether the configured field is set.
     */
    public boolean hasConfigured() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
     * </code>
     *
     * @return The configured.
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured getConfigured() {
      if (configuredBuilder_ == null) {
        return configured_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured.getDefaultInstance()
            : configured_;
      } else {
        return configuredBuilder_.getMessage();
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
     * </code>
     */
    public Builder setConfigured(
        com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured value) {
      if (configuredBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configured_ = value;
      } else {
        configuredBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
     * </code>
     */
    public Builder setConfigured(
        com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured.Builder builderForValue) {
      if (configuredBuilder_ == null) {
        configured_ = builderForValue.build();
      } else {
        configuredBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
     * </code>
     */
    public Builder mergeConfigured(
        com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured value) {
      if (configuredBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && configured_ != null
            && configured_
                != com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured
                    .getDefaultInstance()) {
          getConfiguredBuilder().mergeFrom(value);
        } else {
          configured_ = value;
        }
      } else {
        configuredBuilder_.mergeFrom(value);
      }
      if (configured_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
     * </code>
     */
    public Builder clearConfigured() {
      bitField0_ = (bitField0_ & ~0x00000002);
      configured_ = null;
      if (configuredBuilder_ != null) {
        configuredBuilder_.dispose();
        configuredBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured.Builder
        getConfiguredBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConfiguredFieldBuilder().getBuilder();
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredOrBuilder
        getConfiguredOrBuilder() {
      if (configuredBuilder_ != null) {
        return configuredBuilder_.getMessageOrBuilder();
      } else {
        return configured_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured.getDefaultInstance()
            : configured_;
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupConfigured configured = 295631422;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredOrBuilder>
        getConfiguredFieldBuilder() {
      if (configuredBuilder_ == null) {
        configuredBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured,
                com.google.cloud.compute.v1.InterconnectAttachmentGroupConfigured.Builder,
                com.google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredOrBuilder>(
                getConfigured(), getParentForChildren(), isClean());
        configured_ = null;
      }
      return configuredBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by AIP 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return Whether the etag field is set.
     */
    public boolean hasEtag() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by AIP 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by AIP 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by AIP 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by AIP 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by AIP 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000020);
      id_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupIntentOrBuilder>
        intentBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
     * </code>
     *
     * @return Whether the intent field is set.
     */
    public boolean hasIntent() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
     * </code>
     *
     * @return The intent.
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent getIntent() {
      if (intentBuilder_ == null) {
        return intent_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent.getDefaultInstance()
            : intent_;
      } else {
        return intentBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
     * </code>
     */
    public Builder setIntent(com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent value) {
      if (intentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        intent_ = value;
      } else {
        intentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
     * </code>
     */
    public Builder setIntent(
        com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent.Builder builderForValue) {
      if (intentBuilder_ == null) {
        intent_ = builderForValue.build();
      } else {
        intentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
     * </code>
     */
    public Builder mergeIntent(
        com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent value) {
      if (intentBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && intent_ != null
            && intent_
                != com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent
                    .getDefaultInstance()) {
          getIntentBuilder().mergeFrom(value);
        } else {
          intent_ = value;
        }
      } else {
        intentBuilder_.mergeFrom(value);
      }
      if (intent_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
     * </code>
     */
    public Builder clearIntent() {
      bitField0_ = (bitField0_ & ~0x00000040);
      intent_ = null;
      if (intentBuilder_ != null) {
        intentBuilder_.dispose();
        intentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent.Builder
        getIntentBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getIntentFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupIntentOrBuilder
        getIntentOrBuilder() {
      if (intentBuilder_ != null) {
        return intentBuilder_.getMessageOrBuilder();
      } else {
        return intent_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent.getDefaultInstance()
            : intent_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectAttachmentGroupIntent intent = 426849948;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupIntentOrBuilder>
        getIntentFieldBuilder() {
      if (intentBuilder_ == null) {
        intentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent,
                com.google.cloud.compute.v1.InterconnectAttachmentGroupIntent.Builder,
                com.google.cloud.compute.v1.InterconnectAttachmentGroupIntentOrBuilder>(
                getIntent(), getParentForChildren(), isClean());
        intent_ = null;
      }
      return intentBuilder_;
    }

    private java.lang.Object interconnectGroup_ = "";

    /**
     *
     *
     * <pre>
     * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not need to set this unless directed by Google Support.
     * </pre>
     *
     * <code>optional string interconnect_group = 388651918;</code>
     *
     * @return Whether the interconnectGroup field is set.
     */
    public boolean hasInterconnectGroup() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not need to set this unless directed by Google Support.
     * </pre>
     *
     * <code>optional string interconnect_group = 388651918;</code>
     *
     * @return The interconnectGroup.
     */
    public java.lang.String getInterconnectGroup() {
      java.lang.Object ref = interconnectGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        interconnectGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not need to set this unless directed by Google Support.
     * </pre>
     *
     * <code>optional string interconnect_group = 388651918;</code>
     *
     * @return The bytes for interconnectGroup.
     */
    public com.google.protobuf.ByteString getInterconnectGroupBytes() {
      java.lang.Object ref = interconnectGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        interconnectGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not need to set this unless directed by Google Support.
     * </pre>
     *
     * <code>optional string interconnect_group = 388651918;</code>
     *
     * @param value The interconnectGroup to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnectGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      interconnectGroup_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not need to set this unless directed by Google Support.
     * </pre>
     *
     * <code>optional string interconnect_group = 388651918;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterconnectGroup() {
      interconnectGroup_ = getDefaultInstance().getInterconnectGroup();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URL of an InterconnectGroup that groups these Attachments' Interconnects. Customers do not need to set this unless directed by Google Support.
     * </pre>
     *
     * <code>optional string interconnect_group = 388651918;</code>
     *
     * @param value The bytes for interconnectGroup to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnectGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      interconnectGroup_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachmentGroup.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure
        logicalStructure_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructureOrBuilder>
        logicalStructureBuilder_;

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
     * </code>
     *
     * @return Whether the logicalStructure field is set.
     */
    public boolean hasLogicalStructure() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
     * </code>
     *
     * @return The logicalStructure.
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure
        getLogicalStructure() {
      if (logicalStructureBuilder_ == null) {
        return logicalStructure_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure
                .getDefaultInstance()
            : logicalStructure_;
      } else {
        return logicalStructureBuilder_.getMessage();
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
     * </code>
     */
    public Builder setLogicalStructure(
        com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure value) {
      if (logicalStructureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logicalStructure_ = value;
      } else {
        logicalStructureBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
     * </code>
     */
    public Builder setLogicalStructure(
        com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure.Builder
            builderForValue) {
      if (logicalStructureBuilder_ == null) {
        logicalStructure_ = builderForValue.build();
      } else {
        logicalStructureBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
     * </code>
     */
    public Builder mergeLogicalStructure(
        com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure value) {
      if (logicalStructureBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && logicalStructure_ != null
            && logicalStructure_
                != com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure
                    .getDefaultInstance()) {
          getLogicalStructureBuilder().mergeFrom(value);
        } else {
          logicalStructure_ = value;
        }
      } else {
        logicalStructureBuilder_.mergeFrom(value);
      }
      if (logicalStructure_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
     * </code>
     */
    public Builder clearLogicalStructure() {
      bitField0_ = (bitField0_ & ~0x00000200);
      logicalStructure_ = null;
      if (logicalStructureBuilder_ != null) {
        logicalStructureBuilder_.dispose();
        logicalStructureBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure.Builder
        getLogicalStructureBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getLogicalStructureFieldBuilder().getBuilder();
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructureOrBuilder
        getLogicalStructureOrBuilder() {
      if (logicalStructureBuilder_ != null) {
        return logicalStructureBuilder_.getMessageOrBuilder();
      } else {
        return logicalStructure_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure
                .getDefaultInstance()
            : logicalStructure_;
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure logical_structure = 142412989;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructureOrBuilder>
        getLogicalStructureFieldBuilder() {
      if (logicalStructureBuilder_ == null) {
        logicalStructureBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure,
                com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructure.Builder,
                com.google.cloud.compute.v1.InterconnectAttachmentGroupLogicalStructureOrBuilder>(
                getLogicalStructure(), getParentForChildren(), isClean());
        logicalStructure_ = null;
      }
      return logicalStructureBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectAttachmentGroup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectAttachmentGroup)
  private static final com.google.cloud.compute.v1.InterconnectAttachmentGroup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InterconnectAttachmentGroup();
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectAttachmentGroup> PARSER =
      new com.google.protobuf.AbstractParser<InterconnectAttachmentGroup>() {
        @java.lang.Override
        public InterconnectAttachmentGroup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InterconnectAttachmentGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectAttachmentGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentGroup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
