/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FrameworkName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_FRAMEWORK = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/frameworks/{framework}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String framework;

    @Deprecated
    protected FrameworkName() {
        this.organization = null;
        this.location = null;
        this.framework = null;
    }

    private FrameworkName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.framework = (String)Preconditions.checkNotNull((Object)builder.getFramework());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFramework() {
        return this.framework;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FrameworkName of(String organization, String location, String framework) {
        return FrameworkName.newBuilder().setOrganization(organization).setLocation(location).setFramework(framework).build();
    }

    public static String format(String organization, String location, String framework) {
        return FrameworkName.newBuilder().setOrganization(organization).setLocation(location).setFramework(framework).build().toString();
    }

    public static FrameworkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_FRAMEWORK.validatedMatch(formattedString, "FrameworkName.parse: formattedString not in valid format");
        return FrameworkName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("framework"));
    }

    public static List<FrameworkName> parseList(List<String> formattedStrings) {
        ArrayList<FrameworkName> list = new ArrayList<FrameworkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FrameworkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FrameworkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FrameworkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_FRAMEWORK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FrameworkName frameworkName = this;
            synchronized (frameworkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.framework != null) {
                        fieldMapBuilder.put((Object)"framework", (Object)this.framework);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_FRAMEWORK.instantiate(new String[]{"organization", this.organization, "location", this.location, "framework", this.framework});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FrameworkName that = (FrameworkName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.framework, that.framework);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.framework);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String framework;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFramework() {
            return this.framework;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFramework(String framework) {
            this.framework = framework;
            return this;
        }

        private Builder(FrameworkName frameworkName) {
            this.organization = frameworkName.organization;
            this.location = frameworkName.location;
            this.framework = frameworkName.framework;
        }

        public FrameworkName build() {
            return new FrameworkName(this);
        }
    }
}

