/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FrameworkComplianceReportName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/frameworkComplianceReports/{framework_compliance_report}");
    private static final PathTemplate FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_REPORT = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/frameworkComplianceReports/{framework_compliance_report}");
    private static final PathTemplate ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_REPORT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/frameworkComplianceReports/{framework_compliance_report}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String frameworkComplianceReport;
    private final String folder;
    private final String organization;

    @Deprecated
    protected FrameworkComplianceReportName() {
        this.project = null;
        this.location = null;
        this.frameworkComplianceReport = null;
        this.folder = null;
        this.organization = null;
    }

    private FrameworkComplianceReportName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkComplianceReport = (String)Preconditions.checkNotNull((Object)builder.getFrameworkComplianceReport());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT;
    }

    private FrameworkComplianceReportName(FolderLocationFrameworkComplianceReportBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkComplianceReport = (String)Preconditions.checkNotNull((Object)builder.getFrameworkComplianceReport());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_REPORT;
    }

    private FrameworkComplianceReportName(OrganizationLocationFrameworkComplianceReportBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkComplianceReport = (String)Preconditions.checkNotNull((Object)builder.getFrameworkComplianceReport());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_REPORT;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFrameworkComplianceReport() {
        return this.frameworkComplianceReport;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationFrameworkComplianceReportBuilder() {
        return new Builder();
    }

    public static FolderLocationFrameworkComplianceReportBuilder newFolderLocationFrameworkComplianceReportBuilder() {
        return new FolderLocationFrameworkComplianceReportBuilder();
    }

    public static OrganizationLocationFrameworkComplianceReportBuilder newOrganizationLocationFrameworkComplianceReportBuilder() {
        return new OrganizationLocationFrameworkComplianceReportBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FrameworkComplianceReportName of(String project, String location, String frameworkComplianceReport) {
        return FrameworkComplianceReportName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).build();
    }

    public static FrameworkComplianceReportName ofProjectLocationFrameworkComplianceReportName(String project, String location, String frameworkComplianceReport) {
        return FrameworkComplianceReportName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).build();
    }

    public static FrameworkComplianceReportName ofFolderLocationFrameworkComplianceReportName(String folder, String location, String frameworkComplianceReport) {
        return FrameworkComplianceReportName.newFolderLocationFrameworkComplianceReportBuilder().setFolder(folder).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).build();
    }

    public static FrameworkComplianceReportName ofOrganizationLocationFrameworkComplianceReportName(String organization, String location, String frameworkComplianceReport) {
        return FrameworkComplianceReportName.newOrganizationLocationFrameworkComplianceReportBuilder().setOrganization(organization).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).build();
    }

    public static String format(String project, String location, String frameworkComplianceReport) {
        return FrameworkComplianceReportName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).build().toString();
    }

    public static String formatProjectLocationFrameworkComplianceReportName(String project, String location, String frameworkComplianceReport) {
        return FrameworkComplianceReportName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).build().toString();
    }

    public static String formatFolderLocationFrameworkComplianceReportName(String folder, String location, String frameworkComplianceReport) {
        return FrameworkComplianceReportName.newFolderLocationFrameworkComplianceReportBuilder().setFolder(folder).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).build().toString();
    }

    public static String formatOrganizationLocationFrameworkComplianceReportName(String organization, String location, String frameworkComplianceReport) {
        return FrameworkComplianceReportName.newOrganizationLocationFrameworkComplianceReportBuilder().setOrganization(organization).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).build().toString();
    }

    public static FrameworkComplianceReportName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT.match(formattedString);
            return FrameworkComplianceReportName.ofProjectLocationFrameworkComplianceReportName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("framework_compliance_report"));
        }
        if (FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_REPORT.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_REPORT.match(formattedString);
            return FrameworkComplianceReportName.ofFolderLocationFrameworkComplianceReportName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("framework_compliance_report"));
        }
        if (ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_REPORT.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_REPORT.match(formattedString);
            return FrameworkComplianceReportName.ofOrganizationLocationFrameworkComplianceReportName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("framework_compliance_report"));
        }
        throw new ValidationException("FrameworkComplianceReportName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<FrameworkComplianceReportName> parseList(List<String> formattedStrings) {
        ArrayList<FrameworkComplianceReportName> list = new ArrayList<FrameworkComplianceReportName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FrameworkComplianceReportName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FrameworkComplianceReportName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FrameworkComplianceReportName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT.matches(formattedString) || FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_REPORT.matches(formattedString) || ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_REPORT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FrameworkComplianceReportName frameworkComplianceReportName = this;
            synchronized (frameworkComplianceReportName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.frameworkComplianceReport != null) {
                        fieldMapBuilder.put((Object)"framework_compliance_report", (Object)this.frameworkComplianceReport);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FrameworkComplianceReportName that = (FrameworkComplianceReportName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.frameworkComplianceReport, that.frameworkComplianceReport) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.frameworkComplianceReport);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationFrameworkComplianceReportBuilder {
        private String organization;
        private String location;
        private String frameworkComplianceReport;

        protected OrganizationLocationFrameworkComplianceReportBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkComplianceReport() {
            return this.frameworkComplianceReport;
        }

        public OrganizationLocationFrameworkComplianceReportBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationFrameworkComplianceReportBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationFrameworkComplianceReportBuilder setFrameworkComplianceReport(String frameworkComplianceReport) {
            this.frameworkComplianceReport = frameworkComplianceReport;
            return this;
        }

        public FrameworkComplianceReportName build() {
            return new FrameworkComplianceReportName(this);
        }
    }

    public static class FolderLocationFrameworkComplianceReportBuilder {
        private String folder;
        private String location;
        private String frameworkComplianceReport;

        protected FolderLocationFrameworkComplianceReportBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkComplianceReport() {
            return this.frameworkComplianceReport;
        }

        public FolderLocationFrameworkComplianceReportBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationFrameworkComplianceReportBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationFrameworkComplianceReportBuilder setFrameworkComplianceReport(String frameworkComplianceReport) {
            this.frameworkComplianceReport = frameworkComplianceReport;
            return this;
        }

        public FrameworkComplianceReportName build() {
            return new FrameworkComplianceReportName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String frameworkComplianceReport;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkComplianceReport() {
            return this.frameworkComplianceReport;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFrameworkComplianceReport(String frameworkComplianceReport) {
            this.frameworkComplianceReport = frameworkComplianceReport;
            return this;
        }

        private Builder(FrameworkComplianceReportName frameworkComplianceReportName) {
            Preconditions.checkArgument((boolean)Objects.equals(frameworkComplianceReportName.pathTemplate, PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT), (Object)"toBuilder is only supported when FrameworkComplianceReportName has the pattern of projects/{project}/locations/{location}/frameworkComplianceReports/{framework_compliance_report}");
            this.project = frameworkComplianceReportName.project;
            this.location = frameworkComplianceReportName.location;
            this.frameworkComplianceReport = frameworkComplianceReportName.frameworkComplianceReport;
        }

        public FrameworkComplianceReportName build() {
            return new FrameworkComplianceReportName(this);
        }
    }
}

