/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FrameworkDeploymentName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_FRAMEWORK_DEPLOYMENT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/frameworkDeployments/{framework_deployment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String frameworkDeployment;

    @Deprecated
    protected FrameworkDeploymentName() {
        this.organization = null;
        this.location = null;
        this.frameworkDeployment = null;
    }

    private FrameworkDeploymentName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkDeployment = (String)Preconditions.checkNotNull((Object)builder.getFrameworkDeployment());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFrameworkDeployment() {
        return this.frameworkDeployment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FrameworkDeploymentName of(String organization, String location, String frameworkDeployment) {
        return FrameworkDeploymentName.newBuilder().setOrganization(organization).setLocation(location).setFrameworkDeployment(frameworkDeployment).build();
    }

    public static String format(String organization, String location, String frameworkDeployment) {
        return FrameworkDeploymentName.newBuilder().setOrganization(organization).setLocation(location).setFrameworkDeployment(frameworkDeployment).build().toString();
    }

    public static FrameworkDeploymentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_FRAMEWORK_DEPLOYMENT.validatedMatch(formattedString, "FrameworkDeploymentName.parse: formattedString not in valid format");
        return FrameworkDeploymentName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("framework_deployment"));
    }

    public static List<FrameworkDeploymentName> parseList(List<String> formattedStrings) {
        ArrayList<FrameworkDeploymentName> list = new ArrayList<FrameworkDeploymentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FrameworkDeploymentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FrameworkDeploymentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FrameworkDeploymentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_FRAMEWORK_DEPLOYMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FrameworkDeploymentName frameworkDeploymentName = this;
            synchronized (frameworkDeploymentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.frameworkDeployment != null) {
                        fieldMapBuilder.put((Object)"framework_deployment", (Object)this.frameworkDeployment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_FRAMEWORK_DEPLOYMENT.instantiate(new String[]{"organization", this.organization, "location", this.location, "framework_deployment", this.frameworkDeployment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FrameworkDeploymentName that = (FrameworkDeploymentName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.frameworkDeployment, that.frameworkDeployment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.frameworkDeployment);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String frameworkDeployment;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkDeployment() {
            return this.frameworkDeployment;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFrameworkDeployment(String frameworkDeployment) {
            this.frameworkDeployment = frameworkDeployment;
            return this;
        }

        private Builder(FrameworkDeploymentName frameworkDeploymentName) {
            this.organization = frameworkDeploymentName.organization;
            this.location = frameworkDeploymentName.location;
            this.frameworkDeployment = frameworkDeploymentName.frameworkDeployment;
        }

        public FrameworkDeploymentName build() {
            return new FrameworkDeploymentName(this);
        }
    }
}

