/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CloudControlDeploymentName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_CLOUD_CONTROL_DEPLOYMENT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/cloudControlDeployments/{cloud_control_deployment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String cloudControlDeployment;

    @Deprecated
    protected CloudControlDeploymentName() {
        this.organization = null;
        this.location = null;
        this.cloudControlDeployment = null;
    }

    private CloudControlDeploymentName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cloudControlDeployment = (String)Preconditions.checkNotNull((Object)builder.getCloudControlDeployment());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCloudControlDeployment() {
        return this.cloudControlDeployment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CloudControlDeploymentName of(String organization, String location, String cloudControlDeployment) {
        return CloudControlDeploymentName.newBuilder().setOrganization(organization).setLocation(location).setCloudControlDeployment(cloudControlDeployment).build();
    }

    public static String format(String organization, String location, String cloudControlDeployment) {
        return CloudControlDeploymentName.newBuilder().setOrganization(organization).setLocation(location).setCloudControlDeployment(cloudControlDeployment).build().toString();
    }

    public static CloudControlDeploymentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_CLOUD_CONTROL_DEPLOYMENT.validatedMatch(formattedString, "CloudControlDeploymentName.parse: formattedString not in valid format");
        return CloudControlDeploymentName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("cloud_control_deployment"));
    }

    public static List<CloudControlDeploymentName> parseList(List<String> formattedStrings) {
        ArrayList<CloudControlDeploymentName> list = new ArrayList<CloudControlDeploymentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CloudControlDeploymentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CloudControlDeploymentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CloudControlDeploymentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_CLOUD_CONTROL_DEPLOYMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CloudControlDeploymentName cloudControlDeploymentName = this;
            synchronized (cloudControlDeploymentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cloudControlDeployment != null) {
                        fieldMapBuilder.put((Object)"cloud_control_deployment", (Object)this.cloudControlDeployment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_CLOUD_CONTROL_DEPLOYMENT.instantiate(new String[]{"organization", this.organization, "location", this.location, "cloud_control_deployment", this.cloudControlDeployment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CloudControlDeploymentName that = (CloudControlDeploymentName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.cloudControlDeployment, that.cloudControlDeployment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cloudControlDeployment);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String cloudControlDeployment;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCloudControlDeployment() {
            return this.cloudControlDeployment;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCloudControlDeployment(String cloudControlDeployment) {
            this.cloudControlDeployment = cloudControlDeployment;
            return this;
        }

        private Builder(CloudControlDeploymentName cloudControlDeploymentName) {
            this.organization = cloudControlDeploymentName.organization;
            this.location = cloudControlDeploymentName.location;
            this.cloudControlDeployment = cloudControlDeploymentName.cloudControlDeployment;
        }

        public CloudControlDeploymentName build() {
            return new CloudControlDeploymentName(this);
        }
    }
}

