/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/cloudquotas/v1/resources.proto

// Protobuf Java Version: 3.25.8
package com.google.api.cloudquotas.v1;

/**
 *
 *
 * <pre>
 * QuotaPreference represents the preferred quota configuration specified for
 * a project, folder or organization. There is only one QuotaPreference
 * resource for a quota value targeting a unique set of dimensions.
 * </pre>
 *
 * Protobuf type {@code google.api.cloudquotas.v1.QuotaPreference}
 */
public final class QuotaPreference extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.cloudquotas.v1.QuotaPreference)
    QuotaPreferenceOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use QuotaPreference.newBuilder() to construct.
  private QuotaPreference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QuotaPreference() {
    name_ = "";
    etag_ = "";
    service_ = "";
    quotaId_ = "";
    justification_ = "";
    contactEmail_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QuotaPreference();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.cloudquotas.v1.ResourcesProto
        .internal_static_google_api_cloudquotas_v1_QuotaPreference_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetDimensions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.cloudquotas.v1.ResourcesProto
        .internal_static_google_api_cloudquotas_v1_QuotaPreference_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.cloudquotas.v1.QuotaPreference.class,
            com.google.api.cloudquotas.v1.QuotaPreference.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required except in the CREATE requests.
   * The resource name of the quota preference.
   * The ID component following "locations/" must be "global".
   * Example:
   * `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required except in the CREATE requests.
   * The resource name of the quota preference.
   * The ID component following "locations/" must be "global".
   * Example:
   * `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 2;

  private static final class DimensionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.api.cloudquotas.v1.ResourcesProto
                .internal_static_google_api_cloudquotas_v1_QuotaPreference_DimensionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetDimensions() {
    if (dimensions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(DimensionsDefaultEntryHolder.defaultEntry);
    }
    return dimensions_;
  }

  public int getDimensionsCount() {
    return internalGetDimensions().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Immutable. The dimensions that this quota preference applies to. The key of
   * the map entry is the name of a dimension, such as "region", "zone",
   * "network_id", and the value of the map entry is the dimension value.
   *
   * If a dimension is missing from the map of dimensions, the quota preference
   * applies to all the dimension values except for those that have other quota
   * preferences configured for the specific value.
   *
   * NOTE: QuotaPreferences can only be applied across all values of "user" and
   * "resource" dimension. Do not set values for "user" or "resource" in the
   * dimension map.
   *
   * Example: {"provider", "Foo Inc"} where "provider" is a service specific
   * dimension.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public boolean containsDimensions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDimensions().getMap().containsKey(key);
  }

  /** Use {@link #getDimensionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
    return getDimensionsMap();
  }

  /**
   *
   *
   * <pre>
   * Immutable. The dimensions that this quota preference applies to. The key of
   * the map entry is the name of a dimension, such as "region", "zone",
   * "network_id", and the value of the map entry is the dimension value.
   *
   * If a dimension is missing from the map of dimensions, the quota preference
   * applies to all the dimension values except for those that have other quota
   * preferences configured for the specific value.
   *
   * NOTE: QuotaPreferences can only be applied across all values of "user" and
   * "resource" dimension. Do not set values for "user" or "resource" in the
   * dimension map.
   *
   * Example: {"provider", "Foo Inc"} where "provider" is a service specific
   * dimension.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
    return internalGetDimensions().getMap();
  }

  /**
   *
   *
   * <pre>
   * Immutable. The dimensions that this quota preference applies to. The key of
   * the map entry is the name of a dimension, such as "region", "zone",
   * "network_id", and the value of the map entry is the dimension value.
   *
   * If a dimension is missing from the map of dimensions, the quota preference
   * applies to all the dimension values except for those that have other quota
   * preferences configured for the specific value.
   *
   * NOTE: QuotaPreferences can only be applied across all values of "user" and
   * "resource" dimension. Do not set values for "user" or "resource" in the
   * dimension map.
   *
   * Example: {"provider", "Foo Inc"} where "provider" is a service specific
   * dimension.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getDimensionsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Immutable. The dimensions that this quota preference applies to. The key of
   * the map entry is the name of a dimension, such as "region", "zone",
   * "network_id", and the value of the map entry is the dimension value.
   *
   * If a dimension is missing from the map of dimensions, the quota preference
   * applies to all the dimension values except for those that have other quota
   * preferences configured for the specific value.
   *
   * NOTE: QuotaPreferences can only be applied across all values of "user" and
   * "resource" dimension. Do not set values for "user" or "resource" in the
   * dimension map.
   *
   * Example: {"provider", "Foo Inc"} where "provider" is a service specific
   * dimension.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getDimensionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int QUOTA_CONFIG_FIELD_NUMBER = 3;
  private com.google.api.cloudquotas.v1.QuotaConfig quotaConfig_;

  /**
   *
   *
   * <pre>
   * Required. Preferred quota configuration.
   * </pre>
   *
   * <code>
   * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the quotaConfig field is set.
   */
  @java.lang.Override
  public boolean hasQuotaConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Preferred quota configuration.
   * </pre>
   *
   * <code>
   * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The quotaConfig.
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1.QuotaConfig getQuotaConfig() {
    return quotaConfig_ == null
        ? com.google.api.cloudquotas.v1.QuotaConfig.getDefaultInstance()
        : quotaConfig_;
  }

  /**
   *
   *
   * <pre>
   * Required. Preferred quota configuration.
   * </pre>
   *
   * <code>
   * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1.QuotaConfigOrBuilder getQuotaConfigOrBuilder() {
    return quotaConfig_ == null
        ? com.google.api.cloudquotas.v1.QuotaConfig.getDefaultInstance()
        : quotaConfig_;
  }

  public static final int ETAG_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The current etag of the quota preference. If an etag is provided
   * on update and does not match the current server's etag of the quota
   * preference, the request will be blocked and an ABORTED error will be
   * returned. See https://google.aip.dev/134#etags for more details on etags.
   * </pre>
   *
   * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The current etag of the quota preference. If an etag is provided
   * on update and does not match the current server's etag of the quota
   * preference, the request will be blocked and an ABORTED error will be
   * returned. See https://google.aip.dev/134#etags for more details on etags.
   * </pre>
   *
   * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Create time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Create time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Create time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Update time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Update time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Update time stamp
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int SERVICE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the service to which the quota preference is applied.
   * </pre>
   *
   * <code>string service = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the service to which the quota preference is applied.
   * </pre>
   *
   * <code>string service = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUOTA_ID_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object quotaId_ = "";

  /**
   *
   *
   * <pre>
   * Required. The id of the quota to which the quota preference is applied. A
   * quota name is unique in the service. Example: `CpusPerProjectPerRegion`
   * </pre>
   *
   * <code>string quota_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The quotaId.
   */
  @java.lang.Override
  public java.lang.String getQuotaId() {
    java.lang.Object ref = quotaId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      quotaId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The id of the quota to which the quota preference is applied. A
   * quota name is unique in the service. Example: `CpusPerProjectPerRegion`
   * </pre>
   *
   * <code>string quota_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for quotaId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQuotaIdBytes() {
    java.lang.Object ref = quotaId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      quotaId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECONCILING_FIELD_NUMBER = 10;
  private boolean reconciling_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Is the quota preference pending Google Cloud approval and
   * fulfillment.
   * </pre>
   *
   * <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int JUSTIFICATION_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object justification_ = "";

  /**
   *
   *
   * <pre>
   * The reason / justification for this quota preference.
   * </pre>
   *
   * <code>string justification = 11;</code>
   *
   * @return The justification.
   */
  @java.lang.Override
  public java.lang.String getJustification() {
    java.lang.Object ref = justification_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      justification_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The reason / justification for this quota preference.
   * </pre>
   *
   * <code>string justification = 11;</code>
   *
   * @return The bytes for justification.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJustificationBytes() {
    java.lang.Object ref = justification_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      justification_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTACT_EMAIL_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object contactEmail_ = "";

  /**
   *
   *
   * <pre>
   * Input only. An email address that can be used to contact the the user, in
   * case Google Cloud needs more information to make a decision before
   * additional quota can be granted.
   *
   * When requesting a quota increase, the email address is required.
   * When requesting a quota decrease, the email address is optional.
   * For example, the email address is optional when the
   * `QuotaConfig.preferred_value` is smaller than the
   * `QuotaDetails.reset_value`.
   * </pre>
   *
   * <code>string contact_email = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The contactEmail.
   */
  @java.lang.Override
  public java.lang.String getContactEmail() {
    java.lang.Object ref = contactEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      contactEmail_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Input only. An email address that can be used to contact the the user, in
   * case Google Cloud needs more information to make a decision before
   * additional quota can be granted.
   *
   * When requesting a quota increase, the email address is required.
   * When requesting a quota decrease, the email address is optional.
   * For example, the email address is optional when the
   * `QuotaConfig.preferred_value` is smaller than the
   * `QuotaDetails.reset_value`.
   * </pre>
   *
   * <code>string contact_email = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for contactEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContactEmailBytes() {
    java.lang.Object ref = contactEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      contactEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDimensions(), DimensionsDefaultEntryHolder.defaultEntry, 2);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getQuotaConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, etag_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, service_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(quotaId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, quotaId_);
    }
    if (reconciling_ != false) {
      output.writeBool(10, reconciling_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(justification_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, justification_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contactEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, contactEmail_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDimensions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
          DimensionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, dimensions__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getQuotaConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, etag_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, service_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(quotaId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, quotaId_);
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, reconciling_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(justification_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, justification_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contactEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, contactEmail_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.cloudquotas.v1.QuotaPreference)) {
      return super.equals(obj);
    }
    com.google.api.cloudquotas.v1.QuotaPreference other =
        (com.google.api.cloudquotas.v1.QuotaPreference) obj;

    if (!getName().equals(other.getName())) return false;
    if (!internalGetDimensions().equals(other.internalGetDimensions())) return false;
    if (hasQuotaConfig() != other.hasQuotaConfig()) return false;
    if (hasQuotaConfig()) {
      if (!getQuotaConfig().equals(other.getQuotaConfig())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getService().equals(other.getService())) return false;
    if (!getQuotaId().equals(other.getQuotaId())) return false;
    if (getReconciling() != other.getReconciling()) return false;
    if (!getJustification().equals(other.getJustification())) return false;
    if (!getContactEmail().equals(other.getContactEmail())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (!internalGetDimensions().getMap().isEmpty()) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDimensions().hashCode();
    }
    if (hasQuotaConfig()) {
      hash = (37 * hash) + QUOTA_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getQuotaConfig().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    hash = (37 * hash) + QUOTA_ID_FIELD_NUMBER;
    hash = (53 * hash) + getQuotaId().hashCode();
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    hash = (37 * hash) + JUSTIFICATION_FIELD_NUMBER;
    hash = (53 * hash) + getJustification().hashCode();
    hash = (37 * hash) + CONTACT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getContactEmail().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.cloudquotas.v1.QuotaPreference prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * QuotaPreference represents the preferred quota configuration specified for
   * a project, folder or organization. There is only one QuotaPreference
   * resource for a quota value targeting a unique set of dimensions.
   * </pre>
   *
   * Protobuf type {@code google.api.cloudquotas.v1.QuotaPreference}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.cloudquotas.v1.QuotaPreference)
      com.google.api.cloudquotas.v1.QuotaPreferenceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.cloudquotas.v1.ResourcesProto
          .internal_static_google_api_cloudquotas_v1_QuotaPreference_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.cloudquotas.v1.ResourcesProto
          .internal_static_google_api_cloudquotas_v1_QuotaPreference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.cloudquotas.v1.QuotaPreference.class,
              com.google.api.cloudquotas.v1.QuotaPreference.Builder.class);
    }

    // Construct using com.google.api.cloudquotas.v1.QuotaPreference.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getQuotaConfigFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      internalGetMutableDimensions().clear();
      quotaConfig_ = null;
      if (quotaConfigBuilder_ != null) {
        quotaConfigBuilder_.dispose();
        quotaConfigBuilder_ = null;
      }
      etag_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      service_ = "";
      quotaId_ = "";
      reconciling_ = false;
      justification_ = "";
      contactEmail_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.cloudquotas.v1.ResourcesProto
          .internal_static_google_api_cloudquotas_v1_QuotaPreference_descriptor;
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1.QuotaPreference getDefaultInstanceForType() {
      return com.google.api.cloudquotas.v1.QuotaPreference.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1.QuotaPreference build() {
      com.google.api.cloudquotas.v1.QuotaPreference result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1.QuotaPreference buildPartial() {
      com.google.api.cloudquotas.v1.QuotaPreference result =
          new com.google.api.cloudquotas.v1.QuotaPreference(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.api.cloudquotas.v1.QuotaPreference result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dimensions_ = internalGetDimensions();
        result.dimensions_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.quotaConfig_ =
            quotaConfigBuilder_ == null ? quotaConfig_ : quotaConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.service_ = service_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.quotaId_ = quotaId_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.justification_ = justification_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.contactEmail_ = contactEmail_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.cloudquotas.v1.QuotaPreference) {
        return mergeFrom((com.google.api.cloudquotas.v1.QuotaPreference) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.cloudquotas.v1.QuotaPreference other) {
      if (other == com.google.api.cloudquotas.v1.QuotaPreference.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableDimensions().mergeFrom(other.internalGetDimensions());
      bitField0_ |= 0x00000002;
      if (other.hasQuotaConfig()) {
        mergeQuotaConfig(other.getQuotaConfig());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getQuotaId().isEmpty()) {
        quotaId_ = other.quotaId_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      if (!other.getJustification().isEmpty()) {
        justification_ = other.justification_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getContactEmail().isEmpty()) {
        contactEmail_ = other.contactEmail_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
                    input.readMessage(
                        DimensionsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDimensions()
                    .getMutableMap()
                    .put(dimensions__.getKey(), dimensions__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getQuotaConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                quotaId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 80:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 80
            case 90:
              {
                justification_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                contactEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required except in the CREATE requests.
     * The resource name of the quota preference.
     * The ID component following "locations/" must be "global".
     * Example:
     * `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required except in the CREATE requests.
     * The resource name of the quota preference.
     * The ID component following "locations/" must be "global".
     * Example:
     * `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required except in the CREATE requests.
     * The resource name of the quota preference.
     * The ID component following "locations/" must be "global".
     * Example:
     * `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required except in the CREATE requests.
     * The resource name of the quota preference.
     * The ID component following "locations/" must be "global".
     * Example:
     * `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required except in the CREATE requests.
     * The resource name of the quota preference.
     * The ID component following "locations/" must be "global".
     * Example:
     * `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDimensions() {
      if (dimensions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DimensionsDefaultEntryHolder.defaultEntry);
      }
      return dimensions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDimensions() {
      if (dimensions_ == null) {
        dimensions_ =
            com.google.protobuf.MapField.newMapField(DimensionsDefaultEntryHolder.defaultEntry);
      }
      if (!dimensions_.isMutable()) {
        dimensions_ = dimensions_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return dimensions_;
    }

    public int getDimensionsCount() {
      return internalGetDimensions().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Immutable. The dimensions that this quota preference applies to. The key of
     * the map entry is the name of a dimension, such as "region", "zone",
     * "network_id", and the value of the map entry is the dimension value.
     *
     * If a dimension is missing from the map of dimensions, the quota preference
     * applies to all the dimension values except for those that have other quota
     * preferences configured for the specific value.
     *
     * NOTE: QuotaPreferences can only be applied across all values of "user" and
     * "resource" dimension. Do not set values for "user" or "resource" in the
     * dimension map.
     *
     * Example: {"provider", "Foo Inc"} where "provider" is a service specific
     * dimension.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    @java.lang.Override
    public boolean containsDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDimensions().getMap().containsKey(key);
    }

    /** Use {@link #getDimensionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
      return getDimensionsMap();
    }

    /**
     *
     *
     * <pre>
     * Immutable. The dimensions that this quota preference applies to. The key of
     * the map entry is the name of a dimension, such as "region", "zone",
     * "network_id", and the value of the map entry is the dimension value.
     *
     * If a dimension is missing from the map of dimensions, the quota preference
     * applies to all the dimension values except for those that have other quota
     * preferences configured for the specific value.
     *
     * NOTE: QuotaPreferences can only be applied across all values of "user" and
     * "resource" dimension. Do not set values for "user" or "resource" in the
     * dimension map.
     *
     * Example: {"provider", "Foo Inc"} where "provider" is a service specific
     * dimension.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
      return internalGetDimensions().getMap();
    }

    /**
     *
     *
     * <pre>
     * Immutable. The dimensions that this quota preference applies to. The key of
     * the map entry is the name of a dimension, such as "region", "zone",
     * "network_id", and the value of the map entry is the dimension value.
     *
     * If a dimension is missing from the map of dimensions, the quota preference
     * applies to all the dimension values except for those that have other quota
     * preferences configured for the specific value.
     *
     * NOTE: QuotaPreferences can only be applied across all values of "user" and
     * "resource" dimension. Do not set values for "user" or "resource" in the
     * dimension map.
     *
     * Example: {"provider", "Foo Inc"} where "provider" is a service specific
     * dimension.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDimensionsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The dimensions that this quota preference applies to. The key of
     * the map entry is the name of a dimension, such as "region", "zone",
     * "network_id", and the value of the map entry is the dimension value.
     *
     * If a dimension is missing from the map of dimensions, the quota preference
     * applies to all the dimension values except for those that have other quota
     * preferences configured for the specific value.
     *
     * NOTE: QuotaPreferences can only be applied across all values of "user" and
     * "resource" dimension. Do not set values for "user" or "resource" in the
     * dimension map.
     *
     * Example: {"provider", "Foo Inc"} where "provider" is a service specific
     * dimension.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getDimensionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDimensions() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableDimensions().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The dimensions that this quota preference applies to. The key of
     * the map entry is the name of a dimension, such as "region", "zone",
     * "network_id", and the value of the map entry is the dimension value.
     *
     * If a dimension is missing from the map of dimensions, the quota preference
     * applies to all the dimension values except for those that have other quota
     * preferences configured for the specific value.
     *
     * NOTE: QuotaPreferences can only be applied across all values of "user" and
     * "resource" dimension. Do not set values for "user" or "resource" in the
     * dimension map.
     *
     * Example: {"provider", "Foo Inc"} where "provider" is a service specific
     * dimension.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder removeDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDimensions().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDimensions() {
      bitField0_ |= 0x00000002;
      return internalGetMutableDimensions().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Immutable. The dimensions that this quota preference applies to. The key of
     * the map entry is the name of a dimension, such as "region", "zone",
     * "network_id", and the value of the map entry is the dimension value.
     *
     * If a dimension is missing from the map of dimensions, the quota preference
     * applies to all the dimension values except for those that have other quota
     * preferences configured for the specific value.
     *
     * NOTE: QuotaPreferences can only be applied across all values of "user" and
     * "resource" dimension. Do not set values for "user" or "resource" in the
     * dimension map.
     *
     * Example: {"provider", "Foo Inc"} where "provider" is a service specific
     * dimension.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder putDimensions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDimensions().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The dimensions that this quota preference applies to. The key of
     * the map entry is the name of a dimension, such as "region", "zone",
     * "network_id", and the value of the map entry is the dimension value.
     *
     * If a dimension is missing from the map of dimensions, the quota preference
     * applies to all the dimension values except for those that have other quota
     * preferences configured for the specific value.
     *
     * NOTE: QuotaPreferences can only be applied across all values of "user" and
     * "resource" dimension. Do not set values for "user" or "resource" in the
     * dimension map.
     *
     * Example: {"provider", "Foo Inc"} where "provider" is a service specific
     * dimension.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder putAllDimensions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDimensions().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.api.cloudquotas.v1.QuotaConfig quotaConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.cloudquotas.v1.QuotaConfig,
            com.google.api.cloudquotas.v1.QuotaConfig.Builder,
            com.google.api.cloudquotas.v1.QuotaConfigOrBuilder>
        quotaConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Preferred quota configuration.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the quotaConfig field is set.
     */
    public boolean hasQuotaConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Preferred quota configuration.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The quotaConfig.
     */
    public com.google.api.cloudquotas.v1.QuotaConfig getQuotaConfig() {
      if (quotaConfigBuilder_ == null) {
        return quotaConfig_ == null
            ? com.google.api.cloudquotas.v1.QuotaConfig.getDefaultInstance()
            : quotaConfig_;
      } else {
        return quotaConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Preferred quota configuration.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQuotaConfig(com.google.api.cloudquotas.v1.QuotaConfig value) {
      if (quotaConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        quotaConfig_ = value;
      } else {
        quotaConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Preferred quota configuration.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQuotaConfig(
        com.google.api.cloudquotas.v1.QuotaConfig.Builder builderForValue) {
      if (quotaConfigBuilder_ == null) {
        quotaConfig_ = builderForValue.build();
      } else {
        quotaConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Preferred quota configuration.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeQuotaConfig(com.google.api.cloudquotas.v1.QuotaConfig value) {
      if (quotaConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && quotaConfig_ != null
            && quotaConfig_ != com.google.api.cloudquotas.v1.QuotaConfig.getDefaultInstance()) {
          getQuotaConfigBuilder().mergeFrom(value);
        } else {
          quotaConfig_ = value;
        }
      } else {
        quotaConfigBuilder_.mergeFrom(value);
      }
      if (quotaConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Preferred quota configuration.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearQuotaConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      quotaConfig_ = null;
      if (quotaConfigBuilder_ != null) {
        quotaConfigBuilder_.dispose();
        quotaConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Preferred quota configuration.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.api.cloudquotas.v1.QuotaConfig.Builder getQuotaConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getQuotaConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Preferred quota configuration.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.api.cloudquotas.v1.QuotaConfigOrBuilder getQuotaConfigOrBuilder() {
      if (quotaConfigBuilder_ != null) {
        return quotaConfigBuilder_.getMessageOrBuilder();
      } else {
        return quotaConfig_ == null
            ? com.google.api.cloudquotas.v1.QuotaConfig.getDefaultInstance()
            : quotaConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Preferred quota configuration.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1.QuotaConfig quota_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.cloudquotas.v1.QuotaConfig,
            com.google.api.cloudquotas.v1.QuotaConfig.Builder,
            com.google.api.cloudquotas.v1.QuotaConfigOrBuilder>
        getQuotaConfigFieldBuilder() {
      if (quotaConfigBuilder_ == null) {
        quotaConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.cloudquotas.v1.QuotaConfig,
                com.google.api.cloudquotas.v1.QuotaConfig.Builder,
                com.google.api.cloudquotas.v1.QuotaConfigOrBuilder>(
                getQuotaConfig(), getParentForChildren(), isClean());
        quotaConfig_ = null;
      }
      return quotaConfigBuilder_;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The current etag of the quota preference. If an etag is provided
     * on update and does not match the current server's etag of the quota
     * preference, the request will be blocked and an ABORTED error will be
     * returned. See https://google.aip.dev/134#etags for more details on etags.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The current etag of the quota preference. If an etag is provided
     * on update and does not match the current server's etag of the quota
     * preference, the request will be blocked and an ABORTED error will be
     * returned. See https://google.aip.dev/134#etags for more details on etags.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The current etag of the quota preference. If an etag is provided
     * on update and does not match the current server's etag of the quota
     * preference, the request will be blocked and an ABORTED error will be
     * returned. See https://google.aip.dev/134#etags for more details on etags.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The current etag of the quota preference. If an etag is provided
     * on update and does not match the current server's etag of the quota
     * preference, the request will be blocked and an ABORTED error will be
     * returned. See https://google.aip.dev/134#etags for more details on etags.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The current etag of the quota preference. If an etag is provided
     * on update and does not match the current server's etag of the quota
     * preference, the request will be blocked and an ABORTED error will be
     * returned. See https://google.aip.dev/134#etags for more details on etags.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Create time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time stamp
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object service_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the service to which the quota preference is applied.
     * </pre>
     *
     * <code>string service = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the service to which the quota preference is applied.
     * </pre>
     *
     * <code>string service = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the service to which the quota preference is applied.
     * </pre>
     *
     * <code>string service = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the service to which the quota preference is applied.
     * </pre>
     *
     * <code>string service = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the service to which the quota preference is applied.
     * </pre>
     *
     * <code>string service = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object quotaId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The id of the quota to which the quota preference is applied. A
     * quota name is unique in the service. Example: `CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string quota_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The quotaId.
     */
    public java.lang.String getQuotaId() {
      java.lang.Object ref = quotaId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        quotaId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The id of the quota to which the quota preference is applied. A
     * quota name is unique in the service. Example: `CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string quota_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for quotaId.
     */
    public com.google.protobuf.ByteString getQuotaIdBytes() {
      java.lang.Object ref = quotaId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        quotaId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The id of the quota to which the quota preference is applied. A
     * quota name is unique in the service. Example: `CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string quota_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The quotaId to set.
     * @return This builder for chaining.
     */
    public Builder setQuotaId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      quotaId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The id of the quota to which the quota preference is applied. A
     * quota name is unique in the service. Example: `CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string quota_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuotaId() {
      quotaId_ = getDefaultInstance().getQuotaId();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The id of the quota to which the quota preference is applied. A
     * quota name is unique in the service. Example: `CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string quota_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for quotaId to set.
     * @return This builder for chaining.
     */
    public Builder setQuotaIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      quotaId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private boolean reconciling_;

    /**
     *
     *
     * <pre>
     * Output only. Is the quota preference pending Google Cloud approval and
     * fulfillment.
     * </pre>
     *
     * <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Is the quota preference pending Google Cloud approval and
     * fulfillment.
     * </pre>
     *
     * <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Is the quota preference pending Google Cloud approval and
     * fulfillment.
     * </pre>
     *
     * <code>bool reconciling = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00000100);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object justification_ = "";

    /**
     *
     *
     * <pre>
     * The reason / justification for this quota preference.
     * </pre>
     *
     * <code>string justification = 11;</code>
     *
     * @return The justification.
     */
    public java.lang.String getJustification() {
      java.lang.Object ref = justification_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        justification_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The reason / justification for this quota preference.
     * </pre>
     *
     * <code>string justification = 11;</code>
     *
     * @return The bytes for justification.
     */
    public com.google.protobuf.ByteString getJustificationBytes() {
      java.lang.Object ref = justification_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        justification_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The reason / justification for this quota preference.
     * </pre>
     *
     * <code>string justification = 11;</code>
     *
     * @param value The justification to set.
     * @return This builder for chaining.
     */
    public Builder setJustification(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      justification_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The reason / justification for this quota preference.
     * </pre>
     *
     * <code>string justification = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJustification() {
      justification_ = getDefaultInstance().getJustification();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The reason / justification for this quota preference.
     * </pre>
     *
     * <code>string justification = 11;</code>
     *
     * @param value The bytes for justification to set.
     * @return This builder for chaining.
     */
    public Builder setJustificationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      justification_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object contactEmail_ = "";

    /**
     *
     *
     * <pre>
     * Input only. An email address that can be used to contact the the user, in
     * case Google Cloud needs more information to make a decision before
     * additional quota can be granted.
     *
     * When requesting a quota increase, the email address is required.
     * When requesting a quota decrease, the email address is optional.
     * For example, the email address is optional when the
     * `QuotaConfig.preferred_value` is smaller than the
     * `QuotaDetails.reset_value`.
     * </pre>
     *
     * <code>string contact_email = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The contactEmail.
     */
    public java.lang.String getContactEmail() {
      java.lang.Object ref = contactEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        contactEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. An email address that can be used to contact the the user, in
     * case Google Cloud needs more information to make a decision before
     * additional quota can be granted.
     *
     * When requesting a quota increase, the email address is required.
     * When requesting a quota decrease, the email address is optional.
     * For example, the email address is optional when the
     * `QuotaConfig.preferred_value` is smaller than the
     * `QuotaDetails.reset_value`.
     * </pre>
     *
     * <code>string contact_email = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for contactEmail.
     */
    public com.google.protobuf.ByteString getContactEmailBytes() {
      java.lang.Object ref = contactEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        contactEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. An email address that can be used to contact the the user, in
     * case Google Cloud needs more information to make a decision before
     * additional quota can be granted.
     *
     * When requesting a quota increase, the email address is required.
     * When requesting a quota decrease, the email address is optional.
     * For example, the email address is optional when the
     * `QuotaConfig.preferred_value` is smaller than the
     * `QuotaDetails.reset_value`.
     * </pre>
     *
     * <code>string contact_email = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The contactEmail to set.
     * @return This builder for chaining.
     */
    public Builder setContactEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      contactEmail_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. An email address that can be used to contact the the user, in
     * case Google Cloud needs more information to make a decision before
     * additional quota can be granted.
     *
     * When requesting a quota increase, the email address is required.
     * When requesting a quota decrease, the email address is optional.
     * For example, the email address is optional when the
     * `QuotaConfig.preferred_value` is smaller than the
     * `QuotaDetails.reset_value`.
     * </pre>
     *
     * <code>string contact_email = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContactEmail() {
      contactEmail_ = getDefaultInstance().getContactEmail();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. An email address that can be used to contact the the user, in
     * case Google Cloud needs more information to make a decision before
     * additional quota can be granted.
     *
     * When requesting a quota increase, the email address is required.
     * When requesting a quota decrease, the email address is optional.
     * For example, the email address is optional when the
     * `QuotaConfig.preferred_value` is smaller than the
     * `QuotaDetails.reset_value`.
     * </pre>
     *
     * <code>string contact_email = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for contactEmail to set.
     * @return This builder for chaining.
     */
    public Builder setContactEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      contactEmail_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.cloudquotas.v1.QuotaPreference)
  }

  // @@protoc_insertion_point(class_scope:google.api.cloudquotas.v1.QuotaPreference)
  private static final com.google.api.cloudquotas.v1.QuotaPreference DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.cloudquotas.v1.QuotaPreference();
  }

  public static com.google.api.cloudquotas.v1.QuotaPreference getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QuotaPreference> PARSER =
      new com.google.protobuf.AbstractParser<QuotaPreference>() {
        @java.lang.Override
        public QuotaPreference parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QuotaPreference> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QuotaPreference> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.cloudquotas.v1.QuotaPreference getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
