/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/cloudquotas/v1/resources.proto

// Protobuf Java Version: 3.25.8
package com.google.api.cloudquotas.v1;

public interface QuotaInfoOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.api.cloudquotas.v1.QuotaInfo)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Resource name of this QuotaInfo.
   * The ID component following "locations/" must be "global".
   * Example:
   * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Resource name of this QuotaInfo.
   * The ID component following "locations/" must be "global".
   * Example:
   * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The id of the quota, which is unquie within the service.
   * Example: `CpusPerProjectPerRegion`
   * </pre>
   *
   * <code>string quota_id = 2;</code>
   *
   * @return The quotaId.
   */
  java.lang.String getQuotaId();

  /**
   *
   *
   * <pre>
   * The id of the quota, which is unquie within the service.
   * Example: `CpusPerProjectPerRegion`
   * </pre>
   *
   * <code>string quota_id = 2;</code>
   *
   * @return The bytes for quotaId.
   */
  com.google.protobuf.ByteString getQuotaIdBytes();

  /**
   *
   *
   * <pre>
   * The metric of the quota. It specifies the resources consumption the quota
   * is defined for.
   * Example: `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 3;</code>
   *
   * @return The metric.
   */
  java.lang.String getMetric();

  /**
   *
   *
   * <pre>
   * The metric of the quota. It specifies the resources consumption the quota
   * is defined for.
   * Example: `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 3;</code>
   *
   * @return The bytes for metric.
   */
  com.google.protobuf.ByteString getMetricBytes();

  /**
   *
   *
   * <pre>
   * The name of the service in which the quota is defined.
   * Example: `compute.googleapis.com`
   * </pre>
   *
   * <code>string service = 4;</code>
   *
   * @return The service.
   */
  java.lang.String getService();

  /**
   *
   *
   * <pre>
   * The name of the service in which the quota is defined.
   * Example: `compute.googleapis.com`
   * </pre>
   *
   * <code>string service = 4;</code>
   *
   * @return The bytes for service.
   */
  com.google.protobuf.ByteString getServiceBytes();

  /**
   *
   *
   * <pre>
   * Whether this is a precise quota. A precise quota is tracked with absolute
   * precision. In contrast, an imprecise quota is not tracked with precision.
   * </pre>
   *
   * <code>bool is_precise = 5;</code>
   *
   * @return The isPrecise.
   */
  boolean getIsPrecise();

  /**
   *
   *
   * <pre>
   * The reset time interval for the quota. Refresh interval applies to rate
   * quota only.
   * Example: "minute" for per minute, "day" for per day, or "10 seconds" for
   * every 10 seconds.
   * </pre>
   *
   * <code>string refresh_interval = 6;</code>
   *
   * @return The refreshInterval.
   */
  java.lang.String getRefreshInterval();

  /**
   *
   *
   * <pre>
   * The reset time interval for the quota. Refresh interval applies to rate
   * quota only.
   * Example: "minute" for per minute, "day" for per day, or "10 seconds" for
   * every 10 seconds.
   * </pre>
   *
   * <code>string refresh_interval = 6;</code>
   *
   * @return The bytes for refreshInterval.
   */
  com.google.protobuf.ByteString getRefreshIntervalBytes();

  /**
   *
   *
   * <pre>
   * The container type of the QuotaInfo.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaInfo.ContainerType container_type = 7;</code>
   *
   * @return The enum numeric value on the wire for containerType.
   */
  int getContainerTypeValue();

  /**
   *
   *
   * <pre>
   * The container type of the QuotaInfo.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaInfo.ContainerType container_type = 7;</code>
   *
   * @return The containerType.
   */
  com.google.api.cloudquotas.v1.QuotaInfo.ContainerType getContainerType();

  /**
   *
   *
   * <pre>
   * The dimensions the quota is defined on.
   * </pre>
   *
   * <code>repeated string dimensions = 8;</code>
   *
   * @return A list containing the dimensions.
   */
  java.util.List<java.lang.String> getDimensionsList();

  /**
   *
   *
   * <pre>
   * The dimensions the quota is defined on.
   * </pre>
   *
   * <code>repeated string dimensions = 8;</code>
   *
   * @return The count of dimensions.
   */
  int getDimensionsCount();

  /**
   *
   *
   * <pre>
   * The dimensions the quota is defined on.
   * </pre>
   *
   * <code>repeated string dimensions = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The dimensions at the given index.
   */
  java.lang.String getDimensions(int index);

  /**
   *
   *
   * <pre>
   * The dimensions the quota is defined on.
   * </pre>
   *
   * <code>repeated string dimensions = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the dimensions at the given index.
   */
  com.google.protobuf.ByteString getDimensionsBytes(int index);

  /**
   *
   *
   * <pre>
   * The display name of the quota metric
   * </pre>
   *
   * <code>string metric_display_name = 9;</code>
   *
   * @return The metricDisplayName.
   */
  java.lang.String getMetricDisplayName();

  /**
   *
   *
   * <pre>
   * The display name of the quota metric
   * </pre>
   *
   * <code>string metric_display_name = 9;</code>
   *
   * @return The bytes for metricDisplayName.
   */
  com.google.protobuf.ByteString getMetricDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * The display name of the quota.
   * </pre>
   *
   * <code>string quota_display_name = 10;</code>
   *
   * @return The quotaDisplayName.
   */
  java.lang.String getQuotaDisplayName();

  /**
   *
   *
   * <pre>
   * The display name of the quota.
   * </pre>
   *
   * <code>string quota_display_name = 10;</code>
   *
   * @return The bytes for quotaDisplayName.
   */
  com.google.protobuf.ByteString getQuotaDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * The unit in which the metric value is reported, e.g., "MByte".
   * </pre>
   *
   * <code>string metric_unit = 11;</code>
   *
   * @return The metricUnit.
   */
  java.lang.String getMetricUnit();

  /**
   *
   *
   * <pre>
   * The unit in which the metric value is reported, e.g., "MByte".
   * </pre>
   *
   * <code>string metric_unit = 11;</code>
   *
   * @return The bytes for metricUnit.
   */
  com.google.protobuf.ByteString getMetricUnitBytes();

  /**
   *
   *
   * <pre>
   * Whether it is eligible to request a higher quota value for this quota.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
   * </code>
   *
   * @return Whether the quotaIncreaseEligibility field is set.
   */
  boolean hasQuotaIncreaseEligibility();

  /**
   *
   *
   * <pre>
   * Whether it is eligible to request a higher quota value for this quota.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
   * </code>
   *
   * @return The quotaIncreaseEligibility.
   */
  com.google.api.cloudquotas.v1.QuotaIncreaseEligibility getQuotaIncreaseEligibility();

  /**
   *
   *
   * <pre>
   * Whether it is eligible to request a higher quota value for this quota.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
   * </code>
   */
  com.google.api.cloudquotas.v1.QuotaIncreaseEligibilityOrBuilder
      getQuotaIncreaseEligibilityOrBuilder();

  /**
   *
   *
   * <pre>
   * Whether the quota value is fixed or adjustable
   * </pre>
   *
   * <code>bool is_fixed = 13;</code>
   *
   * @return The isFixed.
   */
  boolean getIsFixed();

  /**
   *
   *
   * <pre>
   * The collection of dimensions info ordered by their dimensions from more
   * specific ones to less specific ones.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
   */
  java.util.List<com.google.api.cloudquotas.v1.DimensionsInfo> getDimensionsInfosList();

  /**
   *
   *
   * <pre>
   * The collection of dimensions info ordered by their dimensions from more
   * specific ones to less specific ones.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
   */
  com.google.api.cloudquotas.v1.DimensionsInfo getDimensionsInfos(int index);

  /**
   *
   *
   * <pre>
   * The collection of dimensions info ordered by their dimensions from more
   * specific ones to less specific ones.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
   */
  int getDimensionsInfosCount();

  /**
   *
   *
   * <pre>
   * The collection of dimensions info ordered by their dimensions from more
   * specific ones to less specific ones.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
   */
  java.util.List<? extends com.google.api.cloudquotas.v1.DimensionsInfoOrBuilder>
      getDimensionsInfosOrBuilderList();

  /**
   *
   *
   * <pre>
   * The collection of dimensions info ordered by their dimensions from more
   * specific ones to less specific ones.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
   */
  com.google.api.cloudquotas.v1.DimensionsInfoOrBuilder getDimensionsInfosOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Whether the quota is a concurrent quota. Concurrent quotas are enforced
   * on the total number of concurrent operations in flight at any given time.
   * </pre>
   *
   * <code>bool is_concurrent = 15;</code>
   *
   * @return The isConcurrent.
   */
  boolean getIsConcurrent();

  /**
   *
   *
   * <pre>
   * URI to the page where users can request more quota for the cloud
   * service—for example,
   * https://console.cloud.google.com/iam-admin/quotas.
   * </pre>
   *
   * <code>string service_request_quota_uri = 17;</code>
   *
   * @return The serviceRequestQuotaUri.
   */
  java.lang.String getServiceRequestQuotaUri();

  /**
   *
   *
   * <pre>
   * URI to the page where users can request more quota for the cloud
   * service—for example,
   * https://console.cloud.google.com/iam-admin/quotas.
   * </pre>
   *
   * <code>string service_request_quota_uri = 17;</code>
   *
   * @return The bytes for serviceRequestQuotaUri.
   */
  com.google.protobuf.ByteString getServiceRequestQuotaUriBytes();
}
